function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { FormattedMessage } from '@kbn/i18n/react';
import { BehaviorSubject, combineLatest, merge, of, ReplaySubject } from 'rxjs';
import { flatMap, map, takeUntil } from 'rxjs/operators';
import { parse } from 'url';
import { EuiLink } from '@elastic/eui';
import { mountReactNode } from '../utils/mount';
import { KIBANA_ASK_ELASTIC_LINK } from './constants';
import { ChromeDocTitle, DocTitleService } from './doc_title';
import { ChromeNavControls, NavControlsService } from './nav_controls';
import { NavLinksService } from './nav_links';
import { ChromeRecentlyAccessed, RecentlyAccessedService } from './recently_accessed';
import { Header } from './ui';
export { ChromeNavControls, ChromeRecentlyAccessed, ChromeDocTitle };
var IS_LOCKED_KEY = 'core.chrome.isLocked';
/** @public */

/** @internal */
export var ChromeService = /*#__PURE__*/function () {
  function ChromeService(params) {
    _classCallCheck(this, ChromeService);

    this.params = params;

    _defineProperty(this, "isVisible$", void 0);

    _defineProperty(this, "isForceHidden$", void 0);

    _defineProperty(this, "stop$", new ReplaySubject(1));

    _defineProperty(this, "navControls", new NavControlsService());

    _defineProperty(this, "navLinks", new NavLinksService());

    _defineProperty(this, "recentlyAccessed", new RecentlyAccessedService());

    _defineProperty(this, "docTitle", new DocTitleService());
  }
  /**
   * These observables allow consumers to toggle the chrome visibility via either:
   *   1. Using setIsVisible() to trigger the next chromeHidden$
   *   2. Setting `chromeless` when registering an application, which will
   *      reset the visibility whenever the next application is mounted
   *   3. Having "embed" in the query string
   */


  _createClass(ChromeService, [{
    key: "initVisibility",
    value: function initVisibility(application) {
      // Start off the chrome service hidden if "embed" is in the hash query string.
      var isEmbedded = ('embed' in parse(location.hash.slice(1), true).query);
      this.isForceHidden$ = new BehaviorSubject(isEmbedded);
      var appHidden$ = merge( // For the isVisible$ logic, having no mounted app is equivalent to having a hidden app
      // in the sense that the chrome UI should not be displayed until a non-chromeless app is mounting or mounted
      of(true), application.currentAppId$.pipe(flatMap(function (appId) {
        return application.applications$.pipe(map(function (applications) {
          return !!appId && applications.has(appId) && !!applications.get(appId).chromeless;
        }));
      })));
      this.isVisible$ = combineLatest([appHidden$, this.isForceHidden$]).pipe(map(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            appHidden = _ref2[0],
            forceHidden = _ref2[1];

        return !appHidden && !forceHidden;
      }), takeUntil(this.stop$));
    }
  }, {
    key: "start",
    value: function () {
      var _start = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref3) {
        var _this = this;

        var application, docLinks, http, injectedMetadata, notifications, uiSettings, appTitle$, brand$, applicationClasses$, helpExtension$, breadcrumbs$, badge$, customNavLink$, helpSupportUrl$, isNavDrawerLocked$, navControls, navLinks, recentlyAccessed, docTitle, setIsNavDrawerLocked, getIsNavDrawerLocked$, getNavType$, isIE;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                application = _ref3.application, docLinks = _ref3.docLinks, http = _ref3.http, injectedMetadata = _ref3.injectedMetadata, notifications = _ref3.notifications, uiSettings = _ref3.uiSettings;
                this.initVisibility(application);
                appTitle$ = new BehaviorSubject('Kibana');
                brand$ = new BehaviorSubject({});
                applicationClasses$ = new BehaviorSubject(new Set());
                helpExtension$ = new BehaviorSubject(undefined);
                breadcrumbs$ = new BehaviorSubject([]);
                badge$ = new BehaviorSubject(undefined);
                customNavLink$ = new BehaviorSubject(undefined);
                helpSupportUrl$ = new BehaviorSubject(KIBANA_ASK_ELASTIC_LINK);
                isNavDrawerLocked$ = new BehaviorSubject(localStorage.getItem(IS_LOCKED_KEY) === 'true');
                navControls = this.navControls.start();
                navLinks = this.navLinks.start({
                  application: application,
                  http: http
                });
                _context.next = 15;
                return this.recentlyAccessed.start({
                  http: http
                });

              case 15:
                recentlyAccessed = _context.sent;
                docTitle = this.docTitle.start({
                  document: window.document
                });

                setIsNavDrawerLocked = function setIsNavDrawerLocked(isLocked) {
                  isNavDrawerLocked$.next(isLocked);
                  localStorage.setItem(IS_LOCKED_KEY, "".concat(isLocked));
                };

                getIsNavDrawerLocked$ = isNavDrawerLocked$.pipe(takeUntil(this.stop$)); // TODO #64541
                // Can delete

                getNavType$ = uiSettings.get$('pageNavigation').pipe(takeUntil(this.stop$));

                isIE = function isIE() {
                  var ua = window.navigator.userAgent;
                  var msie = ua.indexOf('MSIE '); // IE 10 or older

                  var trident = ua.indexOf('Trident/'); // IE 11

                  return msie > 0 || trident > 0;
                };

                if (!this.params.browserSupportsCsp && injectedMetadata.getCspConfig().warnLegacyBrowsers) {
                  notifications.toasts.addWarning({
                    title: mountReactNode( /*#__PURE__*/React.createElement(FormattedMessage, {
                      id: "core.chrome.legacyBrowserWarning",
                      defaultMessage: "Your browser does not meet the security requirements for Kibana."
                    }))
                  });
                }

                if (isIE()) {
                  notifications.toasts.addWarning({
                    title: mountReactNode( /*#__PURE__*/React.createElement(FormattedMessage, {
                      id: "core.chrome.browserDeprecationWarning",
                      defaultMessage: "Support for Internet Explorer will be dropped in future versions of this software, please check {link}.",
                      values: {
                        link: /*#__PURE__*/React.createElement(EuiLink, {
                          target: "_blank",
                          href: "https://www.elastic.co/support/matrix",
                          external: true
                        }, /*#__PURE__*/React.createElement(FormattedMessage, {
                          id: "core.chrome.browserDeprecationLink",
                          defaultMessage: "the support matrix on our website"
                        }))
                      }
                    }))
                  });
                }

                return _context.abrupt("return", {
                  navControls: navControls,
                  navLinks: navLinks,
                  recentlyAccessed: recentlyAccessed,
                  docTitle: docTitle,
                  getHeaderComponent: function getHeaderComponent() {
                    return /*#__PURE__*/React.createElement(Header, {
                      loadingCount$: http.getLoadingCount$(),
                      application: application,
                      appTitle$: appTitle$.pipe(takeUntil(_this.stop$)),
                      badge$: badge$.pipe(takeUntil(_this.stop$)),
                      basePath: http.basePath,
                      breadcrumbs$: breadcrumbs$.pipe(takeUntil(_this.stop$)),
                      customNavLink$: customNavLink$.pipe(takeUntil(_this.stop$)),
                      kibanaDocLink: docLinks.links.kibana,
                      forceAppSwitcherNavigation$: navLinks.getForceAppSwitcherNavigation$(),
                      helpExtension$: helpExtension$.pipe(takeUntil(_this.stop$)),
                      helpSupportUrl$: helpSupportUrl$.pipe(takeUntil(_this.stop$)),
                      homeHref: http.basePath.prepend('/app/home'),
                      isVisible$: _this.isVisible$,
                      kibanaVersion: injectedMetadata.getKibanaVersion(),
                      legacyMode: injectedMetadata.getLegacyMode(),
                      navLinks$: navLinks.getNavLinks$(),
                      recentlyAccessed$: recentlyAccessed.get$(),
                      navControlsLeft$: navControls.getLeft$(),
                      navControlsRight$: navControls.getRight$(),
                      onIsLockedUpdate: setIsNavDrawerLocked,
                      isLocked$: getIsNavDrawerLocked$,
                      navType$: getNavType$
                    });
                  },
                  setAppTitle: function setAppTitle(appTitle) {
                    return appTitle$.next(appTitle);
                  },
                  getBrand$: function getBrand$() {
                    return brand$.pipe(takeUntil(_this.stop$));
                  },
                  setBrand: function setBrand(brand) {
                    brand$.next(Object.freeze({
                      logo: brand.logo,
                      smallLogo: brand.smallLogo
                    }));
                  },
                  getIsVisible$: function getIsVisible$() {
                    return _this.isVisible$;
                  },
                  setIsVisible: function setIsVisible(isVisible) {
                    return _this.isForceHidden$.next(!isVisible);
                  },
                  getApplicationClasses$: function getApplicationClasses$() {
                    return applicationClasses$.pipe(map(function (set) {
                      return _toConsumableArray(set);
                    }), takeUntil(_this.stop$));
                  },
                  addApplicationClass: function addApplicationClass(className) {
                    var update = new Set(_toConsumableArray(applicationClasses$.getValue()));
                    update.add(className);
                    applicationClasses$.next(update);
                  },
                  removeApplicationClass: function removeApplicationClass(className) {
                    var update = new Set(_toConsumableArray(applicationClasses$.getValue()));
                    update.delete(className);
                    applicationClasses$.next(update);
                  },
                  getBadge$: function getBadge$() {
                    return badge$.pipe(takeUntil(_this.stop$));
                  },
                  setBadge: function setBadge(badge) {
                    badge$.next(badge);
                  },
                  getBreadcrumbs$: function getBreadcrumbs$() {
                    return breadcrumbs$.pipe(takeUntil(_this.stop$));
                  },
                  setBreadcrumbs: function setBreadcrumbs(newBreadcrumbs) {
                    breadcrumbs$.next(newBreadcrumbs);
                  },
                  getHelpExtension$: function getHelpExtension$() {
                    return helpExtension$.pipe(takeUntil(_this.stop$));
                  },
                  setHelpExtension: function setHelpExtension(helpExtension) {
                    helpExtension$.next(helpExtension);
                  },
                  setHelpSupportUrl: function setHelpSupportUrl(url) {
                    return helpSupportUrl$.next(url);
                  },
                  getIsNavDrawerLocked$: function (_getIsNavDrawerLocked$) {
                    function getIsNavDrawerLocked$() {
                      return _getIsNavDrawerLocked$.apply(this, arguments);
                    }

                    getIsNavDrawerLocked$.toString = function () {
                      return _getIsNavDrawerLocked$.toString();
                    };

                    return getIsNavDrawerLocked$;
                  }(function () {
                    return getIsNavDrawerLocked$;
                  }),
                  getNavType$: function (_getNavType$) {
                    function getNavType$() {
                      return _getNavType$.apply(this, arguments);
                    }

                    getNavType$.toString = function () {
                      return _getNavType$.toString();
                    };

                    return getNavType$;
                  }(function () {
                    return getNavType$;
                  }),
                  getCustomNavLink$: function getCustomNavLink$() {
                    return customNavLink$.pipe(takeUntil(_this.stop$));
                  },
                  setCustomNavLink: function setCustomNavLink(customNavLink) {
                    customNavLink$.next(customNavLink);
                  }
                });

              case 24:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function start(_x) {
        return _start.apply(this, arguments);
      }

      return start;
    }()
  }, {
    key: "stop",
    value: function stop() {
      this.navLinks.stop();
      this.stop$.next();
    }
  }]);

  return ChromeService;
}();
/**
 * ChromeStart allows plugins to customize the global chrome header UI and
 * enrich the UX with additional information about the current location of the
 * browser.
 *
 * @remarks
 * While ChromeStart exposes many APIs, they should be used sparingly and the
 * developer should understand how they affect other plugins and applications.
 *
 * @example
 * How to add a recently accessed item to the sidebar:
 * ```ts
 * core.chrome.recentlyAccessed.add('/app/map/1234', 'Map 1234', '1234');
 * ```
 *
 * @example
 * How to set the help dropdown extension:
 * ```tsx
 * core.chrome.setHelpExtension(elem => {
 *   ReactDOM.render(<MyHelpComponent />, elem);
 *   return () => ReactDOM.unmountComponentAtNode(elem);
 * });
 * ```
 *
 * @public
 */