function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Utility to remove trailing, leading or duplicate slashes.
 * By default will only remove duplicates.
 */
export var removeSlashes = function removeSlashes(url) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$trailing = _ref.trailing,
      trailing = _ref$trailing === void 0 ? false : _ref$trailing,
      _ref$leading = _ref.leading,
      leading = _ref$leading === void 0 ? false : _ref$leading,
      _ref$duplicates = _ref.duplicates,
      duplicates = _ref$duplicates === void 0 ? true : _ref$duplicates;

  if (duplicates) {
    url = url.replace(/\/{2,}/g, '/');
  }

  if (trailing) {
    url = url.replace(/\/$/, '');
  }

  if (leading) {
    url = url.replace(/^\//, '');
  }

  return url;
};
export var appendAppPath = function appendAppPath(appBasePath) {
  var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  // Only prepend slash if not a hash or query path
  path = path === '' || path.startsWith('#') || path.startsWith('?') ? path : "/".concat(path); // Do not remove trailing slash when in hashbang

  var removeTrailing = path.indexOf('#') === -1;
  return removeSlashes("".concat(appBasePath).concat(path), {
    trailing: removeTrailing,
    duplicates: true,
    leading: false
  });
};
export function isLegacyApp(app) {
  return app.legacy === true;
}
/**
 * Converts a relative path to an absolute url.
 * Implementation is based on a specified behavior of the browser to automatically convert
 * a relative url to an absolute one when setting the `href` attribute of a `<a>` html element.
 *
 * @example
 * ```ts
 * // current url: `https://kibana:8000/base-path/app/my-app`
 * relativeToAbsolute('/base-path/app/another-app') => `https://kibana:8000/base-path/app/another-app`
 * ```
 */

export var relativeToAbsolute = function relativeToAbsolute(url) {
  var a = document.createElement('a');
  a.setAttribute('href', url);
  return a.href;
};
/**
 * Parse given url and return the associated app id and path if any app matches.
 * Input can either be:
 * - a path containing the basePath, ie `/base-path/app/my-app/some-path`
 * - an absolute url matching the `origin` of the kibana instance (as seen by the browser),
 *   i.e `https://kibana:8080/base-path/app/my-app/some-path`
 */

export var parseAppUrl = function parseAppUrl(url, basePath, apps) {
  var getOrigin = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function () {
    return window.location.origin;
  };
  url = removeBasePath(url, basePath, getOrigin());

  if (!url.startsWith('/')) {
    return undefined;
  }

  var _iterator = _createForOfIteratorHelper(apps.values()),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var app = _step.value;
      var appPath = isLegacyApp(app) ? app.appUrl : app.appRoute || "/app/".concat(app.id);

      if (url.startsWith(appPath)) {
        var path = url.substr(appPath.length);
        return {
          app: app.id,
          path: path.length ? path : undefined
        };
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
};

var removeBasePath = function removeBasePath(url, basePath, origin) {
  if (url.startsWith(origin)) {
    url = url.substring(origin.length);
  }

  return basePath.remove(url);
};

export function getAppInfo(app) {
  if (isLegacyApp(app)) {
    var updater$ = app.updater$,
        infos = _objectWithoutProperties(app, ["updater$"]);

    return _objectSpread(_objectSpread({}, infos), {}, {
      status: app.status,
      navLinkStatus: app.navLinkStatus,
      legacy: true
    });
  } else {
    var _updater$ = app.updater$,
        mount = app.mount,
        _infos = _objectWithoutProperties(app, ["updater$", "mount"]);

    return _objectSpread(_objectSpread({}, _infos), {}, {
      status: app.status,
      navLinkStatus: app.navLinkStatus,
      appRoute: app.appRoute,
      legacy: false
    });
  }
}