"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeToFileTask = writeToFileTask;

var path = _interopRequireWildcard(require("path"));

var _utils = require("../utils");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function writeToFileTask({
  roots
}) {
  return roots.map(root => ({
    task: async () => {
      const fullPath = path.resolve(process.cwd(), root.config.output);

      if (root.mapping && Object.keys(root.mapping.properties).length > 0) {
        const serializedMapping = JSON.stringify(root.mapping, null, 2).concat('\n');
        await (0, _utils.writeFileAsync)(fullPath, serializedMapping);
      }
    },
    title: `Writing mapping for ${root.config.root}`
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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