"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDatePicker = exports.euiDatePickerDefaultTimeFormat = exports.euiDatePickerDefaultDateFormat = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _form = require("../form");

var _error_boundary = require("../error_boundary");

var _context = require("../context");

var _packages = require("../../../packages");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// eslint-disable-line import/named
// @ts-ignore the type is provided by react-datepicker.d.ts
// eslint-disable-line import/no-unresolved
var euiDatePickerDefaultDateFormat = 'MM/DD/YYYY';
exports.euiDatePickerDefaultDateFormat = euiDatePickerDefaultDateFormat;
var euiDatePickerDefaultTimeFormat = 'hh:mm A';
exports.euiDatePickerDefaultTimeFormat = euiDatePickerDefaultTimeFormat;
var DatePicker = _packages.ReactDatePicker;

var EuiDatePicker =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiDatePicker, _Component);

  function EuiDatePicker() {
    (0, _classCallCheck2.default)(this, EuiDatePicker);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(EuiDatePicker).apply(this, arguments));
  }

  (0, _createClass2.default)(EuiDatePicker, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          adjustDateOnChange = _this$props.adjustDateOnChange,
          calendarClassName = _this$props.calendarClassName,
          className = _this$props.className,
          customInput = _this$props.customInput,
          dateFormat = _this$props.dateFormat,
          dayClassName = _this$props.dayClassName,
          disabled = _this$props.disabled,
          excludeDates = _this$props.excludeDates,
          filterDate = _this$props.filterDate,
          fullWidth = _this$props.fullWidth,
          iconType = _this$props.iconType,
          injectTimes = _this$props.injectTimes,
          inline = _this$props.inline,
          inputRef = _this$props.inputRef,
          isInvalid = _this$props.isInvalid,
          isLoading = _this$props.isLoading,
          locale = _this$props.locale,
          maxDate = _this$props.maxDate,
          maxTime = _this$props.maxTime,
          minDate = _this$props.minDate,
          minTime = _this$props.minTime,
          onChange = _this$props.onChange,
          onClear = _this$props.onClear,
          openToDate = _this$props.openToDate,
          placeholder = _this$props.placeholder,
          popperClassName = _this$props.popperClassName,
          popoverPlacement = _this$props.popoverPlacement,
          selected = _this$props.selected,
          shadow = _this$props.shadow,
          shouldCloseOnSelect = _this$props.shouldCloseOnSelect,
          showIcon = _this$props.showIcon,
          showTimeSelect = _this$props.showTimeSelect,
          showTimeSelectOnly = _this$props.showTimeSelectOnly,
          timeFormat = _this$props.timeFormat,
          utcOffset = _this$props.utcOffset,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["adjustDateOnChange", "calendarClassName", "className", "customInput", "dateFormat", "dayClassName", "disabled", "excludeDates", "filterDate", "fullWidth", "iconType", "injectTimes", "inline", "inputRef", "isInvalid", "isLoading", "locale", "maxDate", "maxTime", "minDate", "minTime", "onChange", "onClear", "openToDate", "placeholder", "popperClassName", "popoverPlacement", "selected", "shadow", "shouldCloseOnSelect", "showIcon", "showTimeSelect", "showTimeSelectOnly", "timeFormat", "utcOffset"]);
      var classes = (0, _classnames.default)('euiDatePicker', {
        'euiDatePicker--shadow': shadow,
        'euiDatePicker--inline': inline
      });
      var datePickerClasses = (0, _classnames.default)('euiDatePicker', 'euiFieldText', {
        'euiFieldText--fullWidth': fullWidth,
        'euiFieldText-isLoading': isLoading,
        'euiFieldText--withIcon': !inline && showIcon,
        'euiFieldText-isInvalid': isInvalid
      }, className);
      var optionalIcon;

      if (inline || customInput || !showIcon) {
        optionalIcon = undefined;
      } else if (iconType) {
        optionalIcon = iconType;
      } else if (showTimeSelectOnly) {
        optionalIcon = 'clock';
      } else {
        optionalIcon = 'calendar';
      } // In case the consumer did not alter the default date format but wants
      // to add the time select, we append the default time format


      var fullDateFormat = dateFormat;

      if (showTimeSelect && dateFormat === euiDatePickerDefaultDateFormat) {
        fullDateFormat = "".concat(dateFormat, " ").concat(timeFormat);
      } // EuiDatePicker only supports a subset of props from react-datepicker. Using any of
      // the unsupported props below will spit out an error.


      var PropNotSupported = function PropNotSupported() {
        throw new Error("You are using a prop from react-datepicker that EuiDatePicker\n        does not support. Please check the EUI documentation for more information.");
      };

      if ( // We don't want to show multiple months next to each other
      this.props.monthsShown || // There is no need to show week numbers
      this.props.showWeekNumbers || // Our css adapts to height, no need to fix it
      this.props.fixedHeight || // We force the month / year selection UI. No need to configure it
      this.props.dropdownMode || // Short month is uncessary. Our UI has plenty of room for full months
      this.props.useShortMonthInDropdown || // The today button is not needed. This should always be external to the calendar
      this.props.todayButton || // We hide the time caption, so there is no need to overwrite its text
      this.props.timeCaption || // We always want keyboard accessibility on
      this.props.disabledKeyboardNavigation || // This is easy enough to do. It can conflict with isLoading state
      this.props.isClearable || // There is no reason to launch the datepicker in its own modal. Can always build these ourselves
      this.props.withPortal) {
        return _react.default.createElement(_error_boundary.EuiErrorBoundary, null, _react.default.createElement(PropNotSupported, null));
      }

      return _react.default.createElement("span", null, _react.default.createElement("span", {
        className: classes
      }, _react.default.createElement(_form.EuiFormControlLayout, {
        icon: optionalIcon,
        fullWidth: fullWidth,
        clear: selected && onClear ? {
          onClick: onClear
        } : undefined,
        isLoading: isLoading
      }, _react.default.createElement(_form.EuiValidatableControl, {
        isInvalid: isInvalid
      }, _react.default.createElement(_context.EuiI18nConsumer, null, function (_ref) {
        var contextLocale = _ref.locale;
        return _react.default.createElement(DatePicker, (0, _extends2.default)({
          adjustDateOnChange: adjustDateOnChange,
          calendarClassName: calendarClassName,
          className: datePickerClasses,
          customInput: customInput,
          dateFormat: fullDateFormat,
          dayClassName: dayClassName,
          disabled: disabled,
          excludeDates: excludeDates,
          filterDate: filterDate,
          injectTimes: injectTimes,
          inline: inline,
          locale: locale || contextLocale,
          maxDate: maxDate,
          maxTime: maxTime,
          minDate: minDate,
          minTime: minTime,
          onChange: onChange,
          openToDate: openToDate,
          placeholderText: placeholder,
          popperClassName: popperClassName,
          ref: inputRef,
          selected: selected,
          shouldCloseOnSelect: shouldCloseOnSelect,
          showMonthDropdown: true,
          showTimeSelect: showTimeSelect,
          showTimeSelectOnly: showTimeSelectOnly,
          showYearDropdown: true,
          timeFormat: timeFormat,
          utcOffset: utcOffset,
          yearDropdownItemNumber: 7,
          accessibleMode: true,
          popperPlacement: popoverPlacement
        }, rest));
      })))));
    }
  }]);
  return EuiDatePicker;
}(_react.Component);

exports.EuiDatePicker = EuiDatePicker;
(0, _defineProperty2.default)(EuiDatePicker, "defaultProps", {
  adjustDateOnChange: true,
  dateFormat: euiDatePickerDefaultDateFormat,
  fullWidth: false,
  inputRef: function inputRef() {},
  isLoading: false,
  shadow: true,
  shouldCloseOnSelect: true,
  showIcon: true,
  showTimeSelect: false,
  timeFormat: euiDatePickerDefaultTimeFormat,
  popoverPlacement: 'bottom-start'
});
EuiDatePicker.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Applies classes to the numbered days provided. Check docs for example.
     */
  dayClassName: _propTypes.default.func,

  /**
     * Makes the input full width
     */
  fullWidth: _propTypes.default.bool,

  /**
     * ref for the ReactDatePicker instance
     */
  inputRef: _propTypes.default.any.isRequired,

  /**
     * Provides styling to the input when invalid
     */
  isInvalid: _propTypes.default.bool,

  /**
     * Provides styling to the input when loading
     */
  isLoading: _propTypes.default.bool,

  /**
     * What to do when the input is cleared by the x icon
     */
  onClear: _propTypes.default.func,

  /**
     * Opens to this date (in moment format) on first press, regardless of selection
     */
  openToDate: _propTypes.default.any,

  /**
     * Shows only when no date is selected
     */
  placeholder: _propTypes.default.string,

  /**
     * Can turn the shadow off if using the inline prop
     */
  shadow: _propTypes.default.bool,

  /**
     * Show the icon in input
     */
  showIcon: _propTypes.default.bool,

  /**
     * Pass an icon type to change the default `calendar` or `clock` icon
     */
  iconType: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired,
    side: _propTypes.default.any,
    ref: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.func.isRequired])
  }).isRequired]),

  /**
     * Sets the placement of the popover. It accepts: `"bottom"`, `"bottom-end"`, `"bottom-start"`, `"left"`, `"left-end"`, `"left-start"`, `"right"`, `"right-end"`, `"right-start"`, `"top"`, `"top-end"`, `"top-start"`
     */
  popoverPlacement: _propTypes.default.any
};
EuiDatePicker.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiDatePicker",
  "props": {
    "adjustDateOnChange": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "required": false
    },
    "dateFormat": {
      "defaultValue": {
        "value": "'MM/DD/YYYY'",
        "computed": false
      },
      "required": false
    },
    "fullWidth": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Makes the input full width"
    },
    "inputRef": {
      "defaultValue": {
        "value": "() => {}",
        "computed": false
      },
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "ref for the ReactDatePicker instance"
    },
    "isLoading": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Provides styling to the input when loading"
    },
    "shadow": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Can turn the shadow off if using the inline prop"
    },
    "shouldCloseOnSelect": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "required": false
    },
    "showIcon": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Show the icon in input"
    },
    "showTimeSelect": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "required": false
    },
    "timeFormat": {
      "defaultValue": {
        "value": "'hh:mm A'",
        "computed": false
      },
      "required": false
    },
    "popoverPlacement": {
      "defaultValue": {
        "value": "'bottom-start'",
        "computed": false
      },
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Sets the placement of the popover. It accepts: `\"bottom\"`, `\"bottom-end\"`, `\"bottom-start\"`, `\"left\"`, `\"left-end\"`, `\"left-start\"`, `\"right\"`, `\"right-end\"`, `\"right-start\"`, `\"top\"`, `\"top-end\"`, `\"top-start\"`"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "dayClassName": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "Applies classes to the numbered days provided. Check docs for example."
    },
    "isInvalid": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Provides styling to the input when invalid"
    },
    "onClear": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "What to do when the input is cleared by the x icon"
    },
    "openToDate": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Opens to this date (in moment format) on first press, regardless of selection"
    },
    "placeholder": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Shows only when no date is selected"
    },
    "iconType": {
      "type": {
        "name": "union",
        "value": [{
          "name": "union",
          "value": [{
            "name": "enum",
            "value": [{
              "value": "\"accessibility\"",
              "computed": false
            }, {
              "value": "\"addDataApp\"",
              "computed": false
            }, {
              "value": "\"advancedSettingsApp\"",
              "computed": false
            }, {
              "value": "\"aggregate\"",
              "computed": false
            }, {
              "value": "\"alert\"",
              "computed": false
            }, {
              "value": "\"annotation\"",
              "computed": false
            }, {
              "value": "\"apmApp\"",
              "computed": false
            }, {
              "value": "\"apmTrace\"",
              "computed": false
            }, {
              "value": "\"apps\"",
              "computed": false
            }, {
              "value": "\"arrowDown\"",
              "computed": false
            }, {
              "value": "\"arrowLeft\"",
              "computed": false
            }, {
              "value": "\"arrowRight\"",
              "computed": false
            }, {
              "value": "\"arrowUp\"",
              "computed": false
            }, {
              "value": "\"asterisk\"",
              "computed": false
            }, {
              "value": "\"auditbeatApp\"",
              "computed": false
            }, {
              "value": "\"beaker\"",
              "computed": false
            }, {
              "value": "\"bell\"",
              "computed": false
            }, {
              "value": "\"bellSlash\"",
              "computed": false
            }, {
              "value": "\"bolt\"",
              "computed": false
            }, {
              "value": "\"boxesHorizontal\"",
              "computed": false
            }, {
              "value": "\"boxesVertical\"",
              "computed": false
            }, {
              "value": "\"branch\"",
              "computed": false
            }, {
              "value": "\"broom\"",
              "computed": false
            }, {
              "value": "\"brush\"",
              "computed": false
            }, {
              "value": "\"bug\"",
              "computed": false
            }, {
              "value": "\"bullseye\"",
              "computed": false
            }, {
              "value": "\"calendar\"",
              "computed": false
            }, {
              "value": "\"canvasApp\"",
              "computed": false
            }, {
              "value": "\"codeApp\"",
              "computed": false
            }, {
              "value": "\"check\"",
              "computed": false
            }, {
              "value": "\"checkInCircleFilled\"",
              "computed": false
            }, {
              "value": "\"cheer\"",
              "computed": false
            }, {
              "value": "\"clock\"",
              "computed": false
            }, {
              "value": "\"cloudDrizzle\"",
              "computed": false
            }, {
              "value": "\"cloudStormy\"",
              "computed": false
            }, {
              "value": "\"cloudSunny\"",
              "computed": false
            }, {
              "value": "\"compute\"",
              "computed": false
            }, {
              "value": "\"console\"",
              "computed": false
            }, {
              "value": "\"consoleApp\"",
              "computed": false
            }, {
              "value": "\"controlsHorizontal\"",
              "computed": false
            }, {
              "value": "\"controlsVertical\"",
              "computed": false
            }, {
              "value": "\"copy\"",
              "computed": false
            }, {
              "value": "\"copyClipboard\"",
              "computed": false
            }, {
              "value": "\"createAdvancedJob\"",
              "computed": false
            }, {
              "value": "\"createMultiMetricJob\"",
              "computed": false
            }, {
              "value": "\"createPopulationJob\"",
              "computed": false
            }, {
              "value": "\"createSingleMetricJob\"",
              "computed": false
            }, {
              "value": "\"cross\"",
              "computed": false
            }, {
              "value": "\"crossClusterReplicationApp\"",
              "computed": false
            }, {
              "value": "\"crosshairs\"",
              "computed": false
            }, {
              "value": "\"crossInACircleFilled\"",
              "computed": false
            }, {
              "value": "\"currency\"",
              "computed": false
            }, {
              "value": "\"cut\"",
              "computed": false
            }, {
              "value": "\"dashboardApp\"",
              "computed": false
            }, {
              "value": "\"database\"",
              "computed": false
            }, {
              "value": "\"dataVisualizer\"",
              "computed": false
            }, {
              "value": "\"devToolsApp\"",
              "computed": false
            }, {
              "value": "\"discoverApp\"",
              "computed": false
            }, {
              "value": "\"document\"",
              "computed": false
            }, {
              "value": "\"documentEdit\"",
              "computed": false
            }, {
              "value": "\"documents\"",
              "computed": false
            }, {
              "value": "\"dot\"",
              "computed": false
            }, {
              "value": "\"download\"",
              "computed": false
            }, {
              "value": "\"editorAlignCenter\"",
              "computed": false
            }, {
              "value": "\"editorAlignLeft\"",
              "computed": false
            }, {
              "value": "\"editorAlignRight\"",
              "computed": false
            }, {
              "value": "\"editorBold\"",
              "computed": false
            }, {
              "value": "\"editorCodeBlock\"",
              "computed": false
            }, {
              "value": "\"editorComment\"",
              "computed": false
            }, {
              "value": "\"editorDistributeHorizontal\"",
              "computed": false
            }, {
              "value": "\"editorDistributeVertical\"",
              "computed": false
            }, {
              "value": "\"editorHeading\"",
              "computed": false
            }, {
              "value": "\"editorItalic\"",
              "computed": false
            }, {
              "value": "\"editorItemAlignLeft\"",
              "computed": false
            }, {
              "value": "\"editorItemAlignBottom\"",
              "computed": false
            }, {
              "value": "\"editorItemAlignCenter\"",
              "computed": false
            }, {
              "value": "\"editorItemAlignMiddle\"",
              "computed": false
            }, {
              "value": "\"editorItemAlignRight\"",
              "computed": false
            }, {
              "value": "\"editorItemAlignTop\"",
              "computed": false
            }, {
              "value": "\"editorLink\"",
              "computed": false
            }, {
              "value": "\"editorOrderedList\"",
              "computed": false
            }, {
              "value": "\"editorPositionBottomLeft\"",
              "computed": false
            }, {
              "value": "\"editorPositionBottomRight\"",
              "computed": false
            }, {
              "value": "\"editorPositionTopLeft\"",
              "computed": false
            }, {
              "value": "\"editorPositionTopRight\"",
              "computed": false
            }, {
              "value": "\"editorRedo\"",
              "computed": false
            }, {
              "value": "\"editorStrike\"",
              "computed": false
            }, {
              "value": "\"editorTable\"",
              "computed": false
            }, {
              "value": "\"editorUnderline\"",
              "computed": false
            }, {
              "value": "\"editorUndo\"",
              "computed": false
            }, {
              "value": "\"editorUnorderedList\"",
              "computed": false
            }, {
              "value": "\"email\"",
              "computed": false
            }, {
              "value": "\"empty\"",
              "computed": false
            }, {
              "value": "\"emsApp\"",
              "computed": false
            }, {
              "value": "\"exit\"",
              "computed": false
            }, {
              "value": "\"expand\"",
              "computed": false
            }, {
              "value": "\"expandMini\"",
              "computed": false
            }, {
              "value": "\"exportAction\"",
              "computed": false
            }, {
              "value": "\"eye\"",
              "computed": false
            }, {
              "value": "\"eyeClosed\"",
              "computed": false
            }, {
              "value": "\"faceHappy\"",
              "computed": false
            }, {
              "value": "\"faceNeutral\"",
              "computed": false
            }, {
              "value": "\"faceSad\"",
              "computed": false
            }, {
              "value": "\"filebeatApp\"",
              "computed": false
            }, {
              "value": "\"filter\"",
              "computed": false
            }, {
              "value": "\"flag\"",
              "computed": false
            }, {
              "value": "\"folderCheck\"",
              "computed": false
            }, {
              "value": "\"folderClosed\"",
              "computed": false
            }, {
              "value": "\"folderExclamation\"",
              "computed": false
            }, {
              "value": "\"folderOpen\"",
              "computed": false
            }, {
              "value": "\"fullScreen\"",
              "computed": false
            }, {
              "value": "\"gear\"",
              "computed": false
            }, {
              "value": "\"gisApp\"",
              "computed": false
            }, {
              "value": "\"glasses\"",
              "computed": false
            }, {
              "value": "\"globe\"",
              "computed": false
            }, {
              "value": "\"grab\"",
              "computed": false
            }, {
              "value": "\"grabHorizontal\"",
              "computed": false
            }, {
              "value": "\"graphApp\"",
              "computed": false
            }, {
              "value": "\"grid\"",
              "computed": false
            }, {
              "value": "\"grokApp\"",
              "computed": false
            }, {
              "value": "\"heart\"",
              "computed": false
            }, {
              "value": "\"heartbeatApp\"",
              "computed": false
            }, {
              "value": "\"heatmap\"",
              "computed": false
            }, {
              "value": "\"help\"",
              "computed": false
            }, {
              "value": "\"home\"",
              "computed": false
            }, {
              "value": "\"iInCircle\"",
              "computed": false
            }, {
              "value": "\"image\"",
              "computed": false
            }, {
              "value": "\"importAction\"",
              "computed": false
            }, {
              "value": "\"indexClose\"",
              "computed": false
            }, {
              "value": "\"indexEdit\"",
              "computed": false
            }, {
              "value": "\"indexFlush\"",
              "computed": false
            }, {
              "value": "\"indexManagementApp\"",
              "computed": false
            }, {
              "value": "\"indexMapping\"",
              "computed": false
            }, {
              "value": "\"indexOpen\"",
              "computed": false
            }, {
              "value": "\"indexPatternApp\"",
              "computed": false
            }, {
              "value": "\"indexRollupApp\"",
              "computed": false
            }, {
              "value": "\"indexSettings\"",
              "computed": false
            }, {
              "value": "\"inputOutput\"",
              "computed": false
            }, {
              "value": "\"inspect\"",
              "computed": false
            }, {
              "value": "\"invert\"",
              "computed": false
            }, {
              "value": "\"ip\"",
              "computed": false
            }, {
              "value": "\"keyboardShortcut\"",
              "computed": false
            }, {
              "value": "\"kqlField\"",
              "computed": false
            }, {
              "value": "\"kqlFunction\"",
              "computed": false
            }, {
              "value": "\"kqlOperand\"",
              "computed": false
            }, {
              "value": "\"kqlSelector\"",
              "computed": false
            }, {
              "value": "\"kqlValue\"",
              "computed": false
            }, {
              "value": "\"lensApp\"",
              "computed": false
            }, {
              "value": "\"link\"",
              "computed": false
            }, {
              "value": "\"list\"",
              "computed": false
            }, {
              "value": "\"listAdd\"",
              "computed": false
            }, {
              "value": "\"lock\"",
              "computed": false
            }, {
              "value": "\"lockOpen\"",
              "computed": false
            }, {
              "value": "\"logsApp\"",
              "computed": false
            }, {
              "value": "\"logoAerospike\"",
              "computed": false
            }, {
              "value": "\"logoApache\"",
              "computed": false
            }, {
              "value": "\"logoAPM\"",
              "computed": false
            }, {
              "value": "\"logoAppSearch\"",
              "computed": false
            }, {
              "value": "\"logoAWS\"",
              "computed": false
            }, {
              "value": "\"logoAWSMono\"",
              "computed": false
            }, {
              "value": "\"logoAzure\"",
              "computed": false
            }, {
              "value": "\"logoAzureMono\"",
              "computed": false
            }, {
              "value": "\"logoBeats\"",
              "computed": false
            }, {
              "value": "\"logoBusinessAnalytics\"",
              "computed": false
            }, {
              "value": "\"logoCeph\"",
              "computed": false
            }, {
              "value": "\"logoCloud\"",
              "computed": false
            }, {
              "value": "\"logoCloudEnterprise\"",
              "computed": false
            }, {
              "value": "\"logoCode\"",
              "computed": false
            }, {
              "value": "\"logoCodesandbox\"",
              "computed": false
            }, {
              "value": "\"logoCouchbase\"",
              "computed": false
            }, {
              "value": "\"logoDocker\"",
              "computed": false
            }, {
              "value": "\"logoDropwizard\"",
              "computed": false
            }, {
              "value": "\"logoElastic\"",
              "computed": false
            }, {
              "value": "\"logoElasticsearch\"",
              "computed": false
            }, {
              "value": "\"logoElasticStack\"",
              "computed": false
            }, {
              "value": "\"logoEnterpriseSearch\"",
              "computed": false
            }, {
              "value": "\"logoEtcd\"",
              "computed": false
            }, {
              "value": "\"logoGCP\"",
              "computed": false
            }, {
              "value": "\"logoGCPMono\"",
              "computed": false
            }, {
              "value": "\"logoGithub\"",
              "computed": false
            }, {
              "value": "\"logoGmail\"",
              "computed": false
            }, {
              "value": "\"logoGolang\"",
              "computed": false
            }, {
              "value": "\"logoGoogleG\"",
              "computed": false
            }, {
              "value": "\"logoHAproxy\"",
              "computed": false
            }, {
              "value": "\"logoIBM\"",
              "computed": false
            }, {
              "value": "\"logoIBMMono\"",
              "computed": false
            }, {
              "value": "\"logoKafka\"",
              "computed": false
            }, {
              "value": "\"logoKibana\"",
              "computed": false
            }, {
              "value": "\"logoKubernetes\"",
              "computed": false
            }, {
              "value": "\"logoLogging\"",
              "computed": false
            }, {
              "value": "\"logoLogstash\"",
              "computed": false
            }, {
              "value": "\"logoMaps\"",
              "computed": false
            }, {
              "value": "\"logoMemcached\"",
              "computed": false
            }, {
              "value": "\"logoMetrics\"",
              "computed": false
            }, {
              "value": "\"logoMongodb\"",
              "computed": false
            }, {
              "value": "\"logoMySQL\"",
              "computed": false
            }, {
              "value": "\"logoNginx\"",
              "computed": false
            }, {
              "value": "\"logoObservability\"",
              "computed": false
            }, {
              "value": "\"logoOsquery\"",
              "computed": false
            }, {
              "value": "\"logoPhp\"",
              "computed": false
            }, {
              "value": "\"logoPostgres\"",
              "computed": false
            }, {
              "value": "\"logoPrometheus\"",
              "computed": false
            }, {
              "value": "\"logoRabbitmq\"",
              "computed": false
            }, {
              "value": "\"logoRedis\"",
              "computed": false
            }, {
              "value": "\"logoSecurity\"",
              "computed": false
            }, {
              "value": "\"logoSiteSearch\"",
              "computed": false
            }, {
              "value": "\"logoSketch\"",
              "computed": false
            }, {
              "value": "\"logoSlack\"",
              "computed": false
            }, {
              "value": "\"logoUptime\"",
              "computed": false
            }, {
              "value": "\"logoWebhook\"",
              "computed": false
            }, {
              "value": "\"logoWindows\"",
              "computed": false
            }, {
              "value": "\"logoWorkplaceSearch\"",
              "computed": false
            }, {
              "value": "\"logstashFilter\"",
              "computed": false
            }, {
              "value": "\"logstashIf\"",
              "computed": false
            }, {
              "value": "\"logstashInput\"",
              "computed": false
            }, {
              "value": "\"logstashOutput\"",
              "computed": false
            }, {
              "value": "\"logstashQueue\"",
              "computed": false
            }, {
              "value": "\"machineLearningApp\"",
              "computed": false
            }, {
              "value": "\"magnet\"",
              "computed": false
            }, {
              "value": "\"magnifyWithMinus\"",
              "computed": false
            }, {
              "value": "\"magnifyWithPlus\"",
              "computed": false
            }, {
              "value": "\"managementApp\"",
              "computed": false
            }, {
              "value": "\"mapMarker\"",
              "computed": false
            }, {
              "value": "\"memory\"",
              "computed": false
            }, {
              "value": "\"menu\"",
              "computed": false
            }, {
              "value": "\"menuLeft\"",
              "computed": false
            }, {
              "value": "\"menuRight\"",
              "computed": false
            }, {
              "value": "\"merge\"",
              "computed": false
            }, {
              "value": "\"metricbeatApp\"",
              "computed": false
            }, {
              "value": "\"metricsApp\"",
              "computed": false
            }, {
              "value": "\"minimize\"",
              "computed": false
            }, {
              "value": "\"minusInCircle\"",
              "computed": false
            }, {
              "value": "\"minusInCircleFilled\"",
              "computed": false
            }, {
              "value": "\"monitoringApp\"",
              "computed": false
            }, {
              "value": "\"moon\"",
              "computed": false
            }, {
              "value": "\"nested\"",
              "computed": false
            }, {
              "value": "\"node\"",
              "computed": false
            }, {
              "value": "\"notebookApp\"",
              "computed": false
            }, {
              "value": "\"number\"",
              "computed": false
            }, {
              "value": "\"offline\"",
              "computed": false
            }, {
              "value": "\"online\"",
              "computed": false
            }, {
              "value": "\"package\"",
              "computed": false
            }, {
              "value": "\"packetbeatApp\"",
              "computed": false
            }, {
              "value": "\"pageSelect\"",
              "computed": false
            }, {
              "value": "\"pagesSelect\"",
              "computed": false
            }, {
              "value": "\"partial\"",
              "computed": false
            }, {
              "value": "\"paperClip\"",
              "computed": false
            }, {
              "value": "\"pause\"",
              "computed": false
            }, {
              "value": "\"pencil\"",
              "computed": false
            }, {
              "value": "\"pin\"",
              "computed": false
            }, {
              "value": "\"pinFilled\"",
              "computed": false
            }, {
              "value": "\"pipelineApp\"",
              "computed": false
            }, {
              "value": "\"play\"",
              "computed": false
            }, {
              "value": "\"plusInCircle\"",
              "computed": false
            }, {
              "value": "\"plusInCircleFilled\"",
              "computed": false
            }, {
              "value": "\"popout\"",
              "computed": false
            }, {
              "value": "\"push\"",
              "computed": false
            }, {
              "value": "\"questionInCircle\"",
              "computed": false
            }, {
              "value": "\"quote\"",
              "computed": false
            }, {
              "value": "\"recentlyViewedApp\"",
              "computed": false
            }, {
              "value": "\"refresh\"",
              "computed": false
            }, {
              "value": "\"reporter\"",
              "computed": false
            }, {
              "value": "\"reportingApp\"",
              "computed": false
            }, {
              "value": "\"save\"",
              "computed": false
            }, {
              "value": "\"savedObjectsApp\"",
              "computed": false
            }, {
              "value": "\"scale\"",
              "computed": false
            }, {
              "value": "\"search\"",
              "computed": false
            }, {
              "value": "\"searchProfilerApp\"",
              "computed": false
            }, {
              "value": "\"securityAnalyticsApp\"",
              "computed": false
            }, {
              "value": "\"securityApp\"",
              "computed": false
            }, {
              "value": "\"securitySignal\"",
              "computed": false
            }, {
              "value": "\"securitySignalDetected\"",
              "computed": false
            }, {
              "value": "\"securitySignalResolved\"",
              "computed": false
            }, {
              "value": "\"shard\"",
              "computed": false
            }, {
              "value": "\"share\"",
              "computed": false
            }, {
              "value": "\"snowflake\"",
              "computed": false
            }, {
              "value": "\"sortable\"",
              "computed": false
            }, {
              "value": "\"sortDown\"",
              "computed": false
            }, {
              "value": "\"sortLeft\"",
              "computed": false
            }, {
              "value": "\"sortRight\"",
              "computed": false
            }, {
              "value": "\"sortUp\"",
              "computed": false
            }, {
              "value": "\"spacesApp\"",
              "computed": false
            }, {
              "value": "\"sqlApp\"",
              "computed": false
            }, {
              "value": "\"starEmpty\"",
              "computed": false
            }, {
              "value": "\"starEmptySpace\"",
              "computed": false
            }, {
              "value": "\"starFilled\"",
              "computed": false
            }, {
              "value": "\"starFilledSpace\"",
              "computed": false
            }, {
              "value": "\"starMinusEmpty\"",
              "computed": false
            }, {
              "value": "\"starMinusFilled\"",
              "computed": false
            }, {
              "value": "\"starPlusEmpty\"",
              "computed": false
            }, {
              "value": "\"starPlusFilled\"",
              "computed": false
            }, {
              "value": "\"stats\"",
              "computed": false
            }, {
              "value": "\"stop\"",
              "computed": false
            }, {
              "value": "\"stopFilled\"",
              "computed": false
            }, {
              "value": "\"stopSlash\"",
              "computed": false
            }, {
              "value": "\"storage\"",
              "computed": false
            }, {
              "value": "\"string\"",
              "computed": false
            }, {
              "value": "\"submodule\"",
              "computed": false
            }, {
              "value": "\"swatchInput\"",
              "computed": false
            }, {
              "value": "\"symlink\"",
              "computed": false
            }, {
              "value": "\"tableOfContents\"",
              "computed": false
            }, {
              "value": "\"tableDensityExpanded\"",
              "computed": false
            }, {
              "value": "\"tableDensityCompact\"",
              "computed": false
            }, {
              "value": "\"tableDensityNormal\"",
              "computed": false
            }, {
              "value": "\"tag\"",
              "computed": false
            }, {
              "value": "\"tear\"",
              "computed": false
            }, {
              "value": "\"temperature\"",
              "computed": false
            }, {
              "value": "\"timeline\"",
              "computed": false
            }, {
              "value": "\"timelionApp\"",
              "computed": false
            }, {
              "value": "\"training\"",
              "computed": false
            }, {
              "value": "\"trash\"",
              "computed": false
            }, {
              "value": "\"upgradeAssistantApp\"",
              "computed": false
            }, {
              "value": "\"uptimeApp\"",
              "computed": false
            }, {
              "value": "\"user\"",
              "computed": false
            }, {
              "value": "\"users\"",
              "computed": false
            }, {
              "value": "\"usersRolesApp\"",
              "computed": false
            }, {
              "value": "\"vector\"",
              "computed": false
            }, {
              "value": "\"videoPlayer\"",
              "computed": false
            }, {
              "value": "\"visArea\"",
              "computed": false
            }, {
              "value": "\"visAreaStacked\"",
              "computed": false
            }, {
              "value": "\"visBarHorizontal\"",
              "computed": false
            }, {
              "value": "\"visBarHorizontalStacked\"",
              "computed": false
            }, {
              "value": "\"visBarVertical\"",
              "computed": false
            }, {
              "value": "\"visBarVerticalStacked\"",
              "computed": false
            }, {
              "value": "\"visGauge\"",
              "computed": false
            }, {
              "value": "\"visGoal\"",
              "computed": false
            }, {
              "value": "\"visLine\"",
              "computed": false
            }, {
              "value": "\"visMapCoordinate\"",
              "computed": false
            }, {
              "value": "\"visMapRegion\"",
              "computed": false
            }, {
              "value": "\"visMetric\"",
              "computed": false
            }, {
              "value": "\"visPie\"",
              "computed": false
            }, {
              "value": "\"visTable\"",
              "computed": false
            }, {
              "value": "\"visTagCloud\"",
              "computed": false
            }, {
              "value": "\"visText\"",
              "computed": false
            }, {
              "value": "\"visTimelion\"",
              "computed": false
            }, {
              "value": "\"visualizeApp\"",
              "computed": false
            }, {
              "value": "\"visVega\"",
              "computed": false
            }, {
              "value": "\"visVisualBuilder\"",
              "computed": false
            }, {
              "value": "\"watchesApp\"",
              "computed": false
            }, {
              "value": "\"wrench\"",
              "computed": false
            }, {
              "value": "\"tokenClass\"",
              "computed": false
            }, {
              "value": "\"tokenProperty\"",
              "computed": false
            }, {
              "value": "\"tokenEnum\"",
              "computed": false
            }, {
              "value": "\"tokenVariable\"",
              "computed": false
            }, {
              "value": "\"tokenMethod\"",
              "computed": false
            }, {
              "value": "\"tokenAnnotation\"",
              "computed": false
            }, {
              "value": "\"tokenException\"",
              "computed": false
            }, {
              "value": "\"tokenInterface\"",
              "computed": false
            }, {
              "value": "\"tokenParameter\"",
              "computed": false
            }, {
              "value": "\"tokenField\"",
              "computed": false
            }, {
              "value": "\"tokenElement\"",
              "computed": false
            }, {
              "value": "\"tokenFunction\"",
              "computed": false
            }, {
              "value": "\"tokenBoolean\"",
              "computed": false
            }, {
              "value": "\"tokenString\"",
              "computed": false
            }, {
              "value": "\"tokenArray\"",
              "computed": false
            }, {
              "value": "\"tokenNumber\"",
              "computed": false
            }, {
              "value": "\"tokenConstant\"",
              "computed": false
            }, {
              "value": "\"tokenObject\"",
              "computed": false
            }, {
              "value": "\"tokenEvent\"",
              "computed": false
            }, {
              "value": "\"tokenKey\"",
              "computed": false
            }, {
              "value": "\"tokenNull\"",
              "computed": false
            }, {
              "value": "\"tokenStruct\"",
              "computed": false
            }, {
              "value": "\"tokenPackage\"",
              "computed": false
            }, {
              "value": "\"tokenOperator\"",
              "computed": false
            }, {
              "value": "\"tokenEnumMember\"",
              "computed": false
            }, {
              "value": "\"tokenRepo\"",
              "computed": false
            }, {
              "value": "\"tokenSymbol\"",
              "computed": false
            }, {
              "value": "\"tokenFile\"",
              "computed": false
            }, {
              "value": "\"tokenModule\"",
              "computed": false
            }, {
              "value": "\"tokenNamespace\"",
              "computed": false
            }, {
              "value": "\"tokenDate\"",
              "computed": false
            }, {
              "value": "\"tokenIP\"",
              "computed": false
            }, {
              "value": "\"tokenNested\"",
              "computed": false
            }, {
              "value": "\"tokenAlias\"",
              "computed": false
            }, {
              "value": "\"tokenShape\"",
              "computed": false
            }, {
              "value": "\"tokenGeo\"",
              "computed": false
            }, {
              "value": "\"tokenRange\"",
              "computed": false
            }, {
              "value": "\"tokenBinary\"",
              "computed": false
            }, {
              "value": "\"tokenJoin\"",
              "computed": false
            }, {
              "value": "\"tokenPercolator\"",
              "computed": false
            }, {
              "value": "\"tokenFlattened\"",
              "computed": false
            }, {
              "value": "\"tokenRankFeature\"",
              "computed": false
            }, {
              "value": "\"tokenRankFeatures\"",
              "computed": false
            }, {
              "value": "\"tokenKeyword\"",
              "computed": false
            }, {
              "value": "\"tokenCompletionSuggester\"",
              "computed": false
            }, {
              "value": "\"tokenDenseVector\"",
              "computed": false
            }, {
              "value": "\"tokenText\"",
              "computed": false
            }, {
              "value": "\"tokenTokenCount\"",
              "computed": false
            }, {
              "value": "\"tokenSearchType\"",
              "computed": false
            }, {
              "value": "\"tokenHistogram\"",
              "computed": false
            }]
          }, {
            "name": "string"
          }, {
            "name": "elementType"
          }]
        }, {
          "name": "shape",
          "value": {
            "type": {
              "name": "union",
              "value": [{
                "name": "enum",
                "value": [{
                  "value": "\"accessibility\"",
                  "computed": false
                }, {
                  "value": "\"addDataApp\"",
                  "computed": false
                }, {
                  "value": "\"advancedSettingsApp\"",
                  "computed": false
                }, {
                  "value": "\"aggregate\"",
                  "computed": false
                }, {
                  "value": "\"alert\"",
                  "computed": false
                }, {
                  "value": "\"annotation\"",
                  "computed": false
                }, {
                  "value": "\"apmApp\"",
                  "computed": false
                }, {
                  "value": "\"apmTrace\"",
                  "computed": false
                }, {
                  "value": "\"apps\"",
                  "computed": false
                }, {
                  "value": "\"arrowDown\"",
                  "computed": false
                }, {
                  "value": "\"arrowLeft\"",
                  "computed": false
                }, {
                  "value": "\"arrowRight\"",
                  "computed": false
                }, {
                  "value": "\"arrowUp\"",
                  "computed": false
                }, {
                  "value": "\"asterisk\"",
                  "computed": false
                }, {
                  "value": "\"auditbeatApp\"",
                  "computed": false
                }, {
                  "value": "\"beaker\"",
                  "computed": false
                }, {
                  "value": "\"bell\"",
                  "computed": false
                }, {
                  "value": "\"bellSlash\"",
                  "computed": false
                }, {
                  "value": "\"bolt\"",
                  "computed": false
                }, {
                  "value": "\"boxesHorizontal\"",
                  "computed": false
                }, {
                  "value": "\"boxesVertical\"",
                  "computed": false
                }, {
                  "value": "\"branch\"",
                  "computed": false
                }, {
                  "value": "\"broom\"",
                  "computed": false
                }, {
                  "value": "\"brush\"",
                  "computed": false
                }, {
                  "value": "\"bug\"",
                  "computed": false
                }, {
                  "value": "\"bullseye\"",
                  "computed": false
                }, {
                  "value": "\"calendar\"",
                  "computed": false
                }, {
                  "value": "\"canvasApp\"",
                  "computed": false
                }, {
                  "value": "\"codeApp\"",
                  "computed": false
                }, {
                  "value": "\"check\"",
                  "computed": false
                }, {
                  "value": "\"checkInCircleFilled\"",
                  "computed": false
                }, {
                  "value": "\"cheer\"",
                  "computed": false
                }, {
                  "value": "\"clock\"",
                  "computed": false
                }, {
                  "value": "\"cloudDrizzle\"",
                  "computed": false
                }, {
                  "value": "\"cloudStormy\"",
                  "computed": false
                }, {
                  "value": "\"cloudSunny\"",
                  "computed": false
                }, {
                  "value": "\"compute\"",
                  "computed": false
                }, {
                  "value": "\"console\"",
                  "computed": false
                }, {
                  "value": "\"consoleApp\"",
                  "computed": false
                }, {
                  "value": "\"controlsHorizontal\"",
                  "computed": false
                }, {
                  "value": "\"controlsVertical\"",
                  "computed": false
                }, {
                  "value": "\"copy\"",
                  "computed": false
                }, {
                  "value": "\"copyClipboard\"",
                  "computed": false
                }, {
                  "value": "\"createAdvancedJob\"",
                  "computed": false
                }, {
                  "value": "\"createMultiMetricJob\"",
                  "computed": false
                }, {
                  "value": "\"createPopulationJob\"",
                  "computed": false
                }, {
                  "value": "\"createSingleMetricJob\"",
                  "computed": false
                }, {
                  "value": "\"cross\"",
                  "computed": false
                }, {
                  "value": "\"crossClusterReplicationApp\"",
                  "computed": false
                }, {
                  "value": "\"crosshairs\"",
                  "computed": false
                }, {
                  "value": "\"crossInACircleFilled\"",
                  "computed": false
                }, {
                  "value": "\"currency\"",
                  "computed": false
                }, {
                  "value": "\"cut\"",
                  "computed": false
                }, {
                  "value": "\"dashboardApp\"",
                  "computed": false
                }, {
                  "value": "\"database\"",
                  "computed": false
                }, {
                  "value": "\"dataVisualizer\"",
                  "computed": false
                }, {
                  "value": "\"devToolsApp\"",
                  "computed": false
                }, {
                  "value": "\"discoverApp\"",
                  "computed": false
                }, {
                  "value": "\"document\"",
                  "computed": false
                }, {
                  "value": "\"documentEdit\"",
                  "computed": false
                }, {
                  "value": "\"documents\"",
                  "computed": false
                }, {
                  "value": "\"dot\"",
                  "computed": false
                }, {
                  "value": "\"download\"",
                  "computed": false
                }, {
                  "value": "\"editorAlignCenter\"",
                  "computed": false
                }, {
                  "value": "\"editorAlignLeft\"",
                  "computed": false
                }, {
                  "value": "\"editorAlignRight\"",
                  "computed": false
                }, {
                  "value": "\"editorBold\"",
                  "computed": false
                }, {
                  "value": "\"editorCodeBlock\"",
                  "computed": false
                }, {
                  "value": "\"editorComment\"",
                  "computed": false
                }, {
                  "value": "\"editorDistributeHorizontal\"",
                  "computed": false
                }, {
                  "value": "\"editorDistributeVertical\"",
                  "computed": false
                }, {
                  "value": "\"editorHeading\"",
                  "computed": false
                }, {
                  "value": "\"editorItalic\"",
                  "computed": false
                }, {
                  "value": "\"editorItemAlignLeft\"",
                  "computed": false
                }, {
                  "value": "\"editorItemAlignBottom\"",
                  "computed": false
                }, {
                  "value": "\"editorItemAlignCenter\"",
                  "computed": false
                }, {
                  "value": "\"editorItemAlignMiddle\"",
                  "computed": false
                }, {
                  "value": "\"editorItemAlignRight\"",
                  "computed": false
                }, {
                  "value": "\"editorItemAlignTop\"",
                  "computed": false
                }, {
                  "value": "\"editorLink\"",
                  "computed": false
                }, {
                  "value": "\"editorOrderedList\"",
                  "computed": false
                }, {
                  "value": "\"editorPositionBottomLeft\"",
                  "computed": false
                }, {
                  "value": "\"editorPositionBottomRight\"",
                  "computed": false
                }, {
                  "value": "\"editorPositionTopLeft\"",
                  "computed": false
                }, {
                  "value": "\"editorPositionTopRight\"",
                  "computed": false
                }, {
                  "value": "\"editorRedo\"",
                  "computed": false
                }, {
                  "value": "\"editorStrike\"",
                  "computed": false
                }, {
                  "value": "\"editorTable\"",
                  "computed": false
                }, {
                  "value": "\"editorUnderline\"",
                  "computed": false
                }, {
                  "value": "\"editorUndo\"",
                  "computed": false
                }, {
                  "value": "\"editorUnorderedList\"",
                  "computed": false
                }, {
                  "value": "\"email\"",
                  "computed": false
                }, {
                  "value": "\"empty\"",
                  "computed": false
                }, {
                  "value": "\"emsApp\"",
                  "computed": false
                }, {
                  "value": "\"exit\"",
                  "computed": false
                }, {
                  "value": "\"expand\"",
                  "computed": false
                }, {
                  "value": "\"expandMini\"",
                  "computed": false
                }, {
                  "value": "\"exportAction\"",
                  "computed": false
                }, {
                  "value": "\"eye\"",
                  "computed": false
                }, {
                  "value": "\"eyeClosed\"",
                  "computed": false
                }, {
                  "value": "\"faceHappy\"",
                  "computed": false
                }, {
                  "value": "\"faceNeutral\"",
                  "computed": false
                }, {
                  "value": "\"faceSad\"",
                  "computed": false
                }, {
                  "value": "\"filebeatApp\"",
                  "computed": false
                }, {
                  "value": "\"filter\"",
                  "computed": false
                }, {
                  "value": "\"flag\"",
                  "computed": false
                }, {
                  "value": "\"folderCheck\"",
                  "computed": false
                }, {
                  "value": "\"folderClosed\"",
                  "computed": false
                }, {
                  "value": "\"folderExclamation\"",
                  "computed": false
                }, {
                  "value": "\"folderOpen\"",
                  "computed": false
                }, {
                  "value": "\"fullScreen\"",
                  "computed": false
                }, {
                  "value": "\"gear\"",
                  "computed": false
                }, {
                  "value": "\"gisApp\"",
                  "computed": false
                }, {
                  "value": "\"glasses\"",
                  "computed": false
                }, {
                  "value": "\"globe\"",
                  "computed": false
                }, {
                  "value": "\"grab\"",
                  "computed": false
                }, {
                  "value": "\"grabHorizontal\"",
                  "computed": false
                }, {
                  "value": "\"graphApp\"",
                  "computed": false
                }, {
                  "value": "\"grid\"",
                  "computed": false
                }, {
                  "value": "\"grokApp\"",
                  "computed": false
                }, {
                  "value": "\"heart\"",
                  "computed": false
                }, {
                  "value": "\"heartbeatApp\"",
                  "computed": false
                }, {
                  "value": "\"heatmap\"",
                  "computed": false
                }, {
                  "value": "\"help\"",
                  "computed": false
                }, {
                  "value": "\"home\"",
                  "computed": false
                }, {
                  "value": "\"iInCircle\"",
                  "computed": false
                }, {
                  "value": "\"image\"",
                  "computed": false
                }, {
                  "value": "\"importAction\"",
                  "computed": false
                }, {
                  "value": "\"indexClose\"",
                  "computed": false
                }, {
                  "value": "\"indexEdit\"",
                  "computed": false
                }, {
                  "value": "\"indexFlush\"",
                  "computed": false
                }, {
                  "value": "\"indexManagementApp\"",
                  "computed": false
                }, {
                  "value": "\"indexMapping\"",
                  "computed": false
                }, {
                  "value": "\"indexOpen\"",
                  "computed": false
                }, {
                  "value": "\"indexPatternApp\"",
                  "computed": false
                }, {
                  "value": "\"indexRollupApp\"",
                  "computed": false
                }, {
                  "value": "\"indexSettings\"",
                  "computed": false
                }, {
                  "value": "\"inputOutput\"",
                  "computed": false
                }, {
                  "value": "\"inspect\"",
                  "computed": false
                }, {
                  "value": "\"invert\"",
                  "computed": false
                }, {
                  "value": "\"ip\"",
                  "computed": false
                }, {
                  "value": "\"keyboardShortcut\"",
                  "computed": false
                }, {
                  "value": "\"kqlField\"",
                  "computed": false
                }, {
                  "value": "\"kqlFunction\"",
                  "computed": false
                }, {
                  "value": "\"kqlOperand\"",
                  "computed": false
                }, {
                  "value": "\"kqlSelector\"",
                  "computed": false
                }, {
                  "value": "\"kqlValue\"",
                  "computed": false
                }, {
                  "value": "\"lensApp\"",
                  "computed": false
                }, {
                  "value": "\"link\"",
                  "computed": false
                }, {
                  "value": "\"list\"",
                  "computed": false
                }, {
                  "value": "\"listAdd\"",
                  "computed": false
                }, {
                  "value": "\"lock\"",
                  "computed": false
                }, {
                  "value": "\"lockOpen\"",
                  "computed": false
                }, {
                  "value": "\"logsApp\"",
                  "computed": false
                }, {
                  "value": "\"logoAerospike\"",
                  "computed": false
                }, {
                  "value": "\"logoApache\"",
                  "computed": false
                }, {
                  "value": "\"logoAPM\"",
                  "computed": false
                }, {
                  "value": "\"logoAppSearch\"",
                  "computed": false
                }, {
                  "value": "\"logoAWS\"",
                  "computed": false
                }, {
                  "value": "\"logoAWSMono\"",
                  "computed": false
                }, {
                  "value": "\"logoAzure\"",
                  "computed": false
                }, {
                  "value": "\"logoAzureMono\"",
                  "computed": false
                }, {
                  "value": "\"logoBeats\"",
                  "computed": false
                }, {
                  "value": "\"logoBusinessAnalytics\"",
                  "computed": false
                }, {
                  "value": "\"logoCeph\"",
                  "computed": false
                }, {
                  "value": "\"logoCloud\"",
                  "computed": false
                }, {
                  "value": "\"logoCloudEnterprise\"",
                  "computed": false
                }, {
                  "value": "\"logoCode\"",
                  "computed": false
                }, {
                  "value": "\"logoCodesandbox\"",
                  "computed": false
                }, {
                  "value": "\"logoCouchbase\"",
                  "computed": false
                }, {
                  "value": "\"logoDocker\"",
                  "computed": false
                }, {
                  "value": "\"logoDropwizard\"",
                  "computed": false
                }, {
                  "value": "\"logoElastic\"",
                  "computed": false
                }, {
                  "value": "\"logoElasticsearch\"",
                  "computed": false
                }, {
                  "value": "\"logoElasticStack\"",
                  "computed": false
                }, {
                  "value": "\"logoEnterpriseSearch\"",
                  "computed": false
                }, {
                  "value": "\"logoEtcd\"",
                  "computed": false
                }, {
                  "value": "\"logoGCP\"",
                  "computed": false
                }, {
                  "value": "\"logoGCPMono\"",
                  "computed": false
                }, {
                  "value": "\"logoGithub\"",
                  "computed": false
                }, {
                  "value": "\"logoGmail\"",
                  "computed": false
                }, {
                  "value": "\"logoGolang\"",
                  "computed": false
                }, {
                  "value": "\"logoGoogleG\"",
                  "computed": false
                }, {
                  "value": "\"logoHAproxy\"",
                  "computed": false
                }, {
                  "value": "\"logoIBM\"",
                  "computed": false
                }, {
                  "value": "\"logoIBMMono\"",
                  "computed": false
                }, {
                  "value": "\"logoKafka\"",
                  "computed": false
                }, {
                  "value": "\"logoKibana\"",
                  "computed": false
                }, {
                  "value": "\"logoKubernetes\"",
                  "computed": false
                }, {
                  "value": "\"logoLogging\"",
                  "computed": false
                }, {
                  "value": "\"logoLogstash\"",
                  "computed": false
                }, {
                  "value": "\"logoMaps\"",
                  "computed": false
                }, {
                  "value": "\"logoMemcached\"",
                  "computed": false
                }, {
                  "value": "\"logoMetrics\"",
                  "computed": false
                }, {
                  "value": "\"logoMongodb\"",
                  "computed": false
                }, {
                  "value": "\"logoMySQL\"",
                  "computed": false
                }, {
                  "value": "\"logoNginx\"",
                  "computed": false
                }, {
                  "value": "\"logoObservability\"",
                  "computed": false
                }, {
                  "value": "\"logoOsquery\"",
                  "computed": false
                }, {
                  "value": "\"logoPhp\"",
                  "computed": false
                }, {
                  "value": "\"logoPostgres\"",
                  "computed": false
                }, {
                  "value": "\"logoPrometheus\"",
                  "computed": false
                }, {
                  "value": "\"logoRabbitmq\"",
                  "computed": false
                }, {
                  "value": "\"logoRedis\"",
                  "computed": false
                }, {
                  "value": "\"logoSecurity\"",
                  "computed": false
                }, {
                  "value": "\"logoSiteSearch\"",
                  "computed": false
                }, {
                  "value": "\"logoSketch\"",
                  "computed": false
                }, {
                  "value": "\"logoSlack\"",
                  "computed": false
                }, {
                  "value": "\"logoUptime\"",
                  "computed": false
                }, {
                  "value": "\"logoWebhook\"",
                  "computed": false
                }, {
                  "value": "\"logoWindows\"",
                  "computed": false
                }, {
                  "value": "\"logoWorkplaceSearch\"",
                  "computed": false
                }, {
                  "value": "\"logstashFilter\"",
                  "computed": false
                }, {
                  "value": "\"logstashIf\"",
                  "computed": false
                }, {
                  "value": "\"logstashInput\"",
                  "computed": false
                }, {
                  "value": "\"logstashOutput\"",
                  "computed": false
                }, {
                  "value": "\"logstashQueue\"",
                  "computed": false
                }, {
                  "value": "\"machineLearningApp\"",
                  "computed": false
                }, {
                  "value": "\"magnet\"",
                  "computed": false
                }, {
                  "value": "\"magnifyWithMinus\"",
                  "computed": false
                }, {
                  "value": "\"magnifyWithPlus\"",
                  "computed": false
                }, {
                  "value": "\"managementApp\"",
                  "computed": false
                }, {
                  "value": "\"mapMarker\"",
                  "computed": false
                }, {
                  "value": "\"memory\"",
                  "computed": false
                }, {
                  "value": "\"menu\"",
                  "computed": false
                }, {
                  "value": "\"menuLeft\"",
                  "computed": false
                }, {
                  "value": "\"menuRight\"",
                  "computed": false
                }, {
                  "value": "\"merge\"",
                  "computed": false
                }, {
                  "value": "\"metricbeatApp\"",
                  "computed": false
                }, {
                  "value": "\"metricsApp\"",
                  "computed": false
                }, {
                  "value": "\"minimize\"",
                  "computed": false
                }, {
                  "value": "\"minusInCircle\"",
                  "computed": false
                }, {
                  "value": "\"minusInCircleFilled\"",
                  "computed": false
                }, {
                  "value": "\"monitoringApp\"",
                  "computed": false
                }, {
                  "value": "\"moon\"",
                  "computed": false
                }, {
                  "value": "\"nested\"",
                  "computed": false
                }, {
                  "value": "\"node\"",
                  "computed": false
                }, {
                  "value": "\"notebookApp\"",
                  "computed": false
                }, {
                  "value": "\"number\"",
                  "computed": false
                }, {
                  "value": "\"offline\"",
                  "computed": false
                }, {
                  "value": "\"online\"",
                  "computed": false
                }, {
                  "value": "\"package\"",
                  "computed": false
                }, {
                  "value": "\"packetbeatApp\"",
                  "computed": false
                }, {
                  "value": "\"pageSelect\"",
                  "computed": false
                }, {
                  "value": "\"pagesSelect\"",
                  "computed": false
                }, {
                  "value": "\"partial\"",
                  "computed": false
                }, {
                  "value": "\"paperClip\"",
                  "computed": false
                }, {
                  "value": "\"pause\"",
                  "computed": false
                }, {
                  "value": "\"pencil\"",
                  "computed": false
                }, {
                  "value": "\"pin\"",
                  "computed": false
                }, {
                  "value": "\"pinFilled\"",
                  "computed": false
                }, {
                  "value": "\"pipelineApp\"",
                  "computed": false
                }, {
                  "value": "\"play\"",
                  "computed": false
                }, {
                  "value": "\"plusInCircle\"",
                  "computed": false
                }, {
                  "value": "\"plusInCircleFilled\"",
                  "computed": false
                }, {
                  "value": "\"popout\"",
                  "computed": false
                }, {
                  "value": "\"push\"",
                  "computed": false
                }, {
                  "value": "\"questionInCircle\"",
                  "computed": false
                }, {
                  "value": "\"quote\"",
                  "computed": false
                }, {
                  "value": "\"recentlyViewedApp\"",
                  "computed": false
                }, {
                  "value": "\"refresh\"",
                  "computed": false
                }, {
                  "value": "\"reporter\"",
                  "computed": false
                }, {
                  "value": "\"reportingApp\"",
                  "computed": false
                }, {
                  "value": "\"save\"",
                  "computed": false
                }, {
                  "value": "\"savedObjectsApp\"",
                  "computed": false
                }, {
                  "value": "\"scale\"",
                  "computed": false
                }, {
                  "value": "\"search\"",
                  "computed": false
                }, {
                  "value": "\"searchProfilerApp\"",
                  "computed": false
                }, {
                  "value": "\"securityAnalyticsApp\"",
                  "computed": false
                }, {
                  "value": "\"securityApp\"",
                  "computed": false
                }, {
                  "value": "\"securitySignal\"",
                  "computed": false
                }, {
                  "value": "\"securitySignalDetected\"",
                  "computed": false
                }, {
                  "value": "\"securitySignalResolved\"",
                  "computed": false
                }, {
                  "value": "\"shard\"",
                  "computed": false
                }, {
                  "value": "\"share\"",
                  "computed": false
                }, {
                  "value": "\"snowflake\"",
                  "computed": false
                }, {
                  "value": "\"sortable\"",
                  "computed": false
                }, {
                  "value": "\"sortDown\"",
                  "computed": false
                }, {
                  "value": "\"sortLeft\"",
                  "computed": false
                }, {
                  "value": "\"sortRight\"",
                  "computed": false
                }, {
                  "value": "\"sortUp\"",
                  "computed": false
                }, {
                  "value": "\"spacesApp\"",
                  "computed": false
                }, {
                  "value": "\"sqlApp\"",
                  "computed": false
                }, {
                  "value": "\"starEmpty\"",
                  "computed": false
                }, {
                  "value": "\"starEmptySpace\"",
                  "computed": false
                }, {
                  "value": "\"starFilled\"",
                  "computed": false
                }, {
                  "value": "\"starFilledSpace\"",
                  "computed": false
                }, {
                  "value": "\"starMinusEmpty\"",
                  "computed": false
                }, {
                  "value": "\"starMinusFilled\"",
                  "computed": false
                }, {
                  "value": "\"starPlusEmpty\"",
                  "computed": false
                }, {
                  "value": "\"starPlusFilled\"",
                  "computed": false
                }, {
                  "value": "\"stats\"",
                  "computed": false
                }, {
                  "value": "\"stop\"",
                  "computed": false
                }, {
                  "value": "\"stopFilled\"",
                  "computed": false
                }, {
                  "value": "\"stopSlash\"",
                  "computed": false
                }, {
                  "value": "\"storage\"",
                  "computed": false
                }, {
                  "value": "\"string\"",
                  "computed": false
                }, {
                  "value": "\"submodule\"",
                  "computed": false
                }, {
                  "value": "\"swatchInput\"",
                  "computed": false
                }, {
                  "value": "\"symlink\"",
                  "computed": false
                }, {
                  "value": "\"tableOfContents\"",
                  "computed": false
                }, {
                  "value": "\"tableDensityExpanded\"",
                  "computed": false
                }, {
                  "value": "\"tableDensityCompact\"",
                  "computed": false
                }, {
                  "value": "\"tableDensityNormal\"",
                  "computed": false
                }, {
                  "value": "\"tag\"",
                  "computed": false
                }, {
                  "value": "\"tear\"",
                  "computed": false
                }, {
                  "value": "\"temperature\"",
                  "computed": false
                }, {
                  "value": "\"timeline\"",
                  "computed": false
                }, {
                  "value": "\"timelionApp\"",
                  "computed": false
                }, {
                  "value": "\"training\"",
                  "computed": false
                }, {
                  "value": "\"trash\"",
                  "computed": false
                }, {
                  "value": "\"upgradeAssistantApp\"",
                  "computed": false
                }, {
                  "value": "\"uptimeApp\"",
                  "computed": false
                }, {
                  "value": "\"user\"",
                  "computed": false
                }, {
                  "value": "\"users\"",
                  "computed": false
                }, {
                  "value": "\"usersRolesApp\"",
                  "computed": false
                }, {
                  "value": "\"vector\"",
                  "computed": false
                }, {
                  "value": "\"videoPlayer\"",
                  "computed": false
                }, {
                  "value": "\"visArea\"",
                  "computed": false
                }, {
                  "value": "\"visAreaStacked\"",
                  "computed": false
                }, {
                  "value": "\"visBarHorizontal\"",
                  "computed": false
                }, {
                  "value": "\"visBarHorizontalStacked\"",
                  "computed": false
                }, {
                  "value": "\"visBarVertical\"",
                  "computed": false
                }, {
                  "value": "\"visBarVerticalStacked\"",
                  "computed": false
                }, {
                  "value": "\"visGauge\"",
                  "computed": false
                }, {
                  "value": "\"visGoal\"",
                  "computed": false
                }, {
                  "value": "\"visLine\"",
                  "computed": false
                }, {
                  "value": "\"visMapCoordinate\"",
                  "computed": false
                }, {
                  "value": "\"visMapRegion\"",
                  "computed": false
                }, {
                  "value": "\"visMetric\"",
                  "computed": false
                }, {
                  "value": "\"visPie\"",
                  "computed": false
                }, {
                  "value": "\"visTable\"",
                  "computed": false
                }, {
                  "value": "\"visTagCloud\"",
                  "computed": false
                }, {
                  "value": "\"visText\"",
                  "computed": false
                }, {
                  "value": "\"visTimelion\"",
                  "computed": false
                }, {
                  "value": "\"visualizeApp\"",
                  "computed": false
                }, {
                  "value": "\"visVega\"",
                  "computed": false
                }, {
                  "value": "\"visVisualBuilder\"",
                  "computed": false
                }, {
                  "value": "\"watchesApp\"",
                  "computed": false
                }, {
                  "value": "\"wrench\"",
                  "computed": false
                }, {
                  "value": "\"tokenClass\"",
                  "computed": false
                }, {
                  "value": "\"tokenProperty\"",
                  "computed": false
                }, {
                  "value": "\"tokenEnum\"",
                  "computed": false
                }, {
                  "value": "\"tokenVariable\"",
                  "computed": false
                }, {
                  "value": "\"tokenMethod\"",
                  "computed": false
                }, {
                  "value": "\"tokenAnnotation\"",
                  "computed": false
                }, {
                  "value": "\"tokenException\"",
                  "computed": false
                }, {
                  "value": "\"tokenInterface\"",
                  "computed": false
                }, {
                  "value": "\"tokenParameter\"",
                  "computed": false
                }, {
                  "value": "\"tokenField\"",
                  "computed": false
                }, {
                  "value": "\"tokenElement\"",
                  "computed": false
                }, {
                  "value": "\"tokenFunction\"",
                  "computed": false
                }, {
                  "value": "\"tokenBoolean\"",
                  "computed": false
                }, {
                  "value": "\"tokenString\"",
                  "computed": false
                }, {
                  "value": "\"tokenArray\"",
                  "computed": false
                }, {
                  "value": "\"tokenNumber\"",
                  "computed": false
                }, {
                  "value": "\"tokenConstant\"",
                  "computed": false
                }, {
                  "value": "\"tokenObject\"",
                  "computed": false
                }, {
                  "value": "\"tokenEvent\"",
                  "computed": false
                }, {
                  "value": "\"tokenKey\"",
                  "computed": false
                }, {
                  "value": "\"tokenNull\"",
                  "computed": false
                }, {
                  "value": "\"tokenStruct\"",
                  "computed": false
                }, {
                  "value": "\"tokenPackage\"",
                  "computed": false
                }, {
                  "value": "\"tokenOperator\"",
                  "computed": false
                }, {
                  "value": "\"tokenEnumMember\"",
                  "computed": false
                }, {
                  "value": "\"tokenRepo\"",
                  "computed": false
                }, {
                  "value": "\"tokenSymbol\"",
                  "computed": false
                }, {
                  "value": "\"tokenFile\"",
                  "computed": false
                }, {
                  "value": "\"tokenModule\"",
                  "computed": false
                }, {
                  "value": "\"tokenNamespace\"",
                  "computed": false
                }, {
                  "value": "\"tokenDate\"",
                  "computed": false
                }, {
                  "value": "\"tokenIP\"",
                  "computed": false
                }, {
                  "value": "\"tokenNested\"",
                  "computed": false
                }, {
                  "value": "\"tokenAlias\"",
                  "computed": false
                }, {
                  "value": "\"tokenShape\"",
                  "computed": false
                }, {
                  "value": "\"tokenGeo\"",
                  "computed": false
                }, {
                  "value": "\"tokenRange\"",
                  "computed": false
                }, {
                  "value": "\"tokenBinary\"",
                  "computed": false
                }, {
                  "value": "\"tokenJoin\"",
                  "computed": false
                }, {
                  "value": "\"tokenPercolator\"",
                  "computed": false
                }, {
                  "value": "\"tokenFlattened\"",
                  "computed": false
                }, {
                  "value": "\"tokenRankFeature\"",
                  "computed": false
                }, {
                  "value": "\"tokenRankFeatures\"",
                  "computed": false
                }, {
                  "value": "\"tokenKeyword\"",
                  "computed": false
                }, {
                  "value": "\"tokenCompletionSuggester\"",
                  "computed": false
                }, {
                  "value": "\"tokenDenseVector\"",
                  "computed": false
                }, {
                  "value": "\"tokenText\"",
                  "computed": false
                }, {
                  "value": "\"tokenTokenCount\"",
                  "computed": false
                }, {
                  "value": "\"tokenSearchType\"",
                  "computed": false
                }, {
                  "value": "\"tokenHistogram\"",
                  "computed": false
                }]
              }, {
                "name": "string"
              }, {
                "name": "elementType"
              }],
              "required": true
            },
            "side": {
              "name": "any",
              "required": false
            },
            "ref": {
              "name": "union",
              "value": [{
                "name": "string"
              }, {
                "name": "func"
              }],
              "required": false
            }
          }
        }]
      },
      "required": false,
      "description": "Pass an icon type to change the default `calendar` or `clock` icon"
    }
  }
};