"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxPill = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _badge = require("../../badge");

var _i18n = require("../../i18n");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiComboBoxPill =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiComboBoxPill, _Component);

  function EuiComboBoxPill() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiComboBoxPill);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiComboBoxPill)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCloseButtonClick", function () {
      var _this$props = _this.props,
          onClose = _this$props.onClose,
          option = _this$props.option;

      if (onClose) {
        onClose(option);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiComboBoxPill, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          asPlainText = _this$props2.asPlainText,
          children = _this$props2.children,
          className = _this$props2.className,
          color = _this$props2.color,
          onClick = _this$props2.onClick,
          onClickAriaLabel = _this$props2.onClickAriaLabel,
          onClose = _this$props2.onClose,
          option = _this$props2.option,
          rest = (0, _objectWithoutProperties2.default)(_this$props2, ["asPlainText", "children", "className", "color", "onClick", "onClickAriaLabel", "onClose", "option"]);
      var classes = (0, _classnames.default)('euiComboBoxPill', {
        'euiComboBoxPill--plainText': asPlainText
      }, className);
      var onClickProps = onClick && onClickAriaLabel ? {
        onClick: onClick,
        onClickAriaLabel: onClickAriaLabel
      } : {};

      if (onClose) {
        return _react.default.createElement(_i18n.EuiI18n, {
          token: "euiComboBoxPill.removeSelection",
          default: "Remove {children} from selection in this group",
          values: {
            children: children
          }
        }, function (removeSelection) {
          return _react.default.createElement(_badge.EuiBadge, (0, _extends2.default)({
            className: classes,
            closeButtonProps: {
              tabIndex: -1
            },
            color: color,
            iconOnClick: _this2.onCloseButtonClick,
            iconOnClickAriaLabel: removeSelection,
            iconSide: "right",
            iconType: "cross",
            title: children
          }, onClickProps, rest), children);
        });
      }

      if (asPlainText) {
        return _react.default.createElement("span", (0, _extends2.default)({
          className: classes
        }, rest), children);
      }

      return _react.default.createElement(_badge.EuiBadge, (0, _extends2.default)({
        className: classes,
        color: color,
        title: children
      }, rest, onClickProps), children);
    }
  }]);
  return EuiComboBoxPill;
}(_react.Component);

exports.EuiComboBoxPill = EuiComboBoxPill;
(0, _defineProperty2.default)(EuiComboBoxPill, "defaultProps", {
  color: 'hollow'
});
EuiComboBoxPill.propTypes = {
  asPlainText: _propTypes.default.bool,
  children: _propTypes.default.string,
  className: _propTypes.default.string,
  color: _propTypes.default.string,
  onClick: _propTypes.default.func,
  onClickAriaLabel: _propTypes.default.any,
  onClose: _propTypes.default.func,
  option: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any
  }).isRequired,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
EuiComboBoxPill.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "onCloseButtonClick",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }],
  "displayName": "EuiComboBoxPill",
  "props": {
    "color": {
      "defaultValue": {
        "value": "'hollow'",
        "computed": false
      },
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "asPlainText": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "children": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "onClick": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onClickAriaLabel": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "onClose": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "option": {
      "type": {
        "name": "shape",
        "value": {
          "className": {
            "name": "string",
            "required": false
          },
          "aria-label": {
            "name": "string",
            "required": false
          },
          "data-test-subj": {
            "name": "string",
            "required": false
          },
          "isGroupLabelOption": {
            "name": "bool",
            "required": false
          },
          "label": {
            "name": "string",
            "required": true
          },
          "options": {
            "name": "arrayOf",
            "value": {
              "name": "shape",
              "value": {
                "className": {
                  "name": "string",
                  "required": false
                },
                "aria-label": {
                  "name": "string",
                  "required": false
                },
                "data-test-subj": {
                  "name": "string",
                  "required": false
                },
                "isGroupLabelOption": {
                  "name": "bool",
                  "required": false
                },
                "label": {
                  "name": "string",
                  "required": true
                },
                "options": {
                  "name": "arrayOf",
                  "value": {
                    "name": "any"
                  },
                  "required": false
                },
                "value": {
                  "name": "any",
                  "required": false
                }
              }
            },
            "required": false
          },
          "value": {
            "name": "any",
            "required": false
          }
        }
      },
      "required": true,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};