function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { isValidElement } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keysOf } from '../common';
import { getSecureRelForTarget } from '../../services';
import { EuiText } from '../text';
import { EuiTitle } from '../title';
import { EuiBetaBadge } from '../badge/beta_badge';
import { EuiCardSelect, euiCardSelectableColor } from './card_select';
import { htmlIdGenerator } from '../../services/accessibility';
var textAlignToClassNameMap = {
  left: 'euiCard--leftAligned',
  center: 'euiCard--centerAligned',
  right: 'euiCard--rightAligned'
};
export var ALIGNMENTS = keysOf(textAlignToClassNameMap);
var layoutToClassNameMap = {
  vertical: '',
  horizontal: 'euiCard--horizontal'
};
export var LAYOUT_ALIGNMENTS = keysOf(layoutToClassNameMap);
var displayToClassNameMap = {
  panel: '',
  plain: 'euiCard--plain'
};
export var DISPLAYS = keysOf(displayToClassNameMap);
export var EuiCard = function EuiCard(_ref) {
  var className = _ref.className,
      description = _ref.description,
      isDisabled = _ref.isDisabled,
      title = _ref.title,
      _ref$titleElement = _ref.titleElement,
      titleElement = _ref$titleElement === void 0 ? 'span' : _ref$titleElement,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
      icon = _ref.icon,
      image = _ref.image,
      children = _ref.children,
      footer = _ref.footer,
      onClick = _ref.onClick,
      href = _ref.href,
      rel = _ref.rel,
      target = _ref.target,
      _ref$textAlign = _ref.textAlign,
      textAlign = _ref$textAlign === void 0 ? 'center' : _ref$textAlign,
      betaBadgeLabel = _ref.betaBadgeLabel,
      betaBadgeTooltipContent = _ref.betaBadgeTooltipContent,
      betaBadgeTitle = _ref.betaBadgeTitle,
      _ref$layout = _ref.layout,
      layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
      selectable = _ref.selectable,
      _ref$display = _ref.display,
      display = _ref$display === void 0 ? 'panel' : _ref$display,
      rest = _objectWithoutProperties(_ref, ["className", "description", "isDisabled", "title", "titleElement", "titleSize", "icon", "image", "children", "footer", "onClick", "href", "rel", "target", "textAlign", "betaBadgeLabel", "betaBadgeTooltipContent", "betaBadgeTitle", "layout", "selectable", "display"]);

  /**
   * For a11y, we simulate the same click that's provided on the title when clicking the whole card
   * without having to make the whole card a button or anchor tag.
   * *Card Accessibility: The redundant click event https://inclusive-components.design/cards/*
   */
  var link = null;

  var outerOnClick = function outerOnClick(e) {
    if (link && link !== e.target) {
      link.click();
    }
  };

  if (layout === 'horizontal') {
    if (image || footer) {
      throw new Error("EuiCard: layout = horizontal' cannot be used in conjunction with 'image', 'footer', or 'textAlign'.");
    }
  }

  var selectableColorClass = selectable ? "euiCard--isSelectable--".concat(euiCardSelectableColor(selectable.color, selectable.isSelected)) : undefined;
  var classes = classNames('euiCard', displayToClassNameMap[display], textAlignToClassNameMap[textAlign], layoutToClassNameMap[layout], {
    'euiCard--isClickable': onClick || href || selectable && !selectable.isDisabled,
    'euiCard--hasBetaBadge': betaBadgeLabel,
    'euiCard--hasIcon': icon,
    'euiCard--hasChildren': children,
    'euiCard--isSelectable': selectable,
    'euiCard-isSelected': selectable && selectable.isSelected,
    'euiCard-isDisabled': isDisabled
  }, selectableColorClass, className);
  var ariaId = htmlIdGenerator()();
  /**
   * Top area containing image, icon or both
   */

  var imageNode;

  if (image && layout === 'vertical') {
    if (isValidElement(image) || typeof image === 'string') {
      imageNode = React.createElement("div", {
        className: "euiCard__image"
      }, isValidElement(image) ? image : React.createElement("img", {
        src: image,
        alt: ""
      }));
    } else {
      imageNode = null;
    }
  }

  var iconNode;

  if (icon) {
    iconNode = React.cloneElement(icon, {
      className: classNames(icon.props.className, 'euiCard__icon')
    });
  }

  var optionalCardTop;

  if (imageNode || iconNode) {
    optionalCardTop = React.createElement("div", {
      className: "euiCard__top"
    }, imageNode, iconNode);
  }
  /**
   * Optional EuiBetaBadge
   */


  var optionalBetaBadge;
  var optionalBetaBadgeID = '';

  if (betaBadgeLabel) {
    optionalBetaBadgeID = "".concat(ariaId, "BetaBadge");
    optionalBetaBadge = React.createElement("span", {
      className: "euiCard__betaBadgeWrapper"
    }, React.createElement(EuiBetaBadge, {
      id: optionalBetaBadgeID,
      label: betaBadgeLabel,
      title: betaBadgeTitle,
      tooltipContent: betaBadgeTooltipContent,
      className: "euiCard__betaBadge"
    }));
  }
  /**
   * Optional selectable button
   */


  if (selectable && isDisabled && selectable.isDisabled === undefined) {
    selectable.isDisabled = isDisabled;
  }

  var optionalSelectButton;

  if (selectable) {
    optionalSelectButton = React.createElement(EuiCardSelect, _extends({
      "aria-describedby": "".concat(ariaId, "Title ").concat(ariaId, "Description")
    }, selectable, {
      buttonRef: function buttonRef(node) {
        link = node;
      }
    }));
  }
  /**
   * Wraps the title with the link (<a>) or button.
   * This makes the title element a11y friendly and gets described by its content if its interactable.
   */


  var theTitle;

  if (!isDisabled && href) {
    theTitle = React.createElement("a", {
      className: "euiCard__titleAnchor",
      onClick: onClick,
      href: href,
      target: target,
      "aria-describedby": "".concat(ariaId, "Description"),
      rel: getSecureRelForTarget({
        href: href,
        target: target,
        rel: rel
      }),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else if (isDisabled || onClick) {
    theTitle = React.createElement("button", {
      className: "euiCard__titleButton",
      onClick: onClick,
      disabled: isDisabled,
      "aria-describedby": "".concat(optionalBetaBadgeID, " ").concat(ariaId, "Description"),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else {
    theTitle = title;
  }
  /**
   * Convert titleElement to a capital TitleElement
   */


  var TitleElement = titleElement;
  return React.createElement("div", _extends({
    className: classes,
    onClick: outerOnClick
  }, rest), optionalCardTop, React.createElement("div", {
    className: "euiCard__content"
  }, React.createElement(EuiTitle, {
    id: "".concat(ariaId, "Title"),
    className: "euiCard__title",
    size: titleSize
  }, React.createElement(TitleElement, null, theTitle)), React.createElement(EuiText, {
    id: "".concat(ariaId, "Description"),
    size: "s",
    className: "euiCard__description"
  }, React.createElement("p", null, description)), children), optionalBetaBadge, layout === 'vertical' && footer && React.createElement("div", {
    className: "euiCard__footer"
  }, footer), optionalSelectButton);
};
EuiCard.propTypes = {
  /**
     * Card's are required to have at least a title and description
     */
  title: PropTypes.any.isRequired,

  /**
     * Determines the title's heading element
     */
  titleElement: PropTypes.oneOf(["h2", "h3", "h4", "h5", "h6", "span"]),

  /**
     * Determines the title's size, matching that of EuiTitle.
     * Though, card titles can't be too large or small relative to the description text.
     */
  titleSize: PropTypes.oneOf(["s", "xs"]),

  /**
     * Card's are required to have at least a title and description
     */
  description: PropTypes.any.isRequired,

  /**
     * Accepts an `<EuiIcon>` node or `null`
     */
  icon: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.oneOf([null])]),

  /**
     * Accepts a url in string form or ReactElement for a custom image component
     */
  image: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]),

  /**
     * Content to be rendered between the description and the footer
     */
  children: PropTypes.node,

  /**
     * Accepts any combination of elements
     */
  footer: PropTypes.node,

  /**
     * Use only if you want to forego a button in the footer and make the whole card clickable
     */
  onClick: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.func.isRequired]),
  isDisabled: PropTypes.bool,
  href: PropTypes.string,
  target: PropTypes.string,
  rel: PropTypes.string,

  /**
     * Changes alignment of the title and description
     */
  textAlign: PropTypes.oneOf(["left", "center", "right"]),

  /**
     * Change to "horizontal" if you need the icon to be left of the content
     */
  layout: PropTypes.oneOf(["vertical", "horizontal"]),

  /**
     * Add a badge to the card to label it as "Beta" or other non-GA state
     */
  betaBadgeLabel: PropTypes.string,

  /**
     * Add a description to the beta badge (will appear in a tooltip)
     */
  betaBadgeTooltipContent: PropTypes.node,

  /**
     * Optional title will be supplied as tooltip title or title attribute otherwise the label will be used
     */
  betaBadgeTitle: PropTypes.string,

  /**
     * Adds a button to the bottom of the card to allow for in-place selection
     */
  selectable: PropTypes.shape({
    href: PropTypes.string,
    onClick: PropTypes.func,
    iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
    iconSide: PropTypes.oneOf(["left", "right"]),
    color: PropTypes.oneOf(["primary", "danger", "disabled", "text", "ghost"]),
    size: PropTypes.oneOf(["xs", "s", "l"]),
    flush: PropTypes.oneOf(["left", "right"]),
    isDisabled: PropTypes.bool,
    target: PropTypes.string,
    rel: PropTypes.string,

    /**
       * Adds/swaps for loading spinner & disables
       */

    /**
       * Adds/swaps for loading spinner & disables
       */
    isLoading: PropTypes.bool,
    type: PropTypes.oneOf(["button", "submit"]),
    buttonRef: PropTypes.func,

    /**
       * Passes props to `euiButtonEmpty__content` span
       */

    /**
       * Passes props to `euiButtonEmpty__content` span
       */
    contentProps: PropTypes.any,

    /**
       * Passes props to `euiButtonEmpty__text` span
       */

    /**
       * Passes props to `euiButtonEmpty__text` span
       */
    textProps: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Is in the selected state
       */
    isSelected: PropTypes.bool
  }),

  /**
     * Visual display of the card. Display as 'panel' or 'plain'.
     * Selectable cards will always display as 'panel'.
     */
  display: PropTypes.oneOf(["panel", "plain"])
};
EuiCard.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiCard",
  "props": {
    "titleElement": {
      "defaultValue": {
        "value": "'span'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"h2\"",
          "computed": false
        }, {
          "value": "\"h3\"",
          "computed": false
        }, {
          "value": "\"h4\"",
          "computed": false
        }, {
          "value": "\"h5\"",
          "computed": false
        }, {
          "value": "\"h6\"",
          "computed": false
        }, {
          "value": "\"span\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Determines the title's heading element"
    },
    "titleSize": {
      "defaultValue": {
        "value": "'s'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"xs\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Determines the title's size, matching that of EuiTitle.\nThough, card titles can't be too large or small relative to the description text."
    },
    "textAlign": {
      "defaultValue": {
        "value": "'center'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"left\"",
          "computed": false
        }, {
          "value": "\"center\"",
          "computed": false
        }, {
          "value": "\"right\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Changes alignment of the title and description"
    },
    "layout": {
      "defaultValue": {
        "value": "'vertical'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"vertical\"",
          "computed": false
        }, {
          "value": "\"horizontal\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Change to \"horizontal\" if you need the icon to be left of the content"
    },
    "display": {
      "defaultValue": {
        "value": "'panel'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"panel\"",
          "computed": false
        }, {
          "value": "\"plain\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Visual display of the card. Display as 'panel' or 'plain'.\nSelectable cards will always display as 'panel'."
    },
    "title": {
      "type": {
        "name": "any"
      },
      "required": true,
      "description": "Card's are required to have at least a title and description"
    },
    "description": {
      "type": {
        "name": "any"
      },
      "required": true,
      "description": "Card's are required to have at least a title and description"
    },
    "icon": {
      "type": {
        "name": "union",
        "value": [{
          "name": "element"
        }, {
          "name": "enum",
          "value": [{
            "value": "null",
            "computed": false
          }]
        }]
      },
      "required": false,
      "description": "Accepts an `<EuiIcon>` node or `null`"
    },
    "image": {
      "type": {
        "name": "union",
        "value": [{
          "name": "string"
        }, {
          "name": "element"
        }]
      },
      "required": false,
      "description": "Accepts a url in string form or ReactElement for a custom image component"
    },
    "children": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Content to be rendered between the description and the footer"
    },
    "footer": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Accepts any combination of elements"
    },
    "onClick": {
      "type": {
        "name": "union",
        "value": [{
          "name": "func"
        }, {
          "name": "func"
        }]
      },
      "required": false,
      "description": "Use only if you want to forego a button in the footer and make the whole card clickable"
    },
    "isDisabled": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "href": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "target": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "rel": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "betaBadgeLabel": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Add a badge to the card to label it as \"Beta\" or other non-GA state"
    },
    "betaBadgeTooltipContent": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Add a description to the beta badge (will appear in a tooltip)"
    },
    "betaBadgeTitle": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Optional title will be supplied as tooltip title or title attribute otherwise the label will be used"
    },
    "selectable": {
      "type": {
        "name": "shape",
        "value": {
          "href": {
            "name": "string",
            "required": false
          },
          "onClick": {
            "name": "func",
            "required": false
          },
          "iconType": {
            "name": "union",
            "value": [{
              "name": "enum",
              "value": [{
                "value": "\"accessibility\"",
                "computed": false
              }, {
                "value": "\"addDataApp\"",
                "computed": false
              }, {
                "value": "\"advancedSettingsApp\"",
                "computed": false
              }, {
                "value": "\"aggregate\"",
                "computed": false
              }, {
                "value": "\"alert\"",
                "computed": false
              }, {
                "value": "\"annotation\"",
                "computed": false
              }, {
                "value": "\"apmApp\"",
                "computed": false
              }, {
                "value": "\"apmTrace\"",
                "computed": false
              }, {
                "value": "\"apps\"",
                "computed": false
              }, {
                "value": "\"arrowDown\"",
                "computed": false
              }, {
                "value": "\"arrowLeft\"",
                "computed": false
              }, {
                "value": "\"arrowRight\"",
                "computed": false
              }, {
                "value": "\"arrowUp\"",
                "computed": false
              }, {
                "value": "\"asterisk\"",
                "computed": false
              }, {
                "value": "\"auditbeatApp\"",
                "computed": false
              }, {
                "value": "\"beaker\"",
                "computed": false
              }, {
                "value": "\"bell\"",
                "computed": false
              }, {
                "value": "\"bellSlash\"",
                "computed": false
              }, {
                "value": "\"bolt\"",
                "computed": false
              }, {
                "value": "\"boxesHorizontal\"",
                "computed": false
              }, {
                "value": "\"boxesVertical\"",
                "computed": false
              }, {
                "value": "\"branch\"",
                "computed": false
              }, {
                "value": "\"broom\"",
                "computed": false
              }, {
                "value": "\"brush\"",
                "computed": false
              }, {
                "value": "\"bug\"",
                "computed": false
              }, {
                "value": "\"bullseye\"",
                "computed": false
              }, {
                "value": "\"calendar\"",
                "computed": false
              }, {
                "value": "\"canvasApp\"",
                "computed": false
              }, {
                "value": "\"codeApp\"",
                "computed": false
              }, {
                "value": "\"check\"",
                "computed": false
              }, {
                "value": "\"checkInCircleFilled\"",
                "computed": false
              }, {
                "value": "\"cheer\"",
                "computed": false
              }, {
                "value": "\"clock\"",
                "computed": false
              }, {
                "value": "\"cloudDrizzle\"",
                "computed": false
              }, {
                "value": "\"cloudStormy\"",
                "computed": false
              }, {
                "value": "\"cloudSunny\"",
                "computed": false
              }, {
                "value": "\"compute\"",
                "computed": false
              }, {
                "value": "\"console\"",
                "computed": false
              }, {
                "value": "\"consoleApp\"",
                "computed": false
              }, {
                "value": "\"controlsHorizontal\"",
                "computed": false
              }, {
                "value": "\"controlsVertical\"",
                "computed": false
              }, {
                "value": "\"copy\"",
                "computed": false
              }, {
                "value": "\"copyClipboard\"",
                "computed": false
              }, {
                "value": "\"createAdvancedJob\"",
                "computed": false
              }, {
                "value": "\"createMultiMetricJob\"",
                "computed": false
              }, {
                "value": "\"createPopulationJob\"",
                "computed": false
              }, {
                "value": "\"createSingleMetricJob\"",
                "computed": false
              }, {
                "value": "\"cross\"",
                "computed": false
              }, {
                "value": "\"crossClusterReplicationApp\"",
                "computed": false
              }, {
                "value": "\"crosshairs\"",
                "computed": false
              }, {
                "value": "\"crossInACircleFilled\"",
                "computed": false
              }, {
                "value": "\"currency\"",
                "computed": false
              }, {
                "value": "\"cut\"",
                "computed": false
              }, {
                "value": "\"dashboardApp\"",
                "computed": false
              }, {
                "value": "\"database\"",
                "computed": false
              }, {
                "value": "\"dataVisualizer\"",
                "computed": false
              }, {
                "value": "\"devToolsApp\"",
                "computed": false
              }, {
                "value": "\"discoverApp\"",
                "computed": false
              }, {
                "value": "\"document\"",
                "computed": false
              }, {
                "value": "\"documentEdit\"",
                "computed": false
              }, {
                "value": "\"documents\"",
                "computed": false
              }, {
                "value": "\"dot\"",
                "computed": false
              }, {
                "value": "\"download\"",
                "computed": false
              }, {
                "value": "\"editorAlignCenter\"",
                "computed": false
              }, {
                "value": "\"editorAlignLeft\"",
                "computed": false
              }, {
                "value": "\"editorAlignRight\"",
                "computed": false
              }, {
                "value": "\"editorBold\"",
                "computed": false
              }, {
                "value": "\"editorCodeBlock\"",
                "computed": false
              }, {
                "value": "\"editorComment\"",
                "computed": false
              }, {
                "value": "\"editorDistributeHorizontal\"",
                "computed": false
              }, {
                "value": "\"editorDistributeVertical\"",
                "computed": false
              }, {
                "value": "\"editorHeading\"",
                "computed": false
              }, {
                "value": "\"editorItalic\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignLeft\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignBottom\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignCenter\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignMiddle\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignRight\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignTop\"",
                "computed": false
              }, {
                "value": "\"editorLink\"",
                "computed": false
              }, {
                "value": "\"editorOrderedList\"",
                "computed": false
              }, {
                "value": "\"editorPositionBottomLeft\"",
                "computed": false
              }, {
                "value": "\"editorPositionBottomRight\"",
                "computed": false
              }, {
                "value": "\"editorPositionTopLeft\"",
                "computed": false
              }, {
                "value": "\"editorPositionTopRight\"",
                "computed": false
              }, {
                "value": "\"editorRedo\"",
                "computed": false
              }, {
                "value": "\"editorStrike\"",
                "computed": false
              }, {
                "value": "\"editorTable\"",
                "computed": false
              }, {
                "value": "\"editorUnderline\"",
                "computed": false
              }, {
                "value": "\"editorUndo\"",
                "computed": false
              }, {
                "value": "\"editorUnorderedList\"",
                "computed": false
              }, {
                "value": "\"email\"",
                "computed": false
              }, {
                "value": "\"empty\"",
                "computed": false
              }, {
                "value": "\"emsApp\"",
                "computed": false
              }, {
                "value": "\"exit\"",
                "computed": false
              }, {
                "value": "\"expand\"",
                "computed": false
              }, {
                "value": "\"expandMini\"",
                "computed": false
              }, {
                "value": "\"exportAction\"",
                "computed": false
              }, {
                "value": "\"eye\"",
                "computed": false
              }, {
                "value": "\"eyeClosed\"",
                "computed": false
              }, {
                "value": "\"faceHappy\"",
                "computed": false
              }, {
                "value": "\"faceNeutral\"",
                "computed": false
              }, {
                "value": "\"faceSad\"",
                "computed": false
              }, {
                "value": "\"filebeatApp\"",
                "computed": false
              }, {
                "value": "\"filter\"",
                "computed": false
              }, {
                "value": "\"flag\"",
                "computed": false
              }, {
                "value": "\"folderCheck\"",
                "computed": false
              }, {
                "value": "\"folderClosed\"",
                "computed": false
              }, {
                "value": "\"folderExclamation\"",
                "computed": false
              }, {
                "value": "\"folderOpen\"",
                "computed": false
              }, {
                "value": "\"fullScreen\"",
                "computed": false
              }, {
                "value": "\"gear\"",
                "computed": false
              }, {
                "value": "\"gisApp\"",
                "computed": false
              }, {
                "value": "\"glasses\"",
                "computed": false
              }, {
                "value": "\"globe\"",
                "computed": false
              }, {
                "value": "\"grab\"",
                "computed": false
              }, {
                "value": "\"grabHorizontal\"",
                "computed": false
              }, {
                "value": "\"graphApp\"",
                "computed": false
              }, {
                "value": "\"grid\"",
                "computed": false
              }, {
                "value": "\"grokApp\"",
                "computed": false
              }, {
                "value": "\"heart\"",
                "computed": false
              }, {
                "value": "\"heartbeatApp\"",
                "computed": false
              }, {
                "value": "\"heatmap\"",
                "computed": false
              }, {
                "value": "\"help\"",
                "computed": false
              }, {
                "value": "\"home\"",
                "computed": false
              }, {
                "value": "\"iInCircle\"",
                "computed": false
              }, {
                "value": "\"image\"",
                "computed": false
              }, {
                "value": "\"importAction\"",
                "computed": false
              }, {
                "value": "\"indexClose\"",
                "computed": false
              }, {
                "value": "\"indexEdit\"",
                "computed": false
              }, {
                "value": "\"indexFlush\"",
                "computed": false
              }, {
                "value": "\"indexManagementApp\"",
                "computed": false
              }, {
                "value": "\"indexMapping\"",
                "computed": false
              }, {
                "value": "\"indexOpen\"",
                "computed": false
              }, {
                "value": "\"indexPatternApp\"",
                "computed": false
              }, {
                "value": "\"indexRollupApp\"",
                "computed": false
              }, {
                "value": "\"indexSettings\"",
                "computed": false
              }, {
                "value": "\"inputOutput\"",
                "computed": false
              }, {
                "value": "\"inspect\"",
                "computed": false
              }, {
                "value": "\"invert\"",
                "computed": false
              }, {
                "value": "\"ip\"",
                "computed": false
              }, {
                "value": "\"keyboardShortcut\"",
                "computed": false
              }, {
                "value": "\"kqlField\"",
                "computed": false
              }, {
                "value": "\"kqlFunction\"",
                "computed": false
              }, {
                "value": "\"kqlOperand\"",
                "computed": false
              }, {
                "value": "\"kqlSelector\"",
                "computed": false
              }, {
                "value": "\"kqlValue\"",
                "computed": false
              }, {
                "value": "\"lensApp\"",
                "computed": false
              }, {
                "value": "\"link\"",
                "computed": false
              }, {
                "value": "\"list\"",
                "computed": false
              }, {
                "value": "\"listAdd\"",
                "computed": false
              }, {
                "value": "\"lock\"",
                "computed": false
              }, {
                "value": "\"lockOpen\"",
                "computed": false
              }, {
                "value": "\"logsApp\"",
                "computed": false
              }, {
                "value": "\"logoAerospike\"",
                "computed": false
              }, {
                "value": "\"logoApache\"",
                "computed": false
              }, {
                "value": "\"logoAPM\"",
                "computed": false
              }, {
                "value": "\"logoAppSearch\"",
                "computed": false
              }, {
                "value": "\"logoAWS\"",
                "computed": false
              }, {
                "value": "\"logoAWSMono\"",
                "computed": false
              }, {
                "value": "\"logoAzure\"",
                "computed": false
              }, {
                "value": "\"logoAzureMono\"",
                "computed": false
              }, {
                "value": "\"logoBeats\"",
                "computed": false
              }, {
                "value": "\"logoBusinessAnalytics\"",
                "computed": false
              }, {
                "value": "\"logoCeph\"",
                "computed": false
              }, {
                "value": "\"logoCloud\"",
                "computed": false
              }, {
                "value": "\"logoCloudEnterprise\"",
                "computed": false
              }, {
                "value": "\"logoCode\"",
                "computed": false
              }, {
                "value": "\"logoCodesandbox\"",
                "computed": false
              }, {
                "value": "\"logoCouchbase\"",
                "computed": false
              }, {
                "value": "\"logoDocker\"",
                "computed": false
              }, {
                "value": "\"logoDropwizard\"",
                "computed": false
              }, {
                "value": "\"logoElastic\"",
                "computed": false
              }, {
                "value": "\"logoElasticsearch\"",
                "computed": false
              }, {
                "value": "\"logoElasticStack\"",
                "computed": false
              }, {
                "value": "\"logoEnterpriseSearch\"",
                "computed": false
              }, {
                "value": "\"logoEtcd\"",
                "computed": false
              }, {
                "value": "\"logoGCP\"",
                "computed": false
              }, {
                "value": "\"logoGCPMono\"",
                "computed": false
              }, {
                "value": "\"logoGithub\"",
                "computed": false
              }, {
                "value": "\"logoGmail\"",
                "computed": false
              }, {
                "value": "\"logoGolang\"",
                "computed": false
              }, {
                "value": "\"logoGoogleG\"",
                "computed": false
              }, {
                "value": "\"logoHAproxy\"",
                "computed": false
              }, {
                "value": "\"logoIBM\"",
                "computed": false
              }, {
                "value": "\"logoIBMMono\"",
                "computed": false
              }, {
                "value": "\"logoKafka\"",
                "computed": false
              }, {
                "value": "\"logoKibana\"",
                "computed": false
              }, {
                "value": "\"logoKubernetes\"",
                "computed": false
              }, {
                "value": "\"logoLogging\"",
                "computed": false
              }, {
                "value": "\"logoLogstash\"",
                "computed": false
              }, {
                "value": "\"logoMaps\"",
                "computed": false
              }, {
                "value": "\"logoMemcached\"",
                "computed": false
              }, {
                "value": "\"logoMetrics\"",
                "computed": false
              }, {
                "value": "\"logoMongodb\"",
                "computed": false
              }, {
                "value": "\"logoMySQL\"",
                "computed": false
              }, {
                "value": "\"logoNginx\"",
                "computed": false
              }, {
                "value": "\"logoObservability\"",
                "computed": false
              }, {
                "value": "\"logoOsquery\"",
                "computed": false
              }, {
                "value": "\"logoPhp\"",
                "computed": false
              }, {
                "value": "\"logoPostgres\"",
                "computed": false
              }, {
                "value": "\"logoPrometheus\"",
                "computed": false
              }, {
                "value": "\"logoRabbitmq\"",
                "computed": false
              }, {
                "value": "\"logoRedis\"",
                "computed": false
              }, {
                "value": "\"logoSecurity\"",
                "computed": false
              }, {
                "value": "\"logoSiteSearch\"",
                "computed": false
              }, {
                "value": "\"logoSketch\"",
                "computed": false
              }, {
                "value": "\"logoSlack\"",
                "computed": false
              }, {
                "value": "\"logoUptime\"",
                "computed": false
              }, {
                "value": "\"logoWebhook\"",
                "computed": false
              }, {
                "value": "\"logoWindows\"",
                "computed": false
              }, {
                "value": "\"logoWorkplaceSearch\"",
                "computed": false
              }, {
                "value": "\"logstashFilter\"",
                "computed": false
              }, {
                "value": "\"logstashIf\"",
                "computed": false
              }, {
                "value": "\"logstashInput\"",
                "computed": false
              }, {
                "value": "\"logstashOutput\"",
                "computed": false
              }, {
                "value": "\"logstashQueue\"",
                "computed": false
              }, {
                "value": "\"machineLearningApp\"",
                "computed": false
              }, {
                "value": "\"magnet\"",
                "computed": false
              }, {
                "value": "\"magnifyWithMinus\"",
                "computed": false
              }, {
                "value": "\"magnifyWithPlus\"",
                "computed": false
              }, {
                "value": "\"managementApp\"",
                "computed": false
              }, {
                "value": "\"mapMarker\"",
                "computed": false
              }, {
                "value": "\"memory\"",
                "computed": false
              }, {
                "value": "\"menu\"",
                "computed": false
              }, {
                "value": "\"menuLeft\"",
                "computed": false
              }, {
                "value": "\"menuRight\"",
                "computed": false
              }, {
                "value": "\"merge\"",
                "computed": false
              }, {
                "value": "\"metricbeatApp\"",
                "computed": false
              }, {
                "value": "\"metricsApp\"",
                "computed": false
              }, {
                "value": "\"minimize\"",
                "computed": false
              }, {
                "value": "\"minusInCircle\"",
                "computed": false
              }, {
                "value": "\"minusInCircleFilled\"",
                "computed": false
              }, {
                "value": "\"monitoringApp\"",
                "computed": false
              }, {
                "value": "\"moon\"",
                "computed": false
              }, {
                "value": "\"nested\"",
                "computed": false
              }, {
                "value": "\"node\"",
                "computed": false
              }, {
                "value": "\"notebookApp\"",
                "computed": false
              }, {
                "value": "\"number\"",
                "computed": false
              }, {
                "value": "\"offline\"",
                "computed": false
              }, {
                "value": "\"online\"",
                "computed": false
              }, {
                "value": "\"package\"",
                "computed": false
              }, {
                "value": "\"packetbeatApp\"",
                "computed": false
              }, {
                "value": "\"pageSelect\"",
                "computed": false
              }, {
                "value": "\"pagesSelect\"",
                "computed": false
              }, {
                "value": "\"partial\"",
                "computed": false
              }, {
                "value": "\"paperClip\"",
                "computed": false
              }, {
                "value": "\"pause\"",
                "computed": false
              }, {
                "value": "\"pencil\"",
                "computed": false
              }, {
                "value": "\"pin\"",
                "computed": false
              }, {
                "value": "\"pinFilled\"",
                "computed": false
              }, {
                "value": "\"pipelineApp\"",
                "computed": false
              }, {
                "value": "\"play\"",
                "computed": false
              }, {
                "value": "\"plusInCircle\"",
                "computed": false
              }, {
                "value": "\"plusInCircleFilled\"",
                "computed": false
              }, {
                "value": "\"popout\"",
                "computed": false
              }, {
                "value": "\"push\"",
                "computed": false
              }, {
                "value": "\"questionInCircle\"",
                "computed": false
              }, {
                "value": "\"quote\"",
                "computed": false
              }, {
                "value": "\"recentlyViewedApp\"",
                "computed": false
              }, {
                "value": "\"refresh\"",
                "computed": false
              }, {
                "value": "\"reporter\"",
                "computed": false
              }, {
                "value": "\"reportingApp\"",
                "computed": false
              }, {
                "value": "\"save\"",
                "computed": false
              }, {
                "value": "\"savedObjectsApp\"",
                "computed": false
              }, {
                "value": "\"scale\"",
                "computed": false
              }, {
                "value": "\"search\"",
                "computed": false
              }, {
                "value": "\"searchProfilerApp\"",
                "computed": false
              }, {
                "value": "\"securityAnalyticsApp\"",
                "computed": false
              }, {
                "value": "\"securityApp\"",
                "computed": false
              }, {
                "value": "\"securitySignal\"",
                "computed": false
              }, {
                "value": "\"securitySignalDetected\"",
                "computed": false
              }, {
                "value": "\"securitySignalResolved\"",
                "computed": false
              }, {
                "value": "\"shard\"",
                "computed": false
              }, {
                "value": "\"share\"",
                "computed": false
              }, {
                "value": "\"snowflake\"",
                "computed": false
              }, {
                "value": "\"sortable\"",
                "computed": false
              }, {
                "value": "\"sortDown\"",
                "computed": false
              }, {
                "value": "\"sortLeft\"",
                "computed": false
              }, {
                "value": "\"sortRight\"",
                "computed": false
              }, {
                "value": "\"sortUp\"",
                "computed": false
              }, {
                "value": "\"spacesApp\"",
                "computed": false
              }, {
                "value": "\"sqlApp\"",
                "computed": false
              }, {
                "value": "\"starEmpty\"",
                "computed": false
              }, {
                "value": "\"starEmptySpace\"",
                "computed": false
              }, {
                "value": "\"starFilled\"",
                "computed": false
              }, {
                "value": "\"starFilledSpace\"",
                "computed": false
              }, {
                "value": "\"starMinusEmpty\"",
                "computed": false
              }, {
                "value": "\"starMinusFilled\"",
                "computed": false
              }, {
                "value": "\"starPlusEmpty\"",
                "computed": false
              }, {
                "value": "\"starPlusFilled\"",
                "computed": false
              }, {
                "value": "\"stats\"",
                "computed": false
              }, {
                "value": "\"stop\"",
                "computed": false
              }, {
                "value": "\"stopFilled\"",
                "computed": false
              }, {
                "value": "\"stopSlash\"",
                "computed": false
              }, {
                "value": "\"storage\"",
                "computed": false
              }, {
                "value": "\"string\"",
                "computed": false
              }, {
                "value": "\"submodule\"",
                "computed": false
              }, {
                "value": "\"swatchInput\"",
                "computed": false
              }, {
                "value": "\"symlink\"",
                "computed": false
              }, {
                "value": "\"tableOfContents\"",
                "computed": false
              }, {
                "value": "\"tableDensityExpanded\"",
                "computed": false
              }, {
                "value": "\"tableDensityCompact\"",
                "computed": false
              }, {
                "value": "\"tableDensityNormal\"",
                "computed": false
              }, {
                "value": "\"tag\"",
                "computed": false
              }, {
                "value": "\"tear\"",
                "computed": false
              }, {
                "value": "\"temperature\"",
                "computed": false
              }, {
                "value": "\"timeline\"",
                "computed": false
              }, {
                "value": "\"timelionApp\"",
                "computed": false
              }, {
                "value": "\"training\"",
                "computed": false
              }, {
                "value": "\"trash\"",
                "computed": false
              }, {
                "value": "\"upgradeAssistantApp\"",
                "computed": false
              }, {
                "value": "\"uptimeApp\"",
                "computed": false
              }, {
                "value": "\"user\"",
                "computed": false
              }, {
                "value": "\"users\"",
                "computed": false
              }, {
                "value": "\"usersRolesApp\"",
                "computed": false
              }, {
                "value": "\"vector\"",
                "computed": false
              }, {
                "value": "\"videoPlayer\"",
                "computed": false
              }, {
                "value": "\"visArea\"",
                "computed": false
              }, {
                "value": "\"visAreaStacked\"",
                "computed": false
              }, {
                "value": "\"visBarHorizontal\"",
                "computed": false
              }, {
                "value": "\"visBarHorizontalStacked\"",
                "computed": false
              }, {
                "value": "\"visBarVertical\"",
                "computed": false
              }, {
                "value": "\"visBarVerticalStacked\"",
                "computed": false
              }, {
                "value": "\"visGauge\"",
                "computed": false
              }, {
                "value": "\"visGoal\"",
                "computed": false
              }, {
                "value": "\"visLine\"",
                "computed": false
              }, {
                "value": "\"visMapCoordinate\"",
                "computed": false
              }, {
                "value": "\"visMapRegion\"",
                "computed": false
              }, {
                "value": "\"visMetric\"",
                "computed": false
              }, {
                "value": "\"visPie\"",
                "computed": false
              }, {
                "value": "\"visTable\"",
                "computed": false
              }, {
                "value": "\"visTagCloud\"",
                "computed": false
              }, {
                "value": "\"visText\"",
                "computed": false
              }, {
                "value": "\"visTimelion\"",
                "computed": false
              }, {
                "value": "\"visualizeApp\"",
                "computed": false
              }, {
                "value": "\"visVega\"",
                "computed": false
              }, {
                "value": "\"visVisualBuilder\"",
                "computed": false
              }, {
                "value": "\"watchesApp\"",
                "computed": false
              }, {
                "value": "\"wrench\"",
                "computed": false
              }, {
                "value": "\"tokenClass\"",
                "computed": false
              }, {
                "value": "\"tokenProperty\"",
                "computed": false
              }, {
                "value": "\"tokenEnum\"",
                "computed": false
              }, {
                "value": "\"tokenVariable\"",
                "computed": false
              }, {
                "value": "\"tokenMethod\"",
                "computed": false
              }, {
                "value": "\"tokenAnnotation\"",
                "computed": false
              }, {
                "value": "\"tokenException\"",
                "computed": false
              }, {
                "value": "\"tokenInterface\"",
                "computed": false
              }, {
                "value": "\"tokenParameter\"",
                "computed": false
              }, {
                "value": "\"tokenField\"",
                "computed": false
              }, {
                "value": "\"tokenElement\"",
                "computed": false
              }, {
                "value": "\"tokenFunction\"",
                "computed": false
              }, {
                "value": "\"tokenBoolean\"",
                "computed": false
              }, {
                "value": "\"tokenString\"",
                "computed": false
              }, {
                "value": "\"tokenArray\"",
                "computed": false
              }, {
                "value": "\"tokenNumber\"",
                "computed": false
              }, {
                "value": "\"tokenConstant\"",
                "computed": false
              }, {
                "value": "\"tokenObject\"",
                "computed": false
              }, {
                "value": "\"tokenEvent\"",
                "computed": false
              }, {
                "value": "\"tokenKey\"",
                "computed": false
              }, {
                "value": "\"tokenNull\"",
                "computed": false
              }, {
                "value": "\"tokenStruct\"",
                "computed": false
              }, {
                "value": "\"tokenPackage\"",
                "computed": false
              }, {
                "value": "\"tokenOperator\"",
                "computed": false
              }, {
                "value": "\"tokenEnumMember\"",
                "computed": false
              }, {
                "value": "\"tokenRepo\"",
                "computed": false
              }, {
                "value": "\"tokenSymbol\"",
                "computed": false
              }, {
                "value": "\"tokenFile\"",
                "computed": false
              }, {
                "value": "\"tokenModule\"",
                "computed": false
              }, {
                "value": "\"tokenNamespace\"",
                "computed": false
              }, {
                "value": "\"tokenDate\"",
                "computed": false
              }, {
                "value": "\"tokenIP\"",
                "computed": false
              }, {
                "value": "\"tokenNested\"",
                "computed": false
              }, {
                "value": "\"tokenAlias\"",
                "computed": false
              }, {
                "value": "\"tokenShape\"",
                "computed": false
              }, {
                "value": "\"tokenGeo\"",
                "computed": false
              }, {
                "value": "\"tokenRange\"",
                "computed": false
              }, {
                "value": "\"tokenBinary\"",
                "computed": false
              }, {
                "value": "\"tokenJoin\"",
                "computed": false
              }, {
                "value": "\"tokenPercolator\"",
                "computed": false
              }, {
                "value": "\"tokenFlattened\"",
                "computed": false
              }, {
                "value": "\"tokenRankFeature\"",
                "computed": false
              }, {
                "value": "\"tokenRankFeatures\"",
                "computed": false
              }, {
                "value": "\"tokenKeyword\"",
                "computed": false
              }, {
                "value": "\"tokenCompletionSuggester\"",
                "computed": false
              }, {
                "value": "\"tokenDenseVector\"",
                "computed": false
              }, {
                "value": "\"tokenText\"",
                "computed": false
              }, {
                "value": "\"tokenTokenCount\"",
                "computed": false
              }, {
                "value": "\"tokenSearchType\"",
                "computed": false
              }, {
                "value": "\"tokenHistogram\"",
                "computed": false
              }]
            }, {
              "name": "string"
            }, {
              "name": "elementType"
            }],
            "required": false
          },
          "iconSide": {
            "name": "enum",
            "value": [{
              "value": "\"left\"",
              "computed": false
            }, {
              "value": "\"right\"",
              "computed": false
            }],
            "required": false
          },
          "color": {
            "name": "enum",
            "value": [{
              "value": "\"primary\"",
              "computed": false
            }, {
              "value": "\"danger\"",
              "computed": false
            }, {
              "value": "\"disabled\"",
              "computed": false
            }, {
              "value": "\"text\"",
              "computed": false
            }, {
              "value": "\"ghost\"",
              "computed": false
            }],
            "required": false
          },
          "size": {
            "name": "enum",
            "value": [{
              "value": "\"xs\"",
              "computed": false
            }, {
              "value": "\"s\"",
              "computed": false
            }, {
              "value": "\"l\"",
              "computed": false
            }],
            "required": false
          },
          "flush": {
            "name": "enum",
            "value": [{
              "value": "\"left\"",
              "computed": false
            }, {
              "value": "\"right\"",
              "computed": false
            }],
            "required": false
          },
          "isDisabled": {
            "name": "bool",
            "required": false
          },
          "target": {
            "name": "string",
            "required": false
          },
          "rel": {
            "name": "string",
            "required": false
          },
          "isLoading": {
            "name": "bool",
            "description": "Adds/swaps for loading spinner & disables",
            "required": false
          },
          "type": {
            "name": "enum",
            "value": [{
              "value": "\"button\"",
              "computed": false
            }, {
              "value": "\"submit\"",
              "computed": false
            }],
            "required": false
          },
          "buttonRef": {
            "name": "func",
            "required": false
          },
          "contentProps": {
            "name": "any",
            "description": "Passes props to `euiButtonEmpty__content` span",
            "required": false
          },
          "textProps": {
            "name": "any",
            "description": "Passes props to `euiButtonEmpty__text` span",
            "required": false
          },
          "className": {
            "name": "string",
            "required": false
          },
          "aria-label": {
            "name": "string",
            "required": false
          },
          "data-test-subj": {
            "name": "string",
            "required": false
          },
          "isSelected": {
            "name": "bool",
            "description": "Is in the selected state",
            "required": false
          }
        }
      },
      "required": false,
      "description": "Adds a button to the bottom of the card to allow for in-place selection"
    }
  }
};