"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractEmsService = void 0;

var _origin = require("./origin");

var _utils = require("./utils");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class AbstractEmsService {
  constructor(config, emsClient, proxyPath) {
    _defineProperty(this, "_emsClient", void 0);

    _defineProperty(this, "_config", void 0);

    _defineProperty(this, "_proxyPath", void 0);

    _defineProperty(this, "_getAbsoluteUrl", url => {
      if (/^https?:\/\//.test(url)) {
        return url;
      } else {
        return (0, _utils.toAbsoluteUrl)(this.getApiUrl(), url);
      }
    });

    this._config = config;
    this._emsClient = emsClient;
    this._proxyPath = proxyPath;
  }

  getAttributions() {
    return this._config.attribution.map(attribution => {
      const url = this._emsClient.getValueInLanguage(attribution.url);

      const label = this._emsClient.getValueInLanguage(attribution.label);

      return {
        url: url,
        label: label
      };
    });
  }

  getHTMLAttribution() {
    const attributions = this._config.attribution.map(attribution => {
      const url = this._emsClient.getValueInLanguage(attribution.url);

      const label = this._emsClient.getValueInLanguage(attribution.label);

      const html = url ? `<a rel="noreferrer noopener" href="${url}">${label}</a>` : label;
      return this._emsClient.sanitizeHtml(html);
    });

    return attributions.join(' | '); //!!!this is the current convention used in Kibana
  }

  getMarkdownAttribution() {
    const attributions = this._config.attribution.map(attribution => {
      const url = this._emsClient.getValueInLanguage(attribution.url);

      const label = this._emsClient.getValueInLanguage(attribution.label);

      return `[${label}](${url})`;
    });

    return attributions.join('|');
  }

  getOrigin() {
    return _origin.ORIGIN.EMS;
  }
  /**
   * Checks if url is absolute. If not, prepend the basePath.
   */


}

exports.AbstractEmsService = AbstractEmsService;