"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var d3_array_1 = require("d3-array");
var constants_1 = require("../../../scales/constants");
var commons_1 = require("../../../utils/commons");
var domain_1 = require("../../../utils/domain");
var axis_type_utils_1 = require("../utils/axis_type_utils");
var specs_1 = require("../utils/specs");
function mergeYDomain(dataSeries, specs, domainsByGroupId) {
    var specsByGroupIds = splitSpecsByGroupId(specs);
    var specsByGroupIdsEntries = __spread(specsByGroupIds.entries());
    var globalId = specs_1.DEFAULT_GLOBAL_ID;
    var yDomains = specsByGroupIdsEntries.map(function (_a) {
        var _b = __read(_a, 2), groupId = _b[0], groupSpecs = _b[1];
        var customDomain = domainsByGroupId.get(groupId);
        return mergeYDomainForGroup(dataSeries, groupId, groupSpecs, customDomain);
    });
    var globalGroupIds = specs.reduce(function (acc, _a) {
        var groupId = _a.groupId, useDefaultGroupDomain = _a.useDefaultGroupDomain;
        if (groupId !== globalId && useDefaultGroupDomain) {
            acc.add(groupId);
        }
        return acc;
    }, new Set());
    globalGroupIds.add(globalId);
    var globalYDomains = yDomains.filter(function (domain) { return globalGroupIds.has(domain.groupId); });
    var globalYDomain = [Number.MAX_SAFE_INTEGER, Number.MIN_SAFE_INTEGER];
    globalYDomains.forEach(function (domain) {
        globalYDomain = [Math.min(globalYDomain[0], domain.domain[0]), Math.max(globalYDomain[1], domain.domain[1])];
    });
    return yDomains.map(function (domain) {
        if (globalGroupIds.has(domain.groupId)) {
            return __assign(__assign({}, domain), { domain: globalYDomain });
        }
        return domain;
    });
}
exports.mergeYDomain = mergeYDomain;
function mergeYDomainForGroup(dataSeries, groupId, groupSpecs, customDomain) {
    var _a;
    var groupYScaleType = coerceYScaleTypes(__spread(groupSpecs.stacked, groupSpecs.nonStacked));
    var isPercentageStack = groupSpecs.isPercentageStack;
    var domain;
    if (isPercentageStack) {
        domain = domain_1.computeContinuousDataDomain([0, 1], commons_1.identity, customDomain);
    }
    else {
        var newCustomDomain = customDomain ? __assign({}, customDomain) : {};
        var shouldScaleToExtent = groupSpecs.stacked.some(function (_a) {
            var yScaleToDataExtent = _a.yScaleToDataExtent;
            return yScaleToDataExtent;
        })
            || groupSpecs.nonStacked.some(function (_a) {
                var yScaleToDataExtent = _a.yScaleToDataExtent;
                return yScaleToDataExtent;
            });
        if (((_a = customDomain) === null || _a === void 0 ? void 0 : _a.fit) !== true && shouldScaleToExtent) {
            newCustomDomain.fit = true;
        }
        var stackedDataSeries = getDataSeriesOnGroup(dataSeries, groupSpecs.stacked);
        var stackedDomain = computeYStackedDomain(stackedDataSeries);
        var nonStackedDataSeries = getDataSeriesOnGroup(dataSeries, groupSpecs.nonStacked);
        var nonStackedDomain = computeYNonStackedDomain(nonStackedDataSeries);
        domain = domain_1.computeContinuousDataDomain(__spread(stackedDomain, nonStackedDomain), commons_1.identity, newCustomDomain);
        var _b = __read(domain, 2), computedDomainMin = _b[0], computedDomainMax = _b[1];
        if (newCustomDomain && axis_type_utils_1.isCompleteBound(newCustomDomain)) {
            domain = [newCustomDomain.min, newCustomDomain.max];
        }
        else if (newCustomDomain && axis_type_utils_1.isLowerBound(newCustomDomain)) {
            if (newCustomDomain.min > computedDomainMax) {
                throw new Error("custom yDomain for " + groupId + " is invalid, custom min is greater than computed max");
            }
            domain = [newCustomDomain.min, computedDomainMax];
        }
        else if (newCustomDomain && axis_type_utils_1.isUpperBound(newCustomDomain)) {
            if (computedDomainMin > newCustomDomain.max) {
                throw new Error("custom yDomain for " + groupId + " is invalid, computed min is greater than custom max");
            }
            domain = [computedDomainMin, newCustomDomain.max];
        }
    }
    return {
        type: 'yDomain',
        isBandScale: false,
        scaleType: groupYScaleType,
        groupId: groupId,
        domain: domain,
    };
}
function getDataSeriesOnGroup(dataSeries, specs) {
    return specs.reduce(function (acc, spec) {
        var ds = dataSeries.get(spec.id) || [];
        return __spread(acc, ds);
    }, []);
}
exports.getDataSeriesOnGroup = getDataSeriesOnGroup;
function computeYStackedDomain(dataseries) {
    var e_1, _a;
    var stackMap = new Map();
    dataseries.forEach(function (ds, index) {
        ds.data.forEach(function (datum) {
            var stack = stackMap.get(datum.x) || [];
            stack[index] = datum.y1;
            stackMap.set(datum.x, stack);
        });
    });
    var dataValues = [];
    try {
        for (var stackMap_1 = __values(stackMap), stackMap_1_1 = stackMap_1.next(); !stackMap_1_1.done; stackMap_1_1 = stackMap_1.next()) {
            var stackValues = stackMap_1_1.value;
            dataValues.push.apply(dataValues, __spread(stackValues[1]));
            if (stackValues[1].length > 1) {
                dataValues.push(d3_array_1.sum(stackValues[1]));
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (stackMap_1_1 && !stackMap_1_1.done && (_a = stackMap_1.return)) _a.call(stackMap_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (dataValues.length === 0) {
        return [];
    }
    return domain_1.computeContinuousDataDomain(dataValues, commons_1.identity, null);
}
function computeYNonStackedDomain(dataseries) {
    var yValues = new Set();
    dataseries.forEach(function (ds) {
        ds.data.forEach(function (datum) {
            yValues.add(datum.y1);
            if (datum.y0 != null) {
                yValues.add(datum.y0);
            }
        });
    });
    if (yValues.size === 0) {
        return [];
    }
    return domain_1.computeContinuousDataDomain(__spread(yValues.values()), commons_1.identity, null);
}
function splitSpecsByGroupId(specs) {
    var specsByGroupIds = new Map();
    var isHistogramEnabled = specs.some(function (_a) {
        var seriesType = _a.seriesType, enableHistogramMode = _a.enableHistogramMode;
        return seriesType === specs_1.SeriesTypes.Bar && enableHistogramMode;
    });
    specs.forEach(function (spec) {
        var group = specsByGroupIds.get(spec.groupId) || {
            isPercentageStack: false,
            stacked: [],
            nonStacked: [],
        };
        if ((spec.seriesType === specs_1.SeriesTypes.Bar && isHistogramEnabled)
            || (spec.stackAccessors && spec.stackAccessors.length > 0)) {
            group.stacked.push(spec);
        }
        else {
            group.nonStacked.push(spec);
        }
        if (spec.stackAsPercentage === true) {
            group.isPercentageStack = true;
        }
        specsByGroupIds.set(spec.groupId, group);
    });
    return specsByGroupIds;
}
exports.splitSpecsByGroupId = splitSpecsByGroupId;
function coerceYScaleTypes(specs) {
    var scaleTypes = new Set();
    specs.forEach(function (spec) {
        scaleTypes.add(spec.yScaleType);
    });
    return coerceYScale(scaleTypes);
}
exports.coerceYScaleTypes = coerceYScaleTypes;
function coerceYScale(scaleTypes) {
    if (scaleTypes.size === 1) {
        var scales = scaleTypes.values();
        var value = scales.next().value;
        return value;
    }
    return constants_1.ScaleType.Linear;
}
//# sourceMappingURL=y_domain.js.map