/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.generators;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import java.util.Random;

public final class BiasedNumbers {
    private static final int EVIL_RANGE_LEFT = 1;
    private static final int EVIL_RANGE_RIGHT = 1;
    private static final int EVIL_VERY_CLOSE_RANGE_ENDS = 20;
    private static final int EVIL_ZERO_OR_NEAR = 5;
    private static final int EVIL_SIMPLE_PROPORTION = 10;
    private static final int EVIL_RANDOM_REPRESENTATION_BITS = 10;

    public static double randomDoubleBetween(Random r, double min, double max) {
        assert (max >= min) : "max must be >= min: " + min + ", " + max;
        assert (!Double.isNaN(min) && !Double.isNaN(max));
        boolean hasZero = min <= 0.0 && max >= 0.0;
        int pick = r.nextInt(22 + (hasZero ? 5 : 0) + 10 + 10);
        if (--pick < 0 || min == max) {
            return min;
        }
        if (--pick < 0) {
            return max;
        }
        assert (min != max);
        if (Double.isInfinite(min)) {
            min = Math.nextUp(min);
        }
        if (Double.isInfinite(max)) {
            max = Math.nextAfter(max, Double.NEGATIVE_INFINITY);
        }
        if ((pick -= 20) < 0) {
            if (r.nextBoolean()) {
                return BiasedNumbers.fuzzUp(r, min, max);
            }
            return BiasedNumbers.fuzzDown(r, max, min);
        }
        if (hasZero && (pick -= 5) < 0) {
            int v = r.nextInt(4);
            if (v == 0) {
                return 0.0;
            }
            if (v == 1) {
                return -0.0;
            }
            if (v == 2) {
                return BiasedNumbers.fuzzDown(r, 0.0, min);
            }
            if (v == 3) {
                return BiasedNumbers.fuzzUp(r, 0.0, max);
            }
        }
        if ((pick -= 10) < 0) {
            return min + (max - min) * r.nextDouble();
        }
        if ((pick -= 10) < 0) {
            long from = BiasedNumbers.toSortable(min);
            long to = BiasedNumbers.toSortable(max);
            return BiasedNumbers.fromSortable(RandomNumbers.randomLongBetween(r, from, to));
        }
        throw new RuntimeException("Unreachable.");
    }

    public static double fuzzDown(Random r, double v, double min) {
        assert (v >= min);
        for (int steps = RandomNumbers.randomIntBetween(r, 1, 10); steps > 0 && v > min; --steps) {
            v = Math.nextAfter(v, Double.NEGATIVE_INFINITY);
        }
        return v;
    }

    public static double fuzzUp(Random r, double v, double max) {
        assert (v <= max);
        for (int steps = RandomNumbers.randomIntBetween(r, 1, 10); steps > 0 && v < max; --steps) {
            v = Math.nextUp(v);
        }
        return v;
    }

    private static double fromSortable(long sortable) {
        return Double.longBitsToDouble(BiasedNumbers.flip(sortable));
    }

    private static long toSortable(double value) {
        return BiasedNumbers.flip(Double.doubleToLongBits(value));
    }

    private static long flip(long bits) {
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public static float randomFloatBetween(Random r, float min, float max) {
        assert (max >= min) : "max must be >= min: " + min + ", " + max;
        assert (!Float.isNaN(min) && !Float.isNaN(max));
        boolean hasZero = min <= 0.0f && max >= 0.0f;
        int pick = r.nextInt(22 + (hasZero ? 5 : 0) + 10 + 10);
        if (--pick < 0 || min == max) {
            return min;
        }
        if (--pick < 0) {
            return max;
        }
        assert (min != max);
        if (Float.isInfinite(min)) {
            min = Math.nextUp(min);
        }
        if (Float.isInfinite(max)) {
            max = Math.nextAfter(max, Double.NEGATIVE_INFINITY);
        }
        if ((pick -= 20) < 0) {
            if (r.nextBoolean()) {
                return BiasedNumbers.fuzzUp(r, min, max);
            }
            return BiasedNumbers.fuzzDown(r, max, min);
        }
        if (hasZero && (pick -= 5) < 0) {
            int v = r.nextInt(4);
            if (v == 0) {
                return 0.0f;
            }
            if (v == 1) {
                return -0.0f;
            }
            if (v == 2) {
                return BiasedNumbers.fuzzDown(r, 0.0f, min);
            }
            if (v == 3) {
                return BiasedNumbers.fuzzUp(r, 0.0f, max);
            }
        }
        if ((pick -= 10) < 0) {
            return (float)((double)min + ((double)max - (double)min) * r.nextDouble());
        }
        if ((pick -= 10) < 0) {
            int from = BiasedNumbers.toSortable(min);
            int to = BiasedNumbers.toSortable(max);
            return BiasedNumbers.fromSortable(RandomNumbers.randomIntBetween(r, from, to));
        }
        throw new RuntimeException("Unreachable.");
    }

    public static float fuzzDown(Random r, float v, float min) {
        assert (v >= min);
        for (int steps = RandomNumbers.randomIntBetween(r, 1, 10); steps > 0 && v > min; --steps) {
            v = Math.nextAfter(v, Double.NEGATIVE_INFINITY);
        }
        return v;
    }

    public static float fuzzUp(Random r, float v, float max) {
        assert (v <= max);
        for (int steps = RandomNumbers.randomIntBetween(r, 1, 10); steps > 0 && v < max; --steps) {
            v = Math.nextUp(v);
        }
        return v;
    }

    private static float fromSortable(int sortable) {
        return Float.intBitsToFloat(BiasedNumbers.flip(sortable));
    }

    private static int toSortable(float value) {
        return BiasedNumbers.flip(Float.floatToIntBits(value));
    }

    private static int flip(int floatBits) {
        return floatBits ^ floatBits >> 31 & Integer.MAX_VALUE;
    }
}

