/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.Date;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.constant.ConstantStringValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.DateMathParser;

class DateMathValueFunction
extends DateValue.AbstractDateValue {
    private final DateValue dateParam;
    private final String mathParam;
    DateMathParser parser = new DateMathParser();
    public static final String name = "date_math";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public DateMathValueFunction(DateValue dateParam, ConstantStringValue mathParam) throws SolrException {
        this.dateParam = dateParam;
        this.mathParam = "NOW" + mathParam.getString();
        this.exprStr = AnalyticsValueStream.createExpressionString(name, dateParam, mathParam);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, dateParam);
    }

    @Override
    public long getLong() {
        Date date = this.getDate();
        return this.exists ? date.getTime() : 0L;
    }

    @Override
    public Date getDate() {
        Date date = this.dateParam.getDate();
        if (this.dateParam.exists()) {
            this.exists = true;
            return DateMathParser.parseMath((Date)date, (String)this.mathParam);
        }
        this.exists = false;
        return null;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

