/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;

public class JoinCommuteRule
extends RelOptRule {
    public static final JoinCommuteRule INSTANCE = new JoinCommuteRule(false);
    public static final JoinCommuteRule SWAP_OUTER = new JoinCommuteRule(true);
    private final boolean swapOuter;

    public JoinCommuteRule(Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory, boolean swapOuter) {
        super(JoinCommuteRule.operand(clazz, JoinCommuteRule.any()), relBuilderFactory, null);
        this.swapOuter = swapOuter;
    }

    private JoinCommuteRule(boolean swapOuter) {
        this(LogicalJoin.class, RelFactories.LOGICAL_BUILDER, swapOuter);
    }

    @Deprecated
    public JoinCommuteRule(Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory) {
        this(clazz, RelBuilder.proto(Contexts.of((Object)projectFactory)), false);
    }

    @Deprecated
    public JoinCommuteRule(Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory, boolean swapOuter) {
        this(clazz, RelBuilder.proto(Contexts.of((Object)projectFactory)), swapOuter);
    }

    @Deprecated
    public static RelNode swap(Join join) {
        return JoinCommuteRule.swap(join, false, RelFactories.LOGICAL_BUILDER.create(join.getCluster(), null));
    }

    @Deprecated
    public static RelNode swap(Join join, boolean swapOuterJoins) {
        return JoinCommuteRule.swap(join, swapOuterJoins, RelFactories.LOGICAL_BUILDER.create(join.getCluster(), null));
    }

    public static RelNode swap(Join join, boolean swapOuterJoins, RelBuilder relBuilder) {
        JoinRelType joinType = join.getJoinType();
        if (!swapOuterJoins && joinType != JoinRelType.INNER) {
            return null;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelDataType leftRowType = join.getLeft().getRowType();
        RelDataType rightRowType = join.getRight().getRowType();
        VariableReplacer variableReplacer = new VariableReplacer(rexBuilder, leftRowType, rightRowType);
        RexNode oldCondition = join.getCondition();
        RexNode condition = variableReplacer.go(oldCondition);
        Join newJoin = join.copy(join.getTraitSet(), condition, join.getRight(), join.getLeft(), joinType.swap(), join.isSemiJoinDone());
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, true);
        return relBuilder.push(newJoin).project(exps, join.getRowType().getFieldNames()).build();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        if (!join.getSystemFieldList().isEmpty()) {
            return;
        }
        RelNode swapped = JoinCommuteRule.swap(join, this.swapOuter, call.builder());
        if (swapped == null) {
            return;
        }
        Join newJoin = swapped instanceof Join ? (Join)swapped : (Join)swapped.getInput(0);
        call.transformTo(swapped);
        RelBuilder relBuilder = call.builder();
        List<RexNode> exps = RelOptUtil.createSwappedJoinExprs(newJoin, join, false);
        relBuilder.push(swapped).project(exps, newJoin.getRowType().getFieldNames());
        call.getPlanner().ensureRegistered(relBuilder.build(), newJoin);
    }

    private static class VariableReplacer {
        private final RexBuilder rexBuilder;
        private final List<RelDataTypeField> leftFields;
        private final List<RelDataTypeField> rightFields;

        VariableReplacer(RexBuilder rexBuilder, RelDataType leftType, RelDataType rightType) {
            this.rexBuilder = rexBuilder;
            this.leftFields = leftType.getFieldList();
            this.rightFields = rightType.getFieldList();
        }

        public RexNode go(RexNode rex) {
            if (rex instanceof RexCall) {
                ImmutableList.Builder builder = ImmutableList.builder();
                RexCall call = (RexCall)rex;
                for (RexNode operand : call.operands) {
                    builder.add((Object)this.go(operand));
                }
                return call.clone(call.getType(), (List<RexNode>)builder.build());
            }
            if (rex instanceof RexInputRef) {
                RexInputRef var = (RexInputRef)rex;
                int index = var.getIndex();
                if (index < this.leftFields.size()) {
                    return this.rexBuilder.makeInputRef(this.leftFields.get(index).getType(), this.rightFields.size() + index);
                }
                if ((index -= this.leftFields.size()) < this.rightFields.size()) {
                    return this.rexBuilder.makeInputRef(this.rightFields.get(index).getType(), index);
                }
                throw new AssertionError((Object)("Bad field offset: index=" + var.getIndex() + ", leftFieldCount=" + this.leftFields.size() + ", rightFieldCount=" + this.rightFields.size()));
            }
            return rex;
        }
    }
}

