/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.photoshop.PhotoshopDescriptor;
import java.util.HashMap;

public class PhotoshopDirectory
extends Directory {
    public static final int TAG_CHANNELS_ROWS_COLUMNS_DEPTH_MODE = 1000;
    public static final int TAG_MAC_PRINT_INFO = 1001;
    public static final int TAG_XML = 1002;
    public static final int TAG_INDEXED_COLOR_TABLE = 1003;
    public static final int TAG_RESOLUTION_INFO = 1005;
    public static final int TAG_ALPHA_CHANNELS = 1006;
    public static final int TAG_DISPLAY_INFO_OBSOLETE = 1007;
    public static final int TAG_CAPTION = 1008;
    public static final int TAG_BORDER_INFORMATION = 1009;
    public static final int TAG_BACKGROUND_COLOR = 1010;
    public static final int TAG_PRINT_FLAGS = 1011;
    public static final int TAG_GRAYSCALE_AND_MULTICHANNEL_HALFTONING_INFORMATION = 1012;
    public static final int TAG_COLOR_HALFTONING_INFORMATION = 1013;
    public static final int TAG_DUOTONE_HALFTONING_INFORMATION = 1014;
    public static final int TAG_GRAYSCALE_AND_MULTICHANNEL_TRANSFER_FUNCTION = 1015;
    public static final int TAG_COLOR_TRANSFER_FUNCTIONS = 1016;
    public static final int TAG_DUOTONE_TRANSFER_FUNCTIONS = 1017;
    public static final int TAG_DUOTONE_IMAGE_INFORMATION = 1018;
    public static final int TAG_EFFECTIVE_BLACK_AND_WHITE_VALUES = 1019;
    public static final int TAG_EPS_OPTIONS = 1021;
    public static final int TAG_QUICK_MASK_INFORMATION = 1022;
    public static final int TAG_LAYER_STATE_INFORMATION = 1024;
    public static final int TAG_LAYERS_GROUP_INFORMATION = 1026;
    public static final int TAG_IPTC = 1028;
    public static final int TAG_IMAGE_MODE_FOR_RAW_FORMAT_FILES = 1029;
    public static final int TAG_JPEG_QUALITY = 1030;
    public static final int TAG_GRID_AND_GUIDES_INFORMATION = 1032;
    public static final int TAG_THUMBNAIL_OLD = 1033;
    public static final int TAG_COPYRIGHT = 1034;
    public static final int TAG_URL = 1035;
    public static final int TAG_THUMBNAIL = 1036;
    public static final int TAG_GLOBAL_ANGLE = 1037;
    public static final int TAG_ICC_PROFILE_BYTES = 1039;
    public static final int TAG_WATERMARK = 1040;
    public static final int TAG_ICC_UNTAGGED_PROFILE = 1041;
    public static final int TAG_EFFECTS_VISIBLE = 1042;
    public static final int TAG_SPOT_HALFTONE = 1043;
    public static final int TAG_SEED_NUMBER = 1044;
    public static final int TAG_UNICODE_ALPHA_NAMES = 1045;
    public static final int TAG_INDEXED_COLOR_TABLE_COUNT = 1046;
    public static final int TAG_TRANSPARENCY_INDEX = 1047;
    public static final int TAG_GLOBAL_ALTITUDE = 1049;
    public static final int TAG_SLICES = 1050;
    public static final int TAG_WORKFLOW_URL = 1051;
    public static final int TAG_JUMP_TO_XPEP = 1052;
    public static final int TAG_ALPHA_IDENTIFIERS = 1053;
    public static final int TAG_URL_LIST = 1054;
    public static final int TAG_VERSION = 1057;
    public static final int TAG_EXIF_DATA_1 = 1058;
    public static final int TAG_EXIF_DATA_3 = 1059;
    public static final int TAG_XMP_DATA = 1060;
    public static final int TAG_CAPTION_DIGEST = 1061;
    public static final int TAG_PRINT_SCALE = 1062;
    public static final int TAG_PIXEL_ASPECT_RATIO = 1064;
    public static final int TAG_LAYER_COMPS = 1065;
    public static final int TAG_ALTERNATE_DUOTONE_COLORS = 1066;
    public static final int TAG_ALTERNATE_SPOT_COLORS = 1067;
    public static final int TAG_LAYER_SELECTION_IDS = 1069;
    public static final int TAG_HDR_TONING_INFO = 1070;
    public static final int TAG_PRINT_INFO = 1071;
    public static final int TAG_LAYER_GROUPS_ENABLED_ID = 1072;
    public static final int TAG_COLOR_SAMPLERS = 1073;
    public static final int TAG_MEASUREMENT_SCALE = 1074;
    public static final int TAG_TIMELINE_INFORMATION = 1075;
    public static final int TAG_SHEET_DISCLOSURE = 1076;
    public static final int TAG_DISPLAY_INFO = 1077;
    public static final int TAG_ONION_SKINS = 1078;
    public static final int TAG_COUNT_INFORMATION = 1080;
    public static final int TAG_PRINT_INFO_2 = 1082;
    public static final int TAG_PRINT_STYLE = 1083;
    public static final int TAG_MAC_NSPRINTINFO = 1084;
    public static final int TAG_WIN_DEVMODE = 1085;
    public static final int TAG_AUTO_SAVE_FILE_PATH = 1086;
    public static final int TAG_AUTO_SAVE_FORMAT = 1087;
    public static final int TAG_PATH_SELECTION_STATE = 1088;
    public static final int TAG_CLIPPING_PATH_NAME = 2999;
    public static final int TAG_ORIGIN_PATH_INFO = 3000;
    public static final int TAG_IMAGE_READY_VARIABLES_XML = 7000;
    public static final int TAG_IMAGE_READY_DATA_SETS = 7001;
    public static final int TAG_IMAGE_READY_SELECTED_STATE = 7002;
    public static final int TAG_IMAGE_READY_7_ROLLOVER = 7003;
    public static final int TAG_IMAGE_READY_ROLLOVER = 7004;
    public static final int TAG_IMAGE_READY_SAVE_LAYER_SETTINGS = 7005;
    public static final int TAG_IMAGE_READY_VERSION = 7006;
    public static final int TAG_LIGHTROOM_WORKFLOW = 8000;
    public static final int TAG_PRINT_FLAGS_INFO = 10000;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public PhotoshopDirectory() {
        this.setDescriptor(new PhotoshopDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Photoshop";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    @Nullable
    public byte[] getThumbnailBytes() {
        byte[] storedBytes = this.getByteArray(1036);
        if (storedBytes == null) {
            storedBytes = this.getByteArray(1033);
        }
        if (storedBytes == null || storedBytes.length <= 28) {
            return null;
        }
        int thumbSize = storedBytes.length - 28;
        byte[] thumbBytes = new byte[thumbSize];
        System.arraycopy(storedBytes, 28, thumbBytes, 0, thumbSize);
        return thumbBytes;
    }

    static {
        _tagNameMap.put(1000, "Channels, Rows, Columns, Depth, Mode");
        _tagNameMap.put(1001, "Mac Print Info");
        _tagNameMap.put(1002, "XML Data");
        _tagNameMap.put(1003, "Indexed Color Table");
        _tagNameMap.put(1005, "Resolution Info");
        _tagNameMap.put(1006, "Alpha Channels");
        _tagNameMap.put(1007, "Display Info (Obsolete)");
        _tagNameMap.put(1008, "Caption");
        _tagNameMap.put(1009, "Border Information");
        _tagNameMap.put(1010, "Background Color");
        _tagNameMap.put(1011, "Print Flags");
        _tagNameMap.put(1012, "Grayscale and Multichannel Halftoning Information");
        _tagNameMap.put(1013, "Color Halftoning Information");
        _tagNameMap.put(1014, "Duotone Halftoning Information");
        _tagNameMap.put(1015, "Grayscale and Multichannel Transfer Function");
        _tagNameMap.put(1016, "Color Transfer Functions");
        _tagNameMap.put(1017, "Duotone Transfer Functions");
        _tagNameMap.put(1018, "Duotone Image Information");
        _tagNameMap.put(1019, "Effective Black and White Values");
        _tagNameMap.put(1021, "EPS Options");
        _tagNameMap.put(1022, "Quick Mask Information");
        _tagNameMap.put(1024, "Layer State Information");
        _tagNameMap.put(1026, "Layers Group Information");
        _tagNameMap.put(1028, "IPTC-NAA Record");
        _tagNameMap.put(1029, "Image Mode for Raw Format Files");
        _tagNameMap.put(1030, "JPEG Quality");
        _tagNameMap.put(1032, "Grid and Guides Information");
        _tagNameMap.put(1033, "Photoshop 4.0 Thumbnail");
        _tagNameMap.put(1034, "Copyright Flag");
        _tagNameMap.put(1035, "URL");
        _tagNameMap.put(1036, "Thumbnail Data");
        _tagNameMap.put(1037, "Global Angle");
        _tagNameMap.put(1039, "ICC Profile Bytes");
        _tagNameMap.put(1040, "Watermark");
        _tagNameMap.put(1041, "ICC Untagged Profile");
        _tagNameMap.put(1042, "Effects Visible");
        _tagNameMap.put(1043, "Spot Halftone");
        _tagNameMap.put(1044, "Seed Number");
        _tagNameMap.put(1045, "Unicode Alpha Names");
        _tagNameMap.put(1046, "Indexed Color Table Count");
        _tagNameMap.put(1047, "Transparency Index");
        _tagNameMap.put(1049, "Global Altitude");
        _tagNameMap.put(1050, "Slices");
        _tagNameMap.put(1051, "Workflow URL");
        _tagNameMap.put(1052, "Jump To XPEP");
        _tagNameMap.put(1053, "Alpha Identifiers");
        _tagNameMap.put(1054, "URL List");
        _tagNameMap.put(1057, "Version Info");
        _tagNameMap.put(1058, "EXIF Data 1");
        _tagNameMap.put(1059, "EXIF Data 3");
        _tagNameMap.put(1060, "XMP Data");
        _tagNameMap.put(1061, "Caption Digest");
        _tagNameMap.put(1062, "Print Scale");
        _tagNameMap.put(1064, "Pixel Aspect Ratio");
        _tagNameMap.put(1065, "Layer Comps");
        _tagNameMap.put(1066, "Alternate Duotone Colors");
        _tagNameMap.put(1067, "Alternate Spot Colors");
        _tagNameMap.put(1069, "Layer Selection IDs");
        _tagNameMap.put(1070, "HDR Toning Info");
        _tagNameMap.put(1071, "Print Info");
        _tagNameMap.put(1072, "Layer Groups Enabled ID");
        _tagNameMap.put(1073, "Color Samplers");
        _tagNameMap.put(1074, "Measurement Scale");
        _tagNameMap.put(1075, "Timeline Information");
        _tagNameMap.put(1076, "Sheet Disclosure");
        _tagNameMap.put(1077, "Display Info");
        _tagNameMap.put(1078, "Onion Skins");
        _tagNameMap.put(1080, "Count information");
        _tagNameMap.put(1082, "Print Info 2");
        _tagNameMap.put(1083, "Print Style");
        _tagNameMap.put(1084, "Mac NSPrintInfo");
        _tagNameMap.put(1085, "Win DEVMODE");
        _tagNameMap.put(1086, "Auto Save File Subpath");
        _tagNameMap.put(1087, "Auto Save Format");
        _tagNameMap.put(1088, "Subpath Selection State");
        _tagNameMap.put(2999, "Clipping Path Name");
        _tagNameMap.put(3000, "Origin Subpath Info");
        _tagNameMap.put(7000, "Image Ready Variables XML");
        _tagNameMap.put(7001, "Image Ready Data Sets");
        _tagNameMap.put(7002, "Image Ready Selected State");
        _tagNameMap.put(7003, "Image Ready 7 Rollover Expanded State");
        _tagNameMap.put(7004, "Image Ready Rollover Expanded State");
        _tagNameMap.put(7005, "Image Ready Save Layer Settings");
        _tagNameMap.put(7006, "Image Ready Version");
        _tagNameMap.put(8000, "Lightroom Workflow");
        _tagNameMap.put(10000, "Print Flags Information");
    }
}

