/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrPortAwareCookieSpecFactory;
import org.eclipse.jetty.client.HttpAuthenticationStore;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.WWWAuthenticationProtocolHandler;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.util.SPNEGOAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Krb5HttpClientBuilder
implements HttpClientBuilderFactory {
    public static final String LOGIN_CONFIG_PROP = "java.security.auth.login.config";
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Configuration jaasConfig = new SolrJaasConfiguration();
    private HttpRequestInterceptor bufferedEntityInterceptor = (request, context) -> {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
            HttpEntity requestEntity = enclosingRequest.getEntity();
            enclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity(requestEntity));
        }
    };

    public static void regenerateJaasConfiguration() {
        jaasConfig = new SolrJaasConfiguration();
    }

    public SolrHttpClientBuilder getBuilder() {
        return this.getBuilder(HttpClientUtil.getHttpClientBuilder());
    }

    @Override
    public void close() {
        HttpClientUtil.removeRequestInterceptor(this.bufferedEntityInterceptor);
    }

    @Override
    public SolrHttpClientBuilder getHttpClientBuilder(Optional<SolrHttpClientBuilder> builder) {
        return builder.isPresent() ? this.getBuilder(builder.get()) : this.getBuilder();
    }

    private SPNEGOAuthentication createSPNEGOAuthentication() {
        SPNEGOAuthentication authentication = new SPNEGOAuthentication(null){

            public boolean matches(String type, URI uri, String realm) {
                return this.getType().equals(type);
            }
        };
        String clientAppName = System.getProperty("solr.kerberos.jaas.appname", "Client");
        AppConfigurationEntry[] entries = jaasConfig.getAppConfigurationEntry(clientAppName);
        if (entries == null) {
            log.warn("Could not find login configuration entry for {}. SPNego authentication may not be successful.", (Object)clientAppName);
            return authentication;
        }
        if (entries.length != 1) {
            log.warn("Multiple login modules are specified in the configuration file");
            return authentication;
        }
        Map<String, ?> options = entries[0].getOptions();
        String keyTab = (String)options.get("keyTab");
        if (keyTab != null) {
            authentication.setUserKeyTabPath(Paths.get(keyTab, new String[0]));
        }
        authentication.setServiceName("HTTP");
        authentication.setUserName((String)options.get("principal"));
        if ("true".equalsIgnoreCase((String)options.get("useTicketCache"))) {
            authentication.setUseTicketCache(true);
            String ticketCachePath = (String)options.get("ticketCache");
            if (ticketCachePath != null) {
                authentication.setTicketCachePath(Paths.get(ticketCachePath, new String[0]));
            }
            authentication.setRenewTGT("true".equalsIgnoreCase((String)options.get("renewTGT")));
        }
        return authentication;
    }

    @Override
    public void setup(Http2SolrClient http2Client) {
        HttpAuthenticationStore authenticationStore = new HttpAuthenticationStore();
        authenticationStore.addAuthentication((Authentication)this.createSPNEGOAuthentication());
        http2Client.getHttpClient().setAuthenticationStore((AuthenticationStore)authenticationStore);
        http2Client.getProtocolHandlers().put((ProtocolHandler)new WWWAuthenticationProtocolHandler(http2Client.getHttpClient()));
    }

    public SolrHttpClientBuilder getBuilder(SolrHttpClientBuilder builder) {
        if (System.getProperty(LOGIN_CONFIG_PROP) != null) {
            String configValue = System.getProperty(LOGIN_CONFIG_PROP);
            if (configValue != null) {
                log.info("Setting up SPNego auth with config: {}", (Object)configValue);
                String useSubjectCredsProp = "javax.security.auth.useSubjectCredsOnly";
                String useSubjectCredsVal = System.getProperty("javax.security.auth.useSubjectCredsOnly");
                if (useSubjectCredsVal == null) {
                    System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                } else if (!useSubjectCredsVal.toLowerCase(Locale.ROOT).equals("false")) {
                    log.warn("System Property: {} set to: {} not false.  SPNego authentication may not be successful.", (Object)"javax.security.auth.useSubjectCredsOnly", (Object)useSubjectCredsVal);
                }
                Configuration.setConfiguration(jaasConfig);
                builder.setAuthSchemeRegistryProvider(() -> {
                    Registry authProviders = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, false)).build();
                    return authProviders;
                });
                Credentials useJaasCreds = new Credentials(){

                    public String getPassword() {
                        return null;
                    }

                    public Principal getUserPrincipal() {
                        return null;
                    }
                };
                HttpClientUtil.setCookiePolicy("solr-portaware");
                builder.setCookieSpecRegistryProvider(() -> {
                    SolrPortAwareCookieSpecFactory cookieFactory = new SolrPortAwareCookieSpecFactory();
                    Registry cookieRegistry = RegistryBuilder.create().register("solr-portaware", (Object)cookieFactory).build();
                    return cookieRegistry;
                });
                builder.setDefaultCredentialsProvider(() -> {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, useJaasCreds);
                    return credentialsProvider;
                });
                HttpClientUtil.addRequestInterceptor(this.bufferedEntityInterceptor);
            }
        } else {
            log.warn("{} is configured without specifying system property '{}'", (Object)this.getClass().getName(), (Object)LOGIN_CONFIG_PROP);
        }
        return builder;
    }

    private static class SolrJaasConfiguration
    extends Configuration {
        private Configuration baseConfig;
        private Set<String> initiateAppNames = new HashSet<String>(Arrays.asList("com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate"));

        public SolrJaasConfiguration() {
            try {
                this.baseConfig = Configuration.getConfiguration();
            }
            catch (SecurityException e) {
                this.baseConfig = null;
            }
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.baseConfig == null) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("Login prop: {}", (Object)System.getProperty(Krb5HttpClientBuilder.LOGIN_CONFIG_PROP));
            }
            String clientAppName = System.getProperty("solr.kerberos.jaas.appname", "Client");
            if (this.initiateAppNames.contains(appName)) {
                log.debug("Using AppConfigurationEntry for appName '{}' instead of: '{}'", (Object)clientAppName, (Object)appName);
                return this.baseConfig.getAppConfigurationEntry(clientAppName);
            }
            return this.baseConfig.getAppConfigurationEntry(appName);
        }
    }
}

