/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.request.CollectionApiMapping;
import org.apache.solr.common.Callable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.handler.admin.BaseHandlerApiSupport;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionHandlerApi
extends BaseHandlerApiSupport {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final CollectionsHandler handler;
    static Collection<BaseHandlerApiSupport.ApiCommand> apiCommands = CollectionHandlerApi.createCollMapping();

    private static Collection<BaseHandlerApiSupport.ApiCommand> createCollMapping() {
        EnumMap<CollectionApiMapping.Meta, BaseHandlerApiSupport.ApiCommand> result = new EnumMap<CollectionApiMapping.Meta, BaseHandlerApiSupport.ApiCommand>(CollectionApiMapping.Meta.class);
        for (final CollectionApiMapping.Meta meta : CollectionApiMapping.Meta.values()) {
            for (final CollectionsHandler.CollectionOperation op : CollectionsHandler.CollectionOperation.values()) {
                if (op.action != meta.action) continue;
                result.put(meta, new BaseHandlerApiSupport.ApiCommand(){

                    @Override
                    public CollectionApiMapping.CommandMeta meta() {
                        return meta;
                    }

                    @Override
                    public void invoke(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) throws Exception {
                        ((CollectionHandlerApi)apiHandler).handler.invokeAction(req, rsp, ((CollectionHandlerApi)apiHandler).handler.coreContainer, op.action, op);
                    }
                });
            }
        }
        CollectionHandlerApi.addApi(result, CollectionApiMapping.Meta.GET_NODES, (Callable<ApiParams>)((Callable)params -> params.rsp.add("nodes", ((CollectionHandlerApi)params.apiHandler).handler.coreContainer.getZkController().getClusterState().getLiveNodes())));
        CollectionHandlerApi.addApi(result, CollectionApiMapping.Meta.SET_CLUSTER_PROPERTY_OBJ, (Callable<ApiParams>)((Callable)params -> {
            List<CommandOperation> commands = params.req.getCommands(true);
            if (commands == null || commands.isEmpty()) {
                throw new RuntimeException("Empty commands");
            }
            ClusterProperties clusterProperties = new ClusterProperties(((CollectionHandlerApi)params.apiHandler).handler.coreContainer.getZkController().getZkClient());
            try {
                clusterProperties.setClusterProperties(commands.get(0).getDataMap());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in API", (Throwable)e);
            }
        }));
        for (final CollectionApiMapping.Meta meta : CollectionApiMapping.Meta.values()) {
            if (result.get(meta) != null) continue;
            log.error("ERROR_INIT. No corresponding API implementation for : {}", (Object)meta.commandName);
        }
        return result.values();
    }

    private static void addApi(Map<CollectionApiMapping.Meta, BaseHandlerApiSupport.ApiCommand> result, final CollectionApiMapping.Meta metaInfo, final Callable<ApiParams> fun) {
        result.put(metaInfo, new BaseHandlerApiSupport.ApiCommand(){

            @Override
            public CollectionApiMapping.CommandMeta meta() {
                return metaInfo;
            }

            @Override
            public void invoke(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) throws Exception {
                fun.call((Object)new ApiParams(req, rsp, apiHandler));
            }
        });
    }

    public CollectionHandlerApi(CollectionsHandler handler) {
        this.handler = handler;
    }

    @Override
    protected Collection<BaseHandlerApiSupport.ApiCommand> getCommands() {
        return apiCommands;
    }

    protected List<CollectionApiMapping.V2EndPoint> getEndPoints() {
        return Arrays.asList(CollectionApiMapping.EndPoint.values());
    }

    static class ApiParams {
        final SolrQueryRequest req;
        final SolrQueryResponse rsp;
        final BaseHandlerApiSupport apiHandler;

        ApiParams(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) {
            this.req = req;
            this.rsp = rsp;
            this.apiHandler = apiHandler;
        }
    }
}

