'''OpenGL extension EXT.texture_object

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.texture_object to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces named texture objects.  The only way to name
	a texture in GL 1.0 is by defining it as a single display list.  Because
	display lists cannot be edited, these objects are static.  Yet it is
	important to be able to change the images and parameters of a texture.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/texture_object.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.texture_object import *
from OpenGL.raw.GL.EXT.texture_object import _EXTENSION_NAME

def glInitTextureObjectEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glAreTexturesResidentEXT.textures size not checked against n
glAreTexturesResidentEXT=wrapper.wrapper(glAreTexturesResidentEXT).setOutput(
    'residences',size=lambda x:(x,),pnameArg='n',orPassIn=True
).setInputArraySize(
    'textures', None
)
# INPUT glDeleteTexturesEXT.textures size not checked against n
glDeleteTexturesEXT=wrapper.wrapper(glDeleteTexturesEXT).setInputArraySize(
    'textures', None
)
glGenTexturesEXT=wrapper.wrapper(glGenTexturesEXT).setOutput(
    'textures',size=lambda x:(x,),pnameArg='n',orPassIn=True
)
# INPUT glPrioritizeTexturesEXT.priorities size not checked against n
# INPUT glPrioritizeTexturesEXT.textures size not checked against n
glPrioritizeTexturesEXT=wrapper.wrapper(glPrioritizeTexturesEXT).setInputArraySize(
    'priorities', None
).setInputArraySize(
    'textures', None
)
### END AUTOGENERATED SECTION