/*	$OpenBSD: spleen16x32.h,v 1.4 2019/09/05 19:18:32 fcambus Exp $ */

/*
 * Copyright (c) 2018-2019 Frederic Cambus <fcambus@openbsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

static u_char spleen16x32_data[];

struct wsdisplay_font spleen16x32 = {
	"Spleen 16x32",			/* typeface name */
	0,				/* index */
	' ',				/* firstchar */
	256 - ' ',			/* numchars */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	16,				/* width */
	32,				/* height */
	2,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	NULL,				/* cookie */
	spleen16x32_data		/* data */
};

static u_char spleen16x32_data[] = {
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x7f, 0xfe, 	/* .**************. */
	0x7f, 0xfe, 	/* .**************. */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x7f, 0xfe, 	/* .**************. */
	0x7f, 0xfe, 	/* .**************. */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x39, 0x80, 	/* ..***..**....... */
	0x31, 0x80, 	/* ..**...**....... */
	0x31, 0x80, 	/* ..**...**....... */
	0x31, 0x80, 	/* ..**...**....... */
	0x31, 0x80, 	/* ..**...**....... */
	0x39, 0x80, 	/* ..***..**....... */
	0x1f, 0xf0, 	/* ...*********.... */
	0x0f, 0xf8, 	/* ....*********... */
	0x01, 0x9c, 	/* .......**..***.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x9c, 	/* .......**..***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x0c, 	/* ............**.. */
	0x0e, 0x0c, 	/* ....***.....**.. */
	0x1b, 0x18, 	/* ...**.**...**... */
	0x1b, 0x18, 	/* ...**.**...**... */
	0x1b, 0x30, 	/* ...**.**..**.... */
	0x0e, 0x30, 	/* ....***...**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x38, 	/* .....**...***... */
	0x06, 0x6c, 	/* .....**..**.**.. */
	0x0c, 0x6c, 	/* ....**...**.**.. */
	0x0c, 0x6c, 	/* ....**...**.**.. */
	0x18, 0x38, 	/* ...**.....***... */
	0x18, 0x00, 	/* ...**........... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0xe0, 	/* .....******..... */
	0x0f, 0xf0, 	/* ....********.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x1c, 0x38, 	/* ...***....***... */
	0x0f, 0xf0, 	/* ....********.... */
	0x07, 0xe0, 	/* .....******..... */
	0x1f, 0x80, 	/* ...******....... */
	0x3f, 0xc0, 	/* ..********...... */
	0x70, 0xec, 	/* .***....***.**.. */
	0x60, 0x7c, 	/* .**......*****.. */
	0x60, 0x38, 	/* .**.......***... */
	0x60, 0x30, 	/* .**.......**.... */
	0x60, 0x38, 	/* .**.......***... */
	0x70, 0x7c, 	/* .***.....*****.. */
	0x3f, 0xee, 	/* ..*********.***. */
	0x1f, 0xc6, 	/* ...*******...**. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x3c, 	/* ..........****.. */
	0x00, 0xfc, 	/* ........******.. */
	0x01, 0xe0, 	/* .......****..... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x06, 0x00, 	/* .....**......... */
	0x0e, 0x00, 	/* ....***......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x1c, 0x00, 	/* ...***.......... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x1c, 0x00, 	/* ...***.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0e, 0x00, 	/* ....***......... */
	0x06, 0x00, 	/* .....**......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xe0, 	/* .......****..... */
	0x00, 0xfc, 	/* ........******.. */
	0x00, 0x3c, 	/* ..........****.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3c, 0x00, 	/* ..****.......... */
	0x3f, 0x00, 	/* ..******........ */
	0x07, 0x80, 	/* .....****....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x38, 	/* ..........***... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x38, 	/* ..........***... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x07, 0x80, 	/* .....****....... */
	0x3f, 0x00, 	/* ..******........ */
	0x3c, 0x00, 	/* ..****.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x18, 	/* ...**......**... */
	0x1c, 0x38, 	/* ...***....***... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0xe0, 	/* .....******..... */
	0x03, 0xc0, 	/* ......****...... */
	0x03, 0xc0, 	/* ......****...... */
	0x7f, 0xfe, 	/* .**************. */
	0x7f, 0xfe, 	/* .**************. */
	0x03, 0xc0, 	/* ......****...... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x06, 	/* .............**. */
	0x00, 0x06, 	/* .............**. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x3c, 	/* ..**......****.. */
	0x30, 0x7c, 	/* ..**.....*****.. */
	0x30, 0xec, 	/* ..**....***.**.. */
	0x31, 0xcc, 	/* ..**...***..**.. */
	0x33, 0x8c, 	/* ..**..***...**.. */
	0x37, 0x0c, 	/* ..**.***....**.. */
	0x3e, 0x0c, 	/* ..*****.....**.. */
	0x3c, 0x0c, 	/* ..****......**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x80, 	/* .....****....... */
	0x0d, 0x80, 	/* ....**.**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x11, 0x80, 	/* ...*...**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x18, 	/* ...........**... */
	0x07, 0xf0, 	/* .....*******.... */
	0x07, 0xf0, 	/* .....*******.... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x18, 0x18, 	/* ...**......**... */
	0x0f, 0xf0, 	/* ....********.... */
	0x0f, 0xf0, 	/* ....********.... */
	0x18, 0x18, 	/* ...**......**... */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x38, 	/* ..........***... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x0e, 0x00, 	/* ....***......... */
	0x1c, 0x00, 	/* ...***.......... */
	0x38, 0x00, 	/* ..***........... */
	0x38, 0x00, 	/* ..***........... */
	0x1c, 0x00, 	/* ...***.......... */
	0x0e, 0x00, 	/* ....***......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0x38, 	/* ..........***... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x38, 0x00, 	/* ..***........... */
	0x1c, 0x00, 	/* ...***.......... */
	0x0e, 0x00, 	/* ....***......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0x38, 	/* ..........***... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x38, 	/* ..........***... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x0e, 0x00, 	/* ....***......... */
	0x1c, 0x00, 	/* ...***.......... */
	0x38, 0x00, 	/* ..***........... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x31, 0xcc, 	/* ..**...***..**.. */
	0x31, 0xcc, 	/* ..**...***..**.. */
	0x31, 0xcc, 	/* ..**...***..**.. */
	0x31, 0xcc, 	/* ..**...***..**.. */
	0x31, 0xcc, 	/* ..**...***..**.. */
	0x31, 0xcc, 	/* ..**...***..**.. */
	0x31, 0xfc, 	/* ..**...*******.. */
	0x31, 0xfc, 	/* ..**...*******.. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf8, 	/* ....*********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x18, 	/* ..**.......**... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x30, 0x18, 	/* ..**.......**... */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xe0, 	/* ..*********..... */
	0x3f, 0xe0, 	/* ..*********..... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xe0, 	/* ..*********..... */
	0x3f, 0xe0, 	/* ..*********..... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0xfc, 	/* ..**....******.. */
	0x30, 0xfc, 	/* ..**....******.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x80, 	/* ......***....... */
	0x7f, 0x00, 	/* .*******........ */
	0x7e, 0x00, 	/* .******......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x18, 	/* ..**.......**... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x3f, 0xc0, 	/* ..********...... */
	0x3f, 0xc0, 	/* ..********...... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x18, 	/* ..**.......**... */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x3c, 0x3c, 	/* ..****....****.. */
	0x3e, 0x7c, 	/* ..*****..*****.. */
	0x37, 0xec, 	/* ..**.******.**.. */
	0x33, 0xcc, 	/* ..**..****..**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x3c, 0x0c, 	/* ..****......**.. */
	0x3c, 0x0c, 	/* ..****......**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x33, 0x0c, 	/* ..**..**....**.. */
	0x33, 0x0c, 	/* ..**..**....**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x30, 0xcc, 	/* ..**....**..**.. */
	0x30, 0xcc, 	/* ..**....**..**.. */
	0x30, 0x6c, 	/* ..**.....**.**.. */
	0x30, 0x6c, 	/* ..**.....**.**.. */
	0x30, 0x3c, 	/* ..**......****.. */
	0x30, 0x3c, 	/* ..**......****.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x30, 0xcc, 	/* ..**....**..**.. */
	0x38, 0xdc, 	/* ..***...**.***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x18, 	/* ..**.......**... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x30, 0x18, 	/* ..**.......**... */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xf0, 	/* ...*********.... */
	0x0f, 0xf8, 	/* ....*********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x1c, 	/* ...........***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xfe, 	/* .**************. */
	0x7f, 0xfe, 	/* .**************. */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1c, 0x38, 	/* ...***....***... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0xe0, 	/* .....******..... */
	0x03, 0xc0, 	/* ......****...... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x33, 0xcc, 	/* ..**..****..**.. */
	0x37, 0xec, 	/* ..**.******.**.. */
	0x3e, 0x7c, 	/* ..*****..*****.. */
	0x3c, 0x3c, 	/* ..****....****.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1c, 0x38, 	/* ...***....***... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0xe0, 	/* .....******..... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x1c, 	/* ...........***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0f, 0xfc, 	/* ....**********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x06, 	/* .............**. */
	0x00, 0x06, 	/* .............**. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x70, 0x0e, 	/* .***........***. */
	0x60, 0x06, 	/* .**..........**. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xfe, 	/* .**************. */
	0x7f, 0xfe, 	/* .**************. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf0, 	/* ...*********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0xf8, 	/* .......******... */
	0x03, 0xf8, 	/* ......*******... */
	0x07, 0x00, 	/* .....***........ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x1f, 0xe0, 	/* ...********..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x1c, 	/* ...........***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0x80, 	/* .....****....... */
	0x07, 0x80, 	/* .....****....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0xe0, 	/* .......****..... */
	0x01, 0xe0, 	/* .......****..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x80, 	/* ......***....... */
	0x1f, 0x00, 	/* ...*****........ */
	0x1e, 0x00, 	/* ...****......... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x30, 	/* ...**.....**.... */
	0x18, 0x70, 	/* ...**....***.... */
	0x18, 0xe0, 	/* ...**...***..... */
	0x19, 0xc0, 	/* ...**..***...... */
	0x1b, 0x80, 	/* ...**.***....... */
	0x1f, 0x00, 	/* ...*****........ */
	0x1f, 0x00, 	/* ...*****........ */
	0x1b, 0x80, 	/* ...**.***....... */
	0x19, 0xc0, 	/* ...**..***...... */
	0x18, 0xe0, 	/* ...**...***..... */
	0x18, 0x70, 	/* ...**....***.... */
	0x18, 0x38, 	/* ...**.....***... */
	0x18, 0x1c, 	/* ...**......***.. */
	0x18, 0x0c, 	/* ...**.......**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0xf8, 	/* ......*******... */
	0x01, 0xf8, 	/* .......******... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3e, 0x70, 	/* ..*****..***.... */
	0x3e, 0x78, 	/* ..*****..****... */
	0x31, 0x9c, 	/* ..**...**..***.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xf0, 	/* ...*********.... */
	0x0f, 0xf8, 	/* ....*********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x1c, 	/* ...........***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x1f, 0xe0, 	/* ...********..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0xf8, 	/* ......*******... */
	0x01, 0xf8, 	/* .......******... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1c, 0x38, 	/* ...***....***... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0xe0, 	/* .....******..... */
	0x03, 0xc0, 	/* ......****...... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x39, 0x8c, 	/* ..***..**...**.. */
	0x1e, 0x7c, 	/* ...****..*****.. */
	0x0e, 0x7c, 	/* ....***..*****.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1c, 0x38, 	/* ...***....***... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0xe0, 	/* .....******..... */
	0x03, 0xc0, 	/* ......****...... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x1c, 	/* ...........***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0xfc, 	/* ........******.. */
	0x01, 0xfc, 	/* .......*******.. */
	0x03, 0x80, 	/* ......***....... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x07, 0x00, 	/* .....***........ */
	0x3e, 0x00, 	/* ..*****......... */
	0x3c, 0x00, 	/* ..****.......... */
	0x3c, 0x00, 	/* ..****.......... */
	0x3e, 0x00, 	/* ..*****......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xfc, 	/* .......*******.. */
	0x00, 0xfc, 	/* ........******.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0x00, 	/* ..******........ */
	0x3f, 0x80, 	/* ..*******....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x7c, 	/* .........*****.. */
	0x00, 0x3c, 	/* ..........****.. */
	0x00, 0x3c, 	/* ..........****.. */
	0x00, 0x7c, 	/* .........*****.. */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0xc0, 	/* .......***...... */
	0x3f, 0x80, 	/* ..*******....... */
	0x3f, 0x00, 	/* ..******........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0e, 0x0c, 	/* ....***.....**.. */
	0x1f, 0x0c, 	/* ...*****....**.. */
	0x3b, 0x9c, 	/* ..***.***..***.. */
	0x31, 0xf8, 	/* ..**...******... */
	0x30, 0xf0, 	/* ..**....****.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0xc0, 	/* ..***...**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x38, 0xc0, 	/* ..***...**...... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x03, 0xe0, 	/* ......*****..... */
	0x07, 0xf0, 	/* .....*******.... */
	0x0e, 0x38, 	/* ....***...***... */
	0x0c, 0x18, 	/* ....**.....**... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1c, 0x38, 	/* ...***....***... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0xe0, 	/* .....******..... */
	0x0f, 0xf0, 	/* ....********.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x1c, 0x38, 	/* ...***....***... */
	0x0f, 0xf0, 	/* ....********.... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x03, 0xc0, 	/* ......****...... */
	0x03, 0xc0, 	/* ......****...... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0xe0, 	/* .....******..... */
	0x0f, 0xf0, 	/* ....********.... */
	0x1c, 0x70, 	/* ...***...***.... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x1c, 0x00, 	/* ...***.......... */
	0x0e, 0x00, 	/* ....***......... */
	0x07, 0xe0, 	/* .....******..... */
	0x0f, 0xf0, 	/* ....********.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x18, 0x18, 	/* ...**......**... */
	0x1c, 0x38, 	/* ...***....***... */
	0x0f, 0xf0, 	/* ....********.... */
	0x07, 0xe0, 	/* .....******..... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0x38, 	/* ..........***... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x0e, 0x38, 	/* ....***...***... */
	0x0f, 0xf0, 	/* ....********.... */
	0x07, 0xe0, 	/* .....******..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x33, 0xec, 	/* ..**..*****.**.. */
	0x37, 0xec, 	/* ..**.******.**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x37, 0xec, 	/* ..**.******.**.. */
	0x33, 0xec, 	/* ..**..*****.**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0xc0, 	/* .....*****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0x30, 	/* ..........**.... */
	0x07, 0xf0, 	/* .....*******.... */
	0x0f, 0xf0, 	/* ....********.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0f, 0xf0, 	/* ....********.... */
	0x07, 0xf0, 	/* .....*******.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x03, 0x9c, 	/* ......***..***.. */
	0x07, 0x38, 	/* .....***..***... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0xe0, 	/* ...***..***..... */
	0x39, 0xc0, 	/* ..***..***...... */
	0x39, 0xc0, 	/* ..***..***...... */
	0x1c, 0xe0, 	/* ...***..***..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0x38, 	/* .....***..***... */
	0x03, 0x9c, 	/* ......***..***.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x37, 0xcc, 	/* ..**.*****..**.. */
	0x37, 0xec, 	/* ..**.******.**.. */
	0x36, 0x6c, 	/* ..**.**..**.**.. */
	0x37, 0xec, 	/* ..**.******.**.. */
	0x37, 0xcc, 	/* ..**.*****..**.. */
	0x36, 0x6c, 	/* ..**.**..**.**.. */
	0x36, 0x6c, 	/* ..**.**..**.**.. */
	0x36, 0x6c, 	/* ..**.**..**.**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0xe0, 	/* .....******..... */
	0x03, 0xc0, 	/* ......****...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x30, 	/* .....**...**.... */
	0x0f, 0xf0, 	/* ....********.... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x01, 0xe0, 	/* .......****..... */
	0x01, 0xe0, 	/* .......****..... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x07, 0xe0, 	/* .....******..... */
	0x03, 0xc0, 	/* ......****...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x38, 0x78, 	/* ..***....****... */
	0x3f, 0xfe, 	/* ..*************. */
	0x37, 0xce, 	/* ..**.*****..***. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x39, 0x8c, 	/* ..***..**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x39, 0x8c, 	/* ..***..**...**.. */
	0x1f, 0x8c, 	/* ...******...**.. */
	0x0f, 0x8c, 	/* ....*****...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x01, 0x8c, 	/* .......**...**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x06, 0x00, 	/* .....**......... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x80, 	/* .....****....... */
	0x05, 0x80, 	/* .....*.**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x07, 0xe0, 	/* .....******..... */
	0x07, 0xe0, 	/* .....******..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0xe0, 	/* .....******..... */
	0x03, 0xc0, 	/* ......****...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x39, 0xc0, 	/* ..***..***...... */
	0x1c, 0xe0, 	/* ...***..***..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0x38, 	/* .....***..***... */
	0x03, 0x9c, 	/* ......***..***.. */
	0x03, 0x9c, 	/* ......***..***.. */
	0x07, 0x38, 	/* .....***..***... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0xe0, 	/* ...***..***..... */
	0x39, 0xc0, 	/* ..***..***...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x38, 0x00, 	/* ..***........... */
	0x78, 0x00, 	/* .****........... */
	0x58, 0x00, 	/* .*.**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x06, 	/* ...**........**. */
	0x18, 0x0e, 	/* ...**.......***. */
	0x18, 0x1c, 	/* ...**......***.. */
	0x7e, 0x38, 	/* .******...***... */
	0x7e, 0x70, 	/* .******..***.... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x0e, 0x00, 	/* ....***......... */
	0x1d, 0x80, 	/* ...***.**....... */
	0x39, 0x80, 	/* ..***..**....... */
	0x71, 0x98, 	/* .***...**..**... */
	0x61, 0x98, 	/* .**....**..**... */
	0x01, 0x98, 	/* .......**..**... */
	0x01, 0x98, 	/* .......**..**... */
	0x01, 0xfe, 	/* .......********. */
	0x01, 0xfe, 	/* .......********. */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x38, 0x00, 	/* ..***........... */
	0x78, 0x00, 	/* .****........... */
	0x58, 0x00, 	/* .*.**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x06, 	/* ...**........**. */
	0x18, 0x0e, 	/* ...**.......***. */
	0x18, 0x1c, 	/* ...**......***.. */
	0x7e, 0x38, 	/* .******...***... */
	0x7e, 0x70, 	/* .******..***.... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x0e, 0x78, 	/* ....***..****... */
	0x1c, 0xfc, 	/* ...***..******.. */
	0x39, 0x86, 	/* ..***..**....**. */
	0x70, 0x06, 	/* .***.........**. */
	0x60, 0x06, 	/* .**..........**. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc6, 	/* ........**...**. */
	0x01, 0xfe, 	/* .......********. */
	0x01, 0xfe, 	/* .......********. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1e, 0x00, 	/* ...****......... */
	0x3f, 0x00, 	/* ..******........ */
	0x61, 0x80, 	/* .**....**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x0f, 0x00, 	/* ....****........ */
	0x01, 0x86, 	/* .......**....**. */
	0x01, 0x8e, 	/* .......**...***. */
	0x61, 0x9c, 	/* .**....**..***.. */
	0x3f, 0x38, 	/* ..******..***... */
	0x1e, 0x70, 	/* ...****..***.... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x0e, 0x00, 	/* ....***......... */
	0x1d, 0x80, 	/* ...***.**....... */
	0x39, 0x80, 	/* ..***..**....... */
	0x71, 0x98, 	/* .***...**..**... */
	0x61, 0x98, 	/* .**....**..**... */
	0x01, 0x98, 	/* .......**..**... */
	0x01, 0x98, 	/* .......**..**... */
	0x01, 0xfe, 	/* .......********. */
	0x01, 0xfe, 	/* .......********. */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x18, 	/* ...........**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x0f, 0x0c, 	/* ....****....**.. */
	0x1f, 0x9c, 	/* ...******..***.. */
	0x39, 0xf8, 	/* ..***..******... */
	0x30, 0xf0, 	/* ..**....****.... */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x03, 0xc0, 	/* ......****...... */
	0x01, 0x80, 	/* .......**....... */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0xc0, 	/* ..***...**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xfc, 	/* ..**....******.. */
	0x30, 0xfc, 	/* ..**....******.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x03, 0x00, 	/* ......**........ */

	0x00, 0x00, 	/* ................ */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xe0, 	/* ..*********..... */
	0x3f, 0xe0, 	/* ..*********..... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xe0, 	/* ..*********..... */
	0x3f, 0xe0, 	/* ..*********..... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xe0, 	/* ..*********..... */
	0x3f, 0xe0, 	/* ..*********..... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xe0, 	/* ..*********..... */
	0x3f, 0xe0, 	/* ..*********..... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0xff, 0x0c, 	/* ********....**.. */
	0xff, 0x0c, 	/* ********....**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x0f, 0x0c, 	/* ....****....**.. */
	0x1f, 0x9c, 	/* ...******..***.. */
	0x39, 0xf8, 	/* ..***..******... */
	0x30, 0xf0, 	/* ..**....****.... */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x3c, 0x0c, 	/* ..****......**.. */
	0x3c, 0x0c, 	/* ..****......**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x33, 0x0c, 	/* ..**..**....**.. */
	0x33, 0x0c, 	/* ..**..**....**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x30, 0xcc, 	/* ..**....**..**.. */
	0x30, 0xcc, 	/* ..**....**..**.. */
	0x30, 0x6c, 	/* ..**.....**.**.. */
	0x30, 0x6c, 	/* ..**.....**.**.. */
	0x30, 0x3c, 	/* ..**......****.. */
	0x30, 0x3c, 	/* ..**......****.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x0f, 0x0c, 	/* ....****....**.. */
	0x1f, 0x9c, 	/* ...******..***.. */
	0x39, 0xf8, 	/* ..***..******... */
	0x30, 0xf0, 	/* ..**....****.... */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1c, 0x38, 	/* ...***....***... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x07, 0xe0, 	/* .....******..... */
	0x03, 0xc0, 	/* ......****...... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x0f, 0xf8, 	/* ....*********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x3c, 	/* ..***.....****.. */
	0x30, 0x3c, 	/* ..**......****.. */
	0x30, 0x6c, 	/* ..**.....**.**.. */
	0x30, 0x6c, 	/* ..**.....**.**.. */
	0x30, 0xcc, 	/* ..**....**..**.. */
	0x30, 0xcc, 	/* ..**....**..**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x31, 0x8c, 	/* ..**...**...**.. */
	0x33, 0x0c, 	/* ..**..**....**.. */
	0x33, 0x0c, 	/* ..**..**....**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x36, 0x0c, 	/* ..**.**.....**.. */
	0x3c, 0x0c, 	/* ..****......**.. */
	0x3c, 0x0c, 	/* ..****......**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x1c, 	/* ...........***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xc0, 	/* ....******...... */
	0x1f, 0xe0, 	/* ...********..... */
	0x38, 0x70, 	/* ..***....***.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x30, 	/* ..**......**.... */
	0x30, 0x70, 	/* ..**.....***.... */
	0x3f, 0xe0, 	/* ..*********..... */
	0x3f, 0xc0, 	/* ..********...... */
	0x31, 0xf0, 	/* ..**...*****.... */
	0x30, 0x78, 	/* ..**.....****... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3c, 0x0c, 	/* ..****......**.. */
	0x3e, 0x1c, 	/* ..*****....***.. */
	0x37, 0xf8, 	/* ..**.********... */
	0x33, 0xf0, 	/* ..**..******.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf0, 	/* ...*********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf0, 	/* ...*********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf0, 	/* ...*********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0e, 0x0c, 	/* ....***.....**.. */
	0x1f, 0x0c, 	/* ...*****....**.. */
	0x3b, 0x9c, 	/* ..***.***..***.. */
	0x31, 0xf8, 	/* ..**...******... */
	0x30, 0xf0, 	/* ..**....****.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf0, 	/* ...*********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf0, 	/* ...*********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0xe0, 	/* ......*****..... */
	0x06, 0x30, 	/* .....**...**.... */
	0x06, 0x30, 	/* .....**...**.... */
	0x06, 0x30, 	/* .....**...**.... */
	0x03, 0xe0, 	/* ......*****..... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf0, 	/* ...*********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x1c, 	/* ...........***.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x3f, 	/* ...*****..****** */
	0x1f, 0xff, 	/* ...************* */
	0x01, 0xe3, 	/* .......****...** */
	0x00, 0xc3, 	/* ........**....** */
	0x00, 0xc3, 	/* ........**....** */
	0x0f, 0xc3, 	/* ....******....** */
	0x1f, 0xff, 	/* ...************* */
	0x38, 0xff, 	/* ..***...******** */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x39, 0xe0, 	/* ..***..****..... */
	0x1f, 0xff, 	/* ...************* */
	0x0f, 0x3f, 	/* ....****..****** */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x00, 	/* ..***........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x03, 0x00, 	/* ......**........ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x70, 	/* .........***.... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xfc, 	/* ....**********.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x3f, 0xfc, 	/* ..************.. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x38, 0x00, 	/* ..***........... */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0x80, 	/* .....****....... */
	0x07, 0x80, 	/* .....****....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0xe0, 	/* .......****..... */
	0x01, 0xe0, 	/* .......****..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0x80, 	/* .....****....... */
	0x07, 0x80, 	/* .....****....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0xe0, 	/* .......****..... */
	0x01, 0xe0, 	/* .......****..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0x80, 	/* .....****....... */
	0x07, 0x80, 	/* .....****....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0xe0, 	/* .......****..... */
	0x01, 0xe0, 	/* .......****..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0x80, 	/* .....****....... */
	0x07, 0x80, 	/* .....****....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0xe0, 	/* .......****..... */
	0x01, 0xe0, 	/* .......****..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x0f, 0x00, 	/* ....****........ */
	0x1f, 0x80, 	/* ...******....... */
	0x19, 0xc0, 	/* ...**..***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0e, 0x0c, 	/* ....***.....**.. */
	0x1f, 0x0c, 	/* ...*****....**.. */
	0x3b, 0x9c, 	/* ..***.***..***.. */
	0x31, 0xf8, 	/* ..**...******... */
	0x30, 0xf0, 	/* ..**....****.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0e, 0x0c, 	/* ....***.....**.. */
	0x1f, 0x0c, 	/* ...*****....**.. */
	0x3b, 0x9c, 	/* ..***.***..***.. */
	0x31, 0xf8, 	/* ..**...******... */
	0x30, 0xf0, 	/* ..**....****.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf0, 	/* ....********.... */
	0x1f, 0xf8, 	/* ...**********... */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x1f, 0xf8, 	/* ...**********... */
	0x0f, 0xf0, 	/* ....********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xf8, 	/* ...**********... */
	0x1f, 0xf8, 	/* ...**********... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0xf6, 	/* ....********.**. */
	0x1f, 0xfe, 	/* ...************. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x30, 0x3c, 	/* ..**......****.. */
	0x30, 0x7c, 	/* ..**.....*****.. */
	0x30, 0xec, 	/* ..**....***.**.. */
	0x31, 0xcc, 	/* ..**...***..**.. */
	0x33, 0x8c, 	/* ..**..***...**.. */
	0x37, 0x0c, 	/* ..**.***....**.. */
	0x3e, 0x0c, 	/* ..*****.....**.. */
	0x3c, 0x0c, 	/* ..****......**.. */
	0x38, 0x1c, 	/* ..***......***.. */
	0x7f, 0xf8, 	/* .************... */
	0x6f, 0xf0, 	/* .**.********.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x07, 0x00, 	/* .....***........ */
	0x03, 0x80, 	/* ......***....... */
	0x01, 0xc0, 	/* .......***...... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0xc0, 	/* ......****...... */
	0x07, 0xe0, 	/* .....******..... */
	0x0e, 0x70, 	/* ....***..***.... */
	0x1c, 0x38, 	/* ...***....***... */
	0x18, 0x18, 	/* ...**......**... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0xc0, 	/* .......***...... */
	0x03, 0x80, 	/* ......***....... */
	0x07, 0x00, 	/* .....***........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x1c, 	/* ...........***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x3f, 0xf0, 	/* ..**********.... */
	0x3f, 0xf8, 	/* ..***********... */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x1c, 	/* ..**.......***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x0c, 0x30, 	/* ....**....**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x30, 0x0c, 	/* ..**........**.. */
	0x38, 0x0c, 	/* ..***.......**.. */
	0x1f, 0xfc, 	/* ...***********.. */
	0x0f, 0xfc, 	/* ....**********.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x0c, 	/* ............**.. */
	0x00, 0x1c, 	/* ...........***.. */
	0x3f, 0xf8, 	/* ..***********... */
	0x3f, 0xf0, 	/* ..**********.... */
};
