/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.lang.reflect.Array;

public class MultiComparableArrayIterator<T extends Comparable<T>> {
    T[][] compArrays;
    T[] comps;
    int[] indices;
    boolean forward;

    public MultiComparableArrayIterator(T[][] arrays) {
        this((Comparable[][])arrays, true);
    }

    public MultiComparableArrayIterator(T[][] arrays, boolean forward) {
        this.compArrays = arrays;
        this.forward = forward;
        Class<?> arrayClass = this.compArrays.getClass().getComponentType().getComponentType();
        this.comps = (Comparable[])Array.newInstance(arrayClass, this.compArrays.length);
        this.indices = new int[this.compArrays.length];
        if (!forward) {
            for (int i = 0; i < this.compArrays.length; ++i) {
                this.indices[i] = this.compArrays[i].length - 1;
            }
        }
    }

    public boolean hasNext() {
        for (int i = 0; i < this.compArrays.length; ++i) {
            if (this.indices[i] < 0 || this.compArrays[i].length <= this.indices[i]) continue;
            return true;
        }
        return false;
    }

    public T[] next() {
        int i;
        Comparable[] nextComps = (Comparable[])Array.newInstance(this.comps.getClass().getComponentType(), this.comps.length);
        for (int i2 = 0; i2 < this.compArrays.length; ++i2) {
            if (this.comps[i2] != null || this.indices[i2] < 0 || this.indices[i2] >= this.compArrays[i2].length) continue;
            this.comps[i2] = this.compArrays[i2][this.indices[i2]];
        }
        Comparable compNext = null;
        boolean[] next = new boolean[this.comps.length];
        for (i = 0; i < this.comps.length; ++i) {
            if (this.comps[i] == null) continue;
            if (compNext == null) {
                compNext = (Comparable)this.comps[i];
                next[i] = true;
                continue;
            }
            int result = compNext.compareTo(this.comps[i]);
            if (result == 0) {
                next[i] = true;
                continue;
            }
            if ((!this.forward || result <= 0) && (this.forward || result >= 0)) continue;
            compNext = this.comps[i];
            for (int n = 0; n < i; ++n) {
                next[n] = false;
            }
            next[i] = true;
        }
        for (i = 0; i < this.comps.length; ++i) {
            if (!next[i]) continue;
            nextComps[i] = this.comps[i];
            this.comps[i] = null;
            if (this.forward) {
                int n = i;
                this.indices[n] = this.indices[n] + 1;
                continue;
            }
            int n = i;
            this.indices[n] = this.indices[n] - 1;
        }
        return nextComps;
    }
}

