/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis.gui;

import docking.widgets.DataToStringConverter;
import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.ListSelectionDialog;
import docking.widgets.textfield.IntegerTextField;
import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.ScriptInfo;
import ghidra.app.services.AnalyzerType;
import ghidra.framework.analysis.gui.AnalyzerUtil;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class GhidraScriptSelectionDialog
extends ListSelectionDialog<ResourceFile> {
    private ButtonGroup buttonGroup;
    private IntegerTextField priorityField;

    public GhidraScriptSelectionDialog() {
        super("Create Script Based Analyzer", "Script Name:", GhidraScriptUtil.getAllScripts(), (DataToStringConverter)new ScriptNameConverter(), (DataToStringConverter)new ScriptDescriptionConverter());
    }

    protected JComponent buildWorkPanel(String label, DropDownTextFieldDataModel<ResourceFile> model) {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.add(super.buildWorkPanel(label, model));
        panel.add(this.buildTypePanel());
        panel.add(this.buildPriorityPanel());
        return panel;
    }

    private Component buildPriorityPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 40, 20, 0));
        panel.add(new JLabel("Priority:  "));
        this.priorityField = new IntegerTextField(5, 0L);
        panel.add(this.priorityField.getComponent());
        return panel;
    }

    private JComponent createButtonComponent(AnalyzerType type) {
        JPanel panel = new JPanel((LayoutManager)new HorizontalLayout(1));
        Icon icon = AnalyzerUtil.getIcon(type);
        JRadioButton button = new JRadioButton();
        button.setActionCommand(type.name());
        button.setToolTipText(type.getDescription());
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        this.buttonGroup.add(button);
        panel.add((Component)button, "West");
        JLabel label = new JLabel(type.getName(), icon, 2);
        label.setToolTipText(type.getDescription());
        panel.add(label);
        return panel;
    }

    private JComponent buildTypePanel() {
        JPanel panel = new JPanel(new GridLayout(0, 2, 10, 10));
        panel.add(this.createButtonComponent(AnalyzerType.ONE_SHOT_ANALYZER));
        this.buttonGroup.setSelected(this.buttonGroup.getElements().nextElement().getModel(), true);
        panel.add(this.createButtonComponent(AnalyzerType.FUNCTION_ANALYZER));
        panel.add(this.createButtonComponent(AnalyzerType.BYTE_ANALYZER));
        panel.add(this.createButtonComponent(AnalyzerType.FUNCTION_MODIFIERS_ANALYZER));
        panel.add(this.createButtonComponent(AnalyzerType.INSTRUCTION_ANALYZER));
        panel.add(this.createButtonComponent(AnalyzerType.FUNCTION_SIGNATURES_ANALYZER));
        panel.add(this.createButtonComponent(AnalyzerType.DATA_ANALYZER));
        TitledBorder inner = BorderFactory.createTitledBorder("Analyzer Type");
        Border outer = BorderFactory.createEmptyBorder(0, 20, 20, 20);
        panel.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        return panel;
    }

    public AnalyzerType getAnalyzerType() {
        ButtonModel selection = this.buttonGroup.getSelection();
        String actionCommand = selection.getActionCommand();
        return AnalyzerType.valueOf(actionCommand);
    }

    public int getPriority() {
        return this.priorityField.getIntValue();
    }

    public ResourceFile getScriptFile() {
        return (ResourceFile)this.getSelectedItem();
    }

    private static class ScriptDescriptionConverter
    implements DataToStringConverter<ResourceFile> {
        private ScriptDescriptionConverter() {
        }

        public String getString(ResourceFile resourceFile) {
            ScriptInfo info = GhidraScriptUtil.getScriptInfo(resourceFile);
            return info.getDescription();
        }
    }

    private static class ScriptNameConverter
    implements DataToStringConverter<ResourceFile> {
        private ScriptNameConverter() {
        }

        public String getString(ResourceFile resourceFile) {
            return resourceFile.getName();
        }
    }
}

