/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis;

import ghidra.app.services.Analyzer;
import ghidra.framework.analysis.AnalysisManager;
import ghidra.framework.analysis.AnalysisPhase;
import ghidra.framework.analysis.AnalysisTask;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;

public class AnalyzerScheduler {
    private final AnalysisManager analysisManager;
    private final Analyzer analyzer;
    private int rank;
    private boolean enabled;
    private AddressSet addressSet = new AddressSet();
    private AnalysisPhase executionPhase;

    public AnalyzerScheduler(AnalysisManager analysisMgr, Analyzer analyzer, int rank) {
        this.analysisManager = analysisMgr;
        this.rank = rank;
        this.analyzer = analyzer;
    }

    synchronized void setPhase(AnalysisPhase phase) {
        this.executionPhase = phase.getExecutionPhase(this.analyzer);
        this.enabled = this.executionPhase != null;
    }

    synchronized void added(AddressSetView set) {
        if (!this.enabled) {
            return;
        }
        boolean alreadyScheduled = !this.addressSet.isEmpty();
        this.addressSet.add(set);
        if (!alreadyScheduled) {
            this.analysisManager.scheduleAnalysisTask(new AnalysisTask(this.executionPhase, this));
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public int getPriority() {
        return this.rank;
    }

    public AnalysisManager getAnalysisManager() {
        return this.analysisManager;
    }

    public synchronized AddressSetView getAddressSet() {
        AddressSet set = this.addressSet;
        this.addressSet = new AddressSet();
        return set;
    }
}

