/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.ContinuesFactory;
import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.MemoryBlockUtil;
import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.bin.format.pe.BaseRelocation;
import ghidra.app.util.bin.format.pe.BaseRelocationDataDirectory;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.DebugDataDirectory;
import ghidra.app.util.bin.format.pe.ExportDataDirectory;
import ghidra.app.util.bin.format.pe.ExportInfo;
import ghidra.app.util.bin.format.pe.FileHeader;
import ghidra.app.util.bin.format.pe.ImportDataDirectory;
import ghidra.app.util.bin.format.pe.ImportInfo;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionFlags;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbol;
import ghidra.app.util.bin.format.pe.debug.DebugDirectoryParser;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.app.util.demangler.DemanglerUtil;
import ghidra.app.util.importer.MemoryConflictHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MessageLogContinuesFactory;
import ghidra.app.util.opinion.AbstractPeDebugLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Conv;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PeLoader
extends AbstractPeDebugLoader {
    public static final String PE_NAME = "Portable Executable (PE)";
    public static final String HEADERS = "Headers";
    private static final long MIN_BYTE_LENGTH = 4L;
    public static final String PARSE_CLI_HEADERS_OPTION_NAME = "Parse CLI headers (if present)";
    static final boolean PARSE_CLI_HEADERS_OPTION_DEFAULT = true;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 4L) {
            return loadSpecs;
        }
        PortableExecutable pe = PortableExecutable.createPortableExecutable((GenericFactory)RethrowContinuesFactory.INSTANCE, provider, PortableExecutable.SectionLayout.FILE, false, false);
        NTHeader ntHeader = pe.getNTHeader();
        if (ntHeader != null && ntHeader.getOptionalHeader() != null) {
            long imageBase = ntHeader.getOptionalHeader().getImageBase();
            String machineName = ntHeader.getFileHeader().getMachineName();
            String compiler = CompilerOpinion.stripFamily(CompilerOpinion.getOpinion(pe, provider));
            for (QueryResult result : QueryOpinionService.query(this.getName(), machineName, compiler)) {
                loadSpecs.add(new LoadSpec((Loader)this, imageBase, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, imageBase, true));
            }
        }
        return loadSpecs;
    }

    @Override
    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, MemoryConflictHandler handler, TaskMonitor monitor, MessageLog log) throws IOException {
        if (monitor.isCancelled()) {
            return;
        }
        ContinuesFactory factory = MessageLogContinuesFactory.create((MessageLog)log);
        PortableExecutable pe = PortableExecutable.createPortableExecutable((GenericFactory)factory, provider, PortableExecutable.SectionLayout.FILE, false, this.shouldParseCliHeaders(options));
        NTHeader ntHeader = pe.getNTHeader();
        if (ntHeader == null) {
            return;
        }
        OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
        FileHeader fileHeader = ntHeader.getFileHeader();
        monitor.setMessage("Completing PE header parsing...");
        try {
            Map<Integer, Address> sectionNumberToAddress = this.processMemoryBlocks(pe, program, handler, monitor, log);
            monitor.setCancelEnabled(false);
            optionalHeader.processDataDirectories(monitor);
            monitor.setCancelEnabled(true);
            optionalHeader.validateDataDirectories(program);
            DataDirectory[] datadirs = optionalHeader.getDataDirectories();
            this.layoutHeaders(program, pe, ntHeader, datadirs);
            for (DataDirectory datadir : datadirs) {
                if (datadir == null || !datadir.hasParsedCorrectly() || !datadir.hasParsedCorrectly()) continue;
                datadir.markup(program, false, monitor, log, ntHeader);
            }
            this.processExports(optionalHeader, program, monitor, log);
            this.processImports(optionalHeader, program, monitor, log);
            this.processRelocations(optionalHeader, program, monitor, log);
            this.processDebug(optionalHeader, sectionNumberToAddress, program, monitor);
            this.processProperties(optionalHeader, program, monitor);
            this.processComments(program.getListing(), monitor);
            this.processSymbols(fileHeader, sectionNumberToAddress, program, monitor, log);
            this.processEntryPoints(ntHeader, program, monitor);
            String compiler = CompilerOpinion.getOpinion(pe, provider).toString();
            program.setCompiler(compiler);
        }
        catch (AddressOverflowException e) {
            throw new IOException(e);
        }
        catch (DuplicateNameException e) {
            throw new IOException(e);
        }
        catch (CodeUnitInsertionException e) {
            throw new IOException(e);
        }
        catch (DataTypeConflictException e) {
            throw new IOException(e);
        }
        catch (MemoryAccessException e) {
            throw new IOException(e);
        }
        monitor.setMessage(program.getName() + ": done!");
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        if (!loadIntoProgram) {
            list.add(new Option(PARSE_CLI_HEADERS_OPTION_NAME, true, Boolean.class, "-loader-parseCliHeaders"));
        }
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!name.equals(PARSE_CLI_HEADERS_OPTION_NAME) || Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
        }
        return super.validateOptions(provider, loadSpec, options);
    }

    @Override
    protected boolean isCaseInsensitiveLibraryFilenames() {
        return true;
    }

    private boolean shouldParseCliHeaders(List<Option> options) {
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(PARSE_CLI_HEADERS_OPTION_NAME)) continue;
                return (Boolean)option.getValue();
            }
        }
        return true;
    }

    private void layoutHeaders(Program program, PortableExecutable pe, NTHeader ntHeader, DataDirectory[] datadirs) {
        try {
            DataType dt = pe.getDOSHeader().toDataType();
            Address start = program.getImageBase();
            DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            dt = pe.getRichHeader().toDataType();
            if (dt != null) {
                start = program.getImageBase().add((long)pe.getRichHeader().getOffset());
                DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            dt = ntHeader.toDataType();
            start = program.getImageBase().add((long)pe.getDOSHeader().e_lfanew());
            DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            FileHeader fh = ntHeader.getFileHeader();
            SectionHeader[] sections = fh.getSectionHeaders();
            int index = fh.getPointerToSections();
            start = program.getImageBase().add((long)index);
            for (SectionHeader section : sections) {
                dt = section.toDataType();
                DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.setComment(0, start, section.getName());
                start = start.add((long)dt.getLength());
            }
        }
        catch (Exception e1) {
            Msg.error((Object)this, (Object)("Error laying down header structures " + e1));
        }
    }

    private void processSymbols(FileHeader fileHeader, Map<Integer, Address> sectionNumberToAddress, Program program, TaskMonitor monitor, MessageLog log) {
        List<DebugCOFFSymbol> symbols = fileHeader.getSymbols();
        int errorCount = 0;
        for (DebugCOFFSymbol symbol : symbols) {
            if (this.processDebugCoffSymbol(symbol, sectionNumberToAddress, program, monitor)) continue;
            ++errorCount;
        }
        if (errorCount != 0) {
            log.appendMsg("Failed to apply " + errorCount + " symbols contained within unknown sections.");
        }
    }

    private void processProperties(OptionalHeader optionalHeader, Program prog, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        Options props = prog.getOptions("Program Information");
        props.setInt("SectionAlignment", optionalHeader.getSectionAlignment());
        props.setBoolean("Relocatable", prog.getRelocationTable().getSize() > 0);
    }

    private void processRelocations(OptionalHeader optionalHeader, Program prog, TaskMonitor monitor, MessageLog log) {
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage(prog.getName() + ": processing relocation tables...");
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        if (dataDirectories.length <= 5) {
            return;
        }
        BaseRelocationDataDirectory brdd = (BaseRelocationDataDirectory)dataDirectories[5];
        if (brdd == null) {
            return;
        }
        AddressSpace space = prog.getAddressFactory().getDefaultAddressSpace();
        RelocationTable relocTable = prog.getRelocationTable();
        Memory memory = prog.getMemory();
        BaseRelocation[] relocs = brdd.getBaseRelocations();
        long originalImageBase = optionalHeader.getOriginalImageBase();
        AddressRangeImpl brddRange = new AddressRangeImpl(space.getAddress(originalImageBase + (long)brdd.getVirtualAddress()), space.getAddress(originalImageBase + (long)brdd.getVirtualAddress() + (long)brdd.getSize()));
        AddressRangeImpl headerRange = new AddressRangeImpl(space.getAddress(originalImageBase), space.getAddress(originalImageBase + optionalHeader.getSizeOfHeaders()));
        LittleEndianDataConverter conv = new LittleEndianDataConverter();
        for (BaseRelocation reloc : relocs) {
            if (monitor.isCancelled()) {
                return;
            }
            int baseAddr = reloc.getVirtualAddress();
            int count = reloc.getCount();
            for (int j = 0; j < count; ++j) {
                int type = reloc.getType(j);
                if (type == 0) continue;
                int offset = reloc.getOffset(j);
                long addr = Conv.intToLong((int)(baseAddr + offset)) + optionalHeader.getImageBase();
                Address relocAddr = space.getAddress(addr);
                try {
                    byte[] bytes = optionalHeader.is64bit() ? new byte[8] : new byte[4];
                    memory.getBytes(relocAddr, bytes);
                    if (optionalHeader.wasRebased()) {
                        byte[] newbytes;
                        long val = optionalHeader.is64bit() ? conv.getLong(bytes) : (long)conv.getInt(bytes) & 0xFFFFFFFFL;
                        val = val - (originalImageBase & 0xFFFFFFFFL) + optionalHeader.getImageBase();
                        byte[] byArray = newbytes = optionalHeader.is64bit() ? conv.getBytes(val) : conv.getBytes((int)val);
                        if (type == 3) {
                            memory.setBytes(relocAddr, newbytes);
                        } else if (type == 10) {
                            memory.setBytes(relocAddr, newbytes);
                        } else {
                            Msg.error((Object)this, (Object)("Non-standard relocation type " + type));
                        }
                    }
                    relocTable.add(relocAddr, type, null, bytes, null);
                }
                catch (MemoryAccessException e) {
                    log.appendMsg("Relocation does not exist in memory: " + relocAddr);
                }
                if (brddRange.contains(relocAddr)) {
                    Msg.error((Object)this, (Object)("Self-modifying relocation table at " + relocAddr));
                    return;
                }
                if (!headerRange.contains(relocAddr)) continue;
                Msg.error((Object)this, (Object)("Header modified at " + relocAddr));
                return;
            }
        }
    }

    private void processImports(OptionalHeader optionalHeader, Program program, TaskMonitor monitor, MessageLog log) {
        ImportInfo[] imports;
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage(program.getName() + ": processing imports...");
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        if (dataDirectories.length <= 1) {
            return;
        }
        ImportDataDirectory idd = (ImportDataDirectory)dataDirectories[1];
        if (idd == null) {
            return;
        }
        AddressFactory af = program.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        Listing listing = program.getListing();
        ReferenceManager refManager = program.getReferenceManager();
        for (ImportInfo importInfo : imports = idd.getImports()) {
            Address extAddr;
            if (monitor.isCancelled()) {
                return;
            }
            long addr = Conv.intToLong((int)importInfo.getAddress()) + optionalHeader.getImageBase();
            if (!optionalHeader.is64bit()) {
                addr &= 0xFFFFFFFFL;
            }
            Address address = space.getAddress(addr);
            this.setComment(1, address, importInfo.getComment());
            Data data = listing.getDefinedDataAt(address);
            if (data == null || !(data.getValue() instanceof Address) || (extAddr = (Address)data.getValue()) == null) continue;
            data.removeOperandReference(0, extAddr);
            try {
                refManager.addExternalReference(address, importInfo.getDLL().toUpperCase(), importInfo.getName(), extAddr, SourceType.IMPORTED, 0, RefType.DATA);
            }
            catch (DuplicateNameException e) {
                log.appendMsg("External location not created: " + e.getMessage());
            }
            catch (InvalidInputException e) {
                log.appendMsg("External location not created: " + e.getMessage());
            }
        }
    }

    private void markAsCode(Program program, Address address) {
        AddressSetPropertyMap codeProp = program.getAddressSetPropertyMap("CodeMap");
        if (codeProp == null) {
            try {
                codeProp = program.createAddressSetPropertyMap("CodeMap");
            }
            catch (DuplicateNameException e) {
                codeProp = program.getAddressSetPropertyMap("CodeMap");
            }
        }
        if (codeProp != null) {
            codeProp.add(address, address);
        }
    }

    private void processExports(OptionalHeader optionalHeader, Program program, TaskMonitor monitor, MessageLog log) {
        ExportInfo[] exports;
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage(program.getName() + ": processing exports...");
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        if (dataDirectories.length <= 0) {
            return;
        }
        ExportDataDirectory edd = (ExportDataDirectory)dataDirectories[0];
        if (edd == null) {
            return;
        }
        AddressFactory af = program.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        SymbolTable symTable = program.getSymbolTable();
        Memory memory = program.getMemory();
        Listing listing = program.getListing();
        ReferenceManager refManager = program.getReferenceManager();
        for (ExportInfo export : exports = edd.getExports()) {
            MemoryBlock block;
            if (monitor.isCancelled()) {
                return;
            }
            Address address = space.getAddress(export.getAddress());
            this.setComment(1, address, export.getComment());
            symTable.addExternalEntryPoint(address);
            String name = export.getName();
            try {
                symTable.createLabel(address, name, SourceType.IMPORTED);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            DemangledObject demangledObj = null;
            try {
                demangledObj = DemanglerUtil.demangle(program, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (demangledObj != null) {
                Object comment = demangledObj.getSignature(true);
                if (this.hasComment(3, address)) {
                    comment = "\n" + (String)comment;
                }
                this.setComment(3, address, (String)comment);
            }
            try {
                symTable.createLabel(address, "Ordinal_" + export.getOrdinal(), SourceType.IMPORTED);
            }
            catch (InvalidInputException comment) {
                // empty catch block
            }
            if (export.isForwarded()) {
                try {
                    Object obj;
                    listing.createData(address, (DataType)TerminatedStringDataType.dataType, -1);
                    Data data = listing.getDataAt(address);
                    if (data != null && (obj = data.getValue()) instanceof String) {
                        String str = (String)obj;
                        int dotpos = str.indexOf(46);
                        if (dotpos < 0) {
                            dotpos = 0;
                        }
                        String dllName = str.substring(0, dotpos) + ".dll";
                        String expName = str.substring(dotpos + 1);
                        try {
                            refManager.addExternalReference(address, dllName.toUpperCase(), expName, null, SourceType.IMPORTED, 0, RefType.DATA);
                        }
                        catch (DuplicateNameException e) {
                            log.appendMsg("External location not created: " + e.getMessage());
                        }
                        catch (InvalidInputException e) {
                            log.appendMsg("External location not created: " + e.getMessage());
                        }
                    }
                }
                catch (CodeUnitInsertionException data) {
                    // empty catch block
                }
            }
            if ((block = memory.getBlock(address)) == null || block.isExecute()) continue;
            try {
                if (demangledObj instanceof DemangledVariable) {
                    DataType dt;
                    DemangledVariable demangledVar = (DemangledVariable)demangledObj;
                    DemangledDataType ddt = demangledVar.getDataType();
                    DataType dataType = dt = ddt == null ? null : ddt.getDataType(program.getDataTypeManager());
                    if (dt != null && dt.getLength() > 0) {
                        listing.createData(address, dt);
                        continue;
                    }
                    listing.createData(address, (DataType)new Undefined1DataType());
                    continue;
                }
                listing.createData(address, StructConverter.POINTER, address.getPointerSize());
                Data data = listing.getDataAt(address);
                Address ptr = data.getAddress(0);
                if (ptr != null && memory.contains(ptr)) continue;
                listing.clearCodeUnits(data.getMinAddress(), data.getMaxAddress(), false);
                listing.createData(address, (DataType)new Undefined1DataType());
            }
            catch (DataTypeConflictException | CodeUnitInsertionException throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Address> processMemoryBlocks(PortableExecutable pe, Program prog, MemoryConflictHandler handler, TaskMonitor monitor, MessageLog log) throws AddressOverflowException, IOException {
        boolean x;
        boolean w;
        boolean r;
        Address address;
        long addr2;
        AddressFactory af = prog.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        HashMap<Integer, Address> sectionNumberToAddress = new HashMap<Integer, Address>();
        if (monitor.isCancelled()) {
            return sectionNumberToAddress;
        }
        monitor.setMessage(prog.getName() + ": processing memory blocks...");
        NTHeader ntHeader = pe.getNTHeader();
        FileHeader fileHeader = ntHeader.getFileHeader();
        OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
        MemoryBlockUtil mbu = new MemoryBlockUtil(prog, handler);
        SectionHeader[] sections = fileHeader.getSectionHeaders();
        if (sections.length == 0) {
            Msg.warn((Object)this, (Object)"No sections found");
        }
        try {
            int virtualSize = this.getVirtualSize(pe, sections, space);
            addr2 = optionalHeader.getImageBase();
            address = space.getAddress(addr2);
            r = true;
            w = false;
            x = false;
            try (InputStream dataStream = fileHeader.getDataStream();){
                mbu.createInitializedBlock(HEADERS, address, dataStream, virtualSize, "", "", r, w, x, monitor);
            }
        }
        finally {
            log.appendMsg(mbu.getMessages());
            mbu.dispose();
            mbu = null;
        }
        mbu = new MemoryBlockUtil(prog, handler);
        try {
            for (int i = 0; i < sections.length; ++i) {
                int dataSize;
                if (monitor.isCancelled()) {
                    HashMap<Integer, Address> addr2 = sectionNumberToAddress;
                    return addr2;
                }
                addr2 = (long)sections[i].getVirtualAddress() + optionalHeader.getImageBase();
                address = space.getAddress(addr2);
                r = (sections[i].getCharacteristics() & SectionFlags.IMAGE_SCN_MEM_READ.getMask()) != 0;
                w = (sections[i].getCharacteristics() & SectionFlags.IMAGE_SCN_MEM_WRITE.getMask()) != 0;
                x = (sections[i].getCharacteristics() & SectionFlags.IMAGE_SCN_MEM_EXECUTE.getMask()) != 0;
                int rawDataSize = sections[i].getSizeOfRawData();
                int virtualSize = sections[i].getVirtualSize();
                if (rawDataSize != 0) {
                    try (InputStream dataStream = sections[i].getDataStream();){
                        int dataSize2;
                        int n = dataSize2 = rawDataSize > virtualSize && virtualSize > 0 || rawDataSize < 0 ? virtualSize : rawDataSize;
                        if (ntHeader.checkRVA(dataSize2) || 0 < dataSize2 && (long)dataSize2 < pe.getFileLength()) {
                            if (!ntHeader.checkRVA(dataSize2)) {
                                Msg.warn((Object)this, (Object)("OptionalHeader.SizeOfImage < size of " + sections[i].getName() + " section"));
                            }
                            mbu.createInitializedBlock(sections[i].getReadableName(), address, dataStream, dataSize2, "", "", r, w, x, monitor);
                            sectionNumberToAddress.put(i + 1, address);
                        }
                    }
                    if (rawDataSize == virtualSize || rawDataSize > virtualSize) continue;
                    if (rawDataSize < 0) {
                        Msg.error((Object)this, (Object)("Section[" + i + "] has invalid size " + Integer.toHexString(rawDataSize) + " (" + Integer.toHexString(virtualSize) + ")"));
                        break;
                    }
                    virtualSize -= rawDataSize;
                    address = address.add((long)rawDataSize);
                }
                if (virtualSize == 0) {
                    Msg.error((Object)this, (Object)("Section[" + i + "] has size zero"));
                    continue;
                }
                int n = dataSize = virtualSize > 0 || rawDataSize < 0 ? virtualSize : 0;
                if (dataSize <= 0) continue;
                mbu.createUninitializedBlock(false, sections[i].getReadableName(), address, dataSize, "", "", r, w, x);
                sectionNumberToAddress.put(i + 1, address);
            }
        }
        catch (IllegalStateException ise) {
            if (optionalHeader.getFileAlignment() != optionalHeader.getSectionAlignment()) {
                throw new IllegalStateException(ise);
            }
            Msg.warn((Object)this, (Object)"Section header processing aborted");
        }
        finally {
            log.appendMsg(mbu.getMessages());
            mbu.dispose();
            mbu = null;
        }
        return sectionNumberToAddress;
    }

    private int getVirtualSize(PortableExecutable pe, SectionHeader[] sections, AddressSpace space) {
        DOSHeader dosHeader = pe.getDOSHeader();
        OptionalHeader optionalHeader = pe.getNTHeader().getOptionalHeader();
        int virtualSize = optionalHeader.is64bit() ? 240 : 224;
        virtualSize += 24;
        if (optionalHeader.getSizeOfHeaders() > (long)(virtualSize += dosHeader.e_lfanew())) {
            virtualSize = (int)optionalHeader.getSizeOfHeaders();
        }
        if (optionalHeader.getFileAlignment() == optionalHeader.getSectionAlignment() && optionalHeader.getFileAlignment() <= 2048) {
            Msg.warn((Object)this, (Object)"File and section alignments identical - possible driver or sectionless image");
        }
        return virtualSize;
    }

    private void processEntryPoints(NTHeader ntHeader, Program prog, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage(prog.getName() + ": processing entry points...");
        OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
        AddressFactory af = prog.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        SymbolTable symTable = prog.getSymbolTable();
        long entry = optionalHeader.getAddressOfEntryPoint();
        int ptr = ntHeader.rvaToPointer((int)entry);
        if (ptr < 0 && (entry != 0L || (ntHeader.getFileHeader().getCharacteristics() & 0x2000) == 0)) {
            Msg.warn((Object)this, (Object)("Virtual entry point at " + Long.toHexString(entry)));
        }
        Address baseAddr = space.getAddress(entry);
        long imageBase = optionalHeader.getImageBase();
        Address entryAddr = baseAddr.addWrap(imageBase);
        entry += optionalHeader.getImageBase();
        try {
            symTable.createLabel(entryAddr, "entry", SourceType.IMPORTED);
            this.markAsCode(prog, entryAddr);
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        symTable.addExternalEntryPoint(entryAddr);
    }

    private void processDebug(OptionalHeader optionalHeader, Map<Integer, Address> sectionNumberToAddress, Program program, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage(program.getName() + ": processing debug information...");
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        if (dataDirectories.length <= 6) {
            return;
        }
        DebugDataDirectory ddd = (DebugDataDirectory)dataDirectories[6];
        if (ddd == null) {
            return;
        }
        DebugDirectoryParser parser = ddd.getParser();
        if (parser == null) {
            return;
        }
        this.processDebug(parser, sectionNumberToAddress, program, monitor);
    }

    @Override
    public String getName() {
        return PE_NAME;
    }

    public static class CompilerOpinion {
        static final char[] errString_borland = "This program must be run under Win32\r\n$".toCharArray();
        static final char[] errString_GCC_VS = "This program cannot be run in DOS mode.\r\r\n$".toCharArray();
        static final int[] asm16_Borland = new int[]{186, 16, 0, 14, 31, 180, 9, 205, 33, 184, 1, 76, 205, 33, 144, 144};
        static final int[] asm16_GCC_VS = new int[]{14, 31, 186, 14, 0, 180, 9, 205, 33, 184, 1, 76, 205, 33};

        public static String stripFamily(CompilerEnum val) {
            if (val == CompilerEnum.BorlandCpp) {
                return "borlandcpp";
            }
            if (val == CompilerEnum.BorlandPascal) {
                return "borlanddelphi";
            }
            if (val == CompilerEnum.BorlandUnk) {
                return "borlandcpp";
            }
            String compilerid = val.toString();
            int colon = compilerid.indexOf(58);
            if (colon > 0) {
                return compilerid.substring(0, colon);
            }
            return compilerid;
        }

        private static SectionHeader getSectionHeader(String name, SectionHeader[] list) {
            for (SectionHeader element : list) {
                if (!element.getName().equals(name)) continue;
                return element;
            }
            return null;
        }

        private static boolean compareBytesToChars(byte[] bytearray, int bytestart, char[] chararray) {
            int i;
            if (bytestart + chararray.length < bytearray.length) {
                for (i = 0; i < chararray.length && chararray[i] == (char)bytearray[bytestart + i]; ++i) {
                }
            }
            return i == chararray.length;
        }

        public static CompilerEnum getOpinion(PortableExecutable pe, ByteProvider provider) throws IOException {
            int counter;
            CompilerEnum compilerType = CompilerEnum.Unknown;
            CompilerEnum offsetChoice = CompilerEnum.Unknown;
            CompilerEnum asmChoice = CompilerEnum.Unknown;
            CompilerEnum errStringChoice = CompilerEnum.Unknown;
            BinaryReader br = new BinaryReader(provider, true);
            DOSHeader dh = pe.getDOSHeader();
            if (pe.getNTHeader().getOptionalHeader().isCLI()) {
                return CompilerEnum.CLI;
            }
            if (dh.e_lfanew() == 128) {
                offsetChoice = CompilerEnum.GCC_VS;
            } else if (dh.e_lfanew() < 128) {
                offsetChoice = CompilerEnum.Unknown;
            } else {
                int val1 = br.readInt(128L);
                int val2 = br.readInt(132L);
                if (val1 != 0 && val2 != 0 && (val1 ^ val2) == 1399742788) {
                    compilerType = CompilerEnum.VisualStudio;
                    return compilerType;
                }
                if (dh.e_lfanew() == 256) {
                    offsetChoice = CompilerEnum.BorlandPascal;
                } else if (dh.e_lfanew() == 512) {
                    offsetChoice = CompilerEnum.BorlandCpp;
                } else {
                    if (dh.e_lfanew() > 768) {
                        compilerType = CompilerEnum.Unknown;
                        return compilerType;
                    }
                    offsetChoice = CompilerEnum.Unknown;
                }
            }
            byte[] asm = provider.readBytes(64L, 256L);
            for (counter = 0; counter < asm16_Borland.length && (asm[counter] & 0xFF) == (asm16_Borland[counter] & 0xFF); ++counter) {
            }
            if (counter == asm16_Borland.length) {
                asmChoice = CompilerEnum.BorlandUnk;
            } else {
                for (counter = 0; counter < asm16_GCC_VS.length && (asm[counter] & 0xFF) == (asm16_GCC_VS[counter] & 0xFF); ++counter) {
                }
                asmChoice = counter == asm16_GCC_VS.length ? CompilerEnum.GCC_VS : CompilerEnum.Unknown;
            }
            int errStringOffset = -1;
            for (int i = 10; i < asm.length - 3; ++i) {
                if (asm[i] != 84 || asm[i + 1] != 104 || asm[i + 2] != 105 || asm[i + 3] != 115) continue;
                errStringOffset = i;
            }
            if (errStringOffset == -1) {
                asmChoice = CompilerEnum.Unknown;
            } else if (CompilerOpinion.compareBytesToChars(asm, errStringOffset, errString_borland)) {
                errStringChoice = CompilerEnum.BorlandUnk;
                if (offsetChoice == CompilerEnum.BorlandCpp || offsetChoice == CompilerEnum.BorlandPascal) {
                    compilerType = offsetChoice;
                    return compilerType;
                }
            } else {
                errStringChoice = CompilerOpinion.compareBytesToChars(asm, errStringOffset, errString_GCC_VS) ? CompilerEnum.GCC_VS : CompilerEnum.Unknown;
            }
            if (errStringChoice == CompilerEnum.GCC_VS && asmChoice == CompilerEnum.GCC_VS && dh.e_lfanew() == 128) {
                int addrCode = br.readInt(dh.e_lfanew() + 40);
                if (addrCode != 4096) {
                    compilerType = CompilerEnum.VisualStudio;
                    return compilerType;
                }
                int ptrSymTable = br.readInt(dh.e_lfanew() + 12);
                if (ptrSymTable != 0) {
                    compilerType = CompilerEnum.GCC;
                    return compilerType;
                }
            } else if (errStringChoice == CompilerEnum.Unknown || asmChoice == CompilerEnum.Unknown) {
                compilerType = CompilerEnum.Unknown;
                return compilerType;
            }
            if (errStringChoice == CompilerEnum.BorlandUnk || asmChoice == CompilerEnum.BorlandUnk) {
                compilerType = CompilerEnum.BorlandUnk;
                return compilerType;
            }
            compilerType = offsetChoice == CompilerEnum.GCC_VS || errStringChoice == CompilerEnum.GCC_VS ? CompilerEnum.GCC_VS : CompilerEnum.Unknown;
            boolean probablyNotVS = false;
            SectionHeader[] headers = pe.getNTHeader().getFileHeader().getSectionHeaders();
            if (CompilerOpinion.getSectionHeader(".idata", headers) != null) {
                probablyNotVS = true;
            }
            if (CompilerOpinion.getSectionHeader("CODE", headers) != null) {
                compilerType = CompilerEnum.BorlandPascal;
                return compilerType;
            }
            SectionHeader segment = CompilerOpinion.getSectionHeader(".bss", headers);
            if (segment != null) {
                compilerType = CompilerEnum.GCC;
                return compilerType;
            }
            if (!probablyNotVS) {
                compilerType = CompilerEnum.VisualStudio;
                return compilerType;
            }
            if (CompilerOpinion.getSectionHeader(".tls", headers) != null) {
                compilerType = CompilerEnum.BorlandCpp;
            }
            return compilerType;
        }

        public static enum CompilerEnum {
            VisualStudio("visualstudio:unknown"),
            GCC("gcc:unknown"),
            GCC_VS("visualstudiogcc"),
            BorlandPascal("borland:pascal"),
            BorlandCpp("borland:c++"),
            BorlandUnk("borland:unknown"),
            CLI("cli"),
            Unknown("unknown");

            private String label;

            private CompilerEnum(String label) {
                this.label = label;
            }

            public String toString() {
                return this.label;
            }
        }
    }
}

