/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;

public class PointerDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    public PointerDataTypeHTMLRepresentation(Pointer pointer) {
        super(PointerDataTypeHTMLRepresentation.buildHTMLText(pointer));
    }

    private static String buildHTMLText(Pointer pointer) {
        StringBuffer buffer = new StringBuffer();
        String description = pointer.getDescription();
        if (description == null || description.length() == 0) {
            description = pointer.getDisplayName();
        }
        description = HTMLUtilities.friendlyEncodeHTML((String)description);
        buffer.append(description);
        char firstChar = buffer.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            buffer.replace(0, 1, Character.toString(Character.toUpperCase(firstChar)));
        }
        Pointer baseDataType = pointer;
        while (baseDataType instanceof Pointer) {
            baseDataType = baseDataType.getDataType();
        }
        if (baseDataType == null) {
            return buffer.toString();
        }
        buffer.append("<BR>").append("<BR>");
        buffer.append("Pointer Base Data Type: ").append("<BR>");
        if (baseDataType instanceof BuiltInDataType) {
            String simpleName = baseDataType.getClass().getSimpleName();
            buffer.append("<P STYLE='margin-left: 10px;'>");
            buffer.append(simpleName);
            PointerDataTypeHTMLRepresentation.addDataTypeLength((DataType)baseDataType, buffer);
            buffer.append("</P>");
        } else {
            buffer.append("<P STYLE='margin-left: 10px;'>");
            HTMLDataTypeRepresentation representation = ToolTipUtils.getHTMLRepresentation((DataType)baseDataType);
            String baseHTML = representation.getHTMLContentString();
            buffer.append(baseHTML);
            if (baseHTML.indexOf("Length: ") < 0) {
                PointerDataTypeHTMLRepresentation.addDataTypeLength((DataType)baseDataType, buffer);
            }
            buffer.append("</P>");
        }
        buffer.append("<BR>");
        int length = pointer.getLength();
        buffer.append("Size: ").append(length >= 0 ? Integer.valueOf(length) : "default");
        return buffer.toString();
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        throw new AssertException("Pointer types are not diffable at this time");
    }
}

