/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype;

import docking.DialogComponentProvider;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HelpLocation;
import ghidra.util.data.DataTypeParser;
import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DataTypeSelectionDialog
extends DialogComponentProvider {
    private DataTypeSelectionEditor editor;
    private PluginTool pluginTool;
    private DataType userChoice;
    private int maxSize = -1;
    private DataTypeManager dtm;
    private final DataTypeParser.AllowedDataTypes allowedTypes;

    public DataTypeSelectionDialog(PluginTool pluginTool, DataTypeManager dtm, int maxSize, DataTypeParser.AllowedDataTypes allowedTypes) {
        super("Data Type Chooser Dialog", true, true, true, false);
        this.pluginTool = pluginTool;
        this.dtm = dtm;
        this.maxSize = maxSize;
        this.allowedTypes = allowedTypes;
        this.init();
        this.setHelpLocation(new HelpLocation("DataTypeEditors", "DataTypeSelectionDialog"));
    }

    private void init() {
        this.buildEditor();
        this.addOKButton();
        this.addCancelButton();
    }

    private void buildEditor() {
        this.removeWorkPanel();
        this.editor = new DataTypeSelectionEditor((ServiceProvider)this.pluginTool, this.maxSize, this.allowedTypes);
        this.editor.setPreferredDataTypeManager(this.dtm);
        this.editor.setConsumeEnterKeyPress(false);
        this.editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                if (DataTypeSelectionDialog.this.isVisible()) {
                    DataTypeSelectionDialog.this.cancelCallback();
                }
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                if (DataTypeSelectionDialog.this.isVisible()) {
                    DataTypeSelectionDialog.this.okCallback();
                }
            }
        });
        this.editor.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DataTypeSelectionDialog.this.clearStatusText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DataTypeSelectionDialog.this.clearStatusText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DataTypeSelectionDialog.this.clearStatusText();
            }
        });
        JComponent mainPanel = this.createEditorPanel(this.editor);
        this.addWorkPanel(mainPanel);
        this.rootPanel.validate();
    }

    protected JComponent createEditorPanel(DataTypeSelectionEditor dtEditor) {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.editor.getEditorComponent(), "North");
        return mainPanel;
    }

    protected void dialogShown() {
        SwingUtilities.invokeLater(() -> this.editor.requestFocus());
    }

    protected void cancelCallback() {
        this.userChoice = null;
        super.cancelCallback();
    }

    protected void okCallback() {
        DataType dt;
        try {
            if (!this.editor.validateUserSelection()) {
                this.setStatusText("Unrecognized data type of \"" + this.editor.getCellEditorValueAsText() + "\" entered.");
                return;
            }
            dt = (DataType)this.editor.getCellEditorValue();
            int dtLen = dt.getLength();
            if (this.maxSize >= 0 && dtLen > this.maxSize) {
                this.setStatusText(dt.getDisplayName() + " doesn't fit within " + this.maxSize + " bytes, need " + dtLen + " bytes");
                return;
            }
        }
        catch (Exception e) {
            this.setStatusText(e.getMessage());
            return;
        }
        this.clearStatusText();
        this.userChoice = dt;
        this.close();
    }

    public void close() {
        this.buildEditor();
        this.setStatusText("");
        super.close();
    }

    public void setTabCommitsEdit(boolean doesCommit) {
        this.editor.setTabCommitsEdit(doesCommit);
    }

    public void setInitialDataType(DataType dataType) {
        this.editor.setCellEditorValue(dataType);
    }

    public void clearUserChosenDataType() {
        this.userChoice = null;
    }

    public DataType getUserChosenDataType() {
        return this.userChoice;
    }

    public DataTypeSelectionEditor getEditor() {
        return this.editor;
    }
}

