/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.ne.Segment;
import ghidra.util.Conv;
import java.io.IOException;

public class SegmentTable {
    private Segment[] segments;

    SegmentTable(FactoryBundledWithBinaryReader reader, short index, short segmentCount, short shiftAlignCount) throws IOException {
        long oldIndex = reader.getPointerIndex();
        reader.setPointerIndex(Conv.shortToInt((short)index));
        shiftAlignCount = (short)(1 << shiftAlignCount);
        int segmentCountInt = Conv.shortToInt((short)segmentCount);
        this.segments = new Segment[segmentCountInt];
        int startOffset = 0;
        for (int i = 0; i < segmentCountInt; ++i) {
            this.segments[i] = new Segment(reader, shiftAlignCount, startOffset >> 4);
            int size = this.segments[i].getMinAllocSize() & 0xFFFF;
            if (size == 0) {
                size = 65536;
            }
            startOffset = startOffset + size + 15 & 0xFFFFFFF0;
        }
        reader.setPointerIndex(oldIndex);
    }

    public Segment[] getSegments() {
        return this.segments;
    }
}

