/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ScatteredRelocationInfo
extends RelocationInfo {
    public static final int R_SCATTERED = Integer.MIN_VALUE;
    private int r_scattered;
    private int r_value;

    public static ScatteredRelocationInfo createScatteredRelocationInfo(FactoryBundledWithBinaryReader reader) throws IOException {
        ScatteredRelocationInfo scatteredRelocationInfo = (ScatteredRelocationInfo)reader.getFactory().create(ScatteredRelocationInfo.class, new Object[0]);
        scatteredRelocationInfo.initScatteredRelocationInfo(reader);
        return scatteredRelocationInfo;
    }

    private void initScatteredRelocationInfo(FactoryBundledWithBinaryReader reader) throws IOException {
        int mask = reader.readNextInt();
        this.r_scattered = (mask & Integer.MIN_VALUE) >> 31 & 1;
        this.r_pcrel = (mask & 0x40000000) >> 30;
        this.r_length = (mask & 0x30000000) >> 28;
        this.r_type = (mask & 0xF000000) >> 24;
        this.r_address = mask & 0xFFFFFF;
        this.r_value = reader.readNextInt();
    }

    public boolean isScattered() {
        return this.r_scattered == 1;
    }

    public int getValue() {
        return this.r_value;
    }

    @Override
    public long[] toValues() {
        return new long[]{this.r_scattered, this.r_pcrel, this.r_length, this.r_type, this.r_address, (long)this.r_value & 0xFFFFFFFFL};
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Scattered:    " + this.isScattered());
        buffer.append('\n');
        buffer.append("PC Relocated: " + this.isPcRelocated());
        buffer.append('\n');
        buffer.append("Length:       " + Integer.toHexString(this.r_length) + this.getLengthInBytes());
        buffer.append('\n');
        buffer.append("Type:         " + Integer.toHexString(this.r_type));
        buffer.append('\n');
        buffer.append("Address:      " + Long.toHexString(this.r_address));
        buffer.append('\n');
        buffer.append("Value:        " + Integer.toHexString(this.r_value));
        buffer.append('\n');
        return buffer.toString();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("scattered_relocation_info", 0);
        struct.add(DWORD, "r_mask", "{r_scattered,r_pcrel,r_length,r_type,r_address}");
        struct.add(DWORD, "r_value", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

