/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScriptUnsupportedClassVersionError;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import utilities.util.FileUtilities;

public class JavaScriptClassLoader
extends ClassLoader {
    private Map<File, Long> lastModifiedMap = new HashMap<File, Long>();

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException, GhidraScriptUnsupportedClassVersionError {
        ResourceFile sourceFile = this.getScriptSourceFile(name);
        ResourceFile classFile = this.getClassFile(sourceFile, name);
        if (classFile == null || !classFile.exists()) {
            return super.loadClass(name, resolve);
        }
        try {
            byte[] classBytes = FileUtilities.getBytesFromFile((ResourceFile)classFile);
            Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
            this.saveClassModifiedTime(classFile);
            return clazz;
        }
        catch (UnsupportedClassVersionError ucve) {
            throw new GhidraScriptUnsupportedClassVersionError(ucve, classFile);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException("Unable to load class bytes: " + name);
        }
    }

    private void saveClassModifiedTime(ResourceFile classFile) {
        File file = classFile.getFile(false);
        if (file != null) {
            this.lastModifiedMap.put(file, file.lastModified());
        }
    }

    public Long lastModified(File file) {
        return this.lastModifiedMap.get(file);
    }

    protected ResourceFile getClassFile(ResourceFile sourceFile, String rawName) {
        return GhidraScriptUtil.getClassFile(sourceFile, rawName);
    }

    private ResourceFile getScriptSourceFile(String name) {
        String path = name.replace('.', '/');
        int innerClassIndex = path.indexOf(36);
        if (innerClassIndex != -1) {
            path = path.substring(0, innerClassIndex);
        }
        String sourceFilePath = path + ".java";
        LinkedHashSet<ResourceFile> matchingFiles = new LinkedHashSet<ResourceFile>();
        List<ResourceFile> scriptSourceDirs = GhidraScriptUtil.getScriptSourceDirectories();
        for (ResourceFile sourceDir : scriptSourceDirs) {
            ResourceFile potentialFile = new ResourceFile(sourceDir, sourceFilePath);
            if (!potentialFile.exists()) continue;
            matchingFiles.add(potentialFile);
        }
        int matchCount = matchingFiles.size();
        if (matchCount == 1) {
            return (ResourceFile)matchingFiles.iterator().next();
        }
        if (matchCount > 1) {
            ResourceFile match = (ResourceFile)matchingFiles.iterator().next();
            Msg.warn((Object)this, (Object)("Found " + matchCount + " source files named " + name + ".  Using: " + match));
            return match;
        }
        return null;
    }
}

