/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.KeyBindingPrecedence;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import docking.widgets.tree.support.GTreeNodeTransferable;
import docking.widgets.tree.support.GTreeTransferHandler;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import resources.ResourceManager;

public class CutAction
extends SymbolTreeContextAction {
    private static final Icon CUT_ICON = ResourceManager.loadImage((String)"images/edit-cut22.png");
    private final SymbolTreeProvider provider;
    private ClipboardOwner clipboardOwner;

    public CutAction(SymbolTreePlugin plugin, SymbolTreeProvider provider) {
        super("Cut SymbolTree Node", plugin.getName());
        this.provider = provider;
        this.setEnabled(false);
        this.setPopupMenuData(new MenuData(new String[]{"Cut"}, CUT_ICON, "cut/paste"));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(88, 128);
        this.setKeyBindingData(new KeyBindingData(keyStroke, KeyBindingPrecedence.ActionMapLevel));
        this.clipboardOwner = new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard currentClipboard, Transferable transferable) {
                GTreeNodeTransferable gtTransferable = (GTreeNodeTransferable)transferable;
                List nodeList = gtTransferable.getAllData();
                CutAction.this.setNodesCut(nodeList, false);
            }
        };
    }

    @Override
    public boolean isEnabledForContext(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length == 0) {
            return false;
        }
        for (TreePath path : selectionPaths) {
            SymbolTreeNode node = (SymbolTreeNode)path.getLastPathComponent();
            if (node.canCut()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        this.clearClipboardFromPreviousCut();
        List<GTreeNode> transferableList = this.createList(selectionPaths);
        this.setClipboardContents(context.getSymbolTree(), this.provider.getClipboard(), transferableList);
        this.setNodesCut(transferableList, true);
        context.getSymbolTree().repaint();
    }

    private void clearClipboardFromPreviousCut() {
        Transferable transferable = this.provider.getClipboard().getContents((Object)this);
        if (transferable instanceof SymbolTreeNodeTransferable) {
            GTreeNodeTransferable gtTransferable = (GTreeNodeTransferable)transferable;
            List nodeList = gtTransferable.getAllData();
            this.setNodesCut(nodeList, false);
        }
    }

    private void setNodesCut(List<GTreeNode> nodeList, boolean isCut) {
        for (GTreeNode node : nodeList) {
            SymbolTreeNode cutNode = (SymbolTreeNode)node;
            cutNode.setNodeCut(isCut);
        }
    }

    private List<GTreeNode> createList(TreePath[] paths) {
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        if (paths != null) {
            for (TreePath element : paths) {
                GTreeNode node = (GTreeNode)element.getLastPathComponent();
                list.add(node);
            }
        }
        return list;
    }

    private void setClipboardContents(GTree gTree, Clipboard clipboard, List<GTreeNode> list) {
        GTreeDragNDropHandler dragNDropHandler = gTree.getDragNDropHandler();
        SymbolTreeNodeTransferable contents = new SymbolTreeNodeTransferable((GTreeTransferHandler)dragNDropHandler, list);
        clipboard.setContents((Transferable)((Object)contents), this.clipboardOwner);
    }

    class SymbolTreeNodeTransferable
    extends GTreeNodeTransferable {
        public SymbolTreeNodeTransferable(GTreeTransferHandler handler, List<GTreeNode> selectedData) {
            super(handler, selectedData);
        }
    }
}

