/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.dnd.DragGestureAdapter;
import docking.dnd.DragSrcAdapter;
import docking.dnd.Draggable;
import docking.dnd.GhidraTransferable;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.script.GhidraScriptComponentProvider;
import ghidra.util.table.GhidraTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.util.ArrayList;

public class DraggableScriptTable
extends GhidraTable
implements Draggable {
    private DragSrcAdapter dragSourceAdapter;
    private DragGestureAdapter dragGestureAdapter;
    private DragSource dragSource;
    private final GhidraScriptComponentProvider provider;

    public DraggableScriptTable(GhidraScriptComponentProvider provider) {
        super(provider.getTableModel());
        this.provider = provider;
        this.setHTMLRenderingEnabled(true);
        this.initDragNDrop();
    }

    private void initDragNDrop() {
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragGestureAdapter = new DragGestureAdapter((Draggable)this);
        this.dragSourceAdapter = new DragSrcAdapter((Draggable)this);
        this.dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 3, (DragGestureListener)this.dragGestureAdapter);
    }

    public boolean isStartDragOk(DragGestureEvent e) {
        return true;
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceAdapter;
    }

    public int getDragAction() {
        return 3;
    }

    public Transferable getTransferable(Point p) {
        int[] selectedRows;
        ArrayList<ResourceFile> arrayList = new ArrayList<ResourceFile>();
        for (int element : selectedRows = this.getSelectedRows()) {
            arrayList.add(this.provider.getScriptAt(element));
        }
        return new GhidraTransferable(arrayList);
    }

    public void move() {
    }

    public void dragCanceled(DragSourceDropEvent event) {
    }
}

