/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.scalartable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.help.HelpService;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableFilter;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.scalartable.RangeFilterTextField;
import ghidra.app.plugin.core.scalartable.ScalarRowObject;
import ghidra.app.plugin.core.scalartable.ScalarSearchContext;
import ghidra.app.plugin.core.scalartable.ScalarSearchDialog;
import ghidra.app.plugin.core.scalartable.ScalarSearchModel;
import ghidra.app.plugin.core.scalartable.ScalarSearchPlugin;
import ghidra.app.services.GoToService;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.DeleteTableRowAction;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import resources.ResourceManager;

public class ScalarSearchProvider
extends ComponentProviderAdapter
implements OptionsChangeListener {
    public static final ImageIcon ICON = ResourceManager.loadImage((String)"images/dataW.gif");
    private ScalarSearchPlugin plugin;
    private GhidraThreadedTablePanel<ScalarRowObject> threadedTablePanel;
    private GTableFilterPanel<ScalarRowObject> filter;
    private JComponent mainComponent;
    private JPanel mainPanel;
    private GhidraTable scalarTable;
    private ScalarSearchModel scalarModel;
    private DockingAction selectAction;
    private ProgramSelection currentSelection;
    private Program program;
    private String primarySubTitle;
    private RangeFilterTextField minField;
    private RangeFilterTextField maxField;

    ScalarSearchProvider(ScalarSearchPlugin plugin, ProgramSelection currentSelection) {
        super(plugin.getTool(), "Scalar Table", plugin.getName());
        this.currentSelection = currentSelection;
        this.program = plugin.getCurrentProgram();
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Scalar_Table"));
        this.mainComponent = this.createWorkPanel();
        this.setIcon(ICON);
        this.setTransient();
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        this.setWindowGroup("SCALAR_TABLE_SEARCH");
        this.tool.addComponentProvider((ComponentProvider)this, false);
        this.createActions();
    }

    public String getWindowSubMenuName() {
        return "Search";
    }

    void updateSearchRangeValues(ScalarSearchDialog dialog) {
        long minValue = dialog.getMinSearchValue();
        long maxValue = dialog.getMaxSearchValue();
        this.scalarModel.initialize(this.plugin.getCurrentProgram(), minValue, maxValue);
        String minValueText = dialog.getMinSearchValueText();
        String maxValueText = dialog.getMaxSearchValueText();
        this.updateTitle(minValueText, maxValueText);
    }

    private void updateTitle(String minValueText, String maxValueText) {
        StringBuilder buffy = new StringBuilder("Scalar Search");
        if (minValueText.equals(maxValueText)) {
            buffy.append(" [filter: ").append(minValueText).append(']');
        } else if (!this.isDefaultFilterRange(minValueText, maxValueText)) {
            buffy.append(" [filter: ").append(minValueText).append(" - ").append(maxValueText).append(']');
        }
        this.setTitle(buffy.toString());
        buffy = new StringBuilder();
        if (this.currentSelection != null) {
            buffy.append("in Selection: " + this.getSelectionAsString(this.currentSelection));
        }
        buffy.append(" (").append(this.plugin.getCurrentProgram().getName()).append(')');
        this.primarySubTitle = buffy.toString();
        this.setSubTitle(this.primarySubTitle);
    }

    private boolean isDefaultFilterRange(String min, String max) {
        int minValue = this.minField.getLimitValue();
        int maxValue = this.maxField.getLimitValue();
        return min.equals(Integer.toString(minValue)) && max.equals(Integer.toString(maxValue));
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.startsWith(this.selectAction.getName())) {
            KeyStroke keyStroke = (KeyStroke)newValue;
            this.selectAction.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    private void selectDataInProgramFromTable(ProgramSelection selection) {
        ProgramSelectionPluginEvent pspe = new ProgramSelectionPluginEvent("Selection", selection, this.plugin.getCurrentProgram());
        this.plugin.firePluginEvent(pspe);
    }

    public void componentShown() {
        this.scalarModel.reload();
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ScalarSearchContext(this, this.scalarTable);
    }

    public JComponent getComponent() {
        return this.mainComponent;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.plugin.getName());
    }

    public Program getProgram() {
        return this.program;
    }

    public ScalarSearchModel getScalarModel() {
        return this.scalarModel;
    }

    void programClosed(Program p) {
        if (p == this.program) {
            this.closeComponent();
        }
    }

    void dispose() {
        this.closeComponent();
        this.threadedTablePanel.dispose();
        this.filter.dispose();
        this.scalarTable.dispose();
    }

    ProgramSelection getSelection() {
        return this.scalarTable.getProgramSelection();
    }

    void reload() {
        if (this.isVisible()) {
            this.scalarModel.reload();
        }
    }

    GhidraTable getTable() {
        return this.scalarTable;
    }

    private JComponent createWorkPanel() {
        this.scalarModel = new ScalarSearchModel(this.plugin, this.currentSelection);
        this.threadedTablePanel = new GhidraThreadedTablePanel<ScalarRowObject>(this.scalarModel, 1000);
        this.scalarTable = this.threadedTablePanel.getTable();
        this.filter = new GTableFilterPanel((JTable)((Object)this.scalarTable), (RowObjectTableModel)this.scalarModel);
        this.scalarTable.setName("ScalarTable");
        this.scalarTable.setAutoLookupColumn(1);
        this.scalarTable.setAutoResizeMode(2);
        this.scalarTable.setPreferredScrollableViewportSize(new Dimension(400, 400));
        this.scalarTable.setRowSelectionAllowed(true);
        this.scalarTable.setSelectionMode(2);
        this.scalarTable.getSelectionModel().addListSelectionListener(e -> this.notifyContextChanged());
        this.filter.setSecondaryFilter((TableFilter)new ScalarTableSecondaryFilter());
        this.scalarModel.addTableModelListener(e -> this.setSubTitle(this.primarySubTitle + " " + this.scalarModel.getRowCount() + " items"));
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        this.scalarTable.installNavigation(goToService, goToService.getDefaultNavigatable());
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)((Object)this.threadedTablePanel), "Center");
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.add((Component)this.filter, "North");
        filterPanel.add((Component)new RangeFilterPanel(), "South");
        this.mainPanel.add((Component)filterPanel, "South");
        return this.mainPanel;
    }

    GTableFilterPanel<ScalarRowObject> getFilterPanel() {
        return this.filter;
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    private String getSelectionAsString(ProgramSelection selection) {
        Address min = selection.getMinAddress();
        Address max = selection.getMaxAddress();
        long n = selection.getNumAddresses();
        return "[" + min + ", " + max + "; " + n + " addresses]";
    }

    private void createActions() {
        this.selectAction = new DockingAction("Make Selection", this.getName(), false){

            public void actionPerformed(ActionContext context) {
                ScalarSearchProvider.this.selectDataInProgramFromTable(ScalarSearchProvider.this.getSelection());
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ScalarSearchContext)) {
                    return false;
                }
                ScalarSearchContext scalarWindowContext = (ScalarSearchContext)context;
                GhidraTable table = scalarWindowContext.getScalarTable();
                return table.getSelectedRows().length > 0;
            }
        };
        this.selectAction.setEnabled(false);
        ImageIcon icon = ResourceManager.loadImage((String)"images/text_align_justify.png");
        this.selectAction.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, (Icon)icon));
        this.selectAction.setDescription("Selects currently selected scalar(s) in table");
        this.selectAction.setToolBarData(new ToolBarData((Icon)icon));
        this.selectAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Make_Selection"));
        this.installDummyAction(this.selectAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.selectAction);
        SelectionNavigationAction selectionAction = new SelectionNavigationAction(this.plugin, this.getTable());
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)selectionAction);
        GhidraTable table = this.threadedTablePanel.getTable();
        DeleteTableRowAction removeItemsAction = new DeleteTableRowAction(this.tool, table, this.plugin.getName());
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)removeItemsAction);
    }

    private void installDummyAction(DockingAction action) {
        DummyKeyBindingsOptionsAction dummyAction = new DummyKeyBindingsOptionsAction(action.getName(), null);
        this.tool.addAction((DockingActionIf)dummyAction);
        ToolOptions options = this.tool.getOptions("Key Bindings");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        KeyStroke keyStroke = options.getKeyStroke(dummyAction.getFullName(), null);
        if (keyStroke != null) {
            action.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    private class ScalarTableSecondaryFilter
    implements TableFilter<ScalarRowObject> {
        private ScalarTableSecondaryFilter() {
        }

        public boolean acceptsRow(ScalarRowObject rowObject) {
            Scalar scalar = rowObject.getScalar();
            if (scalar == null) {
                return false;
            }
            long value = scalar.getSignedValue();
            if (value < ScalarSearchProvider.this.minField.getFilterValue()) {
                return false;
            }
            return value <= ScalarSearchProvider.this.maxField.getFilterValue();
        }

        public boolean isSubFilterOf(TableFilter<?> tableFilter) {
            if (!(tableFilter instanceof ScalarTableSecondaryFilter)) {
                return false;
            }
            return false;
        }
    }

    private class RangeFilterPanel
    extends JPanel {
        RangeFilterPanel() {
            Border lowerBorder = BorderFactory.createLoweredBevelBorder();
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(lowerBorder);
            this.add(Box.createHorizontalStrut(4));
            this.add(new JLabel("Min:"));
            this.add(Box.createHorizontalStrut(19));
            ScalarSearchProvider.this.minField = this.createFilterWidget(RangeFilterTextField.FilterType.MIN);
            this.add(ScalarSearchProvider.this.minField.getComponent());
            this.add(Box.createHorizontalStrut(10));
            this.add(new JLabel("Max:"));
            this.add(Box.createHorizontalStrut(5));
            ScalarSearchProvider.this.maxField = this.createFilterWidget(RangeFilterTextField.FilterType.MAX);
            this.add(ScalarSearchProvider.this.maxField.getComponent());
            HelpService help = DockingWindowManager.getHelpService();
            help.registerHelp((Object)this, new HelpLocation(ScalarSearchProvider.this.plugin.getName(), "Filter_Scalars"));
        }

        private RangeFilterTextField createFilterWidget(RangeFilterTextField.FilterType filterType) {
            RangeFilterTextField rangefilter = new RangeFilterTextField(filterType, ScalarSearchProvider.this.program);
            rangefilter.addChangeListener(e -> ScalarSearchProvider.this.scalarModel.reFilter());
            return rangefilter;
        }
    }
}

