/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.reloc.RelocationProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.SelectionNavigationAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays relocation information", description="This plugin provides a component for displaying the reloction table. The table can be used to navigate in the code browser.", servicesRequired={GoToService.class}, eventsProduced={ProgramLocationPluginEvent.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class RelocationTablePlugin
extends Plugin
implements DomainObjectListener {
    private Program currentProgram;
    private GoToService goToService;
    private RelocationProvider provider;

    public RelocationTablePlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
        this.provider = new RelocationProvider(this);
        this.createActions();
    }

    private void createActions() {
        DockingAction programSelectionAction = new DockingAction("Make Selection", this.getName(), false){

            public void actionPerformed(ActionContext context) {
                RelocationTablePlugin.this.makeSelection();
            }
        };
        programSelectionAction.setDescription("Make a selection using selected rows");
        ImageIcon icon = ResourceManager.loadImage((String)"images/text_align_justify.png");
        programSelectionAction.setToolBarData(new ToolBarData((Icon)icon));
        programSelectionAction.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, (Icon)icon));
        programSelectionAction.setHelpLocation(new HelpLocation("Search", "Make_Selection"));
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)programSelectionAction);
        SelectionNavigationAction navigationAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)navigationAction);
    }

    private void makeSelection() {
        ProgramSelection selection = this.provider.getTable().getProgramSelection();
        ProgramSelectionPluginEvent event = new ProgramSelectionPluginEvent(this.getName(), selection, this.currentProgram);
        this.firePluginEvent(event);
    }

    public void dispose() {
        super.dispose();
        this.provider.dispose();
        this.currentProgram = null;
        this.goToService = null;
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program oldProg = this.currentProgram;
            Program newProg = ev.getActiveProgram();
            if (oldProg != null) {
                this.programClosed();
            }
            if (newProg != null) {
                this.programOpened(newProg);
            }
        }
    }

    private void programOpened(Program p) {
        p.addListener((DomainObjectListener)this);
        this.currentProgram = p;
        this.provider.setProgram(p);
    }

    private void programClosed() {
        this.currentProgram.removeListener((DomainObjectListener)this);
        this.currentProgram = null;
        this.provider.setProgram(null);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(27) || ev.containsEvent(4)) {
            this.provider.setProgram(this.currentProgram);
        }
    }
}

