/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.references.EditExternalReferencePanel;
import ghidra.app.plugin.core.references.EditMemoryReferencePanel;
import ghidra.app.plugin.core.references.EditReferencePanel;
import ghidra.app.plugin.core.references.EditRegisterReferencePanel;
import ghidra.app.plugin.core.references.EditStackReferencePanel;
import ghidra.app.plugin.core.references.InstructionPanel;
import ghidra.app.plugin.core.references.InstructionPanelListener;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;

public class EditReferenceDialog
extends DialogComponentProvider {
    static final int PREFERRED_PANEL_HEIGHT = 190;
    static final int PREFERRED_PANEL_WIDTH = 450;
    private static final HelpLocation ADD_HELP = new HelpLocation("ReferencesPlugin", "addRef");
    private static final HelpLocation EDIT_HELP = new HelpLocation("ReferencesPlugin", "editRef");
    private ReferencesPlugin plugin;
    private InstructionPanel instrPanel;
    private JRadioButton memRefChoice;
    private JRadioButton extRefChoice;
    private JRadioButton stackRefChoice;
    private JRadioButton regRefChoice;
    private JPanel bottomPanel;
    private CardLayout bottomPanelLayout;
    private EditMemoryReferencePanel memRefPanel;
    private EditExternalReferencePanel extRefPanel;
    private EditStackReferencePanel stackRefPanel;
    private EditRegisterReferencePanel regRefPanel;
    private EditReferencePanel activeRefPanel;
    private boolean initializing;

    public EditReferenceDialog(ReferencesPlugin plugin) {
        super("Edit Reference", true);
        this.plugin = plugin;
        this.addWorkPanel(this.buildMainPanel());
        this.addApplyButton();
        this.addCancelButton();
        this.setDefaultButton(this.applyButton);
    }

    public void dispose() {
        this.close();
        this.cleanup();
    }

    CodeUnit getCurrentCodeUnit() {
        return this.instrPanel.getCurrentCodeUnit();
    }

    private void cleanup() {
        this.memRefPanel.cleanup();
        this.extRefPanel.cleanup();
        this.stackRefPanel.cleanup();
        this.regRefPanel.cleanup();
    }

    private JComponent buildMainPanel() {
        JPanel topPanel = new JPanel(new BorderLayout());
        this.instrPanel = new InstructionPanel(5, 5, 5, 5, null, this.plugin, new InstructionPanelListener(){

            @Override
            public boolean dropSupported() {
                return false;
            }

            @Override
            public void operandSelected(int opIndex, int subIndex) {
                if (!EditReferenceDialog.this.initializing) {
                    EditReferenceDialog.this.setAddOpIndex(opIndex, subIndex);
                }
            }

            @Override
            public void selectionDropped(AddressSetView set, CodeUnit cu, int opIndex) {
                throw new UnsupportedOperationException();
            }
        });
        topPanel.add((Component)this.instrPanel, "North");
        JPanel refTypePanel = new JPanel(new FlowLayout(0, 5, 5));
        refTypePanel.setBorder(new TitledBorder(new EtchedBorder(), "Type of Reference"));
        ChangeListener refChoiceListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JRadioButton refChoiceButton;
                Object src = e.getSource();
                if (src instanceof JRadioButton && (refChoiceButton = (JRadioButton)src).isSelected()) {
                    EditReferenceDialog.this.refChoiceActivated(refChoiceButton);
                }
            }
        };
        this.memRefChoice = new JRadioButton("Memory");
        this.memRefChoice.addChangeListener(refChoiceListener);
        this.extRefChoice = new JRadioButton("External");
        this.extRefChoice.addChangeListener(refChoiceListener);
        this.stackRefChoice = new JRadioButton("Stack");
        this.stackRefChoice.addChangeListener(refChoiceListener);
        this.regRefChoice = new JRadioButton("Register");
        this.regRefChoice.addChangeListener(refChoiceListener);
        ButtonGroup refChoices = new ButtonGroup();
        refChoices.add(this.memRefChoice);
        refChoices.add(this.extRefChoice);
        refChoices.add(this.stackRefChoice);
        refChoices.add(this.regRefChoice);
        refTypePanel.add(this.memRefChoice);
        refTypePanel.add(this.extRefChoice);
        refTypePanel.add(this.stackRefChoice);
        refTypePanel.add(this.regRefChoice);
        topPanel.add((Component)refTypePanel, "Center");
        EmptyBorder panelBorder = new EmptyBorder(5, 10, 5, 10);
        this.memRefPanel = new EditMemoryReferencePanel(this.plugin);
        this.memRefPanel.setBorder(panelBorder);
        this.extRefPanel = new EditExternalReferencePanel(this.plugin);
        this.extRefPanel.setBorder(panelBorder);
        this.stackRefPanel = new EditStackReferencePanel(this.plugin);
        this.stackRefPanel.setBorder(panelBorder);
        this.regRefPanel = new EditRegisterReferencePanel(this.plugin);
        this.regRefPanel.setBorder(panelBorder);
        this.bottomPanelLayout = new CardLayout();
        this.bottomPanel = new JPanel(this.bottomPanelLayout);
        this.bottomPanel.setFocusCycleRoot(true);
        this.bottomPanel.setPreferredSize(new Dimension(450, 190));
        this.bottomPanel.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.bottomPanel.add((Component)this.memRefPanel, this.memRefPanel.getName());
        this.bottomPanel.add((Component)this.extRefPanel, this.extRefPanel.getName());
        this.bottomPanel.add((Component)this.stackRefPanel, this.stackRefPanel.getName());
        this.bottomPanel.add((Component)this.regRefPanel, this.regRefPanel.getName());
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.add((Component)topPanel, "North");
        workPanel.add((Component)this.bottomPanel, "Center");
        return workPanel;
    }

    private void setAddOpIndex(int opIndex, int subIndex) {
        Address existingRefAddr;
        CodeUnit cu = this.instrPanel.getCurrentCodeUnit();
        Program p = cu.getProgram();
        boolean inFunction = p.getFunctionManager().getFunctionContaining(cu.getMinAddress()) != null;
        Reference[] refs = p.getReferenceManager().getReferencesFrom(cu.getMinAddress(), opIndex);
        Address address = existingRefAddr = refs.length != 0 ? refs[0].getToAddress() : null;
        if (!this.memRefPanel.initialize(cu, opIndex, subIndex)) {
            throw new AssertException("Memory reference must always be permitted");
        }
        this.memRefChoice.setEnabled(true);
        this.extRefChoice.setEnabled(this.extRefPanel.initialize(cu, opIndex, subIndex));
        this.stackRefChoice.setEnabled(inFunction && this.stackRefPanel.initialize(cu, opIndex, subIndex));
        this.regRefChoice.setEnabled(inFunction && this.regRefPanel.initialize(cu, opIndex, subIndex));
        this.memRefChoice.setSelected(true);
        if (existingRefAddr != null) {
            if (existingRefAddr.isStackAddress()) {
                if (this.stackRefChoice.isEnabled()) {
                    this.stackRefChoice.setSelected(true);
                }
            } else if (existingRefAddr.isRegisterAddress()) {
                if (this.regRefChoice.isEnabled()) {
                    this.regRefChoice.setSelected(true);
                }
            } else if (existingRefAddr.isExternalAddress() && this.extRefChoice.isEnabled()) {
                this.extRefChoice.setSelected(true);
            }
        } else if (this.stackRefChoice.isEnabled() && this.stackRefPanel.isValidStackRef()) {
            this.stackRefChoice.setSelected(true);
        } else if (this.regRefChoice.isEnabled()) {
            this.regRefChoice.setSelected(true);
        }
    }

    private void refChoiceActivated(JRadioButton refChoiceButton) {
        if (refChoiceButton == this.memRefChoice) {
            this.activeRefPanel = this.memRefPanel;
        } else if (refChoiceButton == this.stackRefChoice) {
            this.activeRefPanel = this.stackRefPanel;
        } else if (refChoiceButton == this.regRefChoice) {
            this.activeRefPanel = this.regRefPanel;
        } else if (refChoiceButton == this.extRefChoice) {
            this.activeRefPanel = this.extRefPanel;
        }
        this.bottomPanelLayout.show(this.bottomPanel, this.activeRefPanel.getName());
        this.activeRefPanel.requestFocus();
    }

    public void initDialog(CodeUnit cu, int opIndex, int subIndex, Reference ref) {
        this.initializing = true;
        this.instrPanel.setCodeUnitLocation(cu, opIndex, subIndex, ref != null);
        if (ref != null) {
            this.configureEditReference(cu, ref);
        } else {
            this.configureAddReference(opIndex, subIndex);
        }
        this.initializing = false;
        this.activeRefPanel.requestFocus();
    }

    private void configureAddReference(int opIndex, int subIndex) {
        this.setTitle("Add Reference");
        this.setHelpLocation(ADD_HELP);
        this.applyButton.setText("Add");
        this.setAddOpIndex(opIndex, subIndex);
    }

    private void configureEditReference(CodeUnit cu, Reference ref) {
        this.setTitle("Edit Reference");
        this.setHelpLocation(EDIT_HELP);
        this.applyButton.setText("Update");
        this.memRefChoice.setEnabled(false);
        this.extRefChoice.setEnabled(false);
        this.stackRefChoice.setEnabled(false);
        this.regRefChoice.setEnabled(false);
        Address toAddress = ref.getToAddress();
        if (toAddress.isRegisterAddress() || cu.getProgram().getRegister(toAddress) != null) {
            this.regRefPanel.initialize(cu, ref);
            this.regRefChoice.setSelected(true);
            this.regRefChoice.setEnabled(true);
            if (toAddress.isMemoryAddress()) {
                this.memRefPanel.initialize(cu, ref);
                this.memRefChoice.setEnabled(true);
            }
        } else if (toAddress.isStackAddress()) {
            this.stackRefPanel.initialize(cu, ref);
            this.stackRefChoice.setSelected(true);
            this.stackRefChoice.setEnabled(true);
        } else if (toAddress.isMemoryAddress()) {
            this.memRefPanel.initialize(cu, ref);
            this.memRefChoice.setSelected(true);
            this.memRefChoice.setEnabled(true);
        } else if (toAddress.isExternalAddress()) {
            this.extRefPanel.initialize(cu, ref);
            this.extRefChoice.setSelected(true);
            this.extRefChoice.setEnabled(true);
        } else {
            throw new AssertException("Unknown address type");
        }
    }

    protected void applyCallback() {
        if (this.activeRefPanel.applyReference()) {
            this.close();
            this.cleanup();
        }
    }

    protected void cancelCallback() {
        this.close();
        this.cleanup();
    }

    void readDataState(SaveState saveState) {
        Element element = saveState.getXmlElement("MemoryReferencePanelState");
        if (element != null) {
            this.memRefPanel.readXmlDataState(element);
        }
    }

    void writeDataState(SaveState saveState) {
        Element element = new Element("MemoryReferencePanelState");
        this.memRefPanel.writeXmlDataState(element);
        saveState.putXmlElement("MemoryReferencePanelState", element);
    }
}

