/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.processors;

import docking.DialogComponentProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.LcsSelectionListener;
import ghidra.plugin.importer.NewLanguagePanel;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.HelpLocation;
import javax.swing.BorderFactory;

public class SetLanguageDialog
extends DialogComponentProvider {
    private NewLanguagePanel selectLangPanel;
    private LanguageService langService;
    private PluginTool tool;
    private Program currProgram;
    private LanguageID dialogLanguageDescID;
    private CompilerSpecID dialogCompilerSpecDescID;
    LcsSelectionListener listener = e -> {
        LanguageID langID = null;
        CompilerSpecID compilerSpecID = null;
        if (e.selection != null) {
            langID = e.selection.languageID;
            compilerSpecID = e.selection.compilerSpecID;
        }
        if (langID != null && langID.equals((Object)this.currProgram.getLanguageID())) {
            if (compilerSpecID != null && compilerSpecID.equals((Object)this.currProgram.getCompilerSpec().getCompilerSpecID())) {
                this.setStatusText("Please select a different Language or Compiler Spec.");
                this.setOkEnabled(false);
            } else {
                this.setStatusText(null);
                this.setOkEnabled(true);
            }
            return;
        }
        this.setStatusText(null);
        this.setOkEnabled(langID != null);
    };

    public SetLanguageDialog(PluginTool tool, Program program) {
        super(SetLanguageDialog.getTitle(program), true, true, true, false);
        this.currProgram = program;
        this.tool = tool;
        this.langService = DefaultLanguageService.getLanguageService();
        this.selectLangPanel = new NewLanguagePanel();
        LanguageCompilerSpecPair lcsPair = new LanguageCompilerSpecPair(this.currProgram.getLanguageID(), this.currProgram.getCompilerSpec().getCompilerSpecID());
        this.selectLangPanel.setSelectedLcsPair(lcsPair);
        this.selectLangPanel.addSelectionListener(this.listener);
        this.selectLangPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addWorkPanel(this.selectLangPanel);
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(false);
        this.setHelpLocation(new HelpLocation("LanguageProviderPlugin", "set language"));
        this.selectLangPanel.setShowRecommendedCheckbox(false);
    }

    private static String getTitle(Program program) {
        return "Set Language: " + program.getDomainFile().getName();
    }

    LanguageID getLanguageDescriptionID() {
        this.tool.showDialog((DialogComponentProvider)this);
        return this.dialogLanguageDescID;
    }

    CompilerSpecID getCompilerSpecDescriptionID() {
        return this.dialogCompilerSpecDescID;
    }

    void dispose() {
        this.close();
    }

    protected void okCallback() {
        LanguageCompilerSpecPair selectedLcsPair = this.selectLangPanel.getSelectedLcsPair();
        if (selectedLcsPair == null) {
            this.dialogLanguageDescID = null;
            this.dialogCompilerSpecDescID = null;
        } else {
            this.dialogLanguageDescID = selectedLcsPair.languageID;
            this.dialogCompilerSpecDescID = selectedLcsPair.compilerSpecID;
        }
        this.close();
    }
}

