/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import ghidra.app.cmd.memory.AddMemoryBlockCmd;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.NamingUtilities;
import ghidra.util.datastruct.StringKeyIndexer;
import javax.swing.event.ChangeListener;

class AddBlockModel {
    private PluginTool tool;
    private Program program;
    private StringKeyIndexer nameIndexer;
    private String blockName;
    private Address startAddr;
    private Address baseAddr;
    private int length;
    private MemoryBlockType blockType;
    private int initialValue;
    private String message;
    private ChangeListener listener;
    private boolean isValid;
    private boolean readEnabled;
    private boolean writeEnabled;
    private boolean executeEnabled;
    private boolean volatileEnabled;
    private boolean isInitialized;

    AddBlockModel(PluginTool tool, Program program) {
        this.tool = tool;
        this.program = program;
        this.nameIndexer = new StringKeyIndexer();
        this.loadBlockNames();
        this.startAddr = program.getImageBase();
        this.blockType = MemoryBlockType.DEFAULT;
        this.initialValue = 0;
        this.readEnabled = true;
        this.writeEnabled = true;
        this.executeEnabled = true;
        this.volatileEnabled = true;
    }

    void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    void setBlockName(String name) {
        this.blockName = name;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setStartAddress(Address addr) {
        this.startAddr = addr;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setLength(int length) {
        this.length = length;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setBlockType(MemoryBlockType blockType) {
        this.blockType = blockType;
        this.readEnabled = true;
        this.writeEnabled = true;
        this.executeEnabled = true;
        this.volatileEnabled = true;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    void setIsInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    void setBaseAddress(Address baseAddr) {
        this.baseAddr = baseAddr;
        this.validateInfo();
        this.listener.stateChanged(null);
    }

    Address getStartAddress() {
        return this.startAddr;
    }

    MemoryBlockType getBlockType() {
        return this.blockType;
    }

    int getInitialValue() {
        return this.initialValue;
    }

    boolean isValidInfo() {
        return this.isValid;
    }

    String getMessage() {
        return this.message;
    }

    Program getProgram() {
        return this.program;
    }

    boolean isReadEnabled() {
        return this.readEnabled;
    }

    boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    boolean isExecuteEnabled() {
        return this.executeEnabled;
    }

    boolean isVolatileEnabled() {
        return this.volatileEnabled;
    }

    boolean getInitializedState() {
        return this.isInitialized;
    }

    boolean execute(String comment, boolean isRead, boolean isWrite, boolean isExecute, boolean isVolatile) {
        this.validateInfo();
        if (!this.isValid) {
            return false;
        }
        AddMemoryBlockCmd cmd = new AddMemoryBlockCmd(this.blockName, comment, "- none -", this.startAddr, this.length, isRead, isWrite, isExecute, isVolatile, (byte)this.initialValue, this.blockType, this.baseAddr, this.isInitialized);
        if (!this.tool.execute((Command)cmd, (DomainObject)this.program)) {
            this.message = cmd.getStatusMsg();
            return false;
        }
        return true;
    }

    void dispose() {
        this.tool = null;
        this.program = null;
    }

    private void validateInfo() {
        long sizeLimit;
        this.message = "";
        this.isValid = false;
        if (this.initialValue < 0 && this.isInitialized) {
            this.message = "Please enter a valid initial byte value";
            return;
        }
        if (this.blockName == null || this.blockName.length() == 0) {
            this.message = "Please enter a name";
            return;
        }
        if (this.nameExists(this.blockName)) {
            this.message = "Block name already exists";
            return;
        }
        if (!NamingUtilities.isValidName((String)this.blockName)) {
            this.message = "Block name is invalid";
            return;
        }
        if (this.startAddr == null) {
            this.message = "Please enter a valid starting address";
            return;
        }
        if (this.blockType == MemoryBlockType.BIT_MAPPED || this.blockType == MemoryBlockType.BYTE_MAPPED) {
            this.isInitialized = false;
            if (this.baseAddr == null) {
                String blockTypeStr = this.blockType == MemoryBlockType.BIT_MAPPED ? "bit" : "overlay";
                this.message = "Please enter a source address for the " + blockTypeStr + " block";
                return;
            }
        }
        long l = sizeLimit = this.isInitialized ? 0x40000000L : 0x300000000L;
        if (this.length <= 0 || (long)this.length > sizeLimit) {
            this.message = "Please enter a valid length > 0 and <= 0x" + Long.toHexString(sizeLimit);
            return;
        }
        if (this.blockType == MemoryBlockType.OVERLAY) {
            AddressFactory factory = this.program.getAddressFactory();
            AddressSpace[] spaces = factory.getAddressSpaces();
            for (int i = 0; i < spaces.length; ++i) {
                if (!spaces[i].getName().equals(this.blockName)) continue;
                this.message = "Address Space named " + this.blockName + " already exists";
                return;
            }
        }
        this.isValid = true;
    }

    private boolean nameExists(String name) {
        return this.nameIndexer.get(name) >= 0;
    }

    private void loadBlockNames() {
        Memory memory = this.program.getMemory();
        MemoryBlock[] blocks = memory.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            this.nameIndexer.put(blocks[i].getName());
        }
    }
}

