/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functionwindow;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProviderManager;
import ghidra.app.plugin.core.functionwindow.FunctionRowObject;
import ghidra.app.plugin.core.functionwindow.FunctionTableModel;
import ghidra.app.plugin.core.functionwindow.FunctionWindowProvider;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Function Viewer", description="Provides a window that displays the list of functions in the program.", eventsConsumed={ProgramClosedPluginEvent.class})
public class FunctionWindowPlugin
extends ProgramPlugin
implements DomainObjectListener,
OptionsChangeListener {
    private DockingAction selectAction;
    private DockingAction compareAction;
    private FunctionWindowProvider provider;
    private SwingUpdateManager swingMgr;
    private FunctionComparisonProviderManager functionComparisonManager = new FunctionComparisonProviderManager(this);

    public FunctionWindowPlugin(PluginTool tool) {
        super(tool, true, false);
        this.swingMgr = new SwingUpdateManager(1000, new Runnable(){

            @Override
            public void run() {
                FunctionWindowPlugin.this.provider.reload();
            }
        });
    }

    public void init() {
        super.init();
        this.provider = new FunctionWindowProvider(this);
        this.createActions();
    }

    public void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.swingMgr.dispose();
        this.provider.dispose();
        super.dispose();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(4)) {
            this.functionComparisonManager.domainObjectRestored(ev);
        }
        if (!this.provider.isVisible()) {
            return;
        }
        if (ev.containsEvent(4) || ev.containsEvent(23) || ev.containsEvent(21)) {
            this.provider.reload();
            return;
        }
        block8: for (int i = 0; i < ev.numRecords(); ++i) {
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            int eventType = doRecord.getEventType();
            switch (eventType) {
                case 30: 
                case 31: {
                    this.swingMgr.update();
                    continue block8;
                }
                case 150: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Function function = (Function)rec.getObject();
                    this.provider.functionAdded(function);
                    continue block8;
                }
                case 151: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Function function = (Function)rec.getObject();
                    if (function == null) continue block8;
                    this.provider.functionRemoved(function);
                    continue block8;
                }
                case 152: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Function function = (Function)rec.getObject();
                    this.provider.update(function);
                    continue block8;
                }
                case 40: 
                case 45: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Symbol sym = (Symbol)rec.getNewValue();
                    Address addr = sym.getAddress();
                    Function function = this.currentProgram.getListing().getFunctionAt(addr);
                    if (function == null) continue block8;
                    this.provider.update(function);
                    continue block8;
                }
                case 46: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Symbol sym = (Symbol)rec.getObject();
                    Address addr = sym.getAddress();
                    Function function = this.currentProgram.getListing().getFunctionAt(addr);
                    if (function == null) continue block8;
                    this.provider.update(function);
                }
            }
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.provider.programOpened(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.provider.programClosed();
    }

    Program getProgram() {
        return this.currentProgram;
    }

    private void createActions() {
        this.addSelectAction();
        this.addCompareAction();
        SelectionNavigationAction action = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
    }

    private void addSelectAction() {
        this.selectAction = new DockingAction("Make Selection", this.getName(), false){

            public void actionPerformed(ActionContext context) {
                FunctionWindowPlugin.this.selectFunctions(FunctionWindowPlugin.this.provider.selectFunctions());
            }
        };
        this.selectAction.setEnabled(false);
        ImageIcon icon = ResourceManager.loadImage((String)"images/text_align_justify.png");
        this.selectAction.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, (Icon)icon));
        this.selectAction.setDescription("Selects currently selected function(s) in table");
        this.selectAction.setToolBarData(new ToolBarData((Icon)icon));
        this.installDummyAction(this.selectAction);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.selectAction);
    }

    private void addCompareAction() {
        this.compareAction = new DockingAction("Compare Selected Functions", this.getName(), false){

            public void actionPerformed(ActionContext context) {
                FunctionWindowPlugin.this.compareSelectedFunctions();
            }
        };
        this.compareAction.setEnabled(false);
        ImageIcon icon = ResourceManager.loadImage((String)"images/page_white_c.png");
        this.compareAction.setPopupMenuData(new MenuData(new String[]{"Compare Functions"}, (Icon)icon));
        this.compareAction.setDescription("Compares the currently selected function(s) in the table.");
        this.compareAction.setToolBarData(new ToolBarData((Icon)icon));
        this.installDummyAction(this.compareAction);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.compareAction);
    }

    private void installDummyAction(DockingAction action) {
        DummyKeyBindingsOptionsAction dummyAction = new DummyKeyBindingsOptionsAction(action.getName(), null);
        this.tool.addAction((DockingActionIf)dummyAction);
        ToolOptions options = this.tool.getOptions("Key Bindings");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        KeyStroke keyStroke = options.getKeyStroke(dummyAction.getFullName(), null);
        if (keyStroke != null) {
            action.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        KeyStroke keyStroke;
        if (optionName.startsWith(this.selectAction.getName())) {
            keyStroke = (KeyStroke)newValue;
            this.selectAction.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
        if (optionName.startsWith(this.compareAction.getName())) {
            keyStroke = (KeyStroke)newValue;
            this.compareAction.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    void setActionsEnabled(boolean enabled) {
        this.selectAction.setEnabled(enabled);
        this.compareAction.setEnabled(enabled);
    }

    void showFunctions() {
        this.provider.showFunctions();
    }

    private void selectFunctions(ProgramSelection selection) {
        ProgramSelectionPluginEvent pspe = new ProgramSelectionPluginEvent("Selection", selection, this.currentProgram);
        this.firePluginEvent(pspe);
    }

    private FunctionComparisonProvider compareSelectedFunctions() {
        Function[] functions = this.getSelectedFunctions();
        if (functions.length < 2) {
            Msg.showError((Object)((Object)this), (Component)this.provider.getComponent(), (String)"Compare Selected Functions", (Object)"Select two or more rows in the table indicating functions to compare.");
            return null;
        }
        return this.functionComparisonManager.showFunctionComparisonProvider(functions);
    }

    private Function[] getSelectedFunctions() {
        GhidraTable table = this.provider.getTable();
        int[] selectedRows = table.getSelectedRows();
        Function[] functions = new Function[selectedRows.length];
        FunctionTableModel model = this.provider.getModel();
        Program program = model.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        List functionRowObjects = model.getRowObjects(selectedRows);
        int index = 0;
        for (FunctionRowObject functionRowObject : functionRowObjects) {
            long key = functionRowObject.getKey();
            functions[index++] = functionManager.getFunction(key);
        }
        return functions;
    }

    @Override
    protected void programClosed(Program program) {
        this.functionComparisonManager.closeProviders(program);
    }
}

