/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.InputDialog;
import ghidra.app.cmd.function.ChangeFunctionTagCmd;
import ghidra.app.cmd.function.DeleteFunctionTagCmd;
import ghidra.app.plugin.core.function.tags.FunctionTagList;
import ghidra.app.plugin.core.function.tags.FunctionTagTemp;
import ghidra.app.plugin.core.function.tags.FunctionTagsComponentProvider;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class TagListPanel
extends JPanel {
    protected Program program;
    protected FunctionTagList list;
    protected Function function;
    protected DefaultListModel<FunctionTag> model = new DefaultListModel();
    protected DefaultListModel<FunctionTag> filteredModel = new DefaultListModel();
    protected PluginTool tool;
    protected String filterString = "";

    public TagListPanel(FunctionTagsComponentProvider provider, final PluginTool tool, String title) {
        this.tool = tool;
        this.setLayout(new BorderLayout());
        this.list = new FunctionTagList(this.filteredModel);
        this.list.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                provider.selectionChanged(this);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FunctionTagList list = (FunctionTagList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    FunctionTag tag = (FunctionTag)list.getSelectedValue();
                    if (tag == null) {
                        return;
                    }
                    if (tag instanceof FunctionTagTemp) {
                        Msg.showWarn((Object)list, (Component)list, (String)"Tag Not Editable", (Object)("Tag \"" + tag.getName() + "\" was loaded from an external source and cannot be edited or deleted"));
                        return;
                    }
                    String[] labels = new String[]{"Name:", "Comment:"};
                    String[] init = new String[]{tag.getName(), tag.getComment()};
                    InputDialog dialog = new InputDialog("Edit Tag", labels, init, true, d -> {
                        ChangeFunctionTagCmd cmd;
                        String[] results = d.getValues();
                        if (results == null || results.length != 2) {
                            Msg.error((Object)this, (Object)"Error retrieving data from edit dialog");
                            return false;
                        }
                        String newName = results[0].trim();
                        String newComment = results[1].trim();
                        if (newName.isEmpty()) {
                            Msg.showWarn((Object)this, (Component)list, (String)"Empty Tag Name?", (Object)"Tag name cannot be empty");
                            return false;
                        }
                        if (!newName.equals(tag.getName())) {
                            cmd = new ChangeFunctionTagCmd(tag.getName(), newName, 0);
                            tool.execute((Command)cmd, (DomainObject)TagListPanel.this.program);
                        }
                        if (!newComment.equals(tag.getComment())) {
                            cmd = new ChangeFunctionTagCmd(tag.getName(), newComment, 1);
                            tool.execute((Command)cmd, (DomainObject)TagListPanel.this.program);
                        }
                        return true;
                    });
                    dialog.setPreferredSize(400, 150);
                    DockingWindowManager.showDialog((Component)list, (DialogComponentProvider)dialog);
                    if (dialog.isCanceled()) {
                        return;
                    }
                }
            }
        });
        JLabel label = new JLabel(title);
        this.add((Component)label, "North");
        this.add((Component)this.list, "Center");
    }

    public abstract void refresh(Function var1);

    public void clearSelection() {
        this.list.clearSelection();
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public void setFilterText(String text) {
        this.filterString = text;
        this.applyFilter();
    }

    public boolean tagExists(String name) {
        for (int i = 0; i < this.model.size(); ++i) {
            FunctionTag tag = this.model.getElementAt(i);
            if (!tag.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSelection() {
        return this.list.getSelectedIndices().length != 0;
    }

    protected boolean isSelectionImmutable() {
        return this.list.getSelectedValuesList().stream().anyMatch(val -> val instanceof FunctionTagTemp);
    }

    protected void sortList() {
        ArrayList<FunctionTag> myList = Collections.list(this.model.elements());
        Collections.sort(myList);
        this.model.clear();
        for (FunctionTag tag : myList) {
            this.model.addElement(tag);
        }
    }

    protected void deleteSelectedTags() {
        List<FunctionTag> selectedTags = this.getSelectedTags();
        if (selectedTags.isEmpty()) {
            return;
        }
        int option = OptionDialog.showOptionDialog((Component)this, (String)"Function Tag Delete", (String)"Are you sure? \nThis will delete the tag from all functions in the program.", (String)"OK", (int)2);
        switch (option) {
            case 1: {
                for (FunctionTag tag : selectedTags) {
                    DeleteFunctionTagCmd cmd = new DeleteFunctionTagCmd(tag.getName());
                    this.tool.execute((Command)cmd, (DomainObject)this.program);
                }
                break;
            }
        }
    }

    protected void applyFilter() {
        this.filteredModel.clear();
        for (int i = 0; i < this.model.size(); ++i) {
            if (!this.model.get(i).getName().toLowerCase().contains(this.filterString.toLowerCase())) continue;
            this.filteredModel.addElement(this.model.get(i));
        }
    }

    protected List<FunctionTag> getAssignedTags(Function function) {
        ArrayList<FunctionTag> assignedTags = new ArrayList<FunctionTag>();
        if (function != null) {
            assignedTags.addAll(function.getTags());
        }
        return assignedTags;
    }

    protected List<FunctionTag> getSelectedTags() {
        int[] selectedIndices;
        ArrayList<FunctionTag> tags = new ArrayList<FunctionTag>();
        for (int i : selectedIndices = this.list.getSelectedIndices()) {
            tags.add(this.filteredModel.getElementAt(i));
        }
        return tags;
    }
}

