/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.flowarrow;

import ghidra.app.plugin.core.flowarrow.FlowArrowPlugin;
import ghidra.app.plugin.core.flowarrow.FlowArrowShapeFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.symbol.RefType;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

abstract class FlowArrow {
    private static final int MIN_LINE_SPACING = 9;
    private static final int DEFAULT_LINE_SPACING = 16;
    private static final int MAX_LINE_SPACING = 60;
    private static final double ARROW_SPACING_RATIO = 0.18;
    Address start;
    Address end;
    AddressSet addressSet;
    int depth = -1;
    RefType refType;
    private boolean isUp;
    boolean active;
    boolean selected;
    private FlowArrowPlugin plugin;
    private Component canvas;
    protected Shape arrowBody;
    protected Shape arrowHead;
    private List<Shape> clickableShapes = new ArrayList<Shape>();

    FlowArrow(FlowArrowPlugin plugin, Component canvas, Address start, Address end, RefType referenceType) {
        this.plugin = plugin;
        this.canvas = canvas;
        this.start = start;
        this.end = end;
        this.refType = referenceType;
        this.addressSet = new AddressSet((AddressRange)new AddressRangeImpl(start, end));
        this.isUp = start.compareTo((Object)end) > 0;
    }

    abstract Stroke getSelectedStroke();

    abstract Stroke getActiveStroke();

    abstract Stroke getInactiveStroke();

    void paint(Graphics2D g2, Color fgColor, Color bgColor) {
        if (this.arrowBody == null) {
            this.createShapes();
        }
        this.doPaint(g2, fgColor, bgColor);
    }

    private void doPaint(Graphics2D g2, Color fgColor, Color bgColor) {
        Paint oldPaint = g2.getPaint();
        Stroke oldStroke = g2.getStroke();
        g2.setPaint(fgColor);
        if (this.selected) {
            g2.setStroke(this.getSelectedStroke());
        } else if (this.active) {
            g2.setStroke(this.getActiveStroke());
        } else {
            g2.setStroke(this.getInactiveStroke());
        }
        g2.draw(this.arrowBody);
        g2.fill(this.arrowHead);
        g2.setPaint(oldPaint);
        g2.setStroke(oldStroke);
    }

    boolean isUp() {
        return this.isUp;
    }

    void resetShape() {
        this.arrowBody = null;
        this.arrowHead = null;
        this.clickableShapes.clear();
    }

    boolean intersects(Point p) {
        double size = 5.0;
        double half = size / 2.0;
        double x = (double)p.x - half;
        double y = (double)p.y - half;
        Rectangle2D.Double pickArea = new Rectangle2D.Double(x, y, size, size);
        return this.intersectsAnyPartOfArrow(pickArea);
    }

    private boolean intersectsAnyPartOfArrow(Rectangle2D area) {
        if (this.arrowBody == null) {
            this.createShapes();
        }
        if (this.clickableShapes.isEmpty()) {
            this.createClickableShapes();
        }
        for (Shape s : this.clickableShapes) {
            if (!s.intersects(area)) continue;
            return true;
        }
        return this.arrowHead.intersects(area);
    }

    private void createClickableShapes() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        Rectangle r = null;
        PathIterator it = this.arrowBody.getPathIterator(null);
        float[] coords = new float[6];
        double lastx = 0.0;
        double lasty = 0.0;
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (r != null) {
                        throw new AssertException("Founds a flow arrow shape without a line");
                    }
                    r = new Rectangle((int)coords[0], (int)coords[1], 0, 0);
                    break;
                }
                case 1: {
                    if (r == null) {
                        r = new Rectangle((int)lastx, (int)lasty);
                    }
                    lastx = coords[0];
                    lasty = coords[1];
                    Rectangle shape = this.buildRectangle(r, lastx, lasty);
                    shapes.add(shape);
                    r = null;
                    break;
                }
                case 4: {
                    if (r == null) break;
                    throw new AssertException("Founds a flow arrow shape without a line");
                }
                default: {
                    throw new AssertException("Unhandled path type!");
                }
            }
            it.next();
        }
        this.clickableShapes = shapes;
    }

    private Rectangle buildRectangle(Rectangle r, double endx, double endy) {
        double x = r.x;
        double y = r.y;
        double w = Math.abs(x - endx);
        double h = Math.abs(y - endy);
        if (w != 0.0 && h != 0.0) {
            r.setSize((int)w, (int)h);
            return r;
        }
        if (h == 0.0) {
            if (x > endx) {
                x = endx;
            }
            y -= 1.0;
            h = 2.0;
        } else {
            if (y > endy) {
                y = endy;
            }
            x -= 1.0;
            w = 2.0;
        }
        r.setFrame(x, y, w, h);
        return r;
    }

    private void createShapes() {
        int displayHeight = this.canvas.getHeight();
        int displayWidth = this.canvas.getWidth();
        int lineWidth = this.calculateLineWidth(displayWidth);
        this.arrowBody = FlowArrowShapeFactory.createArrowBody(this.plugin, this, displayWidth, displayHeight, lineWidth);
        this.arrowHead = FlowArrowShapeFactory.createArrowHead(this.plugin, this, displayWidth, displayHeight, lineWidth);
    }

    private int calculateLineWidth(int displayWidth) {
        int lineWidth = 16;
        int maxDepth = this.plugin.getMaxDepth();
        if (maxDepth >= 0) {
            int availabeWidth = displayWidth - 3;
            lineWidth = (int)((double)availabeWidth * 0.18);
        }
        if (lineWidth < 9) {
            lineWidth = 9;
        } else if (lineWidth > 60) {
            lineWidth = 60;
        }
        return lineWidth;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.refType == null ? 0 : this.refType.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowArrow other = (FlowArrow)obj;
        if (this.end == null ? other.end != null : !this.end.equals((Object)other.end)) {
            return false;
        }
        if (this.refType == null ? other.refType != null : !this.refType.equals((Object)other.refType)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals((Object)other.start));
    }

    public String getDisplayString() {
        return "<html><table><tr><td>start</td><td>" + this.start + "</td><tr><td>end</td><td>" + this.end + "</td><tr><td>ref type</td><td>" + this.refType + "</td></tr></table>";
    }

    public String toString() {
        return "start=" + this.start + "; end=" + this.end + "; ref type=" + this.refType;
    }
}

