/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.plugin.core.equate.AbstractConvertAction;
import ghidra.app.plugin.core.equate.EquatePlugin;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;

public class ConvertToSignedHexAction
extends AbstractConvertAction {
    public static final String ACTION_NAME = "Convert To Signed Hex";

    public ConvertToSignedHexAction(EquatePlugin plugin) {
        super(plugin, ACTION_NAME, true);
    }

    @Override
    protected String getMenuName(Program program, Scalar scalar, boolean isData) {
        return this.getStandardLengthString("Signed Hex:") + this.convertToString(program, scalar, isData);
    }

    @Override
    protected String convertToString(Program program, Scalar scalar, boolean isData) {
        if (isData) {
            return null;
        }
        long v = scalar.getSignedValue();
        String valueStr = Long.toString(v, 16).toUpperCase();
        if (v < 0L) {
            return "-0x" + valueStr.substring(1);
        }
        return "0x" + valueStr;
    }

    @Override
    protected int getFormatChoice() {
        return 0;
    }
}

