/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import generic.util.Path;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.framework.model.DomainFile;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;

public class RecentlyOpenedArchiveAction
extends DockingAction {
    private final String projectName;
    private final String archivePath;
    private final DataTypeManagerPlugin plugin;

    public RecentlyOpenedArchiveAction(DataTypeManagerPlugin plugin, String archivePath, String menuGroup) {
        this(plugin, archivePath, RecentlyOpenedArchiveAction.getDisplayPath(archivePath), menuGroup);
    }

    public RecentlyOpenedArchiveAction(DataTypeManagerPlugin plugin, String archivePath, String displayedPath, String menuGroup) {
        super(menuGroup + ": \"" + archivePath + "\"", plugin.getName(), false);
        this.plugin = plugin;
        String[] projectPathname = DataTypeManagerHandler.parseProjectPathname(archivePath);
        if (projectPathname == null) {
            this.projectName = null;
            this.archivePath = archivePath;
        } else {
            this.projectName = projectPathname[0];
            this.archivePath = projectPathname[1];
        }
        this.setMenuBarData(new MenuData(new String[]{menuGroup, displayedPath}, null, menuGroup));
        this.setDescription("Opens the indicated archive in the data type manager.");
        this.setEnabled(true);
    }

    private static String getDisplayPath(String filepath) {
        String[] projectPathname = DataTypeManagerHandler.parseProjectPathname(filepath);
        if (projectPathname == null) {
            return filepath;
        }
        return projectPathname[0] + ":" + projectPathname[1];
    }

    public void actionPerformed(ActionContext context) {
        if (this.projectName == null) {
            DataTypeManagerHandler archiveManager = this.plugin.getDataTypeManagerHandler();
            Path path = new Path(this.archivePath);
            OpenArchiveTask task = new OpenArchiveTask(archiveManager, path);
            new TaskLauncher((Task)task, (Component)this.plugin.getProvider().getComponent());
        } else {
            DomainFile df = this.plugin.getProjectArchiveFile(this.projectName, this.archivePath);
            if (df != null) {
                this.plugin.openArchive(df);
            } else {
                Msg.showError((Object)((Object)this), null, (String)"Project Archive Open Error", (Object)("Project data type archive not found: " + this.getMenuBarData().getMenuItemName()));
            }
        }
    }

    private class OpenArchiveTask
    extends Task {
        private final Path archivePath;
        private final DataTypeManagerHandler archiveManager;

        OpenArchiveTask(DataTypeManagerHandler archiveManager, Path archivePath) {
            super("Opening Archive " + archivePath.getPath().getName(), false, false, true);
            this.archiveManager = archiveManager;
            this.archivePath = archivePath;
        }

        public void run(TaskMonitor monitor) {
            try {
                this.archiveManager.openArchive(this.archivePath.getPath(), false, true);
            }
            catch (Throwable t) {
                DataTypeManagerHandler.handleArchiveFileException(RecentlyOpenedArchiveAction.this.plugin, this.archivePath.getPath(), t);
            }
        }
    }
}

