/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.console;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.console.ConsoleWord;
import ghidra.app.plugin.core.console.ConsoleWriter;
import ghidra.app.services.ConsoleService;
import ghidra.app.services.GoToService;
import ghidra.app.services.QueryData;
import ghidra.framework.main.ConsoleTextPane;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import resources.ResourceManager;

public class ConsoleComponentProvider
extends ComponentProviderAdapter
implements ConsoleService,
OptionsChangeListener {
    private static final String CONSOLE_GIF = "images/monitor.png";
    private static final String CLEAR_GIF = "images/erase16.png";
    private static final String SCROLL_LOCK_GIF = "images/lock.png";
    private static final Font DEFAULT_FONT = new Font("monospaced", 0, 12);
    private static final String FONT_OPTION_LABEL = "Font";
    private static final String FONT_DESCRIPTION = "This is the font that will be used in the Console.  Double-click the font example to change it.";
    private Font font;
    private ConsoleTextPane textPane;
    private JScrollPane scroller;
    private JComponent component;
    private boolean scrollLock = false;
    private DockingAction clearAction;
    private ToggleDockingAction scrollAction;
    private Address currentAddress;
    private PrintWriter stderr;
    private PrintWriter stdin;
    private Program currentProgram;

    public ConsoleComponentProvider(PluginTool tool, String name) {
        super(tool, name, name);
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setHelpLocation(new HelpLocation(this.getName(), "console"));
        this.setIcon(ResourceManager.loadImage((String)CONSOLE_GIF));
        this.setWindowMenuGroup("Console");
        this.setSubTitle("Scripting");
        this.setTitle("Console");
        this.createOptions();
        this.build();
        this.createActions();
    }

    void init() {
        this.stderr = new PrintWriter(new ConsoleWriter(this, true));
        this.stdin = new PrintWriter(new ConsoleWriter(this, false));
        this.setVisible(true);
    }

    void dispose() {
        this.textPane.dispose();
        this.stderr.close();
        this.stdin.close();
    }

    private void createOptions() {
        ToolOptions options = this.tool.getOptions("Console");
        HelpLocation help = new HelpLocation(this.getName(), "ConsolePlugin");
        options.registerOption(FONT_OPTION_LABEL, (Object)DEFAULT_FONT, help, FONT_DESCRIPTION);
        options.setOptionsHelpLocation(help);
        this.font = options.getFont(FONT_OPTION_LABEL, DEFAULT_FONT);
        this.font = SystemUtilities.adjustForFontSizeOverride((Font)this.font);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(FONT_OPTION_LABEL)) {
            this.font = SystemUtilities.adjustForFontSizeOverride((Font)((Font)newValue));
            this.textPane.setFont(this.font);
        }
    }

    private void build() {
        this.textPane = new ConsoleTextPane(this.tool);
        this.textPane.setName("CONSOLE");
        this.textPane.setFont(this.font);
        this.textPane.setEditable(false);
        this.textPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ConsoleComponentProvider.this.currentProgram == null) {
                    return;
                }
                Point hoverPoint = e.getPoint();
                ConsoleWord word = ConsoleComponentProvider.this.getWordSeparatedByWhitespace(hoverPoint);
                if (word == null) {
                    ConsoleComponentProvider.this.textPane.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                Address addr = ConsoleComponentProvider.this.currentProgram.getAddressFactory().getAddress(word.word);
                if (addr != null || ConsoleComponentProvider.this.isSymbol(word.word)) {
                    ConsoleComponentProvider.this.textPane.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                ConsoleWord trimmedWord = word.getWordWithoutSpecialCharacters();
                addr = ConsoleComponentProvider.this.currentProgram.getAddressFactory().getAddress(trimmedWord.word);
                if (addr != null || ConsoleComponentProvider.this.isSymbol(trimmedWord.word)) {
                    ConsoleComponentProvider.this.textPane.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (ConsoleComponentProvider.this.currentProgram == null) {
                    return;
                }
                GoToService gotoService = (GoToService)ConsoleComponentProvider.this.tool.getService(GoToService.class);
                if (gotoService == null) {
                    return;
                }
                Point clickPoint = e.getPoint();
                ConsoleWord word = ConsoleComponentProvider.this.getWordSeparatedByWhitespace(clickPoint);
                if (word == null) {
                    return;
                }
                Address addr = ConsoleComponentProvider.this.currentProgram.getAddressFactory().getAddress(word.word);
                if (addr != null || ConsoleComponentProvider.this.isSymbol(word.word)) {
                    ConsoleComponentProvider.this.goTo(word);
                    return;
                }
                ConsoleWord trimmedWord = word.getWordWithoutSpecialCharacters();
                addr = ConsoleComponentProvider.this.currentProgram.getAddressFactory().getAddress(trimmedWord.word);
                if (addr == null && !ConsoleComponentProvider.this.isSymbol(trimmedWord.word)) {
                    return;
                }
                ConsoleComponentProvider.this.goTo(trimmedWord);
            }
        });
        this.scroller = new JScrollPane(this.textPane);
        this.scroller.setPreferredSize(new Dimension(200, 100));
        this.component = new JPanel(new BorderLayout(5, 5));
        this.component.add((Component)this.scroller, "Center");
        this.tool.addComponentProvider((ComponentProvider)this, true);
    }

    private void goTo(ConsoleWord word) {
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        if (gotoService == null) {
            return;
        }
        boolean found = gotoService.goToQuery(this.currentAddress, new QueryData(word.word, true), null, null);
        if (found) {
            this.select(word);
            return;
        }
        ConsoleWord trimmedWord = word.getWordWithoutSpecialCharacters();
        found = gotoService.goToQuery(this.currentAddress, new QueryData(trimmedWord.word, true), null, null);
        if (found) {
            this.select(trimmedWord);
        }
    }

    private ConsoleWord getWordSeparatedByWhitespace(Point p) {
        int pos = this.textPane.viewToModel(p);
        Document doc = this.textPane.getDocument();
        int endIndex = pos;
        try {
            char c;
            int startIndex;
            for (startIndex = pos; startIndex > 0 && !Character.isWhitespace(c = doc.getText(startIndex, 1).charAt(0)); --startIndex) {
            }
            while (endIndex < doc.getLength() - 1 && !Character.isWhitespace(c = doc.getText(endIndex, 1).charAt(0))) {
                ++endIndex;
            }
            String text = doc.getText(startIndex + 1, endIndex - startIndex);
            if (text == null || text.trim().length() == 0) {
                return null;
            }
            return new ConsoleWord(text.trim(), startIndex + 1, endIndex);
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    private boolean isSymbol(String word) {
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        SymbolIterator symbolIterator = symbolTable.getSymbols(word);
        return symbolIterator.hasNext();
    }

    protected void select(ConsoleWord word) {
        try {
            this.textPane.select(word.startPosition, word.endPosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createActions() {
        this.clearAction = new DockingAction("Clear Console", this.getName()){

            public void actionPerformed(ActionContext context) {
                ConsoleComponentProvider.this.clearMessages();
            }
        };
        this.clearAction.setDescription("Clear Console");
        this.clearAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)CLEAR_GIF), null));
        this.clearAction.setEnabled(true);
        this.scrollAction = new ToggleDockingAction("Scroll Lock", this.getName()){

            public void actionPerformed(ActionContext context) {
                ConsoleComponentProvider.this.textPane.setScrollLock(this.isSelected());
            }
        };
        this.scrollAction.setDescription("Scroll Lock");
        this.scrollAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)SCROLL_LOCK_GIF), null));
        this.scrollAction.setEnabled(true);
        this.scrollAction.setSelected(this.scrollLock);
        this.addLocalAction((DockingActionIf)this.scrollAction);
        this.addLocalAction((DockingActionIf)this.clearAction);
    }

    @Override
    public void addMessage(String originator, String message) {
        this.checkVisible();
        this.textPane.addMessage(originator + "> " + message + "\n");
    }

    @Override
    public void addErrorMessage(String originator, String message) {
        this.checkVisible();
        this.textPane.addErrorMessage(originator + "> " + message + "\n");
    }

    @Override
    public void addException(String originator, Exception e) {
        try {
            e.printStackTrace(this.stderr);
        }
        catch (Exception e1) {
            this.stderr.println("Unexpected Exception: " + e.getMessage());
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                this.stderr.println("\t" + stackTraceElement.toString());
            }
            this.stderr.println("Unexpected Exception: " + e1.getMessage());
            for (StackTraceElement stackTraceElement : e1.getStackTrace()) {
                this.stderr.println("\t" + stackTraceElement.toString());
            }
        }
        Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
    }

    @Override
    public void clearMessages() {
        this.checkVisible();
        this.textPane.setText("");
    }

    @Override
    public void print(String msg) {
        this.checkVisible();
        this.textPane.addPartialMessage(msg);
    }

    @Override
    public void printError(String errmsg) {
        this.checkVisible();
        this.textPane.addErrorMessage(errmsg);
    }

    @Override
    public void println(String msg) {
        this.checkVisible();
        this.textPane.addMessage(msg + "\n");
    }

    @Override
    public void printlnError(String errmsg) {
        this.checkVisible();
        this.textPane.addErrorMessage(errmsg + "\n");
    }

    @Override
    public PrintWriter getStdErr() {
        return this.stderr;
    }

    @Override
    public PrintWriter getStdOut() {
        return this.stdin;
    }

    @Override
    public String getText(int offset, int length) {
        try {
            return this.textPane.getDocument().getText(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public int getTextLength() {
        return this.textPane.getDocument().getLength();
    }

    private void checkVisible() {
        if (!this.isVisible()) {
            this.tool.showComponentProvider((ComponentProvider)this, true);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void requestFocus() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = kfm.getFocusOwner();
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.component)) {
            return;
        }
        this.component.requestFocus();
    }

    public void setCurrentProgram(Program program) {
        this.currentProgram = program;
    }

    public void setCurrentAddress(Address address) {
        this.currentAddress = address;
    }
}

