/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import ghidra.app.services.MarkerService;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import java.awt.Color;
import java.math.BigInteger;

public class MarkerServiceBackgroundColorModel
implements ListingBackgroundColorModel {
    private MarkerService markerService;
    private AddressIndexMap indexMap;
    private Color defaultBackgroundColor = Color.WHITE;

    public MarkerServiceBackgroundColorModel(MarkerService markerService, AddressIndexMap indexMap) {
        this.markerService = markerService;
        this.indexMap = indexMap;
    }

    public Color getBackgroundColor(BigInteger index) {
        Address addr = this.indexMap.getAddress(index);
        Color color = null;
        if (addr != null) {
            color = this.markerService.getBackgroundColor(addr);
        }
        if (color == null) {
            color = this.defaultBackgroundColor;
        }
        return color;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        this.defaultBackgroundColor = c;
    }

    @Override
    public void modelDataChanged(ListingPanel listingPanel) {
        this.indexMap = listingPanel.getAddressIndexMap();
    }
}

