/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.tree.TreePath;

public abstract class CallNode
extends GTreeSlowLoadingNode {
    private boolean allowDuplicates;
    protected AtomicInteger filterDepth;
    private int depth = -1;
    protected boolean invalid = false;

    public CallNode(AtomicInteger filterDepth) {
        this.filterDepth = filterDepth;
    }

    public abstract Function getContainingFunction();

    public abstract ProgramLocation getLocation();

    public abstract Address getSourceAddress();

    abstract CallNode recreate();

    protected Set<Reference> getReferencesFrom(Program program, AddressSetView addresses, TaskMonitor monitor) throws CancelledException {
        HashSet<Reference> set = new HashSet<Reference>();
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressIterator addressIterator = addresses.getAddresses(true);
        while (addressIterator.hasNext()) {
            monitor.checkCanceled();
            Address address = addressIterator.next();
            Reference[] referencesFrom = referenceManager.getReferencesFrom(address);
            if (referencesFrom == null) continue;
            for (Reference reference : referencesFrom) {
                set.add(reference);
            }
        }
        return set;
    }

    protected void setAllowsDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean equals(Object other) {
        if (this.allowDuplicates) {
            return super.equals(other);
        }
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(other.getClass())) {
            return false;
        }
        CallNode otherCallNode = (CallNode)((Object)other);
        return this.getName().equals(otherCallNode.getName());
    }

    public void filter(GTreeFilter filter, TaskMonitor monitor, int min, int max) throws CancelledException {
        if (this.depth() > this.filterDepth.get()) {
            this.doSetActiveChildren(new ArrayList());
            return;
        }
        super.filter(filter, monitor, min, max);
    }

    private int depth() {
        if (this.depth < 0) {
            TreePath treePath = this.getTreePath();
            Object[] path = treePath.getPath();
            this.depth = path.length;
        }
        return this.depth;
    }

    boolean functionIsInPath() {
        Object[] pathComponents;
        TreePath path = this.getTreePath();
        for (Object pathComponent : pathComponents = path.getPath()) {
            CallNode node = (CallNode)((Object)pathComponent);
            Function nodeFunction = node.getContainingFunction();
            Function myFunction = this.getContainingFunction();
            if (node == this || !nodeFunction.equals(myFunction)) continue;
            return true;
        }
        return false;
    }

    protected class CallNodeComparator
    implements Comparator<GTreeNode> {
        protected CallNodeComparator() {
        }

        @Override
        public int compare(GTreeNode o1, GTreeNode o2) {
            return ((CallNode)o1).getSourceAddress().compareTo((Object)((CallNode)o2).getSourceAddress());
        }
    }
}

