/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.util.DiffUtility;

public class ConflictUtility {
    public static String MAROON = "#990000";
    public static String GREEN = "#009900";
    public static String BLUE = "#000099";
    public static String PURPLE = "#990099";
    public static String DARK_CYAN = "#009999";
    public static String OLIVE = "#999900";
    public static String ORANGE = "#FF9900";
    public static String PINK = "#FF9999";
    public static String YELLOW = "#FFFF00";
    public static String GRAY = "#888888";
    public static String ADDRESS_COLOR = MAROON;
    public static String NUMBER_COLOR = MAROON;
    public static String EMPHASIZE_COLOR = MAROON;
    public static String OFFSET_COLOR = MAROON;
    public static String NO_VALUE = "-- No Value --";

    public static String wrapAsHTML(String text) {
        return "<html><body>" + text + "</body></html>";
    }

    public static String colorString(String rgbColor, String text) {
        return "<font color=\"" + rgbColor + "\">" + text + "</font>";
    }

    public static String colorString(String rgbColor, int value) {
        return "<font color=\"" + rgbColor + "\">" + value + "</font>";
    }

    public static String spaces(int num) {
        StringBuffer buf = new StringBuffer(6 * num);
        for (int i = 0; i < num; ++i) {
            buf.append("&nbsp;");
        }
        return buf.toString();
    }

    public static void addCount(StringBuffer buf, int value) {
        buf.append(ConflictUtility.getNumberString(value));
    }

    public static void addAddress(StringBuffer buf, Address addr) {
        buf.append(ConflictUtility.getAddressString(addr));
    }

    public static String getConflictCount(int conflictNum, int totalConflicts) {
        StringBuffer buf = new StringBuffer();
        buf.append("Conflict #");
        ConflictUtility.addCount(buf, conflictNum);
        buf.append(" of ");
        ConflictUtility.addCount(buf, totalConflicts);
        return buf.toString();
    }

    public static String getConflictCount(int conflictNum, int totalConflicts, Address addr) {
        StringBuffer buf = new StringBuffer(ConflictUtility.getConflictCount(conflictNum, totalConflicts));
        buf.append(" @ address: ");
        ConflictUtility.addAddress(buf, addr);
        return buf.toString();
    }

    public static String getConflictCount(int conflictNum, int totalConflicts, AddressRange range) {
        StringBuffer buf = new StringBuffer(ConflictUtility.getConflictCount(conflictNum, totalConflicts));
        buf.append(" for address range: ");
        ConflictUtility.addAddress(buf, range.getMinAddress());
        buf.append("-");
        ConflictUtility.addAddress(buf, range.getMaxAddress());
        return buf.toString();
    }

    public static String getAddressConflictCount(int addressNum, int totalAddresses, boolean isRange) {
        StringBuffer buf = new StringBuffer();
        if (isRange) {
            buf.append("Address range #");
        } else {
            buf.append("Address #");
        }
        ConflictUtility.addCount(buf, addressNum);
        buf.append(" of ");
        ConflictUtility.addCount(buf, totalAddresses);
        buf.append(" with conflicts");
        return buf.toString();
    }

    public static String getTruncatedHTMLString(String originalString, int truncLength) {
        int originalLength;
        if (originalString == null) {
            originalString = "";
        }
        boolean shouldTruncate = (originalLength = originalString.length()) > truncLength;
        Object truncString = originalString;
        if (shouldTruncate) {
            truncString = originalString.substring(0, truncLength - 3) + "...";
        }
        return ConflictUtility.wrapAsHTML(ConflictUtility.replaceNewLines((String)truncString));
    }

    private static String replaceNewLines(String text) {
        int length = text.length();
        StringBuffer buf = new StringBuffer();
        int start = 0;
        while (start < length) {
            int index = text.indexOf(10, start);
            if (index == -1) {
                buf.append(text.substring(start));
                start = length;
                continue;
            }
            buf.append(text.substring(start, index));
            buf.append("<br>");
            start = index + 1;
        }
        return buf.toString();
    }

    public static String getAddressString(Address address) {
        return ConflictUtility.colorString(ADDRESS_COLOR, address != null ? address.toString() : "");
    }

    public static String getAddressString(Address address, boolean showAddressSpace) {
        return ConflictUtility.colorString(ADDRESS_COLOR, address != null ? address.toString(showAddressSpace) : "");
    }

    public static String getNumberString(int count) {
        return ConflictUtility.colorString(NUMBER_COLOR, Integer.toString(count));
    }

    public static String getEmphasizeString(String text) {
        return ConflictUtility.colorString(EMPHASIZE_COLOR, text);
    }

    public static String getOffsetString(int offset) {
        return ConflictUtility.colorString(OFFSET_COLOR, DiffUtility.toSignedHexString(offset));
    }

    public static String getHashString(long hash) {
        return ConflictUtility.colorString(NUMBER_COLOR, "0x" + Long.toHexString(hash));
    }
}

