/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.EntryPointReferenceDB;
import ghidra.program.database.references.ExternalReferenceDB;
import ghidra.program.database.references.MemReferenceDB;
import ghidra.program.database.references.OffsetReferenceDB;
import ghidra.program.database.references.RecordAdapter;
import ghidra.program.database.references.RefList;
import ghidra.program.database.references.RefListFlagsV0;
import ghidra.program.database.references.ReferenceDB;
import ghidra.program.database.references.ShiftedReferenceDB;
import ghidra.program.database.references.StackReferenceDB;
import ghidra.program.database.references.ToAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import java.io.IOException;
import java.util.Iterator;

class RefListV0
extends RefList {
    private static final byte[] EMPTY_DATA = new byte[0];
    private static final int BASE_REF_SIZE = 11;
    private static final int OFFSET_SIZE = 8;
    private static final int SYMBOL_ID_SIZE = 8;
    private int numRefs;
    private byte refLevel = (byte)-1;
    private byte[] refData;
    private Record record;

    RefListV0(long addrKey, AddressMap addrMap, ProgramDB program, DBObjectCache<RefList> cache, boolean isFrom) {
        super(addrKey, addrMap.decodeAddress(addrKey), null, addrMap, program, cache, isFrom);
        this.refData = EMPTY_DATA;
        this.numRefs = 0;
        if (this.adapter != null) {
            this.record = ToAdapter.TO_REFS_SCHEMA.createRecord(this.key);
            this.record.setByteValue(2, (byte)-1);
        }
    }

    RefListV0(Address address, RecordAdapter adapter, AddressMap addrMap, ProgramDB program, DBObjectCache<RefList> cache, boolean isFrom) {
        super(addrMap.getKey(address, true), address, adapter, addrMap, program, cache, isFrom);
        this.refData = EMPTY_DATA;
        this.numRefs = 0;
        if (adapter != null) {
            this.record = ToAdapter.TO_REFS_SCHEMA.createRecord(this.key);
            this.record.setByteValue(2, (byte)-1);
        }
    }

    RefListV0(Record rec, RecordAdapter adapter, AddressMap addrMap, ProgramDB program, DBObjectCache<RefList> cache, boolean isFrom) {
        super(rec.getKey(), addrMap.decodeAddress(rec.getKey()), adapter, addrMap, program, cache, isFrom);
        this.refData = rec.getBinaryData(1);
        this.numRefs = rec.getIntValue(0);
        if (!isFrom) {
            this.refLevel = rec.getByteValue(2);
        }
        this.record = rec;
    }

    @Override
    protected boolean refresh() {
        return false;
    }

    byte[] getData() {
        return this.refData;
    }

    @Override
    void addRef(Address fromAddr, Address toAddr, RefType refType, int opIndex, long symbolID, boolean isPrimary, SourceType source, boolean isOffset, boolean isShift, long offsetOrShift) throws IOException {
        this.appendRef(fromAddr, toAddr, opIndex, refType, source, isPrimary, symbolID, isOffset, isShift, offsetOrShift);
        this.updateRecord();
    }

    synchronized void addRefs(Reference[] refs) throws IOException {
        for (int i = 0; i < refs.length; ++i) {
            boolean isPrimary = refs[i].isPrimary();
            long symbolID = refs[i].getSymbolID();
            boolean isOffset = false;
            boolean isShifted = false;
            long offsetOrShift = 0L;
            if (refs[i].isMemoryReference()) {
                MemReferenceDB memRef = (MemReferenceDB)refs[i];
                isOffset = memRef.isOffset();
                isShifted = memRef.isShifted();
                offsetOrShift = memRef.getOffsetOrShift();
            }
            this.appendRef(refs[i].getFromAddress(), refs[i].getToAddress(), refs[i].getOperandIndex(), refs[i].getReferenceType(), refs[i].getSource(), isPrimary, symbolID, isOffset, isShifted, offsetOrShift);
        }
        this.updateRecord();
    }

    private void appendRef(Address fromAddr, Address toAddr, int opIndex, RefType refType, SourceType source, boolean isPrimary, long symbolID, boolean isOffset, boolean isShifted, long offsetOrShift) {
        byte level;
        if (!this.isFrom && (level = RefListV0.getRefLevel(refType)) > this.refLevel) {
            this.refLevel = level;
        }
        byte[] bytes = this.encode(fromAddr, toAddr, refType, source, opIndex, symbolID, isPrimary, isOffset, isShifted, offsetOrShift);
        byte[] newData = new byte[this.refData.length + bytes.length];
        System.arraycopy(this.refData, 0, newData, 0, this.refData.length);
        System.arraycopy(bytes, 0, newData, this.refData.length, bytes.length);
        this.refData = newData;
        ++this.numRefs;
    }

    @Override
    synchronized Reference[] getAllRefs() {
        Reference[] refs = new Reference[this.numRefs];
        ReferenceIterator it = this.getRefs();
        for (int i = 0; i < this.numRefs; ++i) {
            refs[i] = it.next();
        }
        return refs;
    }

    @Override
    int getNumRefs() {
        return this.numRefs;
    }

    @Override
    boolean hasReference(int opIndex) {
        if (!this.isFrom) {
            return false;
        }
        ReferenceIterator it = this.getRefs();
        while (it.hasNext()) {
            Reference ref = it.next();
            if (ref.getOperandIndex() != opIndex) continue;
            return true;
        }
        return false;
    }

    @Override
    synchronized Reference getPrimaryRef(int opIndex) {
        if (!this.isFrom) {
            return null;
        }
        ReferenceIterator it = this.getRefs();
        while (it.hasNext()) {
            Reference ref = it.next();
            if (!ref.isPrimary() || ref.getOperandIndex() != opIndex) continue;
            return ref;
        }
        return null;
    }

    @Override
    synchronized ReferenceDB getRef(Address refAddress, int opIndex) {
        ReferenceIterator it = this.getRefs();
        while (it.hasNext()) {
            Address addr;
            Reference ref = it.next();
            if (ref.getOperandIndex() != opIndex || !refAddress.equals(addr = this.isFrom ? ref.getToAddress() : ref.getFromAddress())) continue;
            return (ReferenceDB)ref;
        }
        return null;
    }

    @Override
    synchronized ReferenceIterator getRefs() {
        return new RefIterator();
    }

    @Override
    boolean isEmpty() {
        return this.numRefs == 0;
    }

    @Override
    byte getReferenceLevel() {
        return this.refLevel;
    }

    @Override
    synchronized void removeAll() throws IOException {
        this.numRefs = 0;
        this.refData = EMPTY_DATA;
        if (this.adapter != null) {
            this.adapter.removeRecord(this.key);
        }
    }

    @Override
    synchronized boolean removeRef(Address deleteAddr, int opIndex) throws IOException {
        Reference[] result = new ReferenceDB[1];
        int pos = 0;
        int newPos = 0;
        for (int i = 0; i < this.numRefs; ++i) {
            newPos = this.decode(this.refData, pos, result);
            if (((ReferenceDB)result[0]).getOperandIndex() == opIndex) {
                Address addr;
                Address address = addr = this.isFrom ? ((ReferenceDB)result[0]).getToAddress() : ((ReferenceDB)result[0]).getFromAddress();
                if (deleteAddr.equals(addr)) {
                    byte[] newData = new byte[this.refData.length - (newPos - pos)];
                    System.arraycopy(this.refData, 0, newData, 0, pos);
                    System.arraycopy(this.refData, newPos, newData, pos, newData.length - pos);
                    --this.numRefs;
                    if (this.numRefs == 0) {
                        this.refData = EMPTY_DATA;
                        if (this.adapter != null) {
                            this.adapter.removeRecord(this.key);
                        }
                        this.setInvalid();
                    } else {
                        byte level;
                        this.refData = newData;
                        if (!this.isFrom && this.refLevel <= (level = RefListV0.getRefLevel(((ReferenceDB)result[0]).getReferenceType()))) {
                            this.refLevel = this.findHighestRefLevel(this.refLevel);
                        }
                        this.updateRecord();
                    }
                    return true;
                }
            }
            pos = newPos;
        }
        return false;
    }

    private byte findHighestRefLevel(byte currentRefLevel) {
        byte maxLevel = -1;
        ReferenceIterator it = this.getRefs();
        while (it.hasNext()) {
            Reference ref = it.next();
            byte level = RefListV0.getRefLevel(ref.getReferenceType());
            if (maxLevel < level) {
                maxLevel = level;
            }
            if (level <= currentRefLevel) continue;
            return level;
        }
        return maxLevel;
    }

    @Override
    synchronized boolean setPrimary(Reference ref, boolean isPrimary) throws IOException {
        int opIndex = ref.getOperandIndex();
        Address changeAddr = this.isFrom ? ref.getToAddress() : ref.getFromAddress();
        Reference[] result = new Reference[1];
        int pos = 0;
        int newPos = 0;
        for (int i = 0; i < this.numRefs; ++i) {
            newPos = this.decode(this.refData, pos, result);
            Reference r = result[0];
            if (r.getOperandIndex() == opIndex) {
                Address addr;
                Address address = addr = this.isFrom ? r.getToAddress() : r.getFromAddress();
                if (changeAddr.equals(addr)) {
                    if (isPrimary == r.isPrimary()) {
                        return false;
                    }
                    boolean isOffset = false;
                    boolean isShifted = false;
                    long offsetOrShift = 0L;
                    if (r.isMemoryReference()) {
                        isOffset = ((MemReferenceDB)r).isOffset();
                        isShifted = ((MemReferenceDB)r).isShifted();
                        offsetOrShift = ((MemReferenceDB)r).getOffsetOrShift();
                    }
                    byte[] bytes = this.encode(r.getFromAddress(), r.getToAddress(), r.getReferenceType(), r.getSource(), r.getOperandIndex(), r.getSymbolID(), isPrimary, isOffset, isShifted, offsetOrShift);
                    System.arraycopy(bytes, 0, this.refData, pos, bytes.length);
                    this.updateRecord();
                    return true;
                }
            }
            pos = newPos;
        }
        return false;
    }

    @Override
    synchronized boolean setSymbolID(Reference ref, long symbolID) throws IOException {
        int opIndex = ref.getOperandIndex();
        Address changeAddr = this.isFrom ? ref.getToAddress() : ref.getFromAddress();
        Reference[] result = new Reference[1];
        int pos = 0;
        int newPos = 0;
        for (int i = 0; i < this.numRefs; ++i) {
            newPos = this.decode(this.refData, pos, result);
            Reference r = result[0];
            if (r.getOperandIndex() == opIndex) {
                Address addr;
                Address address = addr = this.isFrom ? r.getToAddress() : r.getFromAddress();
                if (changeAddr.equals(addr)) {
                    byte[] bytes;
                    boolean isPrimary = ref.isPrimary();
                    boolean isOffset = false;
                    boolean isShifted = false;
                    long offsetOrShift = 0L;
                    if (r.isMemoryReference()) {
                        isOffset = ((MemReferenceDB)r).isOffset();
                        isShifted = ((MemReferenceDB)r).isShifted();
                        offsetOrShift = ((MemReferenceDB)r).getOffsetOrShift();
                    }
                    if ((bytes = this.encode(r.getFromAddress(), r.getToAddress(), r.getReferenceType(), r.getSource(), r.getOperandIndex(), symbolID, isPrimary, isOffset, isShifted, offsetOrShift)).length == newPos - pos) {
                        System.arraycopy(bytes, 0, this.refData, pos, bytes.length);
                    } else {
                        byte[] newData = new byte[this.refData.length - (newPos - pos) + bytes.length];
                        System.arraycopy(this.refData, 0, newData, 0, pos);
                        System.arraycopy(bytes, 0, newData, pos, bytes.length);
                        System.arraycopy(this.refData, newPos, newData, pos + bytes.length, this.refData.length - newPos);
                        this.refData = newData;
                    }
                    this.updateRecord();
                    return true;
                }
            }
            pos = newPos;
        }
        return false;
    }

    @Override
    synchronized void updateRefType(Address changeAddr, int opIndex, RefType refType) throws IOException {
        boolean updateRefLevel = false;
        byte newLevel = RefListV0.getRefLevel(refType);
        byte highestRefLevel = 0;
        if (!this.isFrom) {
            updateRefLevel = newLevel != this.refLevel;
        }
        Reference[] result = new Reference[1];
        int pos = 0;
        int newPos = 0;
        for (int i = 0; i < this.numRefs; ++i) {
            byte level;
            newPos = this.decode(this.refData, pos, result);
            Reference ref = result[0];
            if (ref.getOperandIndex() == opIndex) {
                Address addr;
                Address address = addr = this.isFrom ? ref.getToAddress() : ref.getFromAddress();
                if (changeAddr.equals(addr)) {
                    boolean isPrimary = ref.isPrimary();
                    long symbolID = ref.getSymbolID();
                    boolean isOffset = false;
                    boolean isShifted = false;
                    long offsetOrShift = 0L;
                    if (ref.isMemoryReference()) {
                        isOffset = ((MemReferenceDB)ref).isOffset();
                        isShifted = ((MemReferenceDB)ref).isShifted();
                        offsetOrShift = ((MemReferenceDB)ref).getOffsetOrShift();
                    }
                    byte[] bytes = this.encode(ref.getFromAddress(), ref.getToAddress(), refType, ref.getSource(), ref.getOperandIndex(), symbolID, isPrimary, isOffset, isShifted, offsetOrShift);
                    System.arraycopy(bytes, 0, this.refData, pos, bytes.length);
                    if (!updateRefLevel) break;
                    if (newLevel > this.refLevel) {
                        highestRefLevel = newLevel;
                        break;
                    }
                    if (newLevel > highestRefLevel) {
                        highestRefLevel = newLevel;
                    }
                }
            } else if (updateRefLevel && (level = RefListV0.getRefLevel(ref.getReferenceType())) > highestRefLevel) {
                highestRefLevel = level;
            }
            pos = newPos;
        }
        if (updateRefLevel) {
            this.refLevel = highestRefLevel;
        }
        this.updateRecord();
    }

    private void updateRecord() throws IOException {
        if (this.adapter != null) {
            this.record.setIntValue(0, this.numRefs);
            this.record.setBinaryData(1, this.refData);
            if (!this.isFrom) {
                this.record.setByteValue(2, this.refLevel);
            }
            this.adapter.putRecord(this.record);
        }
    }

    private byte[] encode(Address fromAddr, Address toAddr, RefType type, SourceType source, int opIndex, long symbolID, boolean isPrimary, boolean isOffsetRef, boolean isShiftRef, long offsetOrShift) {
        boolean hasSymbolID;
        int length = 11;
        boolean bl = hasSymbolID = symbolID >= 0L;
        if (isOffsetRef || isShiftRef) {
            length += 8;
        }
        if (hasSymbolID) {
            length += 8;
        }
        RefListFlagsV0 flags = new RefListFlagsV0(isPrimary, isOffsetRef, hasSymbolID, isShiftRef, source);
        byte[] data = new byte[length];
        Address addr = this.isFrom ? toAddr : fromAddr;
        int offset = RefListV0.putLong(data, 0, this.addrMap.getKey(addr, true));
        data[offset++] = flags.getValue();
        data[offset++] = type.getValue();
        data[offset++] = (byte)opIndex;
        if (hasSymbolID) {
            offset = RefListV0.putLong(data, offset, symbolID);
        }
        if (isOffsetRef || isShiftRef) {
            offset = RefListV0.putLong(data, offset, offsetOrShift);
        }
        return data;
    }

    private int decode(byte[] data, int offset, Reference[] result) {
        Address to;
        long symbolID = -1L;
        long addr = RefListV0.getLong(data, offset);
        offset += 8;
        RefListFlagsV0 flags = new RefListFlagsV0(data[offset++]);
        RefType refType = RefTypeFactory.get(data[offset++]);
        byte opIndex = data[offset++];
        SourceType source = flags.getSource();
        long offsetOrShift = 0L;
        if (flags.hasSymbolID()) {
            symbolID = RefListV0.getLong(data, offset);
            offset += 8;
        }
        Address from = this.isFrom ? this.address : this.addrMap.decodeAddress(addr);
        Address address = to = this.isFrom ? this.addrMap.decodeAddress(addr) : this.address;
        if (flags.isOffsetRef() || flags.isShiftRef()) {
            offsetOrShift = RefListV0.getLong(data, offset);
            offset += 8;
            result[0] = flags.isShiftRef() ? new ShiftedReferenceDB(this.program, from, to, refType, opIndex, source, flags.isPrimary(), symbolID, (int)offsetOrShift) : new OffsetReferenceDB(this.program, from, to, refType, opIndex, source, flags.isPrimary(), symbolID, offsetOrShift);
        } else {
            result[0] = to.isExternalAddress() ? new ExternalReferenceDB(this.program, from, to, refType, opIndex, source) : (from.equals(Address.EXT_FROM_ADDRESS) ? new EntryPointReferenceDB(from, to, refType, opIndex, source, flags.isPrimary(), symbolID) : (to.isStackAddress() ? new StackReferenceDB(this.program, from, to, refType, opIndex, source, flags.isPrimary(), symbolID) : new MemReferenceDB(this.program, from, to, refType, opIndex, source, flags.isPrimary(), symbolID)));
        }
        return offset;
    }

    public static int putLong(byte[] data, int offset, long v) {
        data[offset] = (byte)(v >> 56);
        data[++offset] = (byte)(v >> 48);
        data[++offset] = (byte)(v >> 40);
        data[++offset] = (byte)(v >> 32);
        data[++offset] = (byte)(v >> 24);
        data[++offset] = (byte)(v >> 16);
        data[++offset] = (byte)(v >> 8);
        data[++offset] = (byte)v;
        return ++offset;
    }

    public static long getLong(byte[] data, int offset) {
        return ((long)data[offset] & 0xFFL) << 56 | ((long)data[++offset] & 0xFFL) << 48 | ((long)data[++offset] & 0xFFL) << 40 | ((long)data[++offset] & 0xFFL) << 32 | ((long)data[++offset] & 0xFFL) << 24 | ((long)data[++offset] & 0xFFL) << 16 | ((long)data[++offset] & 0xFFL) << 8 | (long)data[++offset] & 0xFFL;
    }

    static byte getRefLevel(RefType rt) {
        if (rt == RefType.EXTERNAL_REF) {
            return 5;
        }
        if (rt.isCall()) {
            return 3;
        }
        if (rt.isData() || rt.isIndirect()) {
            return 1;
        }
        if (rt.isFlow()) {
            return 2;
        }
        return 0;
    }

    class RefIterator
    implements ReferenceIterator {
        byte[] data;
        int n;
        int pos = 0;
        int index = 0;
        Reference[] refs = new Reference[1];

        RefIterator() {
            this.data = RefListV0.this.refData;
            this.n = RefListV0.this.numRefs;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.n;
        }

        @Override
        public Reference next() {
            if (this.hasNext()) {
                this.pos = RefListV0.this.decode(this.data, this.pos, this.refs);
                ++this.index;
                return this.refs[0];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Reference> iterator() {
            return this;
        }
    }
}

