/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDB;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeComponentDB;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

class StructureDB
extends CompositeDB
implements Structure {
    private static OrdinalComparator ordinalComparator = new OrdinalComparator();
    private static OffsetComparator offsetComparator = new OffsetComparator();
    private static ComponentComparator componentComparator = new ComponentComparator();
    private int structLength;
    private int numComponents;
    private ArrayList<DataTypeComponentDB> components;
    private DataTypeComponentDB flexibleArrayComponent;

    public StructureDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, CompositeDBAdapter compositeAdapter, ComponentDBAdapter componentAdapter, Record record) {
        super(dataMgr, cache, compositeAdapter, componentAdapter, record);
    }

    @Override
    protected void initialize() {
        this.components = new ArrayList();
        try {
            long[] ids = this.componentAdapter.getComponentIdsInComposite(this.key);
            for (int i = 0; i < ids.length; ++i) {
                Record rec = this.componentAdapter.getRecord(ids[i]);
                DataTypeComponentDB component = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
                if (component.isFlexibleArrayComponent()) {
                    this.flexibleArrayComponent = component;
                    continue;
                }
                this.components.add(component);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        Collections.sort(this.components, componentComparator);
        this.structLength = this.record.getIntValue(4);
        this.numComponents = this.record.getIntValue(5);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Structure>";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DataType dataType, int length, String name, String comment, int numCopies) {
        this.lock.acquire();
        try {
            if (length < 1) {
                throw new IllegalArgumentException("Minimum component length is 1 byte");
            }
            for (int ii = 0; ii < numCopies; ++ii) {
                this.doAdd(dataType, length, name, comment, false, false);
            }
            this.adjustInternalAlignment(false);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String name, String comment) {
        if (length < 1) {
            throw new IllegalArgumentException("Minimum component length is 1 byte");
        }
        return this.doAdd(dataType, length, name, comment, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTypeComponent doAdd(DataType dataType, int length, String name, String comment, boolean notify, boolean align) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            DataTypeComponentDB dtc = null;
            try {
                boolean isFlexibleArray = false;
                if (dataType == DataType.DEFAULT) {
                    dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, this.key, this.numComponents, this.structLength);
                } else {
                    int offset = this.structLength;
                    int ordinal = this.numComponents;
                    boolean bl = isFlexibleArray = length == 0;
                    if (length == 0) {
                        offset = -1;
                        ordinal = -1;
                        isFlexibleArray = true;
                        this.clearFlexibleArrayComponent();
                    }
                    Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dataType), this.key, length, ordinal, offset, name, comment);
                    dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
                    dataType.addParent(this);
                    if (isFlexibleArray) {
                        this.flexibleArrayComponent = dtc;
                    } else {
                        this.components.add(dtc);
                    }
                }
                if (!isFlexibleArray) {
                    this.record.setIntValue(5, ++this.numComponents);
                    this.structLength += dtc.getLength();
                    this.record.setIntValue(4, this.structLength);
                    this.compositeAdapter.updateRecord(this.record, true);
                }
                if (align) {
                    this.adjustInternalAlignment(false);
                }
                if (notify) {
                    this.notifySizeChanged();
                }
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void growStructure(int amount) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (!this.isInternallyAligned()) {
                this.doGrowStructure(amount);
            }
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    private void doGrowStructure(int amount) {
        if (!this.isInternallyAligned()) {
            this.numComponents += amount;
        }
        this.record.setIntValue(5, this.numComponents);
        this.structLength += amount;
        this.record.setIntValue(4, this.structLength);
        try {
            this.compositeAdapter.updateRecord(this.record, true);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal < 0 || ordinal > this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            if (ordinal == this.numComponents) {
                DataTypeComponent dataTypeComponent = this.add(dataType, length, name, comment);
                return dataTypeComponent;
            }
            this.validateDataType(dataType);
            if (length < 1) {
                throw new IllegalArgumentException("Minimum component length is 1 byte");
            }
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            int idx = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
            if (idx < 0) {
                idx = -idx - 1;
            }
            if (dataType == DataType.DEFAULT) {
                this.shiftOffsets(idx, 1, 1);
                this.notifySizeChanged();
                DataTypeComponent dataTypeComponent = this.getComponent(ordinal);
                return dataTypeComponent;
            }
            int dtLength = dataType.getLength();
            if (dtLength > 0 && dtLength < length) {
                length = dtLength;
            }
            int offset = this.getComponent(ordinal).getOffset();
            Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dataType), this.key, length, ordinal, offset, name, comment);
            DataTypeComponentDB dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            dataType.addParent(this);
            this.shiftOffsets(idx, 1, dtc.getLength());
            this.components.add(idx, dtc);
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(int ordinal, DataType dataType, int length, String name, String comment, int numCopies) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal < 0 || ordinal > this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            if (ordinal == this.numComponents) {
                this.add(dataType, length, name, comment, numCopies);
                return;
            }
            for (int ii = 0; ii < numCopies; ++ii) {
                this.insert(ordinal + ii, dataType, length, name, comment);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int ordinal) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            int idx = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
            if (idx >= 0) {
                DataTypeComponentDB dtc = this.components.remove(idx);
                dtc.getDataType().removeParent(this);
                try {
                    this.componentAdapter.removeRecord(dtc.getKey());
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
                this.shiftOffsets(idx, -1, -dtc.getLength());
                this.adjustInternalAlignment(true);
                this.notifySizeChanged();
                return;
            }
            idx = -idx - 1;
            this.shiftOffsets(idx, -1, -1);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int[] ordinals) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            for (int ordinal : ordinals) {
                if (ordinal >= 0 && ordinal < this.numComponents) continue;
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            for (int ordinal : ordinals) {
                int idx = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
                if (idx >= 0) {
                    DataTypeComponentDB dtc = this.components.remove(idx);
                    dtc.getDataType().removeParent(this);
                    try {
                        this.componentAdapter.removeRecord(dtc.getKey());
                    }
                    catch (IOException e) {
                        this.dataMgr.dbError(e);
                    }
                    this.shiftOffsets(idx, -1, -dtc.getLength());
                    continue;
                }
                idx = -idx - 1;
                this.shiftOffsets(idx, -1, -1);
            }
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPartOf(DataType dataType) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.equals(dataType)) {
                boolean bl = true;
                return bl;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponent dtc = this.components.get(i);
                DataType subDt = dtc.getDataType();
                if (subDt instanceof Composite) {
                    if (!((Composite)subDt).isPartOf(dataType)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!subDt.equals(dataType)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.numComponents;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumDefinedComponents() {
        this.lock.acquire();
        try {
            int n = this.components.size();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent getComponent(int ordinal) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (ordinal == this.numComponents && this.flexibleArrayComponent != null) {
                DataTypeComponentDB dataTypeComponentDB = this.flexibleArrayComponent;
                return dataTypeComponentDB;
            }
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            if (this.isInternallyAligned()) {
                DataTypeComponent dataTypeComponent = this.components.get(ordinal);
                return dataTypeComponent;
            }
            int idx = Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
            if (idx >= 0) {
                DataTypeComponent dataTypeComponent = this.components.get(idx);
                return dataTypeComponent;
            }
            int offset = 0;
            if ((idx = -idx - 1) == 0) {
                offset = ordinal;
            } else {
                DataTypeComponent dtc = this.components.get(idx - 1);
                offset = dtc.getEndOffset() + ordinal - dtc.getOrdinal();
            }
            DataTypeComponentDB dataTypeComponentDB = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, this.key, ordinal, offset);
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent[] getComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataTypeComponent[] comps = new DataTypeComponent[this.numComponents];
            for (int i = 0; i < comps.length; ++i) {
                comps[i] = this.getComponent(i);
            }
            DataTypeComponent[] dataTypeComponentArray = comps;
            return dataTypeComponentArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        StructureDataType struct = new StructureDataType(this.getCategoryPath(), this.getName(), this.getLength(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        StructureDataType struct = new StructureDataType(this.getCategoryPath(), this.getName(), this.getLength(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public boolean isNotYetDefined() {
        return this.structLength == 0 && this.flexibleArrayComponent == null;
    }

    @Override
    public int getLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.structLength == 0) {
                int n = 1;
                return n;
            }
            int n = this.structLength;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearComponent(int ordinal) {
        block7: {
            this.lock.acquire();
            try {
                this.checkDeleted();
                if (ordinal < 0 || ordinal >= this.numComponents) {
                    throw new ArrayIndexOutOfBoundsException(ordinal);
                }
                int idx = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
                if (idx < 0) break block7;
                DataTypeComponentDB dtc = this.components.remove(idx);
                dtc.getDataType().removeParent(this);
                try {
                    this.componentAdapter.removeRecord(dtc.getKey());
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
                int len = dtc.getLength();
                if (len > 1) {
                    this.shiftOffsets(idx, len - 1, 0);
                }
                this.adjustInternalAlignment(true);
                this.dataMgr.dataTypeChanged(this);
            }
            finally {
                this.lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAtOffset(int offset) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (offset < 0) {
                throw new IllegalArgumentException("Offset cannot be negative.");
            }
            int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
            int delta = -1;
            if (index < 0) {
                index = -index - 1;
            } else {
                DataTypeComponentDB dtc = this.components.remove(index);
                dtc.getDataType().removeParent(this);
                try {
                    this.componentAdapter.removeRecord(dtc.getKey());
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
                delta = -dtc.getLength();
            }
            this.shiftOffsets(index, -1, delta);
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent getComponentAt(int offset) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (offset >= this.structLength || offset < 0) {
                DataTypeComponent dataTypeComponent = null;
                return dataTypeComponent;
            }
            int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
            if (index >= 0) {
                DataTypeComponent dataTypeComponent = this.components.get(index);
                return dataTypeComponent;
            }
            if (this.isInternallyAligned()) {
                DataTypeComponent dataTypeComponent = null;
                return dataTypeComponent;
            }
            index = -index - 1;
            int ordinal = offset;
            if (index > 0) {
                DataTypeComponent dtc = this.components.get(index - 1);
                ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
            }
            DataTypeComponentDB dataTypeComponentDB = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, this.key, ordinal, offset);
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent getDataTypeAt(int offset) {
        this.lock.acquire();
        try {
            DataType dt;
            DataTypeComponent dtc = this.getComponentAt(offset);
            if (dtc != null && (dt = dtc.getDataType()) instanceof Structure) {
                DataTypeComponent dataTypeComponent = ((Structure)dt).getDataTypeAt(offset - dtc.getOffset());
                return dataTypeComponent;
            }
            DataTypeComponent dataTypeComponent = dtc;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent[] getDefinedComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataTypeComponent[] dataTypeComponentArray = this.components.toArray(new DataTypeComponent[this.components.size()]);
            return dataTypeComponentArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insertAtOffset(int offset, DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            DataTypeComponentDB dtc;
            this.checkDeleted();
            if (offset < 0) {
                throw new IllegalArgumentException("Offset cannot be negative.");
            }
            this.validateDataType(dataType);
            if (length < 1) {
                throw new IllegalArgumentException("Minimum component length is 1 byte");
            }
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            if (offset > this.structLength && !this.isInternallyAligned()) {
                this.numComponents += offset - this.structLength;
                this.structLength = offset;
            }
            int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
            int additionalShift = 0;
            if (index >= 0) {
                DataTypeComponentDB dtc2 = this.components.get(index);
                additionalShift = offset - dtc2.getOffset();
            } else {
                index = -index - 1;
            }
            int ordinal = offset;
            if (index > 0) {
                dtc = this.components.get(index - 1);
                ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
            }
            if (dataType == DataType.DEFAULT) {
                this.shiftOffsets(index, 1 + additionalShift, 1 + additionalShift);
                this.adjustInternalAlignment(true);
                this.notifySizeChanged();
                dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, this.key, ordinal, offset);
                return dtc;
            }
            int dtLength = dataType.getLength();
            if (dtLength > 0 && dtLength < length) {
                length = dtLength;
            }
            Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dataType), this.key, length, ordinal, offset, name, comment);
            dataType.addParent(this);
            DataTypeComponentDB dtc3 = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            this.shiftOffsets(index, 1 + additionalShift, dtc3.getLength() + additionalShift);
            this.components.add(index, dtc3);
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
            DataTypeComponentDB dataTypeComponentDB = dtc3;
            return dataTypeComponentDB;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public DataTypeComponent insertAtOffset(int offset, DataType dataType, int length) {
        return this.insertAtOffset(offset, dataType, length, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent replace(int ordinal, DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(ordinal);
            }
            this.validateDataType(dataType);
            if (length < 1) {
                throw new IllegalArgumentException("Minimum component length is 1 byte");
            }
            if (dataType == DataType.DEFAULT) {
                this.clearComponent(ordinal);
                DataTypeComponent dataTypeComponent = this.getComponent(ordinal);
                return dataTypeComponent;
            }
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            DataTypeComponent origDtc = this.getComponent(ordinal);
            DataTypeComponent replaceComponent = this.replaceComponent(origDtc, dataType, length, name, comment, true);
            this.adjustInternalAlignment(true);
            DataTypeComponent dataTypeComponent = replaceComponent;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent replace(int ordinal, DataType dataType, int length) {
        return this.replace(ordinal, dataType, length, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent replaceAtOffset(int offset, DataType dataType, int length, String name, String comment) {
        if (offset >= this.getLength()) {
            throw new IllegalArgumentException("Can't replace at an offset that doesn't exist in the structure");
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            DataTypeComponent replaceComponent = this.doReplace(offset, dataType, length, name, comment, true);
            this.adjustInternalAlignment(true);
            DataTypeComponent dataTypeComponent = replaceComponent;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Structure)) {
            throw new IllegalArgumentException();
        }
        this.doReplaceWith((Structure)dataType, true);
    }

    void doReplaceWith(Structure struct, boolean notify) {
        this.doReplaceWith(struct, notify, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReplaceWith(Structure struct, boolean notify, DataTypeConflictHandler handler) {
        this.lock.acquire();
        try {
            DataTypeComponent dtc;
            int i;
            this.checkDeleted();
            int oldLength = this.structLength;
            long oldMinAlignment = this.getMinimumAlignment();
            for (int i2 = 0; i2 < this.components.size(); ++i2) {
                DataTypeComponentDB dtc2 = this.components.get(i2);
                dtc2.getDataType().removeParent(this);
                this.componentAdapter.removeRecord(dtc2.getKey());
            }
            this.components.clear();
            if (this.flexibleArrayComponent != null) {
                this.flexibleArrayComponent.getDataType().removeParent(this);
                this.componentAdapter.removeRecord(this.flexibleArrayComponent.getKey());
                this.flexibleArrayComponent = null;
            }
            if (struct.isNotYetDefined()) {
                this.numComponents = 0;
                this.structLength = 0;
            } else {
                this.structLength = struct.getLength();
                this.numComponents = this.isInternallyAligned() ? 0 : this.structLength;
            }
            this.setAlignment(struct, false);
            this.setDescription(struct.getDescription());
            DataTypeComponent[] otherComponents = struct.getDefinedComponents();
            for (i = 0; i < otherComponents.length; ++i) {
                dtc = otherComponents[i];
                DataType dt = dtc.getDataType();
                if (dt == null) {
                    Msg.warn((Object)this, (Object)("Data type IS NULL: in " + struct.getPathName() + " component " + i));
                    continue;
                }
                dt = this.resolve(dt, handler);
                if (this.isInternallyAligned()) {
                    this.doAdd(dt, dtc.getLength(), dtc.getFieldName(), dtc.getComment(), false, true);
                    continue;
                }
                this.doReplace(dtc.getOffset(), dt, dtc.getLength(), dtc.getFieldName(), dtc.getComment(), false);
            }
            for (i = 0; i < this.components.size(); ++i) {
                int n;
                dtc = this.components.get(i);
                DataType dataType = dtc.getDataType();
                if (dataType.getLength() <= dtc.getLength() || (n = this.consumeBytesAfter(i, dataType.getLength() - dtc.getLength())) <= 0) continue;
                this.shiftOffsets(i + 1, 0 - n, 0);
            }
            DataTypeComponent flexComponent = struct.getFlexibleArrayComponent();
            if (flexComponent != null) {
                DataType dt = flexComponent.getDataType();
                if (dt == null) {
                    Msg.warn((Object)this, (Object)("Data type IS NULL: in " + struct.getPathName() + " flexible array component"));
                } else {
                    dt = this.resolve(dt, handler);
                    this.doAdd(dt, 0, flexComponent.getFieldName(), flexComponent.getComment(), false, true);
                }
            }
            this.record.setIntValue(5, this.numComponents);
            this.record.setIntValue(4, this.structLength);
            this.compositeAdapter.updateRecord(this.record, false);
            if (notify) {
                if (oldMinAlignment != (long)this.getMinimumAlignment()) {
                    this.notifyAlignmentChanged();
                } else if (oldLength != this.structLength) {
                    this.notifySizeChanged();
                } else {
                    this.dataMgr.dataTypeChanged(this);
                }
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeDeleted(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            boolean didChange = false;
            int n = this.components.size();
            for (int i = n - 1; i >= 0; --i) {
                DataTypeComponentDB dtc = this.components.get(i);
                if (dtc.getDataType() != dt) continue;
                dt.removeParent(this);
                this.components.remove(i);
                this.shiftOffsets(i, dtc.getLength() - 1, 0);
                try {
                    this.componentAdapter.removeRecord(dtc.getKey());
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
                didChange = true;
            }
            if (didChange) {
                this.adjustInternalAlignment(true);
                this.dataMgr.dataTypeChanged(this);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeSizeChanged(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.isInternallyAligned()) {
                this.adjustInternalAlignment(true);
                return;
            }
            int n = this.components.size();
            boolean didChange = false;
            for (int i = 0; i < n; ++i) {
                int consumed;
                int dtcLen;
                DataTypeComponentDB dtc = this.components.get(i);
                if (dtc.getDataType() != dt) continue;
                int dtLen = dt.getLength();
                if (dtLen < (dtcLen = dtc.getLength())) {
                    dtc.setLength(dtLen, true);
                    this.shiftOffsets(i + 1, dtcLen - dtLen, 0);
                    didChange = true;
                    continue;
                }
                if (dtLen <= dtcLen || (consumed = this.consumeBytesAfter(i, dtLen - dtcLen)) <= 0) continue;
                dtc.updateRecord();
                this.shiftOffsets(i + 1, -consumed, 0);
                didChange = true;
            }
            if (didChange) {
                this.adjustInternalAlignment(true);
                this.notifySizeChanged();
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.adjustInternalAlignment(true);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isEquivalent(DataType dataType) {
        int otherNumComps;
        if (dataType == this) {
            return true;
        }
        if (dataType == null || !(dataType instanceof Structure)) {
            return false;
        }
        this.checkIsValid();
        if (this.resolving) {
            if (dataType.getUniversalID().equals((Object)this.getUniversalID())) {
                return true;
            }
            return DataTypeUtilities.equalsIgnoreConflict(this.getPathName(), dataType.getPathName());
        }
        Structure struct = (Structure)dataType;
        if (this.isInternallyAligned() != struct.isInternallyAligned() || this.isDefaultAligned() != struct.isDefaultAligned() || this.isMachineAligned() != struct.isMachineAligned() || this.getMinimumAlignment() != struct.getMinimumAlignment() || this.getPackingValue() != struct.getPackingValue() || !this.isInternallyAligned() && this.getLength() != struct.getLength()) {
            return false;
        }
        DataTypeComponent myFlexComp = this.getFlexibleArrayComponent();
        DataTypeComponent otherFlexComp = struct.getFlexibleArrayComponent();
        if (myFlexComp != null ? otherFlexComp == null || !myFlexComp.isEquivalent(otherFlexComp) : otherFlexComp != null) {
            return false;
        }
        int myNumComps = this.getNumComponents();
        if (myNumComps != (otherNumComps = struct.getNumComponents())) {
            return false;
        }
        for (int i = 0; i < myNumComps; ++i) {
            DataTypeComponent otherDtc;
            DataTypeComponent myDtc = this.getComponent(i);
            if (myDtc.isEquivalent(otherDtc = struct.getComponent(i))) continue;
            return false;
        }
        return true;
    }

    private int consumeBytesAfter(int definedComponentIndex, int numBytes) {
        int available;
        DataTypeComponentDB thisDtc = this.components.get(definedComponentIndex);
        int thisLen = thisDtc.getLength();
        int nextOffset = thisDtc.getOffset() + thisLen;
        if (definedComponentIndex == this.components.size() - 1) {
            available = this.structLength - nextOffset;
            if (numBytes > available) {
                this.doGrowStructure(numBytes - available);
                available = numBytes;
            }
        } else {
            DataTypeComponent nextDtc = this.components.get(definedComponentIndex + 1);
            available = nextDtc.getOffset() - nextOffset;
        }
        if (numBytes <= available) {
            thisDtc.setLength(thisLen + numBytes, true);
            return numBytes;
        }
        thisDtc.setLength(thisLen + available, true);
        return available;
    }

    private int getLastDefinedComponentIndex() {
        if (this.components.size() == 0) {
            return 0;
        }
        DataTypeComponentDB dataTypeComponentDB = this.components.get(this.components.size() - 1);
        return dataTypeComponentDB.getOrdinal();
    }

    private void shiftOffsets(int definedComponentIndex, int deltaOrdinal, int deltaOffset) {
        for (int i = definedComponentIndex; i < this.components.size(); ++i) {
            DataTypeComponentDB dtc = this.components.get(i);
            dtc.setOffset(dtc.getOffset() + deltaOffset, false);
            dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal, false);
            dtc.updateRecord();
        }
        this.structLength += deltaOffset;
        if (!this.isInternallyAligned()) {
            this.numComponents += deltaOrdinal;
        }
        this.record.setIntValue(5, this.numComponents);
        this.record.setIntValue(4, this.structLength);
        try {
            this.compositeAdapter.updateRecord(this.record, true);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    private DataTypeComponent doReplace(int offset, DataType dataType, int length, String name, String comment, boolean doNotify) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        this.validateDataType(dataType);
        if (length < 1) {
            throw new IllegalArgumentException("Minimum component length is 1 byte");
        }
        dataType = this.resolve(dataType);
        this.checkAncestry(dataType);
        int dtLength = dataType.getLength();
        if (dtLength > 0 && dtLength < length) {
            length = dtLength;
        }
        DataTypeComponent origDtc = this.getComponentAt(offset);
        if (dataType == DataType.DEFAULT) {
            int ordinal = origDtc.getOrdinal();
            this.clearComponent(ordinal);
            return this.getComponent(ordinal);
        }
        return this.replaceComponent(origDtc, dataType, length, name, comment, doNotify);
    }

    private DataTypeComponent replaceComponent(DataTypeComponent origDtc, DataType resolvedDataType, int length, String name, String comment, boolean doNotify) {
        try {
            int bytesAvailable;
            int ordinal = origDtc.getOrdinal();
            int newOffset = origDtc.getOffset();
            int dtcLength = origDtc.getLength();
            int bytesNeeded = length - dtcLength;
            int deltaOrdinal = -bytesNeeded;
            int origStructLength = this.structLength;
            if (!this.isInternallyAligned() && bytesNeeded > 0 && (bytesAvailable = this.getNumUndefinedBytes(ordinal + 1)) < bytesNeeded) {
                if (ordinal == this.getLastDefinedComponentIndex()) {
                    this.growStructure(bytesNeeded - bytesAvailable);
                } else {
                    throw new IllegalArgumentException("Not enough undefined bytes to fit " + resolvedDataType.getPathName() + " in structure " + this.getPathName() + " at offset 0x" + Integer.toHexString(newOffset) + ". It needs " + (bytesNeeded - bytesAvailable) + " more byte(s) to be able to fit.");
                }
            }
            Record rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(resolvedDataType), this.key, length, ordinal, newOffset, name, comment);
            resolvedDataType.addParent(this);
            DataTypeComponentDB newDtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            int index = this.isInternallyAligned() ? ordinal : Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
            if (index < 0) {
                index = -index - 1;
            } else {
                DataTypeComponentDB dataTypeComponentDB = this.components.get(index);
                dataTypeComponentDB.getDataType().removeParent(this);
                DataTypeComponentDB dtc = this.components.remove(index);
                this.componentAdapter.removeRecord(dtc.getKey());
            }
            this.components.add(index, newDtc);
            if (deltaOrdinal != 0) {
                this.shiftOffsets(index + 1, deltaOrdinal, 0);
            }
            if (this.structLength != origStructLength) {
                this.record.setIntValue(4, this.structLength);
                this.compositeAdapter.updateRecord(this.record, true);
                this.adjustInternalAlignment(false);
                this.notifySizeChanged();
            } else if (doNotify) {
                this.dataMgr.dataTypeChanged(this);
            }
            return newDtc;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            return null;
        }
    }

    private int getNumUndefinedBytes(int ordinal) {
        if (this.isInternallyAligned()) {
            return 0;
        }
        if (ordinal >= this.numComponents) {
            return 0;
        }
        int idx = Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator);
        DataTypeComponentDB dtc = null;
        if (idx < 0) {
            if ((idx = -idx - 1) >= this.components.size()) {
                return this.numComponents - ordinal;
            }
            dtc = this.components.get(idx);
            return dtc.getOrdinal() - ordinal;
        }
        return 0;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (oldDt == this) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            try {
                this.validateDataType(newDt);
                if (!(newDt instanceof DataTypeDB) || newDt.getDataTypeManager() != this.getDataTypeManager()) {
                    newDt = this.resolve(newDt);
                }
                this.checkAncestry(newDt);
            }
            catch (Exception e) {
                newDt = DataType.DEFAULT;
            }
            boolean changed = false;
            int nextIndex = 0;
            Iterator<DataTypeComponentDB> it = this.components.iterator();
            while (it.hasNext()) {
                ++nextIndex;
                DataTypeComponentDB comp = it.next();
                DataType compDt = comp.getDataType();
                if (oldDt != compDt) continue;
                oldDt.removeParent(this);
                comp.setDataType(newDt);
                newDt.addParent(this);
                int len = newDt.getLength();
                int oldLen = comp.getLength();
                if (len > 0) {
                    if (len < oldLen) {
                        comp.setLength(len, true);
                        this.shiftOffsets(nextIndex, oldLen - len, 0);
                    } else if (len > oldLen) {
                        int bytesNeeded = len - oldLen;
                        int bytesAvailable = this.getNumUndefinedBytes(comp.getOrdinal() + 1);
                        if (bytesNeeded <= bytesAvailable) {
                            comp.setLength(len, true);
                            this.shiftOffsets(nextIndex, -bytesNeeded, 0);
                        } else if (comp.getOrdinal() == this.getLastDefinedComponentIndex()) {
                            this.doGrowStructure(bytesNeeded - bytesAvailable);
                            comp.setLength(len, true);
                            this.shiftOffsets(nextIndex, -bytesNeeded, 0);
                        } else {
                            comp.setLength(oldLen + bytesAvailable, true);
                            this.shiftOffsets(nextIndex, -bytesAvailable, 0);
                        }
                    }
                }
                changed = true;
            }
            if (changed) {
                this.notifySizeChanged();
            }
        }
        finally {
            this.lock.release();
        }
        this.adjustInternalAlignment(true);
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.flexibleArrayComponent != null) {
                try {
                    this.componentAdapter.removeRecord(this.flexibleArrayComponent.getKey());
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
                this.flexibleArrayComponent = null;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponentDB dtc = this.components.get(i);
                dtc.getDataType().removeParent(this);
                try {
                    this.componentAdapter.removeRecord(dtc.getKey());
                    continue;
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
            }
            this.components.clear();
            this.structLength = 0;
            this.numComponents = 0;
            this.record.setIntValue(4, 0);
            this.record.setIntValue(5, 0);
            try {
                this.compositeAdapter.updateRecord(this.record, true);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean adjustComponents(boolean notify) {
        boolean internallyAligned = this.isInternallyAligned();
        boolean keepDefinedDefaults = !internallyAligned;
        this.lock.acquire();
        try {
            this.checkDeleted();
            int oldLength = this.structLength;
            if (!this.isInternallyAligned()) {
                boolean changed = this.adjustUnalignedComponents();
                if (notify && changed) {
                    this.dataMgr.dataTypeChanged(this);
                }
                boolean bl = changed;
                return bl;
            }
            boolean compositeDBChanged = false;
            boolean componentsDBChanged = false;
            int packingAlignment = this.getPackingValue();
            int currentOrdinal = 0;
            int currentOffset = 0;
            int allComponentsLCM = 1;
            for (DataTypeComponentDB dataTypeComponent : this.components) {
                DataType componentDt = dataTypeComponent.getDataType();
                if (!keepDefinedDefaults && DataType.DEFAULT == componentDt) continue;
                int componentLength = dataTypeComponent.getLength();
                int componentOrdinal = dataTypeComponent.getOrdinal();
                int componentOffset = dataTypeComponent.getOffset();
                int dtLength = componentDt.getLength();
                if (dtLength <= 0) {
                    dtLength = componentLength;
                }
                int componentAlignment = this.getPackedAlignment(componentDt, dtLength, packingAlignment);
                allComponentsLCM = DataOrganizationImpl.getLeastCommonMultiple(allComponentsLCM, componentAlignment);
                int newOffset = DataOrganizationImpl.getOffset(componentAlignment, currentOffset);
                currentOffset = newOffset + dtLength;
                if (componentOrdinal == currentOrdinal && componentOffset == newOffset && componentLength == dtLength) {
                    ++currentOrdinal;
                    continue;
                }
                dataTypeComponent.setOffset(newOffset, false);
                dataTypeComponent.setOrdinal(currentOrdinal, false);
                dataTypeComponent.setLength(dtLength, false);
                dataTypeComponent.updateRecord();
                ++currentOrdinal;
                componentsDBChanged = true;
            }
            if (this.flexibleArrayComponent != null) {
                DataType dataType = this.flexibleArrayComponent.getDataType();
                int componentAlignment = this.getPackedAlignment(dataType, dataType.getLength(), packingAlignment);
                currentOffset = DataOrganizationImpl.getOffset(componentAlignment, currentOffset);
                allComponentsLCM = DataOrganizationImpl.getLeastCommonMultiple(allComponentsLCM, componentAlignment);
            }
            compositeDBChanged = this.updateComposite(currentOrdinal, currentOffset, false);
            boolean addedPadding = this.alignEndOfStruct(allComponentsLCM);
            if (notify && (componentsDBChanged || compositeDBChanged || addedPadding)) {
                if (oldLength != this.structLength) {
                    this.notifySizeChanged();
                } else {
                    this.dataMgr.dataTypeChanged(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    private int getPackedAlignment(DataType componentDt, int dtLength, int packingAlignment) {
        boolean componentForcingAlignment;
        DataOrganization dataOrganization = this.getDataOrganization();
        int componentAlignment = dataOrganization.getAlignment(componentDt, dtLength);
        int componentForcedAlignment = dataOrganization.getForcedAlignment(componentDt);
        boolean bl = componentForcingAlignment = componentForcedAlignment > 0;
        if (componentForcingAlignment) {
            componentAlignment = DataOrganizationImpl.getLeastCommonMultiple(componentAlignment, componentForcedAlignment);
        }
        if (packingAlignment > 0) {
            if (componentForcedAlignment > packingAlignment) {
                componentAlignment = componentForcedAlignment;
            } else if (componentAlignment > packingAlignment) {
                componentAlignment = packingAlignment;
            }
        }
        return componentAlignment;
    }

    private boolean adjustUnalignedComponents() {
        boolean changed = false;
        int currentOrdinal = 0;
        int componentCount = 0;
        int currentOffset = 0;
        for (DataTypeComponentDB dataTypeComponent : this.components) {
            int componentLength = dataTypeComponent.getLength();
            int componentOffset = dataTypeComponent.getOffset();
            int numUndefinedsBefore = componentOffset - currentOffset;
            componentCount += numUndefinedsBefore;
            currentOffset += numUndefinedsBefore;
            ++componentCount;
            currentOffset += componentLength;
            if (dataTypeComponent.getOrdinal() != (currentOrdinal += numUndefinedsBefore)) {
                dataTypeComponent.setOrdinal(currentOrdinal, true);
                changed = true;
            }
            ++currentOrdinal;
        }
        int numUndefinedsAfter = this.structLength - currentOffset;
        if (this.updateNumComponents(componentCount += numUndefinedsAfter)) {
            changed = true;
        }
        return changed;
    }

    private boolean updateNumComponents(int currentNumComponents) {
        boolean compositeChanged = false;
        if (this.numComponents != currentNumComponents) {
            this.numComponents = currentNumComponents;
            this.record.setIntValue(5, this.numComponents);
            compositeChanged = true;
        }
        if (compositeChanged) {
            try {
                this.compositeAdapter.updateRecord(this.record, true);
                return true;
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
        return false;
    }

    private boolean updateComposite(int currentNumComponents, int currentLength, boolean setLastChangeTime) {
        boolean compositeChanged = false;
        if (this.numComponents != currentNumComponents) {
            this.numComponents = currentNumComponents;
            this.record.setIntValue(5, this.numComponents);
            compositeChanged = true;
        }
        if (this.structLength != currentLength) {
            this.structLength = currentLength;
            this.record.setIntValue(4, this.structLength);
            compositeChanged = true;
        }
        if (compositeChanged) {
            try {
                this.compositeAdapter.updateRecord(this.record, setLastChangeTime);
                return true;
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
        return false;
    }

    private boolean alignEndOfStruct(int componentLCM) {
        int padSize;
        int minimumAlignment = this.getMinimumAlignment();
        int structureLength = this.getLength();
        if (structureLength == 0) {
            return true;
        }
        int overallAlignment = componentLCM;
        if (minimumAlignment > overallAlignment) {
            overallAlignment = minimumAlignment;
        }
        if ((padSize = DataOrganizationImpl.getPaddingSize(overallAlignment, this.structLength)) > 0) {
            this.doGrowStructure(padSize);
            return true;
        }
        return false;
    }

    @Override
    public void realign() {
        if (this.isInternallyAligned()) {
            this.adjustInternalAlignment(true);
        }
    }

    @Override
    public void pack(int packingSize) throws InvalidInputException {
        this.setPackingValue(packingSize);
    }

    @Override
    protected void adjustInternalAlignment(boolean notify) {
        this.adjustComponents(notify);
    }

    @Override
    public boolean hasFlexibleArrayComponent() {
        return this.flexibleArrayComponent != null;
    }

    @Override
    public DataTypeComponent getFlexibleArrayComponent() {
        return this.flexibleArrayComponent;
    }

    @Override
    public DataTypeComponent setFlexibleArrayComponent(DataType flexType, String name, String comment) {
        return this.doAdd(flexType, 0, name, comment, true, true);
    }

    @Override
    public void clearFlexibleArrayComponent() {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.flexibleArrayComponent == null) {
                return;
            }
            DataTypeComponentDB dtc = this.flexibleArrayComponent;
            this.flexibleArrayComponent = null;
            dtc.getDataType().removeParent(this);
            try {
                this.componentAdapter.removeRecord(dtc.getKey());
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            this.adjustInternalAlignment(true);
            this.notifySizeChanged();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected void dumpComponents(StringBuilder buffer, String pad) {
        super.dumpComponents(buffer, pad);
        DataTypeComponent dtc = this.getFlexibleArrayComponent();
        if (dtc != null) {
            DataType dataType = dtc.getDataType();
            buffer.append(pad + dataType.getDisplayName() + "[0]");
            buffer.append(pad + dtc.getLength());
            buffer.append(pad + dtc.getFieldName());
            String comment = dtc.getComment();
            if (comment == null) {
                comment = "";
            }
            buffer.append(pad + "\"" + comment + "\"");
            buffer.append("\n");
        }
    }

    private static class ComponentComparator
    implements Comparator<DataTypeComponent> {
        private ComponentComparator() {
        }

        @Override
        public int compare(DataTypeComponent dtc1, DataTypeComponent dtc2) {
            return dtc1.getOrdinal() - dtc2.getOrdinal();
        }
    }

    private static class OrdinalComparator
    implements Comparator<Object> {
        private OrdinalComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                return -this.compare(o2, o1);
            }
            DataTypeComponent dtc = (DataTypeComponent)o1;
            int ordinal = (Integer)o2;
            return dtc.getOrdinal() - ordinal;
        }
    }

    private static class OffsetComparator
    implements Comparator<Object> {
        private OffsetComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                return -this.compare(o2, o1);
            }
            DataTypeComponent dtc = (DataTypeComponent)o1;
            int offset = (Integer)o2;
            if (offset < dtc.getOffset()) {
                return 1;
            }
            if (offset > dtc.getEndOffset()) {
                return -1;
            }
            return 0;
        }
    }
}

