/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.SettingsDB;
import ghidra.program.database.data.SettingsDBAdapter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

class SettingsDBManager
implements Settings {
    private DataTypeManagerDB dataMgr;
    private long dataTypeID;
    private SettingsDBAdapter adapter;
    private DataType dataType;
    private DataTypeComponent dtc;

    public SettingsDBManager(DataTypeManagerDB dataMgr, DataType dataType, long dataTypeID) {
        this.dataMgr = dataMgr;
        this.dataType = dataType;
        this.dataTypeID = dataTypeID;
        this.adapter = dataMgr.getSettingsAdapter();
    }

    public SettingsDBManager(DataTypeManagerDB dataMgr, DataTypeComponent dtc, long dataTypeID) {
        this.dataMgr = dataMgr;
        this.dtc = dtc;
        this.dataType = dtc.getDataType();
        this.dataTypeID = dataTypeID;
        this.adapter = dataMgr.getSettingsAdapter();
    }

    private void settingsChanged() {
        if (this.dtc != null) {
            this.dataMgr.dataTypeChanged(this.dtc.getParent());
        } else {
            this.dataMgr.dataTypeChanged(this.dataType);
        }
    }

    public Long getLong(String name) {
        SettingsDB settingsDB = this.getSettingsDB(name);
        if (settingsDB != null) {
            return settingsDB.getLongValue();
        }
        if (this.dtc != null) {
            return this.dataType.getDefaultSettings().getLong(name);
        }
        return null;
    }

    public String getString(String name) {
        SettingsDB settingsDB = this.getSettingsDB(name);
        if (settingsDB != null) {
            return settingsDB.getStringValue();
        }
        if (this.dtc != null) {
            return this.dataType.getDefaultSettings().getString(name);
        }
        return null;
    }

    public byte[] getByteArray(String name) {
        SettingsDB settingsDB = this.getSettingsDB(name);
        if (settingsDB != null) {
            return settingsDB.getByteValue();
        }
        if (this.dtc != null) {
            return this.dataType.getDefaultSettings().getByteArray(name);
        }
        return null;
    }

    public Object getValue(String name) {
        SettingsDB settingsDB = this.getSettingsDB(name);
        if (settingsDB != null) {
            return settingsDB.getValue();
        }
        if (this.dtc != null) {
            return this.dataType.getDefaultSettings().getValue(name);
        }
        return null;
    }

    public void setLong(String name, long value) {
        try {
            if (this.updateSettingsRecord(name, null, value, null)) {
                this.settingsChanged();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    public void setString(String name, String value) {
        try {
            if (this.updateSettingsRecord(name, value, -1L, null)) {
                this.settingsChanged();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    public void setByteArray(String name, byte[] value) {
        try {
            if (this.updateSettingsRecord(name, null, -1L, value)) {
                this.settingsChanged();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    public void setValue(String name, Object value) {
        if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof String) {
            this.setString(name, (String)value);
        } else if (value instanceof byte[]) {
            this.setByteArray(name, (byte[])value);
        } else {
            throw new IllegalArgumentException("Value is not a known settings type");
        }
    }

    public void clearSetting(String name) {
        try {
            long[] keys = this.adapter.getSettingsKeys(this.dataTypeID);
            for (int i = 0; i < keys.length; ++i) {
                Record rec = this.adapter.getSettingsRecord(keys[i]);
                String settingsName = rec.getString(1);
                if (!settingsName.equals(name)) continue;
                this.adapter.removeSettingsRecord(keys[i]);
                this.settingsChanged();
                return;
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    public void clearAllSettings() {
        try {
            long[] keys = this.adapter.getSettingsKeys(this.dataTypeID);
            for (int i = 0; i < keys.length; ++i) {
                this.adapter.removeSettingsRecord(keys[i]);
            }
            this.settingsChanged();
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    public String[] getNames() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            long[] keys = this.adapter.getSettingsKeys(this.dataTypeID);
            for (int i = 0; i < keys.length; ++i) {
                Record rec = this.adapter.getSettingsRecord(keys[i]);
                String name = rec.getString(1);
                if (list.contains(name)) continue;
                list.add(name);
            }
            String[] names = new String[list.size()];
            return list.toArray(names);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            return new String[0];
        }
    }

    public boolean isEmpty() {
        try {
            return this.adapter.getSettingsKeys(this.dataTypeID).length == 0;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            return true;
        }
    }

    void update(Settings settings) {
        this.clearAllSettings();
        String[] names = settings.getNames();
        for (int i = 0; i < names.length; ++i) {
            this.setValue(names[i], settings.getValue(names[i]));
        }
    }

    static boolean valuesChanged(String oldStrValue, String newStrValue, byte[] oldByteValue, byte[] newByteValue, long oldLongValue, long newLongValue) {
        if (oldStrValue != null && !oldStrValue.equals(newStrValue) || oldStrValue == null && newStrValue != null) {
            return true;
        }
        if (oldByteValue != null && newByteValue != null) {
            return Arrays.equals(oldByteValue, newByteValue);
        }
        if (oldByteValue != null && newByteValue == null || oldByteValue == null && newByteValue != null) {
            return true;
        }
        return oldLongValue != newLongValue;
    }

    private Record getRecord(String name) {
        try {
            long[] keys = this.adapter.getSettingsKeys(this.dataTypeID);
            for (int i = 0; i < keys.length; ++i) {
                Record rec = this.adapter.getSettingsRecord(keys[i]);
                if (!rec.getString(1).equals(name)) continue;
                return rec;
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return null;
    }

    private SettingsDB getSettingsDB(String name) {
        Record record = this.getRecord(name);
        if (record != null) {
            return new SettingsDB(record);
        }
        return null;
    }

    private boolean updateSettingsRecord(String name, String strValue, long longValue, byte[] byteValue) throws IOException {
        boolean wasChanged = false;
        Record record = this.getRecord(name);
        if (record == null) {
            wasChanged = true;
            record = this.adapter.createSettingsRecord(this.dataTypeID, name, strValue, longValue, byteValue);
        } else {
            long recLongValue;
            byte[] recByteValue;
            String recStrValue = record.getString(3);
            wasChanged = SettingsDBManager.valuesChanged(recStrValue, strValue, recByteValue = record.getBinaryData(4), byteValue, recLongValue = record.getLongValue(2), longValue);
            if (wasChanged) {
                record.setString(3, strValue);
                record.setLongValue(2, longValue);
                record.setBinaryData(4, byteValue);
                this.adapter.updateSettingsRecord(record);
            }
        }
        return wasChanged;
    }

    public Settings getDefaultSettings() {
        return null;
    }
}

