/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.OperandValue;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.SpecificSymbol;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public class OperandSymbol
extends SpecificSymbol {
    public static final int code_address = 1;
    public static final int offset_irrel = 2;
    public static final int variable_len = 4;
    public static final int marked = 8;
    public int reloffset;
    public int offsetbase;
    int minimumlength;
    int hand;
    OperandValue localexp;
    private TripleSymbol triple;
    private PatternExpression defexp;
    private int flags;

    public OperandSymbol(Location location) {
        super(location);
    }

    public int getRelativeOffset() {
        return this.reloffset;
    }

    public int getOffsetBase() {
        return this.offsetbase;
    }

    public int getMinimumLength() {
        return this.minimumlength;
    }

    public PatternExpression getDefiningExpression() {
        return this.defexp;
    }

    public TripleSymbol getDefiningSymbol() {
        return this.triple;
    }

    public int getIndex() {
        return this.hand;
    }

    public void setCodeAddress() {
        this.flags |= 1;
    }

    public boolean isCodeAddress() {
        return (this.flags & 1) != 0;
    }

    public void setOffsetIrrelevant() {
        this.flags |= 2;
    }

    public boolean isOffsetIrrelevant() {
        return (this.flags & 2) != 0;
    }

    public void setVariableLength() {
        this.flags |= 4;
    }

    public boolean isVariableLength() {
        return (this.flags & 4) != 0;
    }

    public void setMark() {
        this.flags |= 8;
    }

    public void clearMark() {
        this.flags &= 0xFFFFFFF7;
    }

    public boolean isMarked() {
        return (this.flags & 8) != 0;
    }

    @Override
    public PatternExpression getPatternExpression() {
        return this.localexp;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.operand_symbol;
    }

    public OperandSymbol(Location location, String nm, int index, Constructor ct) {
        super(location, nm);
        this.flags = 0;
        this.hand = index;
        this.localexp = new OperandValue(location, index, ct);
        this.localexp.layClaim();
        this.defexp = null;
        this.triple = null;
    }

    public void defineOperand(PatternExpression pe) {
        if (this.defexp != null || this.triple != null) {
            throw new SleighError("Redefining operand from " + pe.location, this.getLocation());
        }
        this.defexp = pe;
        this.defexp.layClaim();
    }

    public void defineOperand(TripleSymbol tri) {
        if (this.defexp != null || this.triple != null) {
            throw new SleighError("Redefining operand " + tri.getName() + " from " + tri.getLocation(), this.getLocation());
        }
        this.triple = tri;
    }

    @Override
    public void dispose() {
        PatternExpression.release(this.localexp);
        if (this.defexp != null) {
            PatternExpression.release(this.defexp);
        }
    }

    @Override
    public VarnodeTpl getVarnode() {
        if (this.defexp != null) {
            return new VarnodeTpl(this.location, this.hand, true);
        }
        if (this.triple instanceof SpecificSymbol) {
            return ((SpecificSymbol)this.triple).getVarnode();
        }
        if (this.triple != null && (this.triple.getType() == symbol_type.valuemap_symbol || this.triple.getType() == symbol_type.name_symbol)) {
            return new VarnodeTpl(this.location, this.hand, true);
        }
        return new VarnodeTpl(this.location, this.hand, false);
    }

    @Override
    public void getFixedHandle(FixedHandle hnd, ParserWalker pos) {
        hnd = pos.getFixedHandle(this.hand);
    }

    @Override
    public int getSize() {
        if (this.triple != null) {
            return this.triple.getSize();
        }
        return 0;
    }

    @Override
    public void print(PrintStream s, ParserWalker pos) {
        pos.pushOperand(this.getIndex());
        if (this.triple != null) {
            if (this.triple.getType() == symbol_type.subtable_symbol) {
                pos.getConstructor().print(s, pos);
            } else {
                this.triple.print(s, pos);
            }
        } else {
            long val = this.defexp.getValue(pos);
            if (val >= 0L) {
                s.append("0x");
                s.append(Long.toHexString(val));
            } else {
                s.append("-0x");
                s.append(Long.toHexString(-val));
            }
        }
        pos.popOperand();
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<operand_sym");
        this.saveSleighSymbolXmlHeader(s);
        if (this.triple != null) {
            s.append(" subsym=\"0x");
            s.print(Long.toHexString(this.triple.getId()));
            s.append("\"");
        }
        s.append(" off=\"");
        s.print(this.reloffset);
        s.append("\"");
        s.append(" base=\"").print(this.offsetbase);
        s.append("\"");
        s.append(" minlen=\"").print(this.minimumlength);
        s.append("\"");
        if (this.isCodeAddress()) {
            s.append(" code=\"true\"");
        }
        s.append(" index=\"").print(this.hand);
        s.append("\">\n");
        this.localexp.saveXml(s);
        if (this.defexp != null) {
            this.defexp.saveXml(s);
        }
        s.append("</operand_sym>\n");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<operand_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.append("/>\n");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        this.defexp = null;
        this.triple = null;
        this.flags = 0;
        this.hand = XmlUtils.decodeUnknownInt(el.getAttributeValue("index"));
        this.reloffset = XmlUtils.decodeUnknownInt(el.getAttributeValue("off"));
        this.offsetbase = XmlUtils.decodeUnknownInt(el.getAttributeValue("base"));
        this.minimumlength = XmlUtils.decodeUnknownInt(el.getAttributeValue("minlen"));
        String value = el.getAttributeValue("subsym");
        if (value != null) {
            int id = XmlUtils.decodeUnknownInt(value);
            this.triple = (TripleSymbol)trans.findSymbol(id);
        }
        if (XmlUtils.decodeBoolean(el.getAttributeValue("code"))) {
            this.flags |= 1;
        }
        List children = el.getChildren();
        Element firstChild = (Element)children.get(0);
        this.localexp = (OperandValue)PatternExpression.restoreExpression(firstChild, trans);
        this.localexp.layClaim();
        if (children.size() > 1) {
            Element secondChild = (Element)children.get(1);
            this.defexp = PatternExpression.restoreExpression(secondChild, trans);
            this.defexp.layClaim();
        }
    }
}

