/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.expression;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ContextField
extends PatternValue {
    private int startbit;
    private int endbit;
    private int startbyte;
    private int endbyte;
    private int shift;
    private boolean signbit;

    public int hashCode() {
        int result = 0;
        result += this.startbit;
        result *= 31;
        result += this.endbit;
        result *= 31;
        return result += Boolean.hashCode(this.signbit);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContextField)) {
            return false;
        }
        ContextField that = (ContextField)obj;
        if (this.startbit != that.startbit) {
            return false;
        }
        if (this.endbit != that.endbit) {
            return false;
        }
        return this.signbit == that.signbit;
    }

    public int getStartBit() {
        return this.startbit;
    }

    public int getEndBit() {
        return this.endbit;
    }

    public boolean getSignBit() {
        return this.signbit;
    }

    @Override
    public long minValue() {
        return 0L;
    }

    @Override
    public long maxValue() {
        long res = -1L;
        res <<= this.endbit - this.startbit;
        return (res <<= 1) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long getValue(ParserWalker walker) throws MemoryAccessException {
        long res = this.getContextBytes(walker);
        res >>= this.shift;
        res = this.signbit ? TokenField.signExtend(res, this.endbit - this.startbit) : TokenField.zeroExtend(res, this.endbit - this.startbit);
        return res;
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage lang) {
        XmlElement el = parser.start(new String[]{"contextfield"});
        this.signbit = SpecXmlUtils.decodeBoolean((String)el.getAttribute("signbit"));
        this.startbit = SpecXmlUtils.decodeInt((String)el.getAttribute("startbit"));
        this.endbit = SpecXmlUtils.decodeInt((String)el.getAttribute("endbit"));
        this.startbyte = SpecXmlUtils.decodeInt((String)el.getAttribute("startbyte"));
        this.endbyte = SpecXmlUtils.decodeInt((String)el.getAttribute("endbyte"));
        this.shift = SpecXmlUtils.decodeInt((String)el.getAttribute("shift"));
        parser.end(el);
    }

    private long getContextBytes(ParserWalker walker) {
        int tmp;
        long res = 0L;
        int bs = this.startbyte;
        int size = this.endbyte - bs + 1;
        while (size >= 4) {
            tmp = walker.getContextBytes(bs, 4);
            res <<= 32;
            res |= (long)tmp;
            size = this.endbyte - (bs += 4) + 1;
        }
        if (size > 0) {
            tmp = walker.getContextBytes(bs, size);
            res <<= 8 * size;
            res |= (long)tmp;
        }
        return res;
    }

    public boolean hasSignbit() {
        return this.signbit;
    }

    public int getByteStart() {
        return this.startbyte;
    }

    public int getByteEnd() {
        return this.endbyte;
    }

    public int getShift() {
        return this.shift;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[ctx(" + this.startbit + "," + this.endbit + ")");
        if (this.signbit) {
            sb.append(", signed");
        }
        sb.append(", bytes " + this.startbyte + "-" + this.endbyte);
        sb.append(", shift=" + this.shift);
        sb.append("]");
        return sb.toString();
    }
}

