/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitorAdapter;
import ghidra.util.xml.XmlAttributeException;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;

public class MemoryBlockDefinition {
    private String blockName;
    private String addressString;
    private int length;
    private boolean initialized;
    private String bitMappedAddress;
    private boolean readPermission = true;
    private boolean writePermission = true;
    private boolean executePermission = false;
    private boolean volatilePermission = false;

    public String toString() {
        return this.blockName + " @ " + this.addressString + ", length=0x" + Integer.toHexString(this.length);
    }

    public MemoryBlockDefinition(String blockName, String addressString, String bitMappedAddress, String mode, String lengthString, String initializedString) throws XmlAttributeException {
        this.blockName = blockName;
        this.addressString = addressString;
        this.bitMappedAddress = bitMappedAddress;
        if (mode != null) {
            this.readPermission = (mode = mode.toLowerCase()).indexOf(114) >= 0;
            this.writePermission = mode.indexOf(119) >= 0;
            this.executePermission = mode.indexOf(120) >= 0;
            this.volatilePermission = mode.indexOf(118) >= 0;
        }
        try {
            this.length = XmlUtilities.parseInt((String)lengthString);
        }
        catch (NumberFormatException e) {
            throw new XmlAttributeException(lengthString + " is not a valid integer");
        }
        this.initialized = XmlUtilities.parseBoolean((String)initializedString);
    }

    public MemoryBlockDefinition(XmlElement element) {
        this(element.getAttribute("name"), element.getAttribute("start_address"), element.getAttribute("bit_mapped_address"), element.getAttribute("mode"), element.getAttribute("length"), element.getAttribute("initialized"));
    }

    public void createBlock(Program program) throws LockException, MemoryConflictException, AddressOverflowException, DuplicateNameException {
        MemoryBlock block;
        if (this.blockName == null || this.addressString == null || this.length <= 0) {
            return;
        }
        Memory mem = program.getMemory();
        Address addr = XmlProgramUtilities.parseAddress(program.getAddressFactory(), this.addressString);
        if (this.bitMappedAddress != null) {
            Address mappedAddr = XmlProgramUtilities.parseAddress(program.getAddressFactory(), this.bitMappedAddress);
            block = mem.createBitMappedBlock(this.blockName, addr, mappedAddr, this.length);
        } else if (this.initialized) {
            try {
                block = mem.createInitializedBlock(this.blockName, addr, this.length, (byte)0, TaskMonitorAdapter.DUMMY_MONITOR, false);
            }
            catch (CancelledException e) {
                throw new AssertException((Throwable)e);
            }
        } else {
            block = mem.createUninitializedBlock(this.blockName, addr, this.length, false);
        }
        block.setRead(this.readPermission);
        block.setWrite(this.writePermission);
        block.setExecute(this.executePermission);
        block.setVolatile(this.volatilePermission);
    }
}

