/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTreeNode;
import db.Field;
import db.NodeMgr;
import db.VarKeyInteriorNode;
import db.VarKeyRecordNode;
import db.buffers.DataBuffer;
import java.io.IOException;

abstract class VarKeyNode
implements BTreeNode {
    private static final int KEY_TYPE_SIZE = 1;
    private static final int KEY_COUNT_SIZE = 4;
    private static final int KEY_TYPE_OFFSET = 1;
    private static final int KEY_COUNT_OFFSET = 2;
    static final int VARKEY_NODE_HEADER_SIZE = 6;
    protected final Field keyType;
    protected final int maxKeyLength;
    protected NodeMgr nodeMgr;
    protected DataBuffer buffer;
    protected VarKeyInteriorNode parent;
    protected int keyCount;

    VarKeyNode(NodeMgr nodeMgr, DataBuffer buf) {
        this.nodeMgr = nodeMgr;
        this.buffer = buf;
        this.keyType = Field.getField(buf.getByte(1));
        this.keyCount = this.buffer.getInt(2);
        this.maxKeyLength = VarKeyInteriorNode.getMaxKeyLength(this.buffer.length());
        nodeMgr.addNode(this);
    }

    VarKeyNode(NodeMgr nodeMgr, byte nodeType, Field keyType) throws IOException {
        this.nodeMgr = nodeMgr;
        this.buffer = nodeMgr.getBufferMgr().createBuffer();
        NodeMgr.setNodeType(this.buffer, nodeType);
        this.keyType = keyType.newField();
        this.buffer.putByte(1, keyType.getFieldType());
        this.setKeyCount(0);
        this.maxKeyLength = VarKeyInteriorNode.getMaxKeyLength(this.buffer.length());
        nodeMgr.addNode(this);
    }

    @Override
    public int getBufferId() {
        return this.buffer.getId();
    }

    @Override
    public DataBuffer getBuffer() {
        return this.buffer;
    }

    VarKeyNode getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    @Override
    public int getKeyCount() {
        return this.keyCount;
    }

    @Override
    public void setKeyCount(int cnt) {
        this.keyCount = cnt;
        this.buffer.putInt(2, this.keyCount);
    }

    abstract Field getKey(int var1) throws IOException;

    abstract VarKeyRecordNode getLeafNode(Field var1) throws IOException;

    abstract VarKeyRecordNode getLeftmostLeafNode() throws IOException;

    @Override
    public abstract void delete() throws IOException;
}

