/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.program.model.symbol.FlowType;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FGEdgeImpl
implements FGEdge {
    private final FGVertex startVertex;
    private final FGVertex destinationVertex;
    private final FlowType flowType;
    private final FunctionGraphOptions options;
    private List<Point2D> layoutArticulationPoints = new ArrayList<Point2D>();
    boolean doHashCode = true;
    int hashCode;
    private boolean inActivePath = false;
    private boolean selected = false;
    private double emphasis = 0.0;
    private double alpha = 1.0;
    private String edgeLabel = null;

    public FGEdgeImpl(FGVertex startVertex, FGVertex destinationVertex, FlowType flowType, FunctionGraphOptions options) {
        this.options = options;
        this.startVertex = Objects.requireNonNull(startVertex, "Edge start vertex cannot be null");
        this.destinationVertex = Objects.requireNonNull(destinationVertex, "Edge end vertex cannot be null");
        this.flowType = flowType;
    }

    public boolean isInActivePath() {
        return this.inActivePath;
    }

    public void setInActivePath(boolean inActivePath) {
        this.inActivePath = inActivePath;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public double getEmphasis() {
        return this.emphasis;
    }

    public void setEmphasis(double emphasis) {
        this.emphasis = emphasis;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public List<Point2D> getArticulationPoints() {
        return this.layoutArticulationPoints;
    }

    public void setArticulationPoints(List<Point2D> layoutArticulationPoints) {
        this.layoutArticulationPoints = layoutArticulationPoints == null ? Collections.emptyList() : Collections.unmodifiableList(layoutArticulationPoints);
    }

    public FGVertex getStart() {
        return this.startVertex;
    }

    public FGVertex getEnd() {
        return this.destinationVertex;
    }

    @Override
    public FlowType getFlowType() {
        return this.flowType;
    }

    @Override
    public FGEdgeImpl cloneEdge(FGVertex newStartVertex, FGVertex newDestinationVertex) {
        FGEdgeImpl newEdge = new FGEdgeImpl(newStartVertex, newDestinationVertex, this.flowType, this.options);
        ArrayList<Point2D> newPoints = new ArrayList<Point2D>(this.layoutArticulationPoints.size());
        for (Point2D point : this.layoutArticulationPoints) {
            newPoints.add((Point2D)point.clone());
        }
        newEdge.layoutArticulationPoints = newPoints;
        newEdge.alpha = this.alpha;
        newEdge.inActivePath = this.inActivePath;
        newEdge.selected = this.selected;
        return newEdge;
    }

    @Override
    public String getLabel() {
        return this.edgeLabel;
    }

    @Override
    public void setLabel(String label) {
        this.edgeLabel = label;
    }

    public int hashCode() {
        if (this.doHashCode) {
            int destHashCode = this.destinationVertex.hashCode();
            int rearranged = destHashCode >> 16 | destHashCode << 16;
            this.hashCode = this.startVertex.hashCode() ^ rearranged;
            this.doHashCode = false;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FGEdgeImpl other = (FGEdgeImpl)obj;
        return this.startVertex.equals(other.startVertex) && this.destinationVertex.equals(other.destinationVertex) && this.flowType.equals((Object)other.flowType);
    }

    public String toString() {
        return "(" + this.getStart() + " -> " + this.getEnd() + ")";
    }
}

